/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.util.ParmCodingRule;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgParmCodingRule;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class BgCodeNumberHelper {
    private static Logger logger = Logger.getLogger((String)BgCodeNumberHelper.class.getName());
    private Context ctx = null;
    private boolean hasProperty = false;
    private boolean hasCodeNumber = false;
    private boolean hasShowCodeNumber = false;
    private String property = null;
    private String fieldName = null;

    public BgCodeNumberHelper(Context ctx, String fieldName, String property) {
        this.ctx = ctx;
        this.fieldName = fieldName;
        this.property = property;
    }

    public String getProperty() {
        return this.property;
    }

    public boolean isHasCodeNumber() {
        return this.hasCodeNumber;
    }

    public boolean isHasProperty() {
        return this.hasProperty;
    }

    public boolean isHasShowCodeNumber() {
        return this.hasShowCodeNumber;
    }

    public void init(IObjectValue model, String orgUnitId) throws EASBizException, BOSException {
        CodingRuleInfo codingRuleInfo = null;
        BgParmCodingRule codeRule = this.getParmCodingRule(this.fieldName);
        if (!StringUtils.isEmpty((String)this.property)) {
            codingRuleInfo = this.getBizIntance().getCodingRule(model, orgUnitId, this.property, (ParmCodingRule)codeRule);
        }
        if (codingRuleInfo != null) {
            this.hasProperty = true;
        } else {
            codingRuleInfo = this.getBizIntance().getCodingRule(model, orgUnitId, (ParmCodingRule)codeRule);
        }
        if (codingRuleInfo != null) {
            this.hasCodeNumber = true;
            this.hasShowCodeNumber = codingRuleInfo.isIsAddView();
        }
    }

    public void applyNumber(KDTextField txtField, IObjectValue model, String orgUnitId, KDPromptSelector intermilNoF) {
        if (!this.isHasCodeNumber()) {
            return;
        }
        try {
            if (StringUtils.isEmpty((String)orgUnitId)) {
                orgUnitId = "00000000-0000-0000-0000-000000000000CCE7AED4";
            }
            String number = null;
            if (intermilNoF != null && this.isUseIntermitNumber(model, orgUnitId)) {
                if (this.isUserSelect(model, orgUnitId)) {
                    Object object = null;
                    if (this.isDHExist(model, orgUnitId)) {
                        intermilNoF.show();
                        object = intermilNoF.getData();
                    }
                    if (object != null) {
                        number = object.toString();
                    }
                } else if (this.isHasShowCodeNumber()) {
                    number = this.getNumber(model, orgUnitId);
                }
            } else if (this.isHasShowCodeNumber()) {
                number = this.getNumber(model, orgUnitId);
            }
            this.prepareNumber(txtField, model, number);
            if (this.isModifiable(model, orgUnitId)) {
                BgCodeNumberHelper.setNumberTextEnabled(txtField);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_CodingRule"), (Throwable)e);
            BgCodeNumberHelper.setNumberTextEnabled(txtField);
        }
    }

    public void applyNumber(IObjectValue model, String orgUnitId, String defPrex) throws BgException {
        this.applyNumber(model, orgUnitId, defPrex, false);
    }

    public void applyNumber(IObjectValue model, String orgUnitId, String defPrex, boolean isCover) throws BgException {
        if (this.ctx == null || model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return;
        }
        try {
            String fName = this.fieldName == null ? "number" : this.fieldName;
            String number = null;
            if (!StringUtils.isEmpty((String)model.getString(fName)) && !isCover) {
                return;
            }
            if (this.isHasCodeNumber()) {
                number = this.getNumber(model, orgUnitId);
            }
            if (number == null && !StringUtils.isEmpty((String)defPrex)) {
                number = defPrex + "-" + System.currentTimeMillis();
            }
            model.setString(fName, number);
        }
        catch (Exception e) {
            logger.error((Object)"getCode", (Throwable)e);
            throw new BgException(BgException.NUMBERMANAGERERROR);
        }
    }

    private void prepareNumber(KDTextField txtField, IObjectValue model, String number) {
        if (StringUtils.isEmpty((String)this.fieldName)) {
            this.fieldName = "number";
        }
        if (!StringUtils.isEmpty((String)number)) {
            model.setString(this.fieldName, number);
        }
        if (this.isHasCodeNumber()) {
            BgCodeNumberHelper.setNumberTextDisable(txtField);
        }
        if (this.isHasShowCodeNumber() && txtField != null) {
            txtField.setText(number);
        }
    }

    private static void setNumberTextEnabled(KDTextField txtField) {
        if (txtField != null) {
            txtField.setEnabled(true);
            txtField.setEditable(true);
        }
    }

    private static void setNumberTextDisable(KDTextField txtField) {
        if (txtField != null) {
            txtField.setEnabled(false);
            txtField.setEditable(false);
        }
    }

    private String getNonbreakNumber(IObjectValue model, String orgUnitId) throws EASBizException, BOSException {
        if (this.isHasProperty()) {
            return this.getBizIntance().getNonbreakNumber(model, orgUnitId, this.property, null);
        }
        return this.getBizIntance().getNonbreakNumber(model, orgUnitId);
    }

    public boolean isModifiable(IObjectValue model, String orgUnitId) throws EASBizException, BOSException {
        if (!this.isHasCodeNumber()) {
            return true;
        }
        if (this.isHasProperty()) {
            return this.getBizIntance().isModifiable(model, orgUnitId, this.property);
        }
        return this.getBizIntance().isModifiable(model, orgUnitId);
    }

    private boolean isDHExist(IObjectValue model, String orgUnitId) throws EASBizException, BOSException {
        if (this.isHasProperty()) {
            return this.getBizIntance().isDHExist(model, orgUnitId, this.property);
        }
        return this.getBizIntance().isDHExist(model, orgUnitId);
    }

    private boolean isUserSelect(IObjectValue model, String orgUnitId) throws EASBizException, BOSException {
        if (this.isHasProperty()) {
            return this.getBizIntance().isUserSelect(model, orgUnitId, this.property);
        }
        return this.getBizIntance().isUserSelect(model, orgUnitId);
    }

    private String getNumber(IObjectValue model, String orgUnitId) throws EASBizException, BOSException {
        if (this.isHasProperty()) {
            return this.getBizIntance().getNumber(model, orgUnitId, this.property, null, (ParmCodingRule)this.getParmCodingRule(this.fieldName));
        }
        return this.getBizIntance().getNumber(model, orgUnitId);
    }

    private boolean isUseIntermitNumber(IObjectValue model, String orgUnitId) throws EASBizException, BOSException {
        if (this.isHasProperty()) {
            return this.getBizIntance().isUseIntermitNumber(model, orgUnitId, this.property);
        }
        return this.getBizIntance().isUseIntermitNumber(model, orgUnitId);
    }

    private BgParmCodingRule getParmCodingRule(String fieldName) {
        if (StringUtils.isEmpty((String)fieldName) || "number".equals(fieldName)) {
            return null;
        }
        BgParmCodingRule pcr = new BgParmCodingRule();
        pcr.setCustomProperty(fieldName);
        return pcr;
    }

    private ICodingRuleManager getBizIntance() throws BOSException {
        if (this.ctx == null) {
            return CodingRuleManagerFactory.getRemoteInstance();
        }
        return CodingRuleManagerFactory.getLocalInstance((Context)this.ctx);
    }
}

