/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.filechooser.FileSystemView;
import org.apache.log4j.Logger;

public class BgCommHelper {
    private static final Logger logger = CoreUIObject.getLogger(BgCommHelper.class);

    public static boolean isEmpty(Collection colls) {
        return colls == null || colls.isEmpty();
    }

    public static FilterInfo appandFilter(FilterInfo ... filters) throws BOSException {
        if (filters == null || filters.length <= 1) {
            return filters == null ? null : filters[0];
        }
        FilterInfo _filter = filters[0];
        for (int i = 1; i < filters.length; ++i) {
            _filter.mergeFilter(filters[i], "AND");
        }
        return _filter;
    }

    public static void addFilterItem(FilterInfo filter, FilterItemInfo item) {
        if (filter == null || item == null) {
            return;
        }
        if (filter.getFilterItems() != null) {
            FilterItemCollection fiCol = filter.getFilterItems();
            fiCol.add(item);
            int itemsSize = fiCol.size();
            String str = filter.getMaskString();
            if (itemsSize <= 1) {
                filter.setMaskString("(#0)");
            } else if (str == null) {
                logger.error((Object)"\u4e3a\u907f\u514d\u6ca1\u6709\u8bbe\u7f6emaskString");
            } else {
                filter.setMaskString("(" + str + ") and (#" + String.valueOf(itemsSize - 1) + ")");
            }
        }
    }

    public static void addFilterItemOR(FilterInfo filter, FilterItemInfo item) {
        if (filter == null || item == null) {
            return;
        }
        if (filter.getFilterItems() != null) {
            FilterItemCollection fiCol = filter.getFilterItems();
            fiCol.add(item);
            int itemsSize = fiCol.size();
            String str = filter.getMaskString();
            if (itemsSize <= 1) {
                filter.setMaskString("(#0)");
            } else if (str == null) {
                logger.error((Object)"\u4e3a\u907f\u514d\u6ca1\u6709\u8bbe\u7f6emaskString");
            } else {
                filter.setMaskString("(" + str + ") or (#" + String.valueOf(itemsSize - 1) + ")");
            }
        }
    }

    public static void replaceFilterItemsWithoutMask(FilterInfo filter, FilterItemInfo item) {
        if (filter == null || item == null) {
            return;
        }
        boolean isReplace = false;
        if (filter.getFilterItems() != null) {
            FilterItemInfo fiInfo = null;
            FilterItemCollection fiCol = filter.getFilterItems();
            int n = fiCol.size();
            for (int i = 0; i < n; ++i) {
                fiInfo = fiCol.get(i);
                if (!fiInfo.getPropertyName().trim().equals(item.getPropertyName().trim())) continue;
                fiInfo.setCompareType(item.getCompareType());
                fiInfo.setCompareValue(item.getCompareValue());
                isReplace = true;
            }
            if (!isReplace) {
                fiCol.add(item);
            }
        }
    }

    public static void removeFilterItems(FilterInfo filter, FilterItemInfo item) {
        if (filter == null || item == null) {
            return;
        }
        boolean isRemove = false;
        FilterItemInfo tmpItem = null;
        if (filter.getFilterItems() != null) {
            FilterItemInfo fiInfo = null;
            FilterItemCollection fiCol = filter.getFilterItems();
            int n = fiCol.size();
            for (int i = 0; i < n; ++i) {
                fiInfo = fiCol.get(i);
                if (!fiInfo.getPropertyName().trim().equals(item.getPropertyName().trim())) continue;
                isRemove = true;
                tmpItem = fiInfo;
            }
            if (isRemove) {
                fiCol.remove(tmpItem);
            }
        }
    }

    public static final void replaceFilterItems(FilterInfo filter, FilterItemInfo item) {
        if (filter == null || item == null) {
            return;
        }
        boolean isReplace = false;
        if (filter.getFilterItems() != null) {
            FilterItemInfo fiInfo = null;
            FilterItemCollection fiCol = filter.getFilterItems();
            int n = fiCol.size();
            for (int i = 0; i < n; ++i) {
                fiInfo = fiCol.get(i);
                if (!fiInfo.getPropertyName().trim().equals(item.getPropertyName().trim())) continue;
                fiInfo.setCompareType(item.getCompareType());
                fiInfo.setCompareValue(item.getCompareValue());
                isReplace = true;
            }
            if (!isReplace) {
                fiCol.add(item);
                String str = filter.getMaskString();
                int itemsSize = fiCol.size();
                if (itemsSize <= 1) {
                    filter.setMaskString("(#0)");
                } else if (str == null) {
                    logger.error((Object)"maskString error");
                } else {
                    filter.setMaskString(str + " and (#" + String.valueOf(itemsSize - 1) + ")");
                }
            }
        }
    }

    public static int compare(Comparable c1, Comparable c2) {
        if (c1 == c2) {
            return 0;
        }
        if (c1 == null) {
            return -1;
        }
        if (c2 == null) {
            return 1;
        }
        return c1.compareTo(c2);
    }

    public static void removeEditHelper(KDTable table) {
        if (table != null) {
            ActionMap am = table.getActionMap();
            am.remove("Cut");
            am.remove("Paste");
            am.remove("Copy");
            am.remove("Delete");
            am.remove("Undo");
            am.remove("Redo");
        }
    }

    public static void removePasteHelper(KDTable table) {
        if (table != null) {
            ActionMap am = table.getActionMap();
            am.remove("Paste");
        }
    }

    public static void removeUndo(KDBizPromptBox bizProp) {
        if (bizProp == null) {
            return;
        }
        if (bizProp.getEditor() instanceof KDTextField) {
            bizProp.getEditor().getActionMap().remove("undo-textfield");
            bizProp.getEditor().getActionMap().remove("redo-textfield");
        }
    }

    public static void removeUndo(KDTextField textField) {
        if (textField == null) {
            return;
        }
        textField.getActionMap().remove("undo-textfield");
        textField.getActionMap().remove("redo-textfield");
    }

    public static String getDefaultDirtory() {
        String os = System.getProperty("os.name");
        if (os != null && os.toLowerCase(Locale.ENGLISH).startsWith("window")) {
            return "C:/";
        }
        return FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath();
    }

    public static FullOrgUnitInfo castToFullOrgUnitInfo(OrgUnitInfo orgUnitInfo) {
        if (orgUnitInfo instanceof FullOrgUnitInfo) {
            return (FullOrgUnitInfo)orgUnitInfo;
        }
        if (orgUnitInfo != null) {
            FullOrgUnitInfo result = new FullOrgUnitInfo();
            result.putAll((IObjectValue)orgUnitInfo);
            return result;
        }
        return null;
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof MultiLangItem) {
            return StringUtils.isEmpty((String)String.valueOf(obj));
        }
        if (obj instanceof String) {
            return StringUtils.isEmpty((String)((String)obj));
        }
        if (obj instanceof List) {
            return ((List)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj instanceof IObjectCollection) {
            return ((IObjectCollection)obj).isEmpty();
        }
        if (obj instanceof Object[]) {
            Object[] objs = (Object[])obj;
            if (objs.length == 0) {
                return true;
            }
            if (objs.length == 1 && objs[0] == null) {
                return true;
            }
        }
        return false;
    }

    public static Map transeToMap(IObjectCollection objectCol) {
        return BgCommHelper.transeToMap(objectCol, new String[]{"id"}, false);
    }

    public static Map transeToMap(IObjectCollection objectCol, String[] keyFields) {
        return BgCommHelper.transeToMap(objectCol, keyFields, false);
    }

    public static Map transeToMap(IObjectCollection objectCol, String[] keyFields, boolean allowNull) {
        HashMap<String, IObjectValue> map = new HashMap<String, IObjectValue>();
        if (objectCol == null || objectCol.isEmpty()) {
            return map;
        }
        StringBuffer key = new StringBuffer();
        IObjectValue value = null;
        IObjectValue _value = null;
        Object _vk = null;
        String[] _keyField = null;
        for (int i = 0; i < objectCol.size(); ++i) {
            key.setLength(0);
            value = objectCol.getObject(i);
            block1: for (int k = 0; k < keyFields.length; ++k) {
                _value = value;
                if (key.length() > 0) {
                    key.append(BgBaseConstants.COMBINATE_SPLITER_TABLE);
                }
                _keyField = keyFields[k].split("\\.");
                for (int f = 0; f < _keyField.length; ++f) {
                    _vk = _value.get(_keyField[f]);
                    if (f == _keyField.length - 1) {
                        key.append(_vk);
                        continue;
                    }
                    if (_vk instanceof IObjectValue) {
                        _value = (IObjectValue)_vk;
                        continue;
                    }
                    if (allowNull) {
                        key.append("");
                        continue block1;
                    }
                    return new HashMap();
                }
            }
            map.put(key.toString(), value);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObject(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        Object obj = null;
        InputStream is = null;
        ObjectInputStream bais = null;
        try {
            is = ZipUtil.unpack((byte[])data);
            bais = new ObjectInputStream(is);
            obj = bais.readObject();
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
            }
            catch (Throwable throwable) {
                BgCommHelper.close(bais);
                BgCommHelper.close(is);
                throw throwable;
            }
            BgCommHelper.close(bais);
            BgCommHelper.close(is);
        }
        BgCommHelper.close(bais);
        BgCommHelper.close(is);
        return obj;
    }

    private static void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException ex) {
                logger.error((Object)ex);
            }
            finally {
                is = null;
            }
        }
    }
}

