/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.BgElementCollection;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class BgElementHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BgElementCollection getElementColls(Connection conn, Locale locale) throws SQLException {
        BgElementCollection colls = new BgElementCollection();
        if (conn == null || locale == null) {
            return colls;
        }
        IRowSet rst = null;
        BgElementInfo element = null;
        try {
            rst = BgDBUtils.executeQuery(conn, "select FID, FNumber, FLongNumber, FName_" + locale + " AS FName, FParentId from T_MBG_BgElement");
            while (rst.next()) {
                element = new BgElementInfo();
                element.setId(BOSUuid.read((String)rst.getString("FID")));
                element.setNumber(rst.getString("FNumber"));
                element.setLongNumber(rst.getString("FLongNumber"));
                element.setName(rst.getString("FName"));
                if (!StringUtils.isEmpty((String)rst.getString("FParentId"))) {
                    element.setParent(new BgElementInfo());
                    element.getParent().setId(BOSUuid.read((String)rst.getString("FParentId")));
                }
                colls.add(element);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return colls;
    }

    public static Map<String, String[]> getElementLongNum(Connection conn, Locale locale) throws SQLException {
        HashMap<String, String[]> dataMap = new HashMap<String, String[]>();
        if (conn == null) {
            return dataMap;
        }
        String[] eleStrs = null;
        BgElementInfo element = null;
        BgElementCollection colls = BgElementHelper.getElementColls(conn, locale);
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            element = colls.get(i);
            eleStrs = new String[4];
            eleStrs[0] = element.getNumber();
            eleStrs[1] = element.getLongNumber();
            eleStrs[2] = element.getName();
            dataMap.put(element.getNumber(), eleStrs);
        }
        return dataMap;
    }

    public static Map<String, BgElementInfo> getElementoObjMap() throws BOSException {
        return BgElementHelper.getElementoObjMap(null);
    }

    public static Map<String, BgElementInfo> getElementoObjMap(Context ctx) throws BOSException {
        HashMap<String, BgElementInfo> elementObjMap = new HashMap<String, BgElementInfo>();
        BgElementCollection colls = BgElementHelper.getElementColls(ctx);
        if (colls != null) {
            BgElementInfo element = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                element = colls.get(i);
                elementObjMap.put(element.getNumber(), element);
            }
        }
        return elementObjMap;
    }

    public static BgElementCollection getElementColls(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)BgElementHelper.getSelector());
        if (ctx == null) {
            return BgElementFactory.getRemoteInstance().getBgElementCollection(view);
        }
        return BgElementFactory.getLocalInstance(ctx).getBgElementCollection(view);
    }

    private static SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longnumber");
        sic.add("dataType");
        sic.add("showData");
        return sic;
    }
}

