/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.ma.base.MbgParamsFactory;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class BgParamNHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.utils.BgParamNHelper");

    private static String loadSystemParamValue(Context ctx, String number) {
        String _value = null;
        try {
            _value = ParamManager.getParamValue((Context)ctx, null, (String)number);
        }
        catch (Exception ex) {
            logger.error((Object)"load system param error:", (Throwable)ex);
        }
        return _value;
    }

    private static String loadSystemParamValue(Context ctx, String OUID, String number) {
        String _value = null;
        try {
            _value = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectStringPK(OUID), (String)number);
        }
        catch (Exception ex) {
            logger.error((Object)"load system param error:", (Throwable)ex);
        }
        return _value;
    }

    private static String loadMbgParamValue(Context ctx, String OUID, String number) {
        String _value = null;
        try {
            _value = MbgParamsFactory.getLocalInstance(ctx).getParamValue(OUID, number);
        }
        catch (Exception ex) {
            logger.error((Object)"load system param error:", (Throwable)ex);
        }
        return _value;
    }

    protected static boolean loadParamValue(Context ctx, String paramValue) {
        String _value = BgParamNHelper.loadSystemParamValue(ctx, paramValue);
        return !StringUtils.isEmpty((String)_value) ? Boolean.valueOf(_value) : false;
    }

    protected static boolean loadParamValue(Context ctx, String OUID, String paramValue) {
        String _value = BgParamNHelper.loadSystemParamValue(ctx, OUID, paramValue);
        return !StringUtils.isEmpty((String)_value) ? Boolean.valueOf(_value) : false;
    }

    protected static boolean loadMbgParam(Context ctx, String OUID, String paramValue) {
        String _value = BgParamNHelper.loadMbgParamValue(ctx, OUID, paramValue);
        return !StringUtils.isEmpty((String)_value) ? Boolean.valueOf(_value) : false;
    }

    public static boolean isStartupDimControl(Context ctx, String OUID) {
        return BgParamNHelper.loadMbgParam(ctx, OUID, "MBG_C001");
    }

    public static boolean isEditControlScheme(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_C010");
    }

    public static boolean isZeroIsNull(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_C020");
    }

    public static boolean isShareBizItem(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_C030");
    }

    public static boolean isCalcOfAddnew(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_A010");
    }

    public static boolean isCalcOfSave(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_A020");
    }

    public static boolean isLockCellByFormula(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_A030");
    }

    public static String getMbgShowStyle(Context ctx) {
        return BgParamNHelper.loadSystemParamValue(ctx, "MBG_A130");
    }

    public static String getBgOrgShowStyle(Context ctx) {
        return BgParamNHelper.loadSystemParamValue(ctx, "MBG_A180");
    }

    public static boolean isFilterByOrgRange(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_A190");
    }

    public static boolean isAdjustEntryScenAndEle(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_A200");
    }

    public static boolean isNeedCertificate(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_A220");
    }

    public static boolean isLimitDecomposeScale(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_A230");
    }

    public static boolean isExamineIgnorePrecision(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_A240");
    }

    public static boolean isShowMultiForm(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_A250");
    }

    public static boolean isExamineCheckOnlyUnionReport(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_A270");
    }

    public static boolean isAdjustCheck(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_A140");
    }

    public static boolean isRecordProcess(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_C040");
    }

    public static boolean isUpdateCtrlSetting(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_C050");
    }

    public static boolean isLoadTransitBudget(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_C060");
    }

    public static boolean isNotBgOrgControlCheck(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_C080");
    }

    public static boolean isPeriodAlgorithm(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_A170");
    }

    public static boolean isControlDDLOption(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_A160");
    }

    public static boolean isFormulaRepeat(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_A035");
    }

    public static boolean isUploadRefAttachmentFile(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_A210");
    }

    public static boolean isVersionCopyAuditData(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_A260");
    }

    public static boolean isBgAdjustBillFilterOrgRange(Context ctx) {
        return BgParamNHelper.loadParamValue(ctx, "MBG_A280");
    }
}

