/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.IBgScenario;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BgScenarioHelper {
    public static final String RESOURCE = "com.kingdee.eas.ma.base.BgScenarioResource";
    public static final String BGSCENARIO_SYSDATA_FORBIDDEN_DELETE = "BGSCENARIO_SYSDATA_FORBIDDEN_DELETE";
    public static final String BGSCENARIO_REFED_FORBIDDEN_DELETE = "BGSCENARIO_REFED_FORBIDDEN_DELETE";
    public static final String BGSCENARIO_REFED_BGSCENARIO_DELETE = "BGSCENARIO_REFED_BGSCENARIO_DELETE";
    public static final String BGSCENARIO_ORG_FORBIDDEN_DELETE = "BGSCENARIO_DELETE_FORBBIT_ORG";
    public static final String BGSCENARIO_UPDATA_FORBBIT_SYS = "BGSCENARIO_UPDATA_FORBBIT_SYS";
    public static final String BGSCENARIO_UPDATA_FORBBIT_ORG = "BGSCENARIO_UPDATA_FORBBIT_ORG";
    public static final String BGSCENARIO_DELETE_ERROR_MSG_REFED = "BGSCENARIO_DELETE_ERROR_MSG_REFED";
    public static final String BGSCENARIO_DELETE_ERROR_MSG_SYSDATA = "BGSCENARIO_DELETE_ERROR_MSG_SYSDATA";
    public static final String BGSCENARIO_DELETE_ERROR_MSG_ORG = "BGSCENARIO_DELETE_ERROR_MSG_ORG";
    public static final String BGSCENARIO_EDIT_ERROR_MSG_ORG = "BGSCENARIO_EDIT_ERROR_MSG_ORG";
    public static final String BGSCENARIO_DELETE_ERROR_MSG = "BGSCENARIO_DELETE_ERROR_MSG";
    public static final String BGSCENARIO_TABLE = "T_MBG_BgScenario";
    public static final String BGSCENARIO = "FScenarioID";
    public static final String BUDGET_SCENARIO_NUMBER = "BgData";
    public static final String ACTUAL_SCENARIO_NUMBER = "ActData";
    public static int BUDGET_SCENARIO_VALUE = 0;
    public static int ACTUAL_SCENARIO_VALUE = 1;
    public static final Set<String> sysDataNumbers = new HashSet<String>();

    public static KDBizPromptBox getBgScenarioF7UI(boolean isMultiSelect) {
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        prmtSelect.setQueryInfo("com.kingdee.eas.ma.base.BgScenarioQuery");
        prmtSelect.setDisplayFormat("$name$");
        prmtSelect.setCommitFormat("$number$");
        prmtSelect.setEditFormat("$number$");
        prmtSelect.setEnabledMultiSelection(isMultiSelect);
        return prmtSelect;
    }

    public static List<BgScenarioInfo> getBgScenario() throws BOSException {
        return BgScenarioHelper.getScenario(0);
    }

    public static List<BgScenarioInfo> getBgScenario(Context ctx) throws BOSException {
        return BgScenarioHelper.getScenario(ctx, 0);
    }

    public static List<BgScenarioInfo> getAcScenario() throws BOSException {
        return BgScenarioHelper.getScenario(1);
    }

    public static List<BgScenarioInfo> getAcScenario(Context ctx) throws BOSException {
        return BgScenarioHelper.getScenario(ctx, 1);
    }

    public static Set<String> getBgScenNums(Context ctx) throws BOSException {
        HashSet<String> numberSet = new HashSet<String>();
        List<BgScenarioInfo> scenarios = BgScenarioHelper.getScenario(ctx, 0);
        for (BgScenarioInfo scenario : scenarios) {
            numberSet.add(scenario.getNumber());
        }
        return numberSet;
    }

    public static void setComBoxByScenario(KDComboBox combox, List<BgScenarioInfo> scenarios) throws BOSException, EASBizException {
        if (combox == null || scenarios == null) {
            return;
        }
        combox.removeAllItems();
        if (scenarios != null) {
            combox.addItems(scenarios.toArray());
        }
    }

    public static SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longnumber");
        sic.add("type");
        sic.add("isLeaf");
        sic.add("scenarioId");
        sic.add("parent.id");
        sic.add("parent.number");
        sic.add("isSysData");
        return sic;
    }

    public static List<BgScenarioInfo> getAllScenario() throws Exception {
        ArrayList<BgScenarioInfo> scenarios = new ArrayList<BgScenarioInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)BgScenarioHelper.getSelector());
        view.getSorter().add(new SorterItemInfo("number"));
        BgScenarioCollection colls = BgScenarioFactory.getRemoteInstance().getBgScenarioCollection(view);
        if (colls != null) {
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                scenarios.add(colls.get(i));
            }
        }
        return scenarios;
    }

    public static List<BgScenarioInfo> getAllScenario(Context ctx) throws BOSException {
        ArrayList<BgScenarioInfo> scenarios = new ArrayList<BgScenarioInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)BgScenarioHelper.getSelector());
        view.getSorter().add(new SorterItemInfo("number"));
        BgScenarioCollection colls = BgScenarioFactory.getLocalInstance(ctx).getBgScenarioCollection(view);
        if (colls != null) {
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                scenarios.add(colls.get(i));
            }
        }
        return scenarios;
    }

    private static List<BgScenarioInfo> getScenario(int scenarioType) throws BOSException {
        ArrayList<BgScenarioInfo> scenarios = new ArrayList<BgScenarioInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)scenarioType, CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)BgScenarioHelper.getSelector());
        view.getSorter().add(new SorterItemInfo("number"));
        BgScenarioCollection colls = BgScenarioFactory.getRemoteInstance().getBgScenarioCollection(view);
        if (colls != null) {
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                scenarios.add(colls.get(i));
            }
        }
        return scenarios;
    }

    private static List<BgScenarioInfo> getScenario(Context ctx, int scenarioType) throws BOSException {
        ArrayList<BgScenarioInfo> scenarios = new ArrayList<BgScenarioInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)scenarioType, CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)BgScenarioHelper.getSelector());
        view.getSorter().add(new SorterItemInfo("number"));
        BgScenarioCollection colls = null;
        colls = ctx != null ? BgScenarioFactory.getLocalInstance(ctx).getBgScenarioCollection(view) : BgScenarioFactory.getRemoteInstance().getBgScenarioCollection(view);
        if (colls != null) {
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                scenarios.add(colls.get(i));
            }
        }
        return scenarios;
    }

    public static BgScenarioCollection getScenarioColls(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)BgScenarioHelper.getSelector());
        if (ctx == null) {
            return BgScenarioFactory.getRemoteInstance().getBgScenarioCollection(view);
        }
        return BgScenarioFactory.getLocalInstance(ctx).getBgScenarioCollection(view);
    }

    public static Map<String, Map<String, BgScenarioInfo>> getAdjustScenarioMap(Context ctx) throws BOSException {
        BgScenarioCollection col = BgScenarioHelper.getAdjustScenario(ctx);
        HashMap<String, Map<String, BgScenarioInfo>> result = new HashMap<String, Map<String, BgScenarioInfo>>();
        BgScenarioInfo info = null;
        HashMap<String, BgScenarioInfo> tmp = null;
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            if (info.getActScenarios().isEmpty()) continue;
            tmp = new HashMap<String, BgScenarioInfo>();
            result.put(info.getNumber(), tmp);
            for (int a = 0; a < info.getActScenarios().size(); ++a) {
                tmp.put(info.getActScenarios().get(a).getActScenario().getNumber(), info.getActScenarios().get(a).getActScenario());
            }
        }
        return result;
    }

    public static BgScenarioCollection getAdjustScenario(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(BgScenarioHelper.getSelector());
        view.getSelector().add("actScenarios.actScenario.id");
        view.getSelector().add("actScenarios.actScenario.name");
        view.getSelector().add("actScenarios.actScenario.number");
        view.getSelector().add("actScenarios.actScenario.longnumber");
        view.getSelector().add("actScenarios.actScenario.isSysData");
        view.getSelector().add("actScenarios.actScenario.scenarioId");
        view.setFilter(new FilterInfo());
        view.getSorter().add(new SorterItemInfo("actScenarios.actScenario.number"));
        return BgScenarioHelper.getInstance(ctx).getBgScenarioCollection(view);
    }

    public static IBgScenario getInstance(Context ctx) throws BOSException {
        if (ctx == null) {
            return BgScenarioFactory.getRemoteInstance();
        }
        return BgScenarioFactory.getLocalInstance(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BgScenarioCollection getScenarioColls(Connection conn, Locale locale) throws SQLException {
        BgScenarioCollection colls = new BgScenarioCollection();
        if (conn == null || locale == null) {
            return colls;
        }
        IRowSet rst = null;
        BgScenarioInfo scenario = null;
        try {
            rst = BgDBUtils.executeQuery(conn, "select t.FID, t.FNumber, t.FLongNumber, t.FName_" + locale + " AS FName, t.FType, t.FScenarioId, t.FParentId, t.FIsLeaf, p.FNumber AS PNumber from T_MBG_BgScenario t left join T_MBG_BgScenario p on t.FParentId = p.FID");
            while (rst.next()) {
                scenario = new BgScenarioInfo();
                scenario.setId(BOSUuid.read((String)rst.getString("FID")));
                scenario.setNumber(rst.getString("FNumber"));
                scenario.setLongNumber(rst.getString("FLongNumber"));
                scenario.setName(rst.getString("FName"));
                scenario.setType(BgScenarioType.getEnum(rst.getInt("FType")));
                scenario.setScenarioId(rst.getInt("FScenarioId"));
                scenario.setIsLeaf(rst.getBoolean("FIsLeaf"));
                if (!StringUtils.isEmpty((String)rst.getString("FParentId"))) {
                    scenario.setParent(new BgScenarioInfo());
                    scenario.getParent().setId(BOSUuid.read((String)rst.getString("FParentId")));
                    scenario.getParent().setNumber(rst.getString("PNumber"));
                }
                colls.add(scenario);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return colls;
    }

    public static Set<String> getBgScenario(Connection conn) throws SQLException {
        HashSet<String> scenarios = new HashSet<String>();
        if (conn == null) {
            return scenarios;
        }
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery(conn, "select FNumber from T_MBG_BgScenario where FType = ?", new Object[]{BUDGET_SCENARIO_VALUE});
            while (rst.next()) {
                scenarios.add(rst.getString("FNumber"));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return scenarios;
    }

    public static Set<String> getAcScenarioNumbers(Context ctx) throws SQLException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            Set<String> set = BgScenarioHelper.getAcScenario(conn);
            return set;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public static Set<String> getAcScenario(Connection conn) throws SQLException {
        HashSet<String> scenarios = new HashSet<String>();
        if (conn == null) {
            return scenarios;
        }
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery(conn, "select FNumber from T_MBG_BgScenario where FType = ?", new Object[]{ACTUAL_SCENARIO_VALUE});
            while (rst.next()) {
                scenarios.add(rst.getString("FNumber"));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return scenarios;
    }

    public static Map<String, String[]> getScenarioLongNum(Connection conn, Locale locale) throws SQLException {
        HashMap<String, String[]> dataMap = new HashMap<String, String[]>();
        if (conn == null || locale == null) {
            return dataMap;
        }
        String[] scenStrs = null;
        BgScenarioInfo scenario = null;
        BgScenarioCollection colls = BgScenarioHelper.getScenarioColls(conn, locale);
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            scenario = colls.get(i);
            scenStrs = new String[4];
            scenStrs[0] = scenario.getNumber();
            scenStrs[1] = scenario.getLongNumber();
            scenStrs[2] = scenario.getName();
            dataMap.put(scenario.getNumber(), scenStrs);
        }
        return dataMap;
    }

    public static Map<String, BgScenarioInfo> getScenariooObjMap() throws BOSException {
        return BgScenarioHelper.getScenariooObjMap(null);
    }

    public static Map<String, BgScenarioInfo> getScenariooObjMap(Context ctx) throws BOSException {
        HashMap<String, BgScenarioInfo> scenarioObjMap = new HashMap<String, BgScenarioInfo>();
        BgScenarioCollection colls = BgScenarioHelper.getScenarioColls(ctx);
        if (colls != null) {
            BgScenarioInfo scenario = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                scenario = colls.get(i);
                scenarioObjMap.put(scenario.getNumber(), scenario);
            }
        }
        return scenarioObjMap;
    }

    public static Map<String, BgScenarioInfo> getScenariooObjMap(Connection conn, Locale locale) throws SQLException {
        HashMap<String, BgScenarioInfo> scenarioObjMap = new HashMap<String, BgScenarioInfo>();
        BgScenarioCollection colls = BgScenarioHelper.getScenarioColls(conn, locale);
        if (colls != null) {
            BgScenarioInfo scenario = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                scenario = colls.get(i);
                scenarioObjMap.put(scenario.getNumber(), scenario);
            }
        }
        return scenarioObjMap;
    }

    public static Map<String, String> getScenarioMap(Context ctx) throws BOSException {
        HashMap<String, String> scenarioMap = new HashMap<String, String>();
        if (ctx == null) {
            return scenarioMap;
        }
        BgScenarioCollection colls = BgScenarioHelper.getScenarioColls(ctx);
        if (colls != null) {
            BgScenarioInfo scenario = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                scenario = colls.get(i);
                scenarioMap.put(String.valueOf(scenario.getScenarioId()), scenario.getNumber());
            }
        }
        return scenarioMap;
    }

    public static Map<String, String> getScenarioMap(Connection conn, Locale locale) throws SQLException {
        HashMap<String, String> scenarioMap = new HashMap<String, String>();
        if (conn == null) {
            return scenarioMap;
        }
        BgScenarioCollection colls = BgScenarioHelper.getScenarioColls(conn, locale);
        if (colls != null) {
            BgScenarioInfo scenario = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                scenario = colls.get(i);
                scenarioMap.put(String.valueOf(scenario.getScenarioId()), scenario.getNumber());
            }
        }
        return scenarioMap;
    }

    public static Map<String, String> getScenarioInnMap(Context ctx) throws BOSException {
        HashMap<String, String> scenarioMap = new HashMap<String, String>();
        if (ctx == null) {
            return scenarioMap;
        }
        BgScenarioCollection colls = BgScenarioHelper.getScenarioColls(ctx);
        if (colls != null) {
            BgScenarioInfo scenario = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                scenario = colls.get(i);
                scenarioMap.put(scenario.getNumber(), String.valueOf(scenario.getScenarioId()));
            }
        }
        return scenarioMap;
    }

    static {
        sysDataNumbers.add(BUDGET_SCENARIO_NUMBER);
        sysDataNumbers.add(ACTUAL_SCENARIO_NUMBER);
    }
}

