/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.MbgDimException;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MbgDimHelper {
    public static final String RES = "com.kingdee.eas.ma.base.MbgDimResource";
    public static final String ID = "id";
    public static final String NUMBER = "number";
    public static final String NAME = "name";
    public static final String PARENT_NAME = "parent.name";
    public static final String PARENT_NUMBER = "parent.number";
    public static final String PARENT_ID = "parent.id";
    public static final String LEVEL = "level";
    public static final String ISLEAF = "isLeaf";
    public static final String AGGREGATION = "aggregation";
    public static final String DESCRIPTION = "description";
    public static final String LONGNUMBER = "longNumber";
    public static final String ORGUNIT_NAME = "orgunit.name";
    public static final String ORGUNIT_ID = "orgunit.id";
    public static final String CREATEOR_NAME = "creator.name";
    public static final String CREATETIME = "createTime.name";
    public static final String VIEW_ID = "viewId";
    public static final String ISSYSTEMDEFAULT = "isSystemDefault";
    public static final String LASTUPDATEUSER = "lastUpdateUser.name";
    public static final String LASTUPDATETIME = "lastUpdateTime";
    public static final String ISENABLE = "isEnabled";
    public static final String DISABLEDDATE = "disabledDate";
    public static final String UPDATE_LOGITEM = "mbg_mbgmember_maintenance";
    public static final String SPLITTER_ONE = "_";
    public static final String SPLITTER_TWO = "!";
    public static final String SPLITTER_COMMA = ",";
    private static final int MAX_DIMENSION_COUNT = 97;
    private static final int SYS_DEFAULT_COUNT = 6;
    public static final String DELETE_SUCCESS = "delete_success";
    public static final String DELETE_FAIL = "delete_fail";
    public static final String DELETE_RESULT = "delete_result";
    public static final String REF_DIMRELATION = "ref_dimRelation";
    public static final String REF_BIZ = "ref_biz";
    public static final String REF_TEMPLATE = "ref_template";
    public static final String REF_FORM = "ref_form";
    public static final String REF_DATA = "ref_data";
    public static final String BGPROPERTY_ID = "bgProperty.id";
    public static final String BGPROPERTY = "bgProperty.name";
    public static final String BGPROPERTY_NUMBER = "bgProperty.number";
    public static final String MBGDIM = "mbgDim";
    public static final String MBGVIEW = "mbgView";

    public static String createSrcNumber(Context ctx, String number, String srcId, List numLst) {
        String srcNumber = "";
        number = number.replaceAll("[^a-zA-Z0-9]", "");
        srcId = srcId.replaceAll("[^a-zA-Z0-9]", "");
        if (number.length() < 3) {
            number = number + srcId;
        }
        if (numLst.contains(number.substring(0, 3))) {
            int j;
            int i;
            for (i = 0; i < number.length() - 2; ++i) {
                for (j = i + 1; j < number.length() - 1; ++j) {
                    for (int k = j + 1; k < number.length(); ++k) {
                        srcNumber = String.valueOf(number.charAt(i)) + String.valueOf(number.charAt(j)) + String.valueOf(number.charAt(k));
                        if (numLst.contains(srcNumber)) continue;
                        return srcNumber;
                    }
                }
            }
            for (i = 0; i < number.length() - 2; ++i) {
                for (j = i + 1; j < number.length() - 1; ++j) {
                    for (char c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
                        srcNumber = String.valueOf(number.charAt(i)) + String.valueOf(number.charAt(j)) + String.valueOf(c);
                        if (numLst.contains(srcNumber)) continue;
                        return srcNumber;
                    }
                }
            }
        } else {
            return number.substring(0, 3);
        }
        return srcNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String createDimensionSrcNumber(Context ctx, MbgDimInfo mbgDimInfo) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<String> numLst = new ArrayList<String>();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement("select FSrcNumber from T_MBG_MbgDim where (FSrcNumber IS NOT NULL )");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                numLst.add(rs.getString(1));
            }
        }
        catch (SQLException sQLException) {
            SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        String srcNumber = "";
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        srcNumber = MbgDimHelper.createSrcNumber(ctx, mbgDimInfo.getNumber(), mbgDimInfo.getBOSType().toString(), numLst);
        return srcNumber;
    }

    public static String createDimensionRefField(Context ctx) throws BOSException, EASBizException {
        String i2;
        String refField = null;
        if (ctx == null) {
            return refField;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        HashSet<Integer> refFieldMap = new HashSet<Integer>();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement("select FRefField from T_MBG_MbgDim where (FRefField IS NOT NULL )");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                String str = rst.getString(1);
                if (StringUtils.isEmpty((String)str)) continue;
                refFieldMap.add(new Integer(str.substring(1)));
            }
            if (refFieldMap.size() > 92) {
                throw new MbgDimException(MbgDimException.DIMOVERSYSOUTDEFAULT);
            }
            for (int i2 = 6; i2 <= 97; ++i2) {
                if (refFieldMap.contains(new Integer(i2))) continue;
                refField = "F" + i2;
                break;
            }
            i2 = refField;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return i2;
    }

    public static void setCancelDate(MbgMemberInfo info) {
        if (info == null || info.getParent() == null || info.getParent().isIsEnabled()) {
            return;
        }
        if (!info.getParent().isIsEnabled() && info.getParent().getDisabledDate() != null && info.isIsEnabled() && info.getDisabledDate() == null) {
            info.setIsEnabled(false);
            info.setDisabledDate(new Date(System.currentTimeMillis()));
        }
    }

    public static Set<String> getParentAndChildrenOrgUnitIds(OrgUnitInfo unitInfo) throws BOSException {
        return MbgDimHelper.getParentAndChildrenOrgUnitIds(null, unitInfo);
    }

    public static Set<String> getParentAndChildrenOrgUnitIds(Context ctx, OrgUnitInfo unitInfo) throws BOSException {
        if (unitInfo == null) {
            return new HashSet<String>();
        }
        String longNumber = unitInfo.getLongNumber();
        String[] tmpLongNumbers = longNumber.split(SPLITTER_TWO);
        if (tmpLongNumbers.length == 1) {
            return new HashSet<String>();
        }
        HashSet<String> orgUnitIds = new HashSet<String>();
        longNumber = unitInfo.getLongNumber();
        Object[] parentNumbers = longNumber.split(SPLITTER_TWO);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(ID);
        sic.add(NAME);
        sic.add(NUMBER);
        sic.add("longnumber");
        filter.getFilterItems().add(new FilterItemInfo(NUMBER, new HashSet(Arrays.asList((Object[])parentNumbers)), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(unitInfo.getLongNumber() + "!%"), CompareType.LIKE));
        filter.setMaskString("#0 or #1");
        evi.setFilter(filter);
        evi.setSelector(sic);
        CostCenterOrgUnitCollection costCenterColls = null;
        try {
            costCenterColls = ctx != null ? CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitCollection(evi) : CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(evi);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        if (costCenterColls == null) {
            return new HashSet<String>();
        }
        for (int i = 0; i < costCenterColls.size(); ++i) {
            orgUnitIds.add(costCenterColls.get(i).getId().toString());
        }
        return orgUnitIds;
    }
}

