/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class OrgUnitUtils {
    private static Color COLOR_DEFAULT = Color.BLACK;
    private static Color COLOR_SELECT = Color.RED;

    public static Color getCOLOR_DEFAULT() {
        return COLOR_DEFAULT;
    }

    public static Color getCOLOR_SELECT() {
        return COLOR_SELECT;
    }

    public static TreeModel getOrgTreeModel(KDTree kdTree, String orgUnitId) throws Exception {
        return OrgUnitUtils.getOrgTreeModel(kdTree, OrgViewType.COSTCENTER, orgUnitId, null);
    }

    public static TreeModel getOrgTreeModel(KDTree kdTree, String orgUnitId, TreeWillExpandListener listener) throws Exception {
        return OrgUnitUtils.getOrgTreeModel(kdTree, OrgViewType.COSTCENTER, orgUnitId, listener);
    }

    public static TreeModel getOrgTreeModel(KDTree kdTree, OrgViewType orgViewType, String orgUnitId, TreeWillExpandListener listener) throws Exception {
        TreeModel model;
        if (kdTree == null) {
            return null;
        }
        if (orgViewType == null) {
            orgViewType = OrgViewType.COSTCENTER;
        }
        if (StringUtils.isEmpty((String)orgUnitId)) {
            orgUnitId = SysContext.getSysContext().getCurrentCostUnit().getId().toString();
        }
        if ((model = OrgUnitUtils.getTreeModel(orgViewType, orgUnitId)) != null) {
            if (listener == null) {
                kdTree.addTreeWillExpandListener(new TreeWillExpandListener(){

                    @Override
                    public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
                        try {
                            OrgUnitUtils.addChildNode(node, null);
                        }
                        catch (Exception ex) {
                            ExceptionHandler.handle((String)"", (Throwable)ex);
                        }
                    }

                    @Override
                    public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
                    }
                });
            } else {
                kdTree.addTreeWillExpandListener(listener);
            }
        }
        return model;
    }

    protected static IOrgStructure getOrgStructureInterface() throws BOSException {
        return OrgStructureFactory.getRemoteInstance();
    }

    protected static TreeModel getTreeModel(OrgViewType orgViewType, String orgUnitId) throws Exception {
        OrgStructureInfo selNode = OrgUnitUtils.getOrgStructureInterface().getOrgStructureInfo("select id, longnumber ,unit.id,unit.number,unit.longnumber,unit.name where unit.id = '" + orgUnitId + "' and tree.id = '" + NewOrgViewHelper.convert2TreeId((OrgViewType)orgViewType) + "'");
        DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode((Object)selNode);
        DefaultTreeModel model = null;
        DefaultKingdeeTreeNode node = OrgUnitUtils.getDefaultKingdeeTreeNode(rootNode, orgViewType);
        if (node != null) {
            node.setTextColor(Color.BLACK);
            OrgUnitUtils.dealNode(node, null);
            model = new DefaultTreeModel((TreeNode)node);
        }
        return model;
    }

    public static DefaultKingdeeTreeNode getDefaultKingdeeTreeNode(DefaultKingdeeTreeNode root, OrgViewType viewType) throws EASBizException, BOSException {
        if (root == null) {
            return null;
        }
        if (viewType == null) {
            viewType = OrgViewType.COSTCENTER;
        }
        return NewOrgViewFacadeFactory.getRemoteInstance().getViewDirectChildNodesByMultiCondition(viewType, NewOrgViewHelper.convert2TreeId((OrgViewType)viewType), true, true, root, true, true, null, null, null);
    }

    private static void dealNode(DefaultKingdeeTreeNode root, Set<String> selOrgUnitIds) {
        if (root == null || root.getChildCount() == 0) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo oui = null;
        FullOrgUnitInfo unitInfo = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            node.setTextColor(OrgUnitUtils.getCOLOR_DEFAULT());
            oui = (OrgStructureInfo)node.getUserObject();
            if (oui != null && !oui.isIsLeaf()) {
                node.add((MutableTreeNode)new DefaultKingdeeTreeNode());
            }
            unitInfo = oui.getUnit();
            if (selOrgUnitIds == null || !selOrgUnitIds.contains(unitInfo.getId().toString())) continue;
            node.setTextColor(OrgUnitUtils.getCOLOR_SELECT());
        }
    }

    public static void addChildNode(DefaultKingdeeTreeNode root, Set<String> selOrgUnitIds) throws Exception {
        if (root == null) {
            return;
        }
        int childCount = root.getChildCount();
        if (childCount == 1) {
            int index;
            DefaultKingdeeTreeNode tempNode = (DefaultKingdeeTreeNode)root.getChildAt(0);
            if (tempNode.getUserObject() != null) {
                return;
            }
            root.removeAllChildren();
            DefaultKingdeeTreeNode _root = OrgUnitUtils.getDefaultKingdeeTreeNode(root, null);
            OrgUnitUtils.dealNode(_root, selOrgUnitIds);
            ArrayList<TreeNode> list = new ArrayList<TreeNode>();
            for (index = _root.getChildCount(); index > 0; --index) {
                list.add(_root.getChildAt(index - 1));
            }
            if (!list.isEmpty()) {
                for (index = list.size(); index > 0; --index) {
                    root.add((MutableTreeNode)((DefaultKingdeeTreeNode)list.get(index - 1)));
                }
            }
        }
    }

    public static List<OrgStructureInfo> getSelectOrgUnitInfo(KDTree kdTree) {
        if (kdTree == null) {
            return null;
        }
        ArrayList<OrgStructureInfo> orgUnits = new ArrayList<OrgStructureInfo>();
        return OrgUnitUtils.getSelectOrgUnitInfo((DefaultKingdeeTreeNode)kdTree.getModel().getRoot(), orgUnits);
    }

    private static List<OrgStructureInfo> getSelectOrgUnitInfo(DefaultKingdeeTreeNode root, List<OrgStructureInfo> orgUnits) {
        if (root == null || orgUnits == null) {
            return null;
        }
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            if (node.isChecked() && node.getUserObject() instanceof OrgStructureInfo) {
                orgUnits.add((OrgStructureInfo)node.getUserObject());
            }
            if (node.isLeaf()) continue;
            orgUnits = OrgUnitUtils.getSelectOrgUnitInfo(node, orgUnits);
        }
        return orgUnits;
    }

    public static List<String> getSelectOrgUnitIds(KDTree kdTree) {
        if (kdTree == null) {
            return null;
        }
        ArrayList<String> orgUnits = new ArrayList<String>();
        return OrgUnitUtils.getSelectOrgUnitIds((DefaultKingdeeTreeNode)kdTree.getModel().getRoot(), orgUnits);
    }

    private static List<String> getSelectOrgUnitIds(DefaultKingdeeTreeNode root, List<String> orgUnitIds) {
        if (root == null || orgUnitIds == null) {
            return null;
        }
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo os = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            if (node.isChecked()) {
                if (node.getUserObject() instanceof OrgStructureInfo) {
                    os = (OrgStructureInfo)node.getUserObject();
                    orgUnitIds.add(os.getUnit().getId().toString());
                } else if (node.getUserObject() instanceof OrgUnitInfo) {
                    orgUnitIds.add(((OrgUnitInfo)node.getUserObject()).getId().toString());
                }
            }
            if (node.isLeaf()) continue;
            orgUnitIds = OrgUnitUtils.getSelectOrgUnitIds(node, orgUnitIds);
        }
        return orgUnitIds;
    }

    public static void selectOrgUnit(KDTree kdTree, boolean selected) {
        if (kdTree == null) {
            return;
        }
        OrgUnitUtils.selectOrgUnit((DefaultKingdeeTreeNode)kdTree.getModel().getRoot(), selected);
        kdTree.updateUI();
    }

    public static void selectOrgUnit(DefaultKingdeeTreeNode root, boolean selected) {
        if (root == null) {
            return;
        }
        root.setChecked(selected);
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            node.setChecked(selected);
            if (node.isLeaf()) continue;
            OrgUnitUtils.selectOrgUnit(node, selected);
        }
    }

    public static void selectOrgUnit(KDTree kdTree, Set<String> selOrgUnitIds) {
        if (kdTree == null || selOrgUnitIds == null) {
            return;
        }
        OrgUnitUtils.selectOrgUnit((DefaultKingdeeTreeNode)kdTree.getModel().getRoot(), selOrgUnitIds);
    }

    public static void selectOrgUnit(DefaultKingdeeTreeNode root, Set<String> selOrgUnitIds) {
        if (root == null) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo oui = null;
        Object userObject = root.getUserObject();
        if (userObject != null) {
            OrgUnitInfo orgUnit;
            if (userObject instanceof OrgStructureInfo) {
                oui = (OrgStructureInfo)userObject;
                if (oui.getUnit() != null && selOrgUnitIds.contains(oui.getUnit().getId().toString())) {
                    root.setChecked(true);
                }
            } else if (userObject instanceof OrgUnitInfo && selOrgUnitIds.contains((orgUnit = (OrgUnitInfo)userObject).getId().toString())) {
                root.setChecked(true);
            }
        }
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            OrgUnitUtils.selectOrgUnit(node, selOrgUnitIds);
        }
    }

    public static void selectDirectOrgUnit(DefaultKingdeeTreeNode root, boolean selected) {
        if (root == null) {
            return;
        }
        root.setChecked(selected);
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            node.setChecked(selected);
        }
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, IObjectValue costCenterInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = null;
        CostCenterOrgUnitInfo cost = (CostCenterOrgUnitInfo)costCenterInfo;
        if (cost.getId() == null) {
            return company;
        }
        String orgId = cost.getId().toString();
        if (cost.isIsCompanyOrgUnit()) {
            company = (CompanyOrgUnitInfo)NewOrgViewHelper.getOrgUnitInfo((Context)ctx, (String)cost.getId().toString(), (OrgType)OrgType.Company);
        } else {
            IOrgUnitRelation our = null;
            our = ctx == null ? OrgUnitRelationFactory.getRemoteInstance() : OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection col = our.getToUnit(orgId, 5, 1);
            if (col != null && !col.isEmpty()) {
                company = (CompanyOrgUnitInfo)col.get(0);
            } else {
                String[] numbers = cost.getLongNumber().split("!");
                ICompanyOrgUnit cou = null;
                cou = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("number", new HashSet<String>(Arrays.asList(numbers)), CompareType.INCLUDE));
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add("id");
                evi.getSelector().add("number");
                evi.getSelector().add("name");
                evi.getSelector().add("longNumber");
                evi.getSelector().add("accountTable.id");
                CompanyOrgUnitCollection ccol = cou.getCompanyOrgUnitCollection(evi);
                if (ccol != null && !ccol.isEmpty()) {
                    block0: for (int n = numbers.length - 1; n >= 0; --n) {
                        for (int c = 0; c < ccol.size(); ++c) {
                            if (!numbers[n].equals(ccol.get(c).getNumber())) continue;
                            company = ccol.get(c);
                            break block0;
                        }
                    }
                }
            }
        }
        return company;
    }
}

