/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.bos.Context;
import java.util.HashMap;
import java.util.Map;

public abstract class BgContext {
    public Object getObject(String key) {
        return this.getBgCache().get(key);
    }

    protected abstract Map getBgCache();

    public void putObject(String key, Object obj) {
        this.getBgCache().put(key, obj);
    }

    private BgContext() {
    }

    public static BgContext getClientInstance() {
        return new ClientBgContext();
    }

    public static BgContext getServerInstance(Context ctx) {
        ServerBgContext bgCtx = null;
        bgCtx = new ServerBgContext(ctx);
        return bgCtx;
    }

    private static class ServerBgContext
    extends BgContext {
        private Context ctx;
        private static String cache_key = "server_bg_cache";

        public ServerBgContext(Context ctx) {
            this.ctx = ctx;
        }

        @Override
        public Map getBgCache() {
            HashMap cache = this.ctx.get((Object)cache_key);
            if (cache == null) {
                cache = new HashMap();
                this.ctx.put((Object)cache_key, cache);
            }
            return cache;
        }
    }

    private static class ClientBgContext
    extends BgContext {
        @Override
        public Object getObject(String key) {
            return null;
        }

        @Override
        public void putObject(String key, Object obj) {
        }

        @Override
        public Map getBgCache() {
            return null;
        }
    }
}

