/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.eas.ma.bg.AbstractBgDataInfo;
import com.kingdee.eas.ma.bg.BgCtrlTypeEnum;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgTemplateColumnInfo;
import com.kingdee.eas.ma.bg.BgTemplateRowInfo;
import java.io.Serializable;
import java.math.BigDecimal;

public class BgDataInfo
extends AbstractBgDataInfo
implements Serializable,
Comparable {
    public BgDataInfo() {
    }

    protected BgDataInfo(String pkField) {
        super(pkField);
    }

    public void generateByTemplate(BgTemplateRowInfo bgTpRowInfo, BgTemplateColumnInfo bgTpColumnInfo) {
        BgElementInfo bgElementInfo = bgTpColumnInfo.getBgElement();
        this.setBgElement(bgElementInfo);
        this.setElementNumber(bgElementInfo.getNumber());
        this.setDataType(bgElementInfo.getDataType());
        if (bgTpColumnInfo.isIsControlled()) {
            this.setBgCtrlType(bgTpRowInfo.getBgControlType());
        } else {
            this.setBgCtrlType(BgCtrlTypeEnum.NoCtrl);
        }
        this.setIsFlexibleCtrl(bgTpRowInfo.isIsFlexibleCtrl());
        this.setFlexibleBgCtrlParam(bgTpRowInfo.getFlexibleBgCtrlParam());
        this.setRelativeCtrlFormula(bgTpRowInfo.getRelativeCtrlFormula());
    }

    public void generateByRptTemplate(BgElementInfo bgElementInfo) {
        this.setBgElement(bgElementInfo);
        this.setElementNumber(bgElementInfo.getNumber());
        this.setDataType(bgElementInfo.getDataType());
        this.setBgCtrlType(BgCtrlTypeEnum.NoCtrl);
        this.setIsFlexibleCtrl(false);
        this.setFlexibleBgCtrlParam(new BigDecimal("0"));
        this.setRelativeCtrlFormula("");
    }

    public int compareTo(Object o) {
        BgDataInfo bgDataInfo = (BgDataInfo)o;
        int result = 0;
        result = this.getBgElement().compareTo(bgDataInfo.getBgElement());
        if (result != 0) {
            return result;
        }
        result = this.getCurrency().getNumber().compareTo(bgDataInfo.getCurrency().getNumber());
        return result;
    }

    public String getElementKey() {
        return BgHelper.getBgElementKey(this.getBgElement(), this.getCurrency());
    }

    public String toString() {
        BigDecimal value = this.getBgValue();
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public BgDataInfo dataClone() {
        BgDataInfo bdi = new BgDataInfo();
        BigDecimal zero = new BigDecimal("0.00");
        if (this.getBgValue() != null) {
            bdi.setBgValue(new BigDecimal(Double.toString(this.getBgValue().doubleValue())));
        } else {
            bdi.setBgValue(zero);
        }
        if (this.getBizActual() != null) {
            bdi.setBizActual(new BigDecimal(Double.toString(this.getBizActual().doubleValue())));
        } else {
            bdi.setBizActual(zero);
        }
        bdi.setBgElement(this.getBgElement());
        bdi.setElementNumber(this.getElementNumber());
        bdi.setDataType(this.getDataType());
        bdi.setCurrency(this.getCurrency());
        return bdi;
    }
}

