/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASVerifyException;
import com.kingdee.eas.ma.bg.BgORMEngine;
import com.kingdee.eas.ma.bg.BgORMException;
import com.kingdee.eas.ma.bg.BgVerifyException;
import com.kingdee.eas.ma.bg.SingleVOCache;
import com.kingdee.util.IllegalConversionException;
import com.kingdee.util.InvalidDateException;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;

public class BgEntityAccess {
    private static final String VALUES_BRACKET = ") values(? ";
    private static final String RIGHT_BRACKET = " )";
    private static final String LEFT_BRACKET = " ( ";
    private static final String INTEGER = "Integer";
    private static final String TIMESTAMP = "TimeStamp";
    private static final String TIME = "Time";
    private static final String DATE = "Date";
    private static final String BOOLEAN = "Boolean";
    private static final String STRING = "String";
    private static final String ENUM = "Enum";
    private static final String BOSUUID = "BOSUuid";
    private static final String BIGDECIMAL = "BigDecimal";
    private static final String L3 = "_L3";
    private static final String L2 = "_L2";
    private static final String L1 = "_L1";
    private static final String SET = " set ";
    private static final Locale ObjL1 = new Locale("L1");
    private static final Locale ObjL2 = new Locale("L2");
    private static final Locale ObjL3 = new Locale("L3");
    private static final int BOSUUID_LENGTH = 44;
    private static final String UPDATE = " update ";
    private static final String SELECT = " select ";
    private static final String INSERT_INTO = " insert into  ";
    private static final String DELETE_FROM = " delete from ";
    private static final String WHERE = " where ";
    private static final String OR = " or ";
    private static final String COMA_QUEST = ",?";
    private static final String EQUAL_QUEST = "=?";
    private static final String COMMA = ", ";
    public static final String ENTITY_PK_NAME = "id";
    public int[] sqlTypeAry = null;
    public String[] entityRunningPropertyAry = null;
    public String[] entityNameAry = null;
    public String[] dbFieldNameAry = null;
    public String[] dataType = null;
    public boolean[] isLang = null;
    public boolean[] isLink = null;
    public String tableName = null;
    public String pkFieldName = null;
    public int savePageSize = Integer.MAX_VALUE;

    public BgEntityAccess(Context ctx, BOSObjectType bosType, String[] entityProperties) throws BgVerifyException {
        IMetaDataLoader metaDataloader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entityObject = metaDataloader.getEntity(bosType);
        DataTableInfo tableObject = entityObject.getTable();
        this.tableName = tableObject.getName();
        this.pkFieldName = entityObject.getPropertyByName(ENTITY_PK_NAME).getMappingField().getName();
        int properysize = 0;
        ArrayList<PropertyInfo> prop = new ArrayList<PropertyInfo>();
        for (int i = 0; i < entityProperties.length; ++i) {
            PropertyInfo pro = entityObject.getPropertyByName(entityProperties[i]);
            properysize = pro.getBoolean("isMultilingual") ? (properysize += 3) : ++properysize;
            prop.add(pro);
        }
        this.entityRunningPropertyAry = new String[properysize];
        this.entityNameAry = entityProperties;
        this.isLang = new boolean[properysize];
        this.isLink = new boolean[properysize];
        this.sqlTypeAry = new int[properysize];
        this.dbFieldNameAry = new String[properysize];
        this.dataType = new String[properysize];
        int cnt = 0;
        for (int i = 0; i < entityProperties.length; ++i) {
            PropertyInfo entityProperty = (PropertyInfo)prop.get(i);
            if (entityProperty == null) {
                throw new BgVerifyException(BgVerifyException.CHECKNOEXIST, new Object[]{"property:" + entityProperties[i]});
            }
            String dbField = entityProperty.getMappingField().getName();
            ColumnInfo tableColumn = tableObject.getColumnByName(dbField);
            if (tableColumn == null) {
                System.out.println("EEEEEEEEEEEEEEEEEEEEEEE DBField:" + dbField);
                System.out.println("EEEEEEEEEEEEEEEEEEEEEEE entityName:" + entityProperty.getName());
            }
            if (entityProperty.getBoolean("isMultilingual")) {
                this.initStateaInfo(cnt, entityProperty, tableColumn);
                this.entityRunningPropertyAry[cnt] = !ctx.getLocale().equals(ObjL1) ? entityProperties[i] + L1 : entityProperties[i];
                this.dbFieldNameAry[cnt++] = dbField + L1;
                this.initStateaInfo(cnt, entityProperty, tableColumn);
                this.entityRunningPropertyAry[cnt] = !ctx.getLocale().equals(ObjL2) ? entityProperties[i] + L2 : entityProperties[i];
                this.dbFieldNameAry[cnt++] = dbField + L2;
                this.initStateaInfo(cnt, entityProperty, tableColumn);
                this.entityRunningPropertyAry[cnt] = !ctx.getLocale().equals(ObjL3) ? entityProperties[i] + L3 : entityProperties[i];
                this.dbFieldNameAry[cnt++] = dbField + L3;
                continue;
            }
            this.initStateaInfo(cnt, entityProperty, tableColumn);
            this.entityRunningPropertyAry[cnt] = entityProperties[i];
            this.dbFieldNameAry[cnt++] = dbField;
        }
    }

    private void initStateaInfo(int IndexCount, PropertyInfo entityproperty, ColumnInfo tableColumn) {
        this.isLink[IndexCount] = entityproperty instanceof LinkPropertyInfo;
        if (tableColumn == null) {
            System.out.println("EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE  colunmName last:" + entityproperty.getName());
        }
        if (tableColumn.getTypeName() == null) {
            System.out.println("EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE typeName:" + tableColumn.getName());
        }
        this.sqlTypeAry[IndexCount] = tableColumn.getTypeName().getSQLType();
        this.dataType[IndexCount] = entityproperty.getString("dataType");
    }

    public String getDBFieldName(int i, String name) {
        Object fieldName = null;
        if (this.isLang[i]) {
            StringBuffer sb = new StringBuffer((name.length() + 4) * 3);
            sb.append(name);
            sb.append(L1);
            sb.append(EQUAL_QUEST);
            sb.append(COMMA);
            sb.append(name);
            sb.append(L2);
            sb.append(EQUAL_QUEST);
            sb.append(COMMA);
            sb.append(name);
            sb.append(L3);
            return sb.toString();
        }
        return name;
    }

    public int[] update(Context ctx, IObjectValue[] coll) throws EASBizException {
        int[] i;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(this.getUpdateSql());
            for (IObjectValue vo : coll) {
                Object id = vo.get(ENTITY_PK_NAME);
                if (id == null) {
                    throw new EASVerifyException(EASVerifyException.CHECKBLANK, new Object[]{ENTITY_PK_NAME});
                }
                this.bindToParam(stmt, vo, 1);
                int length = id.toString().length();
                if (length != 28 && length != 44) {
                    throw new SQLException("\u4e1a\u52a1\u5bf9\u8c61ID\u957f\u5ea6\u8bbe\u7f6e\u5f02\u5e38\uff01");
                }
                stmt.setAsciiStream(this.entityRunningPropertyAry.length + 1, (InputStream)new ByteArrayInputStream(id.toString().getBytes()), length);
                stmt.addBatch();
            }
            i = stmt.executeBatch();
        }
        catch (SQLException e1) {
            try {
                throw new BgORMException(BgORMException.UPDATEENTITY, e1, new Object[]{this.tableName});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return i;
    }

    public String getUpdateSql() {
        StringBuffer updateSb = new StringBuffer(128);
        updateSb.append(UPDATE);
        updateSb.append(this.tableName);
        updateSb.append(SET);
        for (int i = 0; i < this.dbFieldNameAry.length; ++i) {
            if (i == 0) {
                updateSb.append(this.dbFieldNameAry[i]);
                updateSb.append(EQUAL_QUEST);
                continue;
            }
            updateSb.append(COMMA);
            updateSb.append(this.dbFieldNameAry[i]);
            updateSb.append(EQUAL_QUEST);
        }
        updateSb.append(WHERE);
        updateSb.append(this.pkFieldName);
        updateSb.append(EQUAL_QUEST);
        return updateSb.toString();
    }

    public String getSelectorSQL() {
        StringBuffer sb = new StringBuffer(128);
        sb.append(SELECT);
        for (int i = 0; i < this.dbFieldNameAry.length; ++i) {
            if (i == 0) {
                sb.append(this.dbFieldNameAry[i]);
                continue;
            }
            sb.append(COMMA).append(this.dbFieldNameAry[i]);
        }
        sb.append(" from ");
        sb.append(this.tableName);
        sb.append(WHERE);
        sb.append(this.pkFieldName);
        sb.append(EQUAL_QUEST);
        return sb.toString();
    }

    private void buildVO(Context ctx, ResultSet rs, IObjectValue vo) throws SQLException, EASBizException {
        for (int i = 0; i < this.entityRunningPropertyAry.length; ++i) {
            int rsIndex = i + 1;
            this.buildVO(ctx, rs, vo, i, rsIndex);
        }
    }

    private void buildVO(Context ctx, ResultSet rs, IObjectValue vo, int i, int rsIndex) throws SQLException, EASBizException {
        Object o = rs.getObject(rsIndex);
        if (o == null) {
            return;
        }
        if (this.isLink[i]) {
            vo.put(this.entityRunningPropertyAry[i], (Object)SingleVOCache.getSingleVO(ctx, BOSUuid.read((String)o.toString())));
        } else if (this.dataType[i].equals(BIGDECIMAL)) {
            vo.setBigDecimal(this.entityRunningPropertyAry[i], rs.getBigDecimal(rsIndex));
        } else if (this.dataType[i].equals(BOSUUID)) {
            vo.setBOSUuid(this.entityRunningPropertyAry[i], TypeConversionUtils.objToBOSUuid((Object)o));
        } else if (this.dataType[i].equals(ENUM)) {
            vo.setInt(this.entityRunningPropertyAry[i], TypeConversionUtils.objToInt((Object)o));
        } else if (this.dataType[i].equals(STRING)) {
            vo.setString(this.entityRunningPropertyAry[i], TypeConversionUtils.objToString((Object)o));
        } else if (this.dataType[i].equals(BOOLEAN)) {
            vo.setBoolean(this.entityRunningPropertyAry[i], TypeConversionUtils.objToBoolean((Object)o));
        } else if (this.dataType[i].equals(DATE)) {
            vo.setDate(this.entityRunningPropertyAry[i], TypeConversionUtils.objToDate((Object)o));
        } else if (this.dataType[i].equals(TIME)) {
            vo.setTime(this.entityRunningPropertyAry[i], TypeConversionUtils.objToTime((Object)o));
        } else if (this.dataType[i].equals(TIMESTAMP)) {
            vo.setTimestamp(this.entityRunningPropertyAry[i], TypeConversionUtils.objToTimestamp((Object)o));
        } else if (this.dataType[i].equals(INTEGER)) {
            vo.setInt(this.entityRunningPropertyAry[i], TypeConversionUtils.objToInt((Object)o));
        } else {
            throw new BgORMException(BgORMException.ILLEGALLENTITYTYPE, new Object[]{this.dataType});
        }
    }

    public IObjectValue getVO(Context ctx, BOSUuid id) throws EASBizException {
        IObjectValue iObjectValue;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(this.getSelectorSQL());
            stmt.setString(1, id.toString());
            rs = stmt.executeQuery();
            IObjectValue vo = BgORMEngine.getNewVOInstance(ctx, id);
            if (!rs.next()) {
                throw new BgVerifyException(BgVerifyException.CHECKNOEXIST, new Object[]{id});
            }
            vo.setBOSUuid(ENTITY_PK_NAME, id);
            this.buildVO(ctx, rs, vo);
            iObjectValue = vo;
        }
        catch (SQLException e1) {
            try {
                throw new BgORMException(BgORMException.GETVO, e1, new Object[]{id});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return iObjectValue;
    }

    public String getInsertSQL() {
        int i;
        StringBuffer updateSb = new StringBuffer(128);
        updateSb.append(INSERT_INTO);
        updateSb.append(this.tableName);
        updateSb.append(LEFT_BRACKET);
        updateSb.append(this.pkFieldName);
        for (i = 0; i < this.dbFieldNameAry.length; ++i) {
            updateSb.append(COMMA);
            updateSb.append(this.dbFieldNameAry[i]);
        }
        updateSb.append(VALUES_BRACKET);
        for (i = 0; i < this.dbFieldNameAry.length; ++i) {
            updateSb.append(COMA_QUEST);
        }
        return updateSb.append(RIGHT_BRACKET).toString();
    }

    public int[] addnew(Context ctx, IObjectValue[] coll) throws BgORMException {
        if (coll == null || coll.length == 0) {
            return null;
        }
        try {
            String sql = this.getInsertSQL();
            int[] nArray = this.doSave(ctx, sql, coll, 0, coll.length);
            return nArray;
        }
        catch (Exception e1) {
            throw new BgORMException(BgORMException.ADDNEWENTITY, e1, new Object[]{this.tableName});
        }
    }

    public void bindToParam(PreparedStatement stat, IObjectValue values, int startIndex) throws SQLException {
        for (int i = 0; i < this.entityRunningPropertyAry.length; ++i) {
            this.bindToParam(stat, i, values, startIndex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void bindToParam(PreparedStatement stmt, int i, IObjectValue values, int srartIndex) throws SQLException {
        String fieldname = this.entityRunningPropertyAry[i];
        int sqltype = this.sqlTypeAry[i];
        int parmIndex = i + srartIndex;
        try {
            Object o = values.get(fieldname);
            if (o == null || o instanceof String && o.toString().length() == 0) {
                if (sqltype == 2005) {
                    stmt.setString(parmIndex, null);
                    return;
                }
                if (sqltype == 2004) {
                    stmt.setBytes(parmIndex, null);
                    return;
                }
                stmt.setNull(parmIndex, sqltype);
                return;
            }
            if (this.isLink[i]) {
                IObjectValue vo = (IObjectValue)o;
                BOSUuid id = vo.getBOSUuid(ENTITY_PK_NAME);
                if (id == null) {
                    stmt.setNull(parmIndex, sqltype);
                    return;
                } else {
                    int length = id.toString().length();
                    if (length != 28 && length != 44) throw new SQLException("\u4e1a\u52a1\u5bf9\u8c61ID\u957f\u5ea6\u8bbe\u7f6e\u5f02\u5e38\uff01");
                    stmt.setAsciiStream(parmIndex, (InputStream)new ByteArrayInputStream(id.toString().getBytes()), length);
                }
                return;
            }
            switch (sqltype) {
                case -1: 
                case 1: 
                case 12: {
                    if (o instanceof BOSUuid) {
                        int length = o.toString().length();
                        if (length != 28 && length != 44) throw new SQLException("\u4e1a\u52a1\u5bf9\u8c61ID\u957f\u5ea6\u8bbe\u7f6e\u5f02\u5e38\uff01");
                        stmt.setAsciiStream(parmIndex, (InputStream)new ByteArrayInputStream(o.toString().getBytes()), length);
                        return;
                    } else {
                        stmt.setString(parmIndex, o.toString());
                    }
                    return;
                }
                case 4: {
                    stmt.setInt(parmIndex, TypeConversionUtils.objToInt((Object)o));
                    return;
                }
                case -7: {
                    stmt.setBoolean(parmIndex, TypeConversionUtils.objToBoolean((Object)o));
                    return;
                }
                case -6: {
                    stmt.setByte(parmIndex, TypeConversionUtils.objToByte((Object)o));
                    return;
                }
                case 5: {
                    stmt.setShort(parmIndex, TypeConversionUtils.objToShort((Object)o));
                    return;
                }
                case -5: {
                    stmt.setLong(parmIndex, TypeConversionUtils.objToLong((Object)o));
                    return;
                }
                case 6: 
                case 7: 
                case 8: {
                    stmt.setDouble(parmIndex, TypeConversionUtils.objToDouble((Object)o));
                    return;
                }
                case 2: 
                case 3: {
                    stmt.setBigDecimal(parmIndex, TypeConversionUtils.objToBigDecimal((Object)o).setScale(10, 4));
                    return;
                }
                case 91: {
                    stmt.setDate(parmIndex, TypeConversionUtils.objToDate((Object)o));
                    return;
                }
                case 92: {
                    stmt.setTime(parmIndex, TypeConversionUtils.objToTime((Object)o));
                    return;
                }
                case 93: {
                    stmt.setObject(parmIndex, TypeConversionUtils.objToTimestamp((Object)o));
                    return;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    stmt.setBytes(parmIndex, TypeConversionUtils.objToBytes((Object)o));
                    return;
                }
                case 2005: {
                    stmt.setString(parmIndex, TypeConversionUtils.objToString((Object)o));
                    return;
                }
            }
            throw new SQLException("Cannot deal with type: " + sqltype);
        }
        catch (IllegalConversionException ice) {
            throw new SQLException(fieldname + "Illegal conversion");
        }
        catch (InvalidDateException dte) {
            throw new SQLException(fieldname + "Invalida Date");
        }
    }

    private int[] doSave(Context ctx, String sql, IObjectValue[] coll, int from, int to) throws BgORMException {
        int[] nArray;
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            int[] rst;
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql);
            Object id = null;
            for (int i = from; i < to; ++i) {
                int length;
                IObjectValue vo = coll[i];
                id = vo.get(ENTITY_PK_NAME);
                if (id == null) {
                    id = BOSUuid.create((BOSObjectType)vo.getBOSType());
                    vo.put(ENTITY_PK_NAME, id);
                }
                if ((length = id.toString().length()) != 28 && length != 44) {
                    throw new SQLException("\u4e1a\u52a1\u5bf9\u8c61ID\u957f\u5ea6\u8bbe\u7f6e\u5f02\u5e38\uff01");
                }
                stmt.setAsciiStream(1, (InputStream)new ByteArrayInputStream(id.toString().getBytes()), length);
                this.bindToParam(stmt, vo, 2);
                stmt.addBatch();
            }
            nArray = rst = stmt.executeBatch();
        }
        catch (SQLException e1) {
            try {
                e1.printStackTrace();
                throw new BgORMException(BgORMException.ADDNEWENTITY, e1, new Object[]{this.tableName});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return nArray;
    }
}

