/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.AbstractBgFormInfo;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgDataCollection;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgEntryCollection;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgPastDataInfo;
import com.kingdee.eas.ma.bg.BgPastRecordInfo;
import com.kingdee.eas.ma.bg.BgPeriodNode;
import com.kingdee.eas.ma.bg.BgRollFormFactory;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;

public class BgFormInfo
extends AbstractBgFormInfo
implements Serializable {
    private transient HashMap mapBgDatas = new HashMap(1024);
    private transient HashMap mapEntries = new HashMap(1024);

    public BgFormInfo() {
        this("id");
    }

    public void setOrgUnit(OrgUnitInfo item) {
        this.setOrgUnit(item.castToFullOrgUnitInfo());
    }

    protected BgFormInfo(String pkField) {
        super(pkField);
    }

    public HashMap getPlainBgDatas() {
        return this.mapBgDatas;
    }

    public HashMap getMapBgEntries() {
        return this.mapEntries;
    }

    public BgFormInfo deepClone() {
        BgFormInfo clonedBgFormInfo = (BgFormInfo)this.clone();
        clonedBgFormInfo.remove("id");
        clonedBgFormInfo.setId(BOSUuid.create((BOSObjectType)clonedBgFormInfo.getBOSType()));
        Iterator iter = clonedBgFormInfo.getBgEntries().iterator();
        while (iter.hasNext()) {
            BgEntryInfo clonedBgEntryInfo = (BgEntryInfo)iter.next();
            clonedBgEntryInfo.remove("id");
            clonedBgEntryInfo.remove("bgForm");
            clonedBgEntryInfo.setId(BOSUuid.create((BOSObjectType)clonedBgEntryInfo.getBOSType()));
            Iterator dataIter = clonedBgEntryInfo.getBgData().iterator();
            while (dataIter.hasNext()) {
                BgDataInfo clonedBgDataInfo = (BgDataInfo)dataIter.next();
                clonedBgDataInfo.remove("id");
                clonedBgDataInfo.remove("bgEntry");
                clonedBgDataInfo.setId(BOSUuid.create((BOSObjectType)clonedBgDataInfo.getBOSType()));
            }
        }
        Iterator iter1 = clonedBgFormInfo.getPastRecords().iterator();
        BgPastRecordInfo recordInfo = null;
        while (iter1.hasNext()) {
            recordInfo = (BgPastRecordInfo)iter1.next();
            recordInfo.remove("id");
            recordInfo.remove("bgForm");
            recordInfo.setId(BOSUuid.create((BOSObjectType)recordInfo.getBOSType()));
        }
        return clonedBgFormInfo;
    }

    public BgEntryCollection getBgEntries(PeriodInfo periodInfo, BgCycleTypeEnum bgCycleType) {
        BgEntryCollection bgEntries = new BgEntryCollection();
        Iterator iter = this.getBgEntries().iterator();
        BgEntryInfo bgEntryInfo = null;
        while (iter.hasNext()) {
            bgEntryInfo = (BgEntryInfo)iter.next();
            if (!bgEntryInfo.getBgCycle().equals((Object)bgCycleType) || !bgEntryInfo.getPeriod().getId().toString().equals(periodInfo.getId().toString())) continue;
            bgEntries.add(bgEntryInfo);
        }
        return bgEntries;
    }

    public boolean checkHasUpperBgEntries(PeriodInfo periodInfo, BgCycleTypeEnum bgCycleType) {
        block3: {
            BgEntryInfo bgEntryInfo;
            Iterator iter;
            block2: {
                BgEntryCollection bgEntries = new BgEntryCollection();
                iter = this.getBgEntries().iterator();
                bgEntryInfo = null;
                if (bgCycleType.getValue() != 2) break block2;
                while (iter.hasNext()) {
                    bgEntryInfo = (BgEntryInfo)iter.next();
                    if (!bgEntryInfo.getBgCycle().equals((Object)bgCycleType) || bgEntryInfo.getPeriod().getPeriodYear() != periodInfo.getPeriodYear() || bgEntryInfo.getPeriod().getPeriodQuarter() != periodInfo.getPeriodQuarter()) continue;
                    return true;
                }
                break block3;
            }
            if (bgCycleType.getValue() != 1) break block3;
            while (iter.hasNext()) {
                bgEntryInfo = (BgEntryInfo)iter.next();
                if (!bgEntryInfo.getBgCycle().equals((Object)bgCycleType) || bgEntryInfo.getPeriod().getPeriodYear() != periodInfo.getPeriodYear()) continue;
                return true;
            }
        }
        return false;
    }

    public HashMap reassembleBgForm() {
        this.mapBgDatas = new HashMap(1024);
        this.mapEntries = new HashMap(1024);
        HashMap map = new HashMap(1024);
        BgEntryInfo bgEntryInfo = null;
        BgDataInfo bgDataInfo = null;
        Iterator iter = this.getBgEntries().iterator();
        while (iter.hasNext()) {
            bgEntryInfo = (BgEntryInfo)iter.next();
            String entryKey = BgFormInfo.generateEntryCode(bgEntryInfo);
            Iterator datas = bgEntryInfo.getBgData().iterator();
            HashMap<Integer, BgDataInfo> subMap = new HashMap<Integer, BgDataInfo>(64);
            while (datas.hasNext()) {
                bgDataInfo = (BgDataInfo)datas.next();
                String dataKey = BgFormInfo.generateBgDataCode(bgDataInfo);
                subMap.put(new Integer(dataKey.hashCode()), bgDataInfo);
                System.out.println(entryKey + dataKey);
                this.mapBgDatas.put(new Integer((entryKey + dataKey).hashCode()), bgDataInfo);
            }
            map.put(new Integer(entryKey.hashCode()), subMap);
            this.mapEntries.put(new Integer(entryKey.hashCode()), bgEntryInfo);
        }
        return map;
    }

    public HashMap reassembleBgForm1() {
        this.mapBgDatas = new HashMap(1024);
        this.mapEntries = new HashMap(1024);
        HashMap map = new HashMap(1024);
        BgEntryInfo bgEntryInfo = null;
        BgDataInfo bgDataInfo = null;
        Iterator iter = this.getBgEntries().iterator();
        while (iter.hasNext()) {
            bgEntryInfo = (BgEntryInfo)iter.next();
            String entryKey = BgFormInfo.generateEntryCode(bgEntryInfo);
            Iterator datas = bgEntryInfo.getBgData().iterator();
            HashMap<String, BgDataInfo> subMap = new HashMap<String, BgDataInfo>(64);
            while (datas.hasNext()) {
                bgDataInfo = (BgDataInfo)datas.next();
                String dataKey = BgFormInfo.generateBgDataCode(bgDataInfo);
                subMap.put(dataKey, bgDataInfo);
                System.out.println(entryKey + dataKey);
                this.mapBgDatas.put(entryKey + dataKey, bgDataInfo);
            }
            map.put(entryKey, subMap);
            this.mapEntries.put(entryKey, bgEntryInfo);
        }
        return map;
    }

    public static String generateEntryCode(BgEntryInfo info) {
        StringBuffer buff = new StringBuffer(256);
        buff.append(new Integer(info.getBgCycle().getValue()).toString());
        buff.append(info.getPeriod().getId().toString());
        buff.append(BgFormInfo.getItem(info.getBgItem1()));
        buff.append(BgFormInfo.getItem(info.getBgItem2()));
        buff.append(BgFormInfo.getItem(info.getBgItem3()));
        buff.append(BgFormInfo.getItem(info.getBgItem4()));
        buff.append(BgFormInfo.getItem(info.getBgItem5()));
        buff.append(BgFormInfo.getItem(info.getBgItem6()));
        return buff.toString();
    }

    private static String getItem(BgItemInfo info) {
        if (info == null) {
            return "_";
        }
        return info.getItemNumber();
    }

    public static String generateBgDataCode(BgDataInfo info) {
        StringBuffer buff = new StringBuffer(256);
        String defStr = "|";
        String eleNumber = info.getElementNumber();
        if (eleNumber == null) {
            buff.append(defStr);
        } else {
            buff.append(eleNumber);
        }
        CurrencyInfo currency = info.getCurrency();
        if (currency == null) {
            buff.append(defStr);
        } else {
            buff.append(currency.getId().toString());
        }
        BgElementInfo eleInfo = info.getBgElement();
        if (eleInfo == null) {
            buff.append(defStr);
        } else {
            buff.append(eleInfo.getId().toString());
        }
        return buff.toString();
    }

    public BgEntryCollection getSummedBgEntries(PeriodInfo periodInfo, BgCycleTypeEnum bgCycleType) {
        BgEntryCollection bgEntries = new BgEntryCollection();
        HashMap<String, Integer> itemMap = new HashMap<String, Integer>();
        TreeMap<Integer, BgEntryCollection> entryMap = new TreeMap<Integer, BgEntryCollection>();
        int row = 0;
        Iterator iter = this.getBgEntries().iterator();
        while (iter.hasNext()) {
            Integer rowIndex;
            BgEntryInfo bgEntryInfo = (BgEntryInfo)iter.next();
            boolean needAddIn = this.isChildOfPeriodNode(periodInfo, bgCycleType, bgEntryInfo);
            if (!needAddIn) continue;
            String itemsKey = bgEntryInfo.getBgItemsKey();
            if (itemMap.get(itemsKey) == null) {
                rowIndex = new Integer(row);
                itemMap.put(itemsKey, rowIndex);
                BgEntryCollection bec = new BgEntryCollection();
                entryMap.put(rowIndex, bec);
                ++row;
            }
            rowIndex = (Integer)itemMap.get(itemsKey);
            ((BgEntryCollection)((Object)entryMap.get(rowIndex))).add(bgEntryInfo);
        }
        for (BgEntryCollection summedBgEntries : entryMap.values()) {
            BgEntryInfo summedBgEntryInfo = BgEntryInfo.getSummedBgEntry(summedBgEntries);
            summedBgEntryInfo.setIsLeafPeriod(false);
            bgEntries.add(summedBgEntryInfo);
        }
        return bgEntries;
    }

    public BgEntryCollection getSummedBgEntries(PeriodInfo periodInfo, BgCycleTypeEnum bgCycleType, String kindName) {
        BgEntryCollection bgEntries = new BgEntryCollection();
        HashMap<String, Integer> itemMap = new HashMap<String, Integer>();
        TreeMap<Integer, BgEntryCollection> entryMap = new TreeMap<Integer, BgEntryCollection>();
        int row = 0;
        Iterator iter = this.getBgEntries().iterator();
        while (iter.hasNext()) {
            Integer rowIndex;
            BgEntryInfo bgEntryInfo = (BgEntryInfo)iter.next();
            boolean needAddIn = this.isChildOfPeriodNode(periodInfo, bgCycleType, bgEntryInfo);
            if (!needAddIn) continue;
            String itemsKey = bgEntryInfo.getBgItemsKey();
            if (itemMap.get(itemsKey) == null) {
                rowIndex = new Integer(row);
                itemMap.put(itemsKey, rowIndex);
                BgEntryCollection bec = new BgEntryCollection();
                entryMap.put(rowIndex, bec);
                ++row;
            }
            rowIndex = (Integer)itemMap.get(itemsKey);
            ((BgEntryCollection)((Object)entryMap.get(rowIndex))).add(bgEntryInfo);
        }
        for (BgEntryCollection summedBgEntries : entryMap.values()) {
            BgEntryInfo summedBgEntryInfo = BgEntryInfo.getSummedBgEntry(summedBgEntries, kindName);
            bgEntries.add(summedBgEntryInfo);
        }
        return bgEntries;
    }

    public boolean isChildOfPeriodNode(PeriodInfo periodInfo, BgCycleTypeEnum bgCycleType, BgEntryInfo bgEntryInfo) {
        boolean sameQuarter;
        boolean needAddIn = false;
        boolean sameYear = bgEntryInfo.getPeriod().getPeriodYear() == periodInfo.getPeriodYear();
        boolean bl = sameQuarter = bgEntryInfo.getPeriod().getPeriodQuarter() == periodInfo.getPeriodQuarter();
        if (bgEntryInfo.isIsLeafPeriod()) {
            if (bgCycleType.getValue() == 1) {
                if (sameYear) {
                    needAddIn = true;
                }
            } else if (bgCycleType.getValue() == 2 && sameYear && sameQuarter) {
                needAddIn = true;
            }
        }
        return needAddIn;
    }

    public BgDataInfo getBgData(String itemsKey, String elementKey, BgPeriodNode bgPeriodNode) {
        BgDataInfo result = null;
        Iterator iter = this.getBgEntries(bgPeriodNode.getPeriod(), bgPeriodNode.getBgCycle()).iterator();
        while (iter.hasNext()) {
            BgEntryInfo bei = (BgEntryInfo)iter.next();
            if (!bei.getBgItemsKey().equals(itemsKey)) continue;
            result = bei.getBgDataByElementNumber(elementKey);
            break;
        }
        return result;
    }

    public void splitPeriod(PeriodInfo periodInfo, BgCycleTypeEnum originalCycle, BgCycleTypeEnum targetCycle) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = OrgUnitCommonFactory.getRemoteInstance().getCompany(this.getOrgUnit().getId());
        Vector targetPeriodNodeVector = new BgPeriodNode(periodInfo, originalCycle, true).getSplittedPeriodNodeVector(targetCycle, company);
        BgEntryCollection splittingBgEntries = this.getBgEntries(periodInfo, targetCycle);
        BgEntryCollection targetBgEntries = new BgEntryCollection();
        Iterator iter = splittingBgEntries.iterator();
        BgEntryInfo bgEntryInfo = null;
        BgEntryCollection singlePeriodTargetBgEntries = null;
        BgEntryInfo targetBgEntryInfo = null;
        BgPeriodNode targetBgPeriodNode = null;
        while (iter.hasNext()) {
            bgEntryInfo = (BgEntryInfo)iter.next();
            singlePeriodTargetBgEntries = new BgEntryCollection();
            int size = targetPeriodNodeVector.size();
            for (int i = 0; i < size; ++i) {
                targetBgEntryInfo = bgEntryInfo.deepClone();
                targetBgPeriodNode = (BgPeriodNode)targetPeriodNodeVector.get(i);
                targetBgEntryInfo.setPeriod(targetBgPeriodNode.getPeriod());
                targetBgEntryInfo.setBgCycle(targetBgPeriodNode.getBgCycle());
                targetBgEntryInfo.setIsLeafPeriod(true);
                singlePeriodTargetBgEntries.add(targetBgEntryInfo);
            }
            bgEntryInfo.setIsLeafPeriod(false);
            this.avgSplitedBgEntries(singlePeriodTargetBgEntries);
            this.getBgEntries().addCollection(singlePeriodTargetBgEntries);
        }
    }

    public void splitPeriod(PeriodInfo periodInfo, BgEntryInfo entryInfo, BgCycleTypeEnum originalCycle, BgCycleTypeEnum targetCycle) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = OrgUnitCommonFactory.getRemoteInstance().getCompany(this.getOrgUnit().getId());
        Vector targetPeriodNodeVector = new BgPeriodNode(periodInfo, originalCycle, true).getSplittedPeriodNodeVector(targetCycle, company);
        BgEntryCollection splittingBgEntries = new BgEntryCollection();
        splittingBgEntries.add(entryInfo);
        BgEntryCollection targetBgEntries = new BgEntryCollection();
        Iterator iter = splittingBgEntries.iterator();
        BgEntryInfo bgEntryInfo = null;
        BgEntryCollection singlePeriodTargetBgEntries = null;
        BgEntryInfo targetBgEntryInfo = null;
        BgPeriodNode targetBgPeriodNode = null;
        while (iter.hasNext()) {
            bgEntryInfo = (BgEntryInfo)iter.next();
            singlePeriodTargetBgEntries = new BgEntryCollection();
            int size = targetPeriodNodeVector.size();
            for (int i = 0; i < size; ++i) {
                targetBgEntryInfo = bgEntryInfo.deepClone();
                targetBgPeriodNode = (BgPeriodNode)targetPeriodNodeVector.get(i);
                targetBgEntryInfo.setPeriod(targetBgPeriodNode.getPeriod());
                targetBgEntryInfo.setBgCycle(targetBgPeriodNode.getBgCycle());
                targetBgEntryInfo.setIsLeafPeriod(true);
                singlePeriodTargetBgEntries.add(targetBgEntryInfo);
            }
            bgEntryInfo.setIsLeafPeriod(false);
            this.avgSplitedBgEntries(singlePeriodTargetBgEntries);
            this.getBgEntries().addCollection(singlePeriodTargetBgEntries);
        }
    }

    public void initValue(BgEntryInfo info) {
        BgDataCollection dataColl = info.getBgData();
        BgDataInfo dataInfo = null;
        for (int i = 0; i < dataColl.size(); ++i) {
            dataInfo = dataColl.get(i);
            dataInfo.setBgActual(new BigDecimal("0"));
            dataInfo.setBgBalance(new BigDecimal("0"));
            dataInfo.setBgInitialValue(new BigDecimal("0"));
            dataInfo.setBgLastBalance(new BigDecimal("0"));
            dataInfo.setBgUsableValue(new BigDecimal("0"));
            dataInfo.setBgValue(new BigDecimal("0"));
            dataInfo.setBizActual(new BigDecimal("0"));
        }
    }

    public void addPeriod(PeriodInfo period1, PeriodInfo period2, BgCycleTypeEnum cycle, BgCycleTypeEnum rollCycle) throws EASBizException, BOSException, SQLException {
        BgEntryCollection bgEntries = this.getBgEntries(period1, rollCycle);
        Iterator iter = bgEntries.iterator();
        BgEntryInfo temp = null;
        BgEntryInfo enInfo = null;
        BgEntryInfo enInfo1 = null;
        BgEntryInfo enInfo2 = null;
        int year1 = period1.getPeriodYear();
        int quarter1 = period1.getPeriodQuarter();
        int year2 = period2.getPeriodYear();
        int quarter2 = period2.getPeriodQuarter();
        while (iter.hasNext()) {
            temp = (BgEntryInfo)iter.next();
            enInfo = temp.deepClone();
            enInfo1 = temp.deepClone();
            enInfo2 = temp.deepClone();
            this.initValue(enInfo);
            this.initValue(enInfo1);
            this.initValue(enInfo2);
            if (year1 < year2) {
                enInfo1.setBgCycle(BgCycleTypeEnum.Year);
                enInfo1.setIsLeafPeriod(false);
                enInfo1.setPeriod(period2);
                this.getBgEntries().add(enInfo1);
            }
            if (rollCycle.equals((Object)BgCycleTypeEnum.Season)) {
                enInfo.setBgCycle(BgCycleTypeEnum.Season);
                if (cycle.equals((Object)BgCycleTypeEnum.Period)) {
                    enInfo.setIsLeafPeriod(false);
                } else {
                    enInfo.setIsLeafPeriod(true);
                }
                CompanyOrgUnitInfo com = OrgUnitCommonFactory.getRemoteInstance().getCompany(this.getOrgUnit().getId());
                PeriodInfo seaPeriod = PeriodUtils.getPeriodInfo((int)period2.getPeriodYear(), (int)this.getMinNumberInSeason(period2), (CompanyOrgUnitInfo)com);
                enInfo.setPeriod(seaPeriod);
                period2 = seaPeriod;
                this.getBgEntries().add(enInfo);
                if (cycle.equals((Object)BgCycleTypeEnum.Period)) {
                    this.splitPeriod(period2, enInfo, BgCycleTypeEnum.Period, BgCycleTypeEnum.Season);
                }
            }
            if (!rollCycle.equals((Object)BgCycleTypeEnum.Period)) continue;
            if (quarter1 < quarter2 || year1 < year2) {
                enInfo2.setBgCycle(BgCycleTypeEnum.Season);
                enInfo2.setIsLeafPeriod(false);
                enInfo2.setPeriod(period2);
                this.getBgEntries().add(enInfo2);
            }
            enInfo.setBgCycle(BgCycleTypeEnum.Period);
            enInfo.setIsLeafPeriod(true);
            enInfo.setPeriod(period2);
            this.getBgEntries().add(enInfo);
        }
    }

    public int getMinNumberInSeason(PeriodInfo info) throws BOSException, SQLException {
        int result = 0;
        StringBuffer sqlForm = new StringBuffer(40);
        sqlForm.append("SELECT min(fperiodnumber) season FROM T_BD_Period a WHERE  a.FTypeID in (select FTypeID from t_bd_period where fid='" + info.getId().toString() + "')  and a.FPeriodYear = " + info.getPeriodYear() + " and a.FPeriodQuarter=" + info.getPeriodQuarter());
        ISQLExecutor iExecutor = SQLExecutorFactory.getRemoteInstance((String)sqlForm.toString());
        IRowSet irs = iExecutor.executeSQL();
        if (irs.next()) {
            result = irs.getInt(1);
        }
        return result;
    }

    public void addLostPeriod(CompanyOrgUnitInfo companyInfo, PeriodInfo period1, PeriodInfo period2, BgCycleTypeEnum cycle, BgCycleTypeEnum rollCycle) throws BOSException, EASBizException {
        BgEntryCollection bgEntries = this.getBgEntries(period1, rollCycle);
        Iterator iter = bgEntries.iterator();
        BgEntryCollection temp = new BgEntryCollection();
        PeriodInfo period = BgRollFormFactory.getRemoteInstance().getFinalPeriod(this.getId().toString(), cycle);
        while (iter.hasNext()) {
            PeriodCollection pc;
            BgEntryInfo tempEn = (BgEntryInfo)iter.next();
            if (!rollCycle.equals((Object)BgCycleTypeEnum.Season) || !cycle.equals((Object)BgCycleTypeEnum.Period) || (pc = PeriodUtils.getPeriodc((PeriodInfo)period, (PeriodInfo)period2, (CompanyOrgUnitInfo)companyInfo)).size() <= 2) continue;
            for (int i = 1; i < pc.size() - 1; ++i) {
                PeriodInfo pInfo = pc.get(i);
                if (pInfo.isIsAdjustPeriod()) continue;
                BgEntryInfo enInfo3 = tempEn.deepClone();
                this.initValue(enInfo3);
                enInfo3.setBgCycle(BgCycleTypeEnum.Period);
                enInfo3.setIsLeafPeriod(true);
                enInfo3.setPeriod(pInfo);
                temp.add(enInfo3);
                enInfo3.getPeriodNode();
            }
        }
        this.getBgEntries().addCollection(temp);
    }

    private void avgSplitedBgEntries(BgEntryCollection splittedBgEntries) {
        BigDecimal size = new BigDecimal(Integer.toString(splittedBgEntries.size()));
        Iterator iter = splittedBgEntries.iterator();
        BgEntryInfo bei = null;
        BgDataCollection beiData = null;
        Iterator dataIter = null;
        BgDataInfo bgDataInfo = null;
        while (iter.hasNext()) {
            bei = (BgEntryInfo)iter.next();
            beiData = bei.getBgData();
            dataIter = beiData.iterator();
            while (dataIter.hasNext()) {
                bgDataInfo = (BgDataInfo)dataIter.next();
                if (!bgDataInfo.getBgElement().isSummable()) continue;
                if (bgDataInfo.getBgValue() == null) {
                    bgDataInfo.setBgValue(new BigDecimal("0"));
                } else {
                    bgDataInfo.setBgValue(bgDataInfo.getBgValue().divide(size, 2));
                }
                if (bgDataInfo.getBgActual() == null) {
                    bgDataInfo.setBgActual(new BigDecimal("0"));
                } else {
                    bgDataInfo.setBgActual(bgDataInfo.getBgActual().divide(size, 2));
                }
                if (bgDataInfo.getBgBalance() == null) {
                    bgDataInfo.setBgBalance(new BigDecimal("0"));
                } else {
                    bgDataInfo.setBgBalance(bgDataInfo.getBgBalance().divide(size, 2));
                }
                if (bgDataInfo.getBgLastBalance() == null) {
                    bgDataInfo.setBgLastBalance(new BigDecimal("0"));
                } else {
                    bgDataInfo.setBgLastBalance(bgDataInfo.getBgLastBalance().divide(size, 2));
                }
                if (bgDataInfo.getBgUsableValue() == null) {
                    bgDataInfo.setBgUsableValue(new BigDecimal("0"));
                } else {
                    bgDataInfo.setBgUsableValue(bgDataInfo.getBgUsableValue().divide(size, 2));
                }
                if (bgDataInfo.getBizActual() == null) {
                    bgDataInfo.setBizActual(new BigDecimal("0"));
                    continue;
                }
                bgDataInfo.setBizActual(bgDataInfo.getBizActual().divide(size, 2));
            }
        }
    }

    public BgPastRecordInfo getLastRecord() {
        BgPastRecordInfo bgPtRdInfo = null;
        int maxVersion = 0;
        Iterator iter = this.getPastRecords().iterator();
        while (iter.hasNext()) {
            BgPastRecordInfo bpri = (BgPastRecordInfo)iter.next();
            if (bpri.getSeq() <= maxVersion) continue;
            maxVersion = bpri.getSeq();
            bgPtRdInfo = bpri;
        }
        return bgPtRdInfo;
    }

    public HashMap getAllPastDataByBgData(BgDataInfo bdi) {
        HashMap<BgPastRecordInfo, BgPastDataInfo> result = new HashMap<BgPastRecordInfo, BgPastDataInfo>();
        Iterator recordIter = this.getPastRecords().iterator();
        while (recordIter.hasNext()) {
            BgPastRecordInfo bpri = (BgPastRecordInfo)recordIter.next();
            BgPastDataInfo bpdi = bpri.getBgPastDataByBgData(bdi);
            if (bpdi == null) continue;
            result.put(bpri, bpdi);
        }
        return result;
    }

    public int getMaxRecordSeq() {
        int result = -1;
        Iterator recordIter = this.getPastRecords().iterator();
        while (recordIter.hasNext()) {
            BgPastRecordInfo bpri = (BgPastRecordInfo)recordIter.next();
            int tmpSeq = bpri.getSeq();
            if (tmpSeq <= result) continue;
            result = tmpSeq;
        }
        return result;
    }

    public BgEntryCollection getBgEntries_RealValue() {
        BgEntryCollection bgEntries = new BgEntryCollection();
        PeriodCollection periodColl = new PeriodCollection();
        Iterator iter = this.getBgEntries().iterator();
        BgEntryInfo bgEntryInfo = null;
        while (iter.hasNext()) {
            bgEntryInfo = (BgEntryInfo)iter.next();
            PeriodInfo periodInfo = bgEntryInfo.getPeriod();
            if (!bgEntryInfo.isIsLeafPeriod() && periodInfo != null) {
                periodColl.add(periodInfo);
                continue;
            }
            bgEntries.add(bgEntryInfo);
        }
        BgCycleTypeEnum[] cycles = null;
        if (this.getBgTemplate().getBgCycle() == BgCycleTypeEnum.Period) {
            cycles = new BgCycleTypeEnum[]{BgCycleTypeEnum.Season, BgCycleTypeEnum.Year};
        } else if (this.getBgTemplate().getBgCycle() == BgCycleTypeEnum.Season) {
            cycles = new BgCycleTypeEnum[]{BgCycleTypeEnum.Year};
        } else if (this.getBgTemplate().getBgCycle() == BgCycleTypeEnum.Year) {
            cycles = new BgCycleTypeEnum[]{};
        }
        for (PeriodInfo periodInfo : periodColl) {
            if (cycles == null) continue;
            int n = cycles.length;
            for (int i = 0; i < n; ++i) {
                BgEntryCollection summedColl = this.getSummedBgEntries(periodInfo, cycles[i]);
                int m = summedColl.size();
                for (int j = 0; j < m; ++j) {
                    summedColl.get(j).setBgCycle(cycles[i]);
                }
                bgEntries.addCollection(summedColl);
            }
        }
        return bgEntries;
    }
}

