/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgItemInfo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class BgFormQuerySchemaHelper {
    public static final int ORGUNIT = 1;
    public static final int BGTYPE = 2;
    public static final int ROWTYPE = 1;
    public static final int COLTYPE = 2;

    public static HashMap parseComplexStr(String str) {
        HashMap map = new HashMap(6);
        if (str == null || str.length() == 0) {
            return map;
        }
        String[] firstLevel = str.split(";");
        for (int i = 0; i < firstLevel.length; ++i) {
            BgFormQuerySchemaHelper.parseTowLevel(map, firstLevel[i]);
        }
        return map;
    }

    private static void parseTowLevel(HashMap map, String item) {
        if (item == null || item.length() == 0) {
            return;
        }
        int index = item.indexOf(":");
        if (index == -1) {
            return;
        }
        String key = item.substring(0, index);
        String value = item.substring(index + 1);
        String[] values = value.split(">");
        List dims = BgFormQuerySchemaHelper.arrayToList(values[0].split(","));
        List facs = BgFormQuerySchemaHelper.arrayToList(values[1].split(","));
        List curs = BgFormQuerySchemaHelper.arrayToList(values[2].split(","));
        List[] mapValues = new List[]{dims, facs, curs};
        map.put(key, mapValues);
    }

    public static String createComplexStr(HashMap map) {
        if (map == null || map.size() == 0) {
            throw new IllegalArgumentException("Argumen is null");
        }
        StringBuffer buff = new StringBuffer(256);
        for (String key : map.keySet()) {
            List[] values = (List[])map.get(key);
            String dim = BgFormQuerySchemaHelper.listToString(values[0]);
            String factor = BgFormQuerySchemaHelper.listToString(values[1]);
            String currency = BgFormQuerySchemaHelper.listToString(values[2]);
            String value = dim + ">" + factor + ">" + currency;
            buff.append(key);
            buff.append(":");
            buff.append(value);
            buff.append(";");
        }
        buff.deleteCharAt(buff.length() - 1);
        return buff.toString();
    }

    private static String listToString(List strs) {
        Object[] arr = strs.toArray();
        return BgFormQuerySchemaHelper.arrayToString(arr);
    }

    public static List arrayToList(String[] strs) {
        ArrayList<String> lst = new ArrayList<String>(strs.length);
        for (int i = 0; i < strs.length; ++i) {
            lst.add(strs[i]);
        }
        return lst;
    }

    private static String arrayToString(Object[] strs) {
        StringBuffer buff = new StringBuffer(128);
        for (int i = 0; i < strs.length; ++i) {
            buff.append((String)strs[i]);
            buff.append(",");
        }
        if (buff.length() == 0) {
            return "";
        }
        buff.deleteCharAt(buff.length() - 1);
        return buff.toString();
    }

    public static HashMap placeBgForm(List lstBgForm, int type) {
        HashMap<String, BgFormInfo> map = new HashMap<String, BgFormInfo>(lstBgForm.size() * 2);
        for (int i = 0; i < lstBgForm.size(); ++i) {
            BgFormInfo info = (BgFormInfo)lstBgForm.get(i);
            String key = BgFormQuerySchemaHelper.createKey(info, type);
            map.put(key, info);
        }
        return map;
    }

    private static String createKey(BgFormInfo info, int type) {
        String tag = "";
        if (type == 1) {
            tag = info.getOrgUnit().getId().toString();
        } else if (type == 2) {
            tag = info.getBgType().getId().toString();
        }
        return tag;
    }

    public static HashMap hashBgForm(BgFormInfo info) {
        HashMap<Integer, BgDataInfo> mapBgDatas = new HashMap<Integer, BgDataInfo>(4096);
        BgEntryInfo bgEntryInfo = null;
        BgDataInfo bgDataInfo = null;
        Iterator iter = info.getBgEntries_RealValue().iterator();
        while (iter.hasNext()) {
            bgEntryInfo = (BgEntryInfo)iter.next();
            String entryKey = BgFormQuerySchemaHelper.generateEntryCode(bgEntryInfo);
            Iterator datas = bgEntryInfo.getBgData().iterator();
            while (datas.hasNext()) {
                bgDataInfo = (BgDataInfo)datas.next();
                String dataKey = BgFormInfo.generateBgDataCode(bgDataInfo);
                mapBgDatas.put(new Integer((entryKey + dataKey).hashCode()), bgDataInfo);
            }
        }
        return mapBgDatas;
    }

    public static Integer generateHashKey(BgEntryInfo entry, BgDataInfo data) {
        String entryId = BgFormQuerySchemaHelper.generateEntryCode(entry);
        String dataId = BgFormInfo.generateBgDataCode(data);
        return new Integer((entryId + dataId).hashCode());
    }

    public static String generateEntryCode(BgEntryInfo info) {
        StringBuffer buff = new StringBuffer(256);
        buff.append(info.isIsLeafPeriod() ? 1 : 0);
        buff.append(new Integer(info.getBgCycle().getValue()).toString());
        buff.append(info.getPeriod().getId().toString());
        buff.append(BgFormQuerySchemaHelper.getItem(info.getBgItem1()));
        buff.append(BgFormQuerySchemaHelper.getItem(info.getBgItem2()));
        buff.append(BgFormQuerySchemaHelper.getItem(info.getBgItem3()));
        buff.append(BgFormQuerySchemaHelper.getItem(info.getBgItem4()));
        buff.append(BgFormQuerySchemaHelper.getItem(info.getBgItem5()));
        buff.append(BgFormQuerySchemaHelper.getItem(info.getBgItem6()));
        return buff.toString();
    }

    private static String getItem(BgItemInfo info) {
        if (info == null) {
            return "_";
        }
        return info.getItemNumber();
    }

    public static Date createDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        return cal.getTime();
    }
}

