/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.Vector;

public class BgPeriodNode
implements Comparable {
    private PeriodInfo period;
    private BgCycleTypeEnum bgCycle;
    private boolean isLeaf;

    public BgPeriodNode() {
        this.period = new PeriodInfo();
    }

    public BgPeriodNode(PeriodInfo periodInfo, BgCycleTypeEnum bgCycle, boolean leaf) {
        this.setPeriod(periodInfo);
        this.setBgCycle(bgCycle);
        this.setLeaf(leaf);
    }

    public BgCycleTypeEnum getBgCycle() {
        return this.bgCycle;
    }

    public int getPeriod2Number() {
        return this.period.getPeriodYear() * 100 + this.period.getPeriodNumber();
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public PeriodInfo getPeriod() {
        return this.period;
    }

    public void setBgCycle(BgCycleTypeEnum enums) {
        this.bgCycle = enums;
    }

    public void setLeaf(boolean b) {
        this.isLeaf = b;
    }

    public void setPeriod(PeriodInfo info) {
        this.period = info;
    }

    public String toString() {
        if (this.bgCycle.equals((Object)BgCycleTypeEnum.Year)) {
            return this.period.getPeriodYear() + BgCycleTypeEnum.Year.getAlias(SysContext.getSysContext().getLocale());
        }
        if (this.bgCycle.equals((Object)BgCycleTypeEnum.Season)) {
            return this.period.getPeriodQuarter() + BgCycleTypeEnum.Season.getAlias(SysContext.getSysContext().getLocale());
        }
        if (this.bgCycle.equals((Object)BgCycleTypeEnum.Period)) {
            return this.period.getPeriodNumber() + BgCycleTypeEnum.Period.getAlias(SysContext.getSysContext().getLocale());
        }
        return "Invalid Period Node";
    }

    public String toNumbericString() {
        return BgPeriodNode.toNumbericString(this.period, this.bgCycle);
    }

    public static String toNumbericString(PeriodInfo periodInfo, BgCycleTypeEnum bgCycle) {
        if (bgCycle.equals((Object)BgCycleTypeEnum.Year)) {
            return String.valueOf(periodInfo.getPeriodYear());
        }
        if (bgCycle.equals((Object)BgCycleTypeEnum.Season)) {
            return String.valueOf(periodInfo.getPeriodYear()) + "-Q" + String.valueOf(periodInfo.getPeriodQuarter());
        }
        if (bgCycle.equals((Object)BgCycleTypeEnum.Period)) {
            return String.valueOf(periodInfo.getPeriodYear()) + "-Q" + String.valueOf(periodInfo.getPeriodQuarter()) + "-" + String.valueOf(periodInfo.getPeriodNumber());
        }
        return "";
    }

    public int compareTo(Object o) {
        int result = 0;
        BgPeriodNode bgPeriodNode = (BgPeriodNode)o;
        result = BgPeriodNode.comparePeriod(this.getPeriod(), bgPeriodNode.getPeriod());
        if (result != 0) {
            return result;
        }
        if (this.getBgCycle() != null && bgPeriodNode.bgCycle != null) {
            result = this.getBgCycle().compareTo((Object)bgPeriodNode.bgCycle);
        }
        return result;
    }

    public static int comparePeriodAndBgCycle(PeriodInfo period1, int bgCycle1, PeriodInfo period2, int bgCycle2) {
        int result = 0;
        result = BgPeriodNode.comparePeriod(period1, period2);
        if (result != 0) {
            return result;
        }
        result = bgCycle1 - bgCycle2;
        return result;
    }

    public static int comparePeriod(PeriodInfo period1, PeriodInfo period2) {
        if (period1.getPeriodYear() - period2.getPeriodYear() != 0) {
            return period1.getPeriodYear() - period2.getPeriodYear();
        }
        return period1.getPeriodNumber() - period2.getPeriodNumber();
    }

    public String toFormulaFormat() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.period.getPeriodYear());
        sb.append("|");
        sb.append(this.period.getPeriodQuarter());
        sb.append("|");
        sb.append(this.period.getPeriodNumber());
        sb.append("|");
        sb.append(this.bgCycle.getName());
        return sb.toString();
    }

    public void readFormulaFormat(String s) {
        String[] array = StringUtils.split((String)s, (String)"|");
        this.period.setPeriodYear(Integer.valueOf(array[0]).intValue());
        this.period.setPeriodQuarter(Integer.valueOf(array[1]).intValue());
        this.period.setPeriodNumber(Integer.valueOf(array[2]).intValue());
        this.setBgCycle(BgCycleTypeEnum.getEnum(array[3]));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BgPeriodNode)) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        BgPeriodNode objPeriodNode = (BgPeriodNode)obj;
        if (this == objPeriodNode) {
            return true;
        }
        return BgPeriodNode.comparePeriod(this.getPeriod(), objPeriodNode.getPeriod()) == 0 && this.getBgCycle().equals((Object)objPeriodNode.getBgCycle());
    }

    public Vector getSplittedPeriodNodeVector(BgCycleTypeEnum targetCycle, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        Vector<BgPeriodNode> vector;
        block5: {
            block7: {
                block6: {
                    block4: {
                        vector = new Vector<BgPeriodNode>();
                        if (!this.bgCycle.equals((Object)BgCycleTypeEnum.Season) || !targetCycle.equals((Object)BgCycleTypeEnum.Year)) break block4;
                        PeriodCollection coll = PeriodUtils.getPeriodc((int)this.period.getPeriodYear(), (CompanyOrgUnitInfo)company);
                        PeriodInfo info = null;
                        Iterator iter = coll.iterator();
                        int i = 1;
                        while (iter.hasNext()) {
                            info = (PeriodInfo)iter.next();
                            if (info.getPeriodQuarter() != i) continue;
                            BgPeriodNode bgP3 = new BgPeriodNode(info, BgCycleTypeEnum.Period, true);
                            vector.add(bgP3);
                            ++i;
                        }
                        break block5;
                    }
                    if (!this.bgCycle.equals((Object)BgCycleTypeEnum.Period) || !targetCycle.equals((Object)BgCycleTypeEnum.Year)) break block6;
                    PeriodCollection coll = PeriodUtils.getPeriodc((int)this.period.getPeriodYear(), (CompanyOrgUnitInfo)company);
                    for (PeriodInfo info : coll) {
                        if (info.isIsAdjustPeriod()) continue;
                        BgPeriodNode bgP3 = new BgPeriodNode(info, BgCycleTypeEnum.Period, true);
                        vector.add(bgP3);
                    }
                    break block5;
                }
                if (!this.bgCycle.equals((Object)BgCycleTypeEnum.Period) || !targetCycle.equals((Object)BgCycleTypeEnum.Season)) break block7;
                PeriodCollection coll = PeriodUtils.getPeriodc((int)this.period.getPeriodYear(), (int)this.period.getPeriodQuarter(), (CompanyOrgUnitInfo)company);
                for (PeriodInfo info : coll) {
                    if (info.isIsAdjustPeriod()) continue;
                    BgPeriodNode bgP3 = new BgPeriodNode(info, BgCycleTypeEnum.Period, true);
                    vector.add(bgP3);
                }
                break block5;
            }
            if (!this.bgCycle.equals((Object)BgCycleTypeEnum.Season) || !targetCycle.equals((Object)BgCycleTypeEnum.Season)) break block5;
            PeriodCollection coll = PeriodUtils.getPeriodc((int)this.period.getPeriodYear(), (int)this.period.getPeriodQuarter(), (CompanyOrgUnitInfo)company);
            for (PeriodInfo info : coll) {
                if (info.isIsAdjustPeriod()) continue;
                BgPeriodNode bgP3 = new BgPeriodNode(info, BgCycleTypeEnum.Period, true);
                vector.add(bgP3);
            }
        }
        return vector;
    }

    public Vector getSplittedPeriodNodeVector_Unstable(BgCycleTypeEnum targetCycle, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        Vector<BgPeriodNode> vector = new Vector<BgPeriodNode>();
        PeriodCollection periodCollection = null;
        if (this.getBgCycle().equals((Object)BgCycleTypeEnum.Year)) {
            periodCollection = PeriodUtils.getPeriodc((int)this.period.getPeriodYear(), (CompanyOrgUnitInfo)companyInfo);
            if (targetCycle.equals((Object)BgCycleTypeEnum.Season)) {
                // empty if block
            }
        } else if (this.getBgCycle().equals((Object)BgCycleTypeEnum.Season)) {
            periodCollection = PeriodUtils.getPeriodc((int)this.period.getPeriodYear(), (int)this.period.getPeriodQuarter(), (CompanyOrgUnitInfo)companyInfo);
        }
        if (periodCollection == null) {
            return null;
        }
        for (PeriodInfo thePeriod : periodCollection) {
            BgPeriodNode bgPeriodNode = new BgPeriodNode(thePeriod, targetCycle, true);
            vector.add(bgPeriodNode);
        }
        return vector;
    }

    public BgPeriodNode getPreviousBgPeriodNode() {
        PeriodInfo prePeriod = (PeriodInfo)this.period.clone();
        BgPeriodNode result = new BgPeriodNode(prePeriod, this.bgCycle, this.isLeaf);
        if (this.bgCycle == BgCycleTypeEnum.Period) {
            int number = prePeriod.getPeriodNumber();
            if (number == 1) {
                prePeriod.setPeriodNumber(12);
                prePeriod.setPeriodYear(this.period.getPeriodYear() - 1);
            } else {
                prePeriod.setPeriodNumber(number - 1);
            }
            number = prePeriod.getPeriodNumber();
            prePeriod.setPeriodQuarter((number - 1) / 3 + 1);
        } else if (this.bgCycle == BgCycleTypeEnum.Season) {
            int number = prePeriod.getPeriodQuarter();
            if (number == 1) {
                prePeriod.setPeriodQuarter(4);
                prePeriod.setPeriodYear(this.period.getPeriodYear() - 1);
                prePeriod.setPeriodNumber(10);
            } else {
                prePeriod.setPeriodQuarter(number - 1);
                prePeriod.setPeriodNumber(this.period.getPeriodNumber() - 3);
            }
        } else if (this.bgCycle == BgCycleTypeEnum.Year) {
            int number = prePeriod.getPeriodYear();
            prePeriod.setPeriodYear(number - 1);
        }
        return result;
    }

    public BgPeriodNode getNextBgPeriodNode() {
        PeriodInfo nextPeriod = (PeriodInfo)this.period.clone();
        BgPeriodNode result = new BgPeriodNode(nextPeriod, this.bgCycle, this.isLeaf);
        if (this.bgCycle == BgCycleTypeEnum.Period) {
            int number = nextPeriod.getPeriodNumber();
            if (number == 12) {
                nextPeriod.setPeriodNumber(1);
                nextPeriod.setPeriodYear(this.period.getPeriodYear() + 1);
            } else {
                nextPeriod.setPeriodNumber(number + 1);
            }
            number = nextPeriod.getPeriodNumber();
            nextPeriod.setPeriodQuarter((number - 1) / 3 + 1);
        } else if (this.bgCycle == BgCycleTypeEnum.Season) {
            int number = nextPeriod.getPeriodQuarter();
            if (number == 4) {
                nextPeriod.setPeriodQuarter(1);
                nextPeriod.setPeriodYear(this.period.getPeriodYear() + 1);
                nextPeriod.setPeriodNumber(1);
            } else {
                nextPeriod.setPeriodQuarter(number + 1);
                nextPeriod.setPeriodNumber(this.period.getPeriodNumber() + 3);
            }
        } else if (this.bgCycle == BgCycleTypeEnum.Year) {
            int number = nextPeriod.getPeriodYear();
            nextPeriod.setPeriodYear(number + 1);
        }
        return result;
    }
}

