/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgEntryCollection;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgPeriodNode;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;

public class BgPeriodRange {
    private PeriodInfo periodNodeFrom;
    private PeriodInfo periodNodeTo;

    public BgPeriodRange(PeriodInfo periodNodeFrom, PeriodInfo periodNodeTo) {
        this.setPeriodNodeFrom(periodNodeFrom);
        this.setPeriodNodeTo(periodNodeTo);
    }

    public Vector getPeriodNodesInRange(CompanyOrgUnitInfo companyInfo, BgCycleTypeEnum bgCycle, PeriodCollection periods) throws EASBizException, BOSException {
        TreeMap<Integer, PeriodInfo> yearMap = new TreeMap<Integer, PeriodInfo>();
        TreeMap<Integer, PeriodInfo> seasonMap = new TreeMap<Integer, PeriodInfo>();
        int size = periods.size();
        for (int i = 0; i < size; ++i) {
            PeriodInfo tmpPeriodInfo = periods.get(i);
            Integer yearKey = new Integer(tmpPeriodInfo.getPeriodYear());
            Integer seasonKey = new Integer(tmpPeriodInfo.getPeriodYear() * 100 + tmpPeriodInfo.getPeriodQuarter());
            if (!yearMap.containsKey(yearKey)) {
                yearMap.put(yearKey, tmpPeriodInfo);
            }
            if (seasonMap.containsKey(seasonKey)) continue;
            seasonMap.put(seasonKey, tmpPeriodInfo);
        }
        if (bgCycle.equals((Object)BgCycleTypeEnum.Year)) {
            return this.getPeriodNodesByYear(yearMap);
        }
        if (bgCycle.equals((Object)BgCycleTypeEnum.Season)) {
            return this.getPeriodNodesBySeason(yearMap, seasonMap);
        }
        if (bgCycle.equals((Object)BgCycleTypeEnum.Period)) {
            return this.getPeriodNodesByPeriod(yearMap, seasonMap, periods);
        }
        return null;
    }

    public Vector getPeriodNodesInRange(CompanyOrgUnitInfo companyInfo, BgCycleTypeEnum bgCycle) throws EASBizException, BOSException {
        PeriodCollection periods = PeriodUtils.getPeriodc((PeriodInfo)this.periodNodeFrom, (PeriodInfo)this.periodNodeTo, (CompanyOrgUnitInfo)companyInfo);
        return this.getPeriodNodesInRange(companyInfo, bgCycle, periods);
    }

    private Vector getPeriodNodesByYear(TreeMap yearMap) {
        Vector<BgPeriodNode> vector = new Vector<BgPeriodNode>();
        Iterator yearIter = yearMap.keySet().iterator();
        while (yearIter.hasNext()) {
            PeriodInfo tmpPeriodInfo = (PeriodInfo)yearMap.get(yearIter.next());
            vector.add(new BgPeriodNode(tmpPeriodInfo, BgCycleTypeEnum.Year, true));
        }
        return vector;
    }

    private Vector getPeriodNodesBySeason(TreeMap yearMap, TreeMap seasonMap) {
        Vector<BgPeriodNode> vector = new Vector<BgPeriodNode>();
        Iterator yearIter = yearMap.keySet().iterator();
        while (yearIter.hasNext()) {
            PeriodInfo yearPeriodInfo = (PeriodInfo)yearMap.get(yearIter.next());
            vector.add(new BgPeriodNode(yearPeriodInfo, BgCycleTypeEnum.Year, false));
            Iterator seasonIter = seasonMap.keySet().iterator();
            while (seasonIter.hasNext()) {
                PeriodInfo seasonPeriodInfo = (PeriodInfo)seasonMap.get(seasonIter.next());
                if (seasonPeriodInfo.getPeriodYear() != yearPeriodInfo.getPeriodYear()) continue;
                vector.add(new BgPeriodNode(seasonPeriodInfo, BgCycleTypeEnum.Season, true));
            }
        }
        return vector;
    }

    private Vector getPeriodNodesByPeriod(TreeMap yearMap, TreeMap seasonMap, PeriodCollection periodCollection) {
        Vector<BgPeriodNode> vector = new Vector<BgPeriodNode>();
        Iterator yearIter = yearMap.keySet().iterator();
        while (yearIter.hasNext()) {
            PeriodInfo yearPeriodInfo = (PeriodInfo)yearMap.get(yearIter.next());
            vector.add(new BgPeriodNode(yearPeriodInfo, BgCycleTypeEnum.Year, false));
            Iterator seasonIter = seasonMap.keySet().iterator();
            while (seasonIter.hasNext()) {
                PeriodInfo seasonPeriodInfo = (PeriodInfo)seasonMap.get(seasonIter.next());
                if (seasonPeriodInfo.getPeriodYear() != yearPeriodInfo.getPeriodYear()) continue;
                vector.add(new BgPeriodNode(seasonPeriodInfo, BgCycleTypeEnum.Season, false));
                for (PeriodInfo tmpPeriodInfo : periodCollection) {
                    if (tmpPeriodInfo.getPeriodYear() != yearPeriodInfo.getPeriodYear() || tmpPeriodInfo.getPeriodQuarter() != seasonPeriodInfo.getPeriodQuarter()) continue;
                    vector.add(new BgPeriodNode(tmpPeriodInfo, BgCycleTypeEnum.Period, true));
                }
            }
        }
        return vector;
    }

    public Vector getPeriodNodesInRange() {
        PeriodInfo mockPeriodInfo = new PeriodInfo();
        mockPeriodInfo.setId(BOSUuid.read((String)"d40bc273-00f9-1000-e000-00abc0a8103382388C4C"));
        mockPeriodInfo.setPeriodYear(2004);
        mockPeriodInfo.setPeriodQuarter(1);
        mockPeriodInfo.setPeriodNumber(1);
        Vector<BgPeriodNode> vector = new Vector<BgPeriodNode>();
        BgPeriodNode bgP1 = new BgPeriodNode(mockPeriodInfo, BgCycleTypeEnum.Year, false);
        vector.add(bgP1);
        BgPeriodNode bgP2 = new BgPeriodNode(mockPeriodInfo, BgCycleTypeEnum.Season, false);
        vector.add(bgP2);
        BgPeriodNode bgP3 = new BgPeriodNode(mockPeriodInfo, BgCycleTypeEnum.Period, true);
        vector.add(bgP3);
        return vector;
    }

    public static Vector getPeriodNodes(BgEntryCollection bgEntries) {
        Vector<BgPeriodNode> vector = new Vector<BgPeriodNode>();
        Iterator iter = bgEntries.iterator();
        while (iter.hasNext()) {
            BgPeriodNode tmpPeriodNode;
            BgEntryInfo bgEntryInfo = (BgEntryInfo)iter.next();
            if (vector.size() > 0 && (tmpPeriodNode = (BgPeriodNode)vector.lastElement()).compareTo(bgEntryInfo.getPeriodNode()) >= 0) continue;
            vector.add(bgEntryInfo.getPeriodNode());
        }
        return vector;
    }

    public static Object[] sortVec_year(Vector vec) {
        int count = vec.size();
        if (count == 0) {
            return null;
        }
        Object[] obj = vec.toArray();
        Object temp = null;
        for (int y = 0; y < count - 1; ++y) {
            for (int x = 1; x < count - y; ++x) {
                if (((BgPeriodNode)obj[x]).getPeriod().getPeriodYear() > ((BgPeriodNode)obj[x - 1]).getPeriod().getPeriodYear()) continue;
                temp = obj[x - 1];
                obj[x - 1] = obj[x];
                obj[x] = temp;
            }
        }
        return obj;
    }

    public static Object[] sortVec_season(Vector vec) {
        int count = vec.size();
        if (count == 0) {
            return null;
        }
        Object[] obj = vec.toArray();
        Object temp = null;
        for (int y = 0; y < count - 1; ++y) {
            for (int x = 1; x < count - y; ++x) {
                if (((BgPeriodNode)obj[x]).getPeriod().getPeriodYear() * 100 + ((BgPeriodNode)obj[x]).getPeriod().getPeriodQuarter() > ((BgPeriodNode)obj[x - 1]).getPeriod().getPeriodYear() * 100 + ((BgPeriodNode)obj[x - 1]).getPeriod().getPeriodQuarter()) continue;
                temp = obj[x - 1];
                obj[x - 1] = obj[x];
                obj[x] = temp;
            }
        }
        return obj;
    }

    public static Object[] sortVec_number(Vector vec) {
        int count = vec.size();
        if (count == 0) {
            return null;
        }
        Object[] obj = vec.toArray();
        Object temp = null;
        for (int y = 0; y < count - 1; ++y) {
            for (int x = 1; x < count - y; ++x) {
                if (((BgPeriodNode)obj[x]).getPeriod2Number() > ((BgPeriodNode)obj[x - 1]).getPeriod2Number()) continue;
                temp = obj[x - 1];
                obj[x - 1] = obj[x];
                obj[x] = temp;
            }
        }
        return obj;
    }

    public static Vector getPeriodNodes_1(BgEntryCollection bgEntries) {
        BgPeriodNode tmpPeriodNode;
        int i;
        Vector vector = new Vector();
        BgPeriodNode[] node = new BgPeriodNode[bgEntries.size()];
        Vector<Object> vecYear = new Vector<Object>();
        Vector<Object> vecSea = new Vector<Object>();
        Vector<Object> vecNumber = new Vector<Object>();
        for (int i2 = 0; i2 < node.length; ++i2) {
            node[i2] = bgEntries.get(i2).getPeriodNode();
            if (node[i2].getBgCycle().getValue() == 1) {
                vecYear.add(node[i2]);
                continue;
            }
            if (node[i2].getBgCycle().getValue() == 2) {
                vecSea.add(node[i2]);
                continue;
            }
            if (node[i2].getBgCycle().getValue() != 3) continue;
            vecNumber.add(node[i2]);
        }
        Object[] year = BgPeriodRange.sortVec_year(vecYear);
        Object[] sea = BgPeriodRange.sortVec_season(vecSea);
        Object[] number = BgPeriodRange.sortVec_number(vecNumber);
        vecYear.clear();
        vecSea.clear();
        vecNumber.clear();
        for (i = 0; year != null && i < year.length; ++i) {
            if (vecYear.size() > 0 && ((tmpPeriodNode = (BgPeriodNode)vecYear.lastElement()).getPeriod().getPeriodYear() == ((BgPeriodNode)year[i]).getPeriod().getPeriodYear() || tmpPeriodNode.getPeriod2Number() > ((BgPeriodNode)year[i]).getPeriod2Number())) continue;
            vecYear.add(year[i]);
        }
        for (i = 0; sea != null && i < sea.length; ++i) {
            if (vecSea.size() > 0 && ((tmpPeriodNode = (BgPeriodNode)vecSea.lastElement()).getPeriod().getPeriodYear() == ((BgPeriodNode)sea[i]).getPeriod().getPeriodYear() && tmpPeriodNode.getPeriod().getPeriodQuarter() == ((BgPeriodNode)sea[i]).getPeriod().getPeriodQuarter() || tmpPeriodNode.getPeriod2Number() > ((BgPeriodNode)sea[i]).getPeriod2Number())) continue;
            vecSea.add(sea[i]);
        }
        for (i = 0; number != null && i < number.length; ++i) {
            if (vecNumber.size() > 0 && ((tmpPeriodNode = (BgPeriodNode)vecNumber.lastElement()).getPeriod().getPeriodYear() == ((BgPeriodNode)number[i]).getPeriod().getPeriodYear() && tmpPeriodNode.getPeriod().getPeriodQuarter() == ((BgPeriodNode)number[i]).getPeriod().getPeriodQuarter() && tmpPeriodNode.getPeriod().getPeriodNumber() == ((BgPeriodNode)number[i]).getPeriod().getPeriodNumber() || tmpPeriodNode.getPeriod2Number() > ((BgPeriodNode)number[i]).getPeriod2Number())) continue;
            vecNumber.add(number[i]);
        }
        for (i = 0; i < vecYear.size(); ++i) {
            vector.add(vecYear.get(i));
            for (int j = 0; j < vecSea.size(); ++j) {
                if (((BgPeriodNode)vecSea.get(j)).getPeriod().getPeriodYear() != ((BgPeriodNode)vecYear.get(i)).getPeriod().getPeriodYear()) continue;
                vector.add(vecSea.get(j));
                for (int k = 0; k < vecNumber.size(); ++k) {
                    if (((BgPeriodNode)vecNumber.get(k)).getPeriod().getPeriodYear() != ((BgPeriodNode)vecYear.get(i)).getPeriod().getPeriodYear() || ((BgPeriodNode)vecSea.get(j)).getPeriod().getPeriodQuarter() != ((BgPeriodNode)vecNumber.get(k)).getPeriod().getPeriodQuarter()) continue;
                    vector.add(vecNumber.get(k));
                }
            }
        }
        return vector;
    }

    public static BgPeriodNode getPreviousPeriod(BgPeriodNode currentBgPeriodNode, Vector vector) {
        BgPeriodNode result = null;
        int theIndex = vector.indexOf(currentBgPeriodNode);
        for (int i = theIndex - 1; i > 0; --i) {
            BgPeriodNode tmpBgPeriodNode = (BgPeriodNode)vector.get(i);
            if (!tmpBgPeriodNode.getBgCycle().equals((Object)currentBgPeriodNode.getBgCycle())) continue;
            result = tmpBgPeriodNode;
            break;
        }
        return result;
    }

    public static BgPeriodNode getNextPeriod(BgPeriodNode currentBgPeriodNode, Vector vector) {
        BgPeriodNode result = null;
        int theIndex = vector.indexOf(currentBgPeriodNode);
        for (int i = theIndex + 1; i < vector.size(); ++i) {
            BgPeriodNode tmpBgPeriodNode = (BgPeriodNode)vector.get(i);
            if (!tmpBgPeriodNode.getBgCycle().equals((Object)currentBgPeriodNode.getBgCycle())) continue;
            result = tmpBgPeriodNode;
            break;
        }
        return result;
    }

    public PeriodInfo getPeriodNodeFrom() {
        return this.periodNodeFrom;
    }

    public PeriodInfo getPeriodNodeTo() {
        return this.periodNodeTo;
    }

    public void setPeriodNodeFrom(PeriodInfo node) {
        this.periodNodeFrom = node;
    }

    public void setPeriodNodeTo(PeriodInfo node) {
        this.periodNodeTo = node;
    }

    public static String adjustPeriodByBgCycle(Vector vecPeriods, BgPeriodNode bgPeriodNode) {
        String strPeriod;
        int index;
        int i;
        StringBuffer strBuffer = new StringBuffer(100);
        int cycle = bgPeriodNode.getBgCycle().getValue();
        int size = vecPeriods.size();
        int year = bgPeriodNode.getPeriod().getPeriodYear();
        int season = bgPeriodNode.getPeriod().getPeriodQuarter();
        if (cycle == 1) {
            for (i = 0; i < size; ++i) {
                BgPeriodNode bgPeriodNodeTemp = (BgPeriodNode)vecPeriods.get(i);
                if (bgPeriodNodeTemp.getBgCycle().getValue() != 3 || bgPeriodNodeTemp.getPeriod().getPeriodYear() != year) continue;
                strBuffer.append(bgPeriodNodeTemp.getPeriod().getPeriodNumber());
                strBuffer.append(",");
            }
        } else if (cycle == 2) {
            for (i = 0; i < size; ++i) {
                BgPeriodNode bgPeriodNodeTemp = (BgPeriodNode)vecPeriods.get(i);
                if (bgPeriodNodeTemp.getBgCycle().getValue() != 3 || bgPeriodNodeTemp.getPeriod().getPeriodQuarter() != season) continue;
                strBuffer.append(bgPeriodNodeTemp.getPeriod().getPeriodNumber());
                strBuffer.append(",");
            }
        }
        if ((index = (strPeriod = strBuffer.toString()).lastIndexOf(",")) != -1) {
            strPeriod = strPeriod.substring(0, index);
        }
        return strPeriod;
    }
}

