/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.ContextUtils;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.account.AccountUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgItemCollection;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgTemplateColumnCollection;
import com.kingdee.eas.ma.bg.BgTemplateColumnInfo;
import com.kingdee.eas.ma.bg.BgTemplateException;
import com.kingdee.eas.ma.bg.BgTemplateFactory;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgTemplate;
import com.kingdee.eas.ma.bg.ReferencedDimensionCollection;
import com.kingdee.eas.ma.bg.ReferencedDimensionInfo;
import com.kingdee.eas.ma.bg.ValidBgDimensionInfo;
import com.kingdee.eas.ma.bg.client.BgItemHelperFactory;
import com.kingdee.eas.ma.bg.client.BgOrgUnitF7SelectorHelper;
import com.kingdee.eas.ma.bg.client.IBgItemHelper;
import com.kingdee.eas.util.client.EASResource;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class BgTemplateHelper {
    public static SelectorItemCollection getFullDataSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("incParam"));
        sic.add(new SelectorItemInfo("bgCycle"));
        sic.add(new SelectorItemInfo("rollingBgCycle"));
        sic.add(new SelectorItemInfo("isCurrent"));
        sic.add(new SelectorItemInfo("bgMethod"));
        sic.add(new SelectorItemInfo("isMultidimensional"));
        sic.add(new SelectorItemInfo("bgCtrlType"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("approveStyle"));
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("bgType"));
        sic.add(new SelectorItemInfo("bgType.orgTree"));
        sic.add(new SelectorItemInfo("orgUnit"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("refCurrencies"));
        sic.add(new SelectorItemInfo("refCurrencies.currency.number"));
        sic.add(new SelectorItemInfo("refCurrencies.currency.name"));
        sic.add(new SelectorItemInfo("refDimensions"));
        sic.add(new SelectorItemInfo("refDimensions.bgDimension"));
        sic.add(new SelectorItemInfo("refDimensions.bgItems"));
        sic.add(new SelectorItemInfo("bgTpRows"));
        sic.add(new SelectorItemInfo("bgTpRows.bgItem1"));
        sic.add(new SelectorItemInfo("bgTpRows.bgItem1.itemNumber"));
        sic.add(new SelectorItemInfo("bgTpRows.bgItem1.itemName"));
        sic.add(new SelectorItemInfo("bgTpRows.bgItem2"));
        sic.add(new SelectorItemInfo("bgTpRows.bgItem2.itemNumber"));
        sic.add(new SelectorItemInfo("bgTpRows.bgItem2.itemName"));
        sic.add(new SelectorItemInfo("bgTpRows.bgItem3"));
        sic.add(new SelectorItemInfo("bgTpRows.bgItem3.itemNumber"));
        sic.add(new SelectorItemInfo("bgTpRows.bgItem3.itemName"));
        sic.add(new SelectorItemInfo("bgTpRows.bgItem4"));
        sic.add(new SelectorItemInfo("bgTpRows.bgItem4.itemNumber"));
        sic.add(new SelectorItemInfo("bgTpRows.bgItem4.itemName"));
        sic.add(new SelectorItemInfo("bgTpRows.bgItem5"));
        sic.add(new SelectorItemInfo("bgTpRows.bgItem5.itemNumber"));
        sic.add(new SelectorItemInfo("bgTpRows.bgItem5.itemName"));
        sic.add(new SelectorItemInfo("bgTpRows.bgItem6"));
        sic.add(new SelectorItemInfo("bgTpRows.bgItem6.itemNumber"));
        sic.add(new SelectorItemInfo("bgTpRows.bgItem6.itemName"));
        sic.add(new SelectorItemInfo("bgTpColumns.*"));
        sic.add(new SelectorItemInfo("bgTpColumns.bgElement"));
        sic.add(new SelectorItemInfo("bgTpColumns.bgElement.bgType"));
        sic.add(new SelectorItemInfo("bgTpColumns.bgElement.number"));
        sic.add(new SelectorItemInfo("bgTpColumns.bgElement.name"));
        sic.add(new SelectorItemInfo("bgTpColumns.bgElement.dataType"));
        sic.add(new SelectorItemInfo("bgTpApportions"));
        sic.add(new SelectorItemInfo("bgTpApportions.primaryItem"));
        sic.add(new SelectorItemInfo("bgTpApportions.assisItem"));
        return sic;
    }

    public static SelectorItemCollection getBasicOrgInfoSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("type"));
        return sic;
    }

    public static SelectorItemCollection getBgTypeSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("bgType"));
        return sic;
    }

    public static SelectorItemCollection getRefDimSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("refDimensions"));
        return sic;
    }

    public static SelectorItemCollection getLocalCySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        return sic;
    }

    public static boolean isCtrlParamEnable(BgTemplateInfo bgTemplateInfo) {
        return bgTemplateInfo.getBgType().isControllable();
    }

    public static BgTemplateColumnCollection generateBgTpColumns(BgTypeInfo bgTypeInfo) {
        BgTemplateColumnCollection bgTpColumns = new BgTemplateColumnCollection();
        Iterator iter = bgTypeInfo.getElements().iterator();
        while (iter.hasNext()) {
            BgElementInfo bgElementInfo = (BgElementInfo)iter.next();
            BgTemplateColumnInfo bgTemplateColumnInfo = new BgTemplateColumnInfo("id");
            bgTemplateColumnInfo.generateFromBgElement(bgElementInfo);
            bgTpColumns.add(bgTemplateColumnInfo);
        }
        return bgTpColumns;
    }

    public static ReferencedDimensionCollection generateRefDims(BgTypeInfo bgTypeInfo) {
        ReferencedDimensionCollection refDims = new ReferencedDimensionCollection();
        Iterator iter = bgTypeInfo.getValidBgDimensions().iterator();
        int seq = 1;
        while (iter.hasNext()) {
            ValidBgDimensionInfo validBgDimensionInfo = (ValidBgDimensionInfo)iter.next();
            ReferencedDimensionInfo referencedDimensionInfo = new ReferencedDimensionInfo("id");
            referencedDimensionInfo.setBgDimension(validBgDimensionInfo.getBgDimension());
            referencedDimensionInfo.setSeq(seq);
            if (seq == 1) {
                referencedDimensionInfo.setIsPrimary(true);
            } else {
                referencedDimensionInfo.setIsPrimary(false);
            }
            ++seq;
            refDims.add(referencedDimensionInfo);
        }
        return refDims;
    }

    public static boolean checkRefed(BgTemplateInfo bgTemplateInfo) throws BOSException {
        boolean isRef = false;
        IBgTemplate ibt = BgTemplateFactory.getRemoteInstance();
        if (ibt.checkRefByBgForm(bgTemplateInfo.getId())) {
            isRef = true;
        }
        return isRef;
    }

    public static boolean checkRefedByChild(BgTemplateInfo bgTemplateInfo) throws BOSException {
        boolean isRefByChild = false;
        IBgTemplate ibt = BgTemplateFactory.getRemoteInstance();
        if (ibt.checkRefByChild(bgTemplateInfo.getId())) {
            isRefByChild = true;
        }
        return isRefByChild;
    }

    public static ReferencedDimensionCollection getVisibleDims_sorted(Context ctx, BgTemplateInfo info) throws BOSException {
        if (info.isIsMultidimensional()) {
            ObjectUuidPK pk = new ObjectUuidPK(info.getId().toString());
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString()));
            view.setFilter(fi);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("refDimensions.isPrimary"));
            sic.add(new SelectorItemInfo("refDimensions.seq"));
            sic.add(new SelectorItemInfo("refDimensions.id"));
            sic.add(new SelectorItemInfo("refDimensions.bgDimension"));
            sic.add(new SelectorItemInfo("refDimensions.bgItems"));
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            view.getSorter().add(new SorterItemInfo("refDimensions.seq"));
            IBgTemplate ibt = null;
            ibt = ctx == null ? BgTemplateFactory.getRemoteInstance() : BgTemplateFactory.getLocalInstance(ctx);
            ReferencedDimensionCollection result = ibt.getBgTemplateCollection(view).get(0).getRefDimensions();
            return result;
        }
        ReferencedDimensionCollection refDims = new ReferencedDimensionCollection();
        ReferencedDimensionInfo referencedDimensionInfo = info.getPrimaryRefDim();
        if (referencedDimensionInfo != null) {
            refDims.add(info.getPrimaryRefDim());
        }
        return refDims;
    }

    public static boolean checkRefDimSeq(ReferencedDimensionCollection refDims) {
        Vector<Integer> vector = new Vector<Integer>();
        Iterator iterator = refDims.iterator();
        while (iterator.hasNext()) {
            vector.add(new Integer(((ReferencedDimensionInfo)iterator.next()).getSeq()));
        }
        boolean result = true;
        int size = vector.size();
        for (int i = 0; i < size; ++i) {
            Integer theSeq = (Integer)vector.get(i);
            if (vector.indexOf(theSeq) != vector.lastIndexOf(theSeq)) {
                result = false;
                break;
            }
            if (theSeq >= 1 && theSeq <= size) continue;
            result = false;
            break;
        }
        return result;
    }

    public static Vector parseToDigital(String s) {
        if (s == null) {
            return null;
        }
        Vector<Integer> v = new Vector<Integer>();
        int digital = -1;
        int size = s.length();
        for (int i = 0; i < size; ++i) {
            int currentDigital = Character.digit(s.charAt(i), 10);
            if (currentDigital == -1) {
                if (digital == -1) continue;
                v.add(new Integer(digital));
                digital = -1;
                continue;
            }
            digital = digital == -1 ? currentDigital : digital * 10 + currentDigital;
        }
        if (digital != -1) {
            v.add(new Integer(digital));
        }
        return v;
    }

    public static void setBgTemplateAccountByTargetOrgUnit(Context ctx, BgTemplateInfo bgTemplateInfo, OrgUnitInfo srcOrgUnitInfo, OrgUnitInfo targetOrgUnitInfo) throws EASBizException, BOSException {
        BOSUuid srcOrgId = srcOrgUnitInfo.getId();
        BOSUuid tarOrgId = targetOrgUnitInfo.getId();
        ICompanyOrgUnit ic = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo srcCompany = ic.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(srcOrgId));
        CompanyOrgUnitInfo tarCompany = ic.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(tarOrgId));
        AccountViewCollection accountViewCollection = BgTemplateHelper.getAccontCollectionByBgTemplate(srcCompany, bgTemplateInfo);
        if (accountViewCollection != null && accountViewCollection.size() > 0) {
            IAccountView iAccountView = AccountViewFactory.getLocalInstance((Context)ctx);
            int sizeTemp = accountViewCollection.size();
            AccountViewCollection accountViewCollectionNew = new AccountViewCollection();
            for (int i = 0; i < sizeTemp; ++i) {
                AccountViewInfo accountViewInfoTemps = accountViewCollection.get(i);
                accountViewInfoTemps = (AccountViewInfo)iAccountView.getValue((IObjectPK)new ObjectUuidPK(accountViewInfoTemps.getId()));
                accountViewCollectionNew.add(accountViewInfoTemps);
            }
            int sizeA = accountViewCollectionNew.size();
            ObjectUuidPK[] pkArray = new ObjectUuidPK[sizeA];
            for (int i = 0; i < sizeA; ++i) {
                pkArray[i] = new ObjectUuidPK(accountViewCollectionNew.get(i).getId());
            }
            Hashtable hashtable = AccountUtils.getSourceCompanyAccountViewByRef((Context)ctx, (IObjectPK[])pkArray, (IObjectPK)new ObjectUuidPK(srcCompany.getId()), (IObjectPK)new ObjectUuidPK(tarCompany.getId()));
            Iterator iterator = bgTemplateInfo.getRefDimensions().iterator();
            IBgItemHelper bgItemHelper = null;
            try {
                bgItemHelper = new BgItemHelperFactory().getBgItemHelper(bgTemplateInfo.getBgType(), BgDimensionEnum.ACCOUNT, bgTemplateInfo.getOrgUnit());
            }
            catch (Exception e) {
                throw new EASBizException(EASBizException.CHECKBLANK);
            }
            if (bgItemHelper == null) {
                throw new EASBizException(EASBizException.CHECKBLANK);
            }
            while (iterator.hasNext()) {
                ReferencedDimensionInfo referencedDimensionInfo = (ReferencedDimensionInfo)iterator.next();
                if (referencedDimensionInfo.getBgDimension().getValue() != 1100) continue;
                BgItemCollection bgItemCollection = referencedDimensionInfo.getBgItems();
                Iterator iteratorItem = bgItemCollection.iterator();
                BgItemCollection bgItemCollectionNew = new BgItemCollection();
                while (iteratorItem.hasNext()) {
                    BgItemInfo bgItemInfo = (BgItemInfo)iteratorItem.next();
                    AccountViewInfo accountViewInfo = BgTemplateHelper.matchAccountByBgItemInfo(accountViewCollection, bgItemInfo);
                    AccountViewCollection accountViewCollectionTemp = (AccountViewCollection)hashtable.get(accountViewInfo.getId().toString());
                    if (accountViewCollectionTemp == null) {
                        throw new BgTemplateException(BgTemplateException.NOTDEFINEDACCOUNTRELATION, new Object[]{accountViewInfo.getName()});
                    }
                    int size = accountViewCollectionTemp.size();
                    if (accountViewCollectionTemp == null || size <= 0) continue;
                    for (int i = 0; i < size; ++i) {
                        AccountViewInfo accountViewInfoTemp = accountViewCollectionTemp.get(i);
                        BgItemInfo bgItemInfoTemp = bgItemHelper.convertBgItem(accountViewInfoTemp);
                        bgItemCollectionNew.add(bgItemInfoTemp);
                    }
                }
                referencedDimensionInfo.getBgItems().clear();
                referencedDimensionInfo.getBgItems().addCollection(bgItemCollectionNew);
            }
        }
    }

    public static AccountViewCollection getAccontCollectionByBgTemplate(CompanyOrgUnitInfo companyOrgUnitInfo, BgTemplateInfo bgTemplateInfo) {
        AccountViewCollection accountCollection = new AccountViewCollection();
        Iterator iterator = bgTemplateInfo.getRefDimensions().iterator();
        while (iterator.hasNext()) {
            ReferencedDimensionInfo referencedDimensionInfo = (ReferencedDimensionInfo)iterator.next();
            if (referencedDimensionInfo.getBgDimension() == null || referencedDimensionInfo.getBgDimension().getValue() != 1100) continue;
            BgItemCollection bgItemCollection = referencedDimensionInfo.getBgItems();
            Iterator iteratorItem = bgItemCollection.iterator();
            while (iteratorItem.hasNext()) {
                BgItemInfo bgItemInfo = (BgItemInfo)iteratorItem.next();
                AccountViewInfo accountViewInfo = BgTemplateHelper.convertBizItem(bgItemInfo);
                if (accountViewInfo == null) continue;
                accountCollection.add(accountViewInfo);
            }
        }
        return accountCollection;
    }

    public static AccountViewInfo matchAccountByBgItemInfo(AccountViewCollection accountViewCollection, BgItemInfo bgItemInfo) {
        AccountViewInfo accountViewInfo = null;
        for (AccountViewInfo accontTemp : accountViewCollection) {
            if (!accontTemp.getId().equals((Object)bgItemInfo.getItemID())) continue;
            accountViewInfo = accontTemp;
            break;
        }
        return accountViewInfo;
    }

    public static AccountViewInfo convertBizItem(BgItemInfo bgItemInfo) {
        AccountViewInfo accountViewInfo = new AccountViewInfo();
        accountViewInfo.setId(bgItemInfo.getItemID());
        accountViewInfo.setNumber(bgItemInfo.getItemNumber());
        accountViewInfo.setName(bgItemInfo.getItemName());
        return accountViewInfo;
    }

    public static void setClonetNumberAndName(Context ctx, BgTemplateInfo clonedTpInfo) throws BOSException, EASBizException {
        String orgId;
        ICodingRuleManager iCodingRuleManager;
        String newNumber = null;
        if (clonedTpInfo.getCompany() != null && (iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx)).isExist((IObjectValue)clonedTpInfo, orgId = clonedTpInfo.getCompany().getId().toString())) {
            newNumber = iCodingRuleManager.getNumber((IObjectValue)clonedTpInfo, orgId);
        }
        if (newNumber == null) {
            String prefixNumber = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"PrefixNumberClone");
            newNumber = prefixNumber + "_" + clonedTpInfo.getNumber() + BgHelper.getTimeString();
        }
        clonedTpInfo.setNumber(newNumber);
        String prefixName = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"PrefixNameClone");
        clonedTpInfo.setName(prefixName + clonedTpInfo.getName());
    }

    public static void setSubNumberAndName(Context ctx, OrgUnitInfo tempOrgInfo, BgTemplateInfo clonedTpInfo) throws EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String newNumber = null;
        String orgId = null;
        orgId = clonedTpInfo.getCompany() != null ? clonedTpInfo.getCompany().getId().toString() : clonedTpInfo.getOrgUnit().getId().toString();
        String groupId = null;
        IOrgUnitCommon iCom = OrgUnitCommonFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo comInfo = iCom.getRootCompany();
        if (comInfo != null) {
            groupId = comInfo.getId().toString();
        }
        boolean hasCode = false;
        if (iCodingRuleManager.isExist((IObjectValue)clonedTpInfo, orgId)) {
            hasCode = true;
        } else if (groupId != null && iCodingRuleManager.isExist((IObjectValue)clonedTpInfo, groupId)) {
            hasCode = true;
        }
        if (hasCode) {
            newNumber = iCodingRuleManager.getNumber((IObjectValue)clonedTpInfo, orgId);
        }
        if (newNumber == null) {
            newNumber = tempOrgInfo.getNumber() + "_" + clonedTpInfo.getNumber() + BgHelper.getTimeString();
        }
        clonedTpInfo.setNumber(newNumber);
        clonedTpInfo.setName(tempOrgInfo.getName() + "_" + clonedTpInfo.getName());
    }

    public static void setCurrUserAndTime(Context ctx, BgTemplateInfo bgTemplateInfo) {
        UserInfo userInfo = ContextUtils.getUser((Context)ctx);
        bgTemplateInfo.setCreator(userInfo);
        bgTemplateInfo.setLastUpdateUser(userInfo);
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        bgTemplateInfo.setCreateTime(timestamp);
        bgTemplateInfo.setLastUpdateTime(timestamp);
    }

    public static BgTemplateInfo findTempByBgTypeAndOrgNum(BgTypeInfo bgTypeInfo, FullOrgUnitInfo org) throws EASBizException, BOSException {
        BgTemplateInfo bgTemp = BgOrgUnitF7SelectorHelper.findBgTemplateInfoOfPath(bgTypeInfo, org.getNumber());
        if (bgTemp == null) {
            INewOrgViewFacade iOrgView = NewOrgViewFacadeFactory.getRemoteInstance();
            Integer treeType = (Integer)org.get("treeType");
            while (bgTemp == null) {
                OrgViewType orgViewType = BgTemplateHelper.getOrgViewType(org);
                OrgUnitInfo perantOrg = iOrgView.getParent(org.getId().toString(), orgViewType);
                if (perantOrg == null) break;
                perantOrg.put("treeType", (Object)treeType);
                org = (FullOrgUnitInfo)perantOrg;
                bgTemp = BgOrgUnitF7SelectorHelper.findBgTemplateInfoOfPath(bgTypeInfo, org.getNumber());
            }
        }
        return bgTemp;
    }

    public static OrgViewType getOrgViewType(FullOrgUnitInfo org) {
        OrgViewType orgViewType = null;
        if (org == null) {
            return null;
        }
        if ((Integer)org.get("treeType") == 0) {
            orgViewType = OrgViewType.ADMIN;
        } else if ((Integer)org.get("treeType") == 1) {
            orgViewType = OrgViewType.COMPANY;
        } else if ((Integer)org.get("treeType") == 2) {
            orgViewType = OrgViewType.SALE;
        } else if ((Integer)org.get("treeType") == 3) {
            orgViewType = OrgViewType.PURCHASE;
        } else if ((Integer)org.get("treeType") == 4) {
            orgViewType = OrgViewType.STORAGE;
        } else if ((Integer)org.get("treeType") == 5) {
            orgViewType = OrgViewType.COSTCENTER;
        } else if ((Integer)org.get("treeType") == 6) {
            orgViewType = OrgViewType.PROFITCENTER;
        } else if ((Integer)org.get("treeType") == 15) {
            orgViewType = OrgViewType.RESPONSECENTER;
        }
        return orgViewType;
    }

    public static OrgViewType getOrgViewTypeByOrgType(OrgType orgType) {
        OrgViewType orgViewType = OrgViewType.COMPANY;
        if (orgType == null) {
            return orgViewType;
        }
        int type = orgType.getValue();
        switch (type) {
            case 0: {
                orgViewType = OrgViewType.ADMIN;
                break;
            }
            case 1: {
                orgViewType = OrgViewType.COMPANY;
                break;
            }
            case 2: {
                orgViewType = OrgViewType.SALE;
                break;
            }
            case 3: {
                orgViewType = OrgViewType.PURCHASE;
                break;
            }
            case 4: {
                orgViewType = OrgViewType.STORAGE;
                break;
            }
            case 6: {
                orgViewType = OrgViewType.RESPONSECENTER;
                break;
            }
            case 5: {
                orgViewType = OrgViewType.RESPONSECENTER;
                break;
            }
            default: {
                orgViewType = OrgViewType.COMPANY;
            }
        }
        return orgViewType;
    }
}

