/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.OrgF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.bg.BgItemCollection;
import com.kingdee.eas.ma.bg.BgItemFactory;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgItem;
import com.kingdee.eas.ma.bg.client.IBgItemHelper;
import java.util.Iterator;

public abstract class AbstractBgItemHelper_OrgUnit
implements IBgItemHelper {
    protected FullOrgUnitInfo orgUnitInfo;
    protected BgTypeInfo bgTypeInfo;
    protected CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();

    @Override
    public BgItemCollection fetcheBgItems() throws EASBizException, BOSException {
        BgItemCollection bic = new BgItemCollection();
        IBgItem ibi = BgItemFactory.getRemoteInstance();
        OrgUnitCollection ouc = ibi.getOrgItemCollection(this.getOrgType().getValue(), this.cuInfo.getId().toString());
        Iterator iter = ouc.iterator();
        while (iter.hasNext()) {
            bic.add(this.convertBgItem(iter.next()));
        }
        return bic;
    }

    @Override
    public void setBgType(BgTypeInfo bgTypeInfo) {
        this.bgTypeInfo = bgTypeInfo;
    }

    @Override
    public void setOrgUnit(FullOrgUnitInfo orgUnitInfo) {
        this.orgUnitInfo = orgUnitInfo;
    }

    @Override
    public BgItemInfo convertBgItem(Object objectInfo) {
        OrgUnitInfo oui = (OrgUnitInfo)objectInfo;
        BgItemInfo bii = new BgItemInfo();
        bii.setId(BOSUuid.create((BOSObjectType)bii.getBOSType()));
        bii.setBgDimension(this.getCurrentBgDimEnum());
        bii.setItemID(oui.getId());
        bii.setItemNumber(oui.getNumber());
        bii.setItemName(oui.getName());
        bii.setIsLeaf(true);
        return bii;
    }

    @Override
    public Object convertBizItem(BgItemInfo bgItemInfo) {
        FullOrgUnitInfo oui = new FullOrgUnitInfo();
        oui.setId(bgItemInfo.getItemID());
        oui.setNumber(bgItemInfo.getItemNumber());
        oui.setName(bgItemInfo.getItemName());
        return oui;
    }

    @Override
    public KDBizPromptBox getBizPromptBox(IUIObject uiObj) {
        KDBizPromptBox box = new KDBizPromptBox();
        OrgF7 orgF7 = new OrgF7(uiObj);
        orgF7.setOrgTypes(new OrgType[]{this.getOrgType()});
        box.setSelector((KDPromptSelector)orgF7);
        return box;
    }

    abstract OrgType getOrgType();
}

