/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgFormulaHelper;
import com.kingdee.eas.ma.bg.BgPeriodEnum;
import com.kingdee.eas.ma.bg.BgPeriodNode;
import com.kingdee.eas.ma.bg.BgPeriodRange;
import com.kingdee.eas.ma.bg.client.IBgDataChangeObserver;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Vector;

public class BgDataColumnObserver
implements IBgDataChangeObserver {
    protected String elementKey;
    protected String formula;
    protected BgFormInfo bgFormInfo;
    protected Vector periodNodeVector;
    protected KDTable kdTable;

    public BgDataColumnObserver(String elementKey, String formula, BgFormInfo bgFormInfo, Vector periodNodeVector, KDTable kdTable) {
        this.elementKey = elementKey;
        this.formula = formula;
        this.bgFormInfo = bgFormInfo;
        this.periodNodeVector = periodNodeVector;
        this.kdTable = kdTable;
    }

    @Override
    public void update(BgEntryInfo bgEntryInfo, BgDataInfo bgDataInfo, int nrow) {
        String subjectElementKey = bgDataInfo.getBgElement().getNumber();
        BgPeriodNode observerBgPeriodNode = this.getObserverPeriodNode(bgEntryInfo.getPeriodNode(), subjectElementKey);
        if (observerBgPeriodNode == null) {
            return;
        }
        BgDataInfo updatingBgDataInfo = this.bgFormInfo.getBgData(bgEntryInfo.getBgItemsKey(), this.elementKey, observerBgPeriodNode);
        if (updatingBgDataInfo == null) {
            return;
        }
        String adjustedFormula = BgFormulaHelper.adjustTemplateFormula(this.formula, nrow, observerBgPeriodNode, this.periodNodeVector);
        if (adjustedFormula.equals("")) {
            return;
        }
        Variant variant = this.kdTable.getScriptManager().run(adjustedFormula);
        BigDecimal decimal = (BigDecimal)variant.getValue();
        updatingBgDataInfo.setBgValue(decimal);
    }

    private BgPeriodNode getObserverPeriodNode(BgPeriodNode curBgPeriodNode, String subjectElementKey) {
        String[] tmpArray = StringUtils.split((String)this.formula, (String)",");
        int position = -1;
        for (int i = 0; i < tmpArray.length; ++i) {
            if (StringUtils.indexOfIgnoreCase((String)tmpArray[i], (String)subjectElementKey) == -1) continue;
            position = i;
        }
        if (position == -1) {
            return null;
        }
        String tmpString = tmpArray[position + 2];
        BgPeriodNode observerPeriodNode = null;
        if (tmpString.indexOf(BgPeriodEnum.CurrentPeriod.getName()) != -1) {
            observerPeriodNode = curBgPeriodNode;
        } else if (tmpString.indexOf(BgPeriodEnum.PreviousPeriod.getName()) != -1) {
            observerPeriodNode = BgPeriodRange.getPreviousPeriod(curBgPeriodNode, this.periodNodeVector);
        } else if (tmpString.indexOf(BgPeriodEnum.NextPeriod.getName()) != -1) {
            observerPeriodNode = BgPeriodRange.getNextPeriod(curBgPeriodNode, this.periodNodeVector);
        } else {
            return null;
        }
        return observerPeriodNode;
    }
}

