/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.bg.BgAssistantDimensionEnum;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgEntryCollection;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgFormCollection;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgItemCollection;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgPeriodNode;
import com.kingdee.eas.ma.bg.BgPeriodRange;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.ReferencedDimensionCollection;
import com.kingdee.eas.ma.bg.ReferencedDimensionInfo;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.ma.bg.client.BgDistributeEditHelper;
import com.kingdee.eas.ma.bg.client.BgFormEditHelper;
import com.kingdee.eas.ma.bg.client.BgItemHelper_ACCOUNT;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.tree.TreeModel;

public class BgDeclareClientHelper {
    private Hashtable hashOfKDTable = new Hashtable(100);
    private Vector vectDim = new Vector(6);
    private int colOfComplex = -1;
    private int colOfOrg = -1;

    public void insertOrgDim(KDTable kdTable, FullOrgUnitCollection orgCollection, BgTemplateInfo bgTemplateInfo, boolean isDeclare) {
        int nOrgUnitCount = orgCollection.size();
        if (nOrgUnitCount == 0) {
            return;
        }
        int nDimCount = bgTemplateInfo.getVisibleDims().size();
        IColumn iColumn = kdTable.addColumn(nDimCount);
        iColumn.setKey(BgAssistantDimensionEnum.SUB_ORGUNIT.getName());
        String strHeadCellName = BgAssistantDimensionEnum.SUB_ORGUNIT.getAlias(SysContext.getSysContext().getLocale());
        int size = kdTable.getHeadRowCount();
        for (int i = 0; i < size; ++i) {
            kdTable.getHeadRow(i).getCell(nDimCount).setValue((Object)strHeadCellName);
        }
        if (isDeclare) {
            kdTable.getHeadMergeManager().mergeBlock(0, 0, kdTable.getHeadRowCount() - 1, kdTable.getColumnCount() - 1, 1);
        }
        int nRowOldCount = kdTable.getRowCount();
        if (nOrgUnitCount == 1) {
            for (int i = 0; i < nRowOldCount; ++i) {
                IRow iRowTemp = kdTable.getRow(i);
                String strRowKey = (String)iRowTemp.getUserObject();
                FullOrgUnitInfo orgUnitInfo = orgCollection.get(0);
                strRowKey = strRowKey + "_" + orgUnitInfo.getNumber();
                iRowTemp.setUserObject((Object)strRowKey);
                String strName = orgUnitInfo.getNumber() + " " + orgUnitInfo.getName();
                iRowTemp.getCell(BgAssistantDimensionEnum.SUB_ORGUNIT.getName()).setValue((Object)strName);
            }
        } else {
            for (int num = 0; num < nRowOldCount * nOrgUnitCount; num += nOrgUnitCount) {
                IRow iRowTemp = kdTable.getRow(num);
                String strRowKey = (String)iRowTemp.getUserObject();
                FullOrgUnitInfo orgUnitInfo = orgCollection.get(0);
                String strRowKeyNew = strRowKey + "_" + orgUnitInfo.getNumber();
                iRowTemp.setUserObject((Object)strRowKeyNew);
                String strName = orgUnitInfo.getNumber() + " " + orgUnitInfo.getName();
                String strOrgColumn = BgAssistantDimensionEnum.SUB_ORGUNIT.getName();
                iRowTemp.getCell(strOrgColumn).setValue((Object)strName);
                iRowTemp.getCell(strOrgColumn).setUserObject((Object)orgUnitInfo);
                for (int j = 1; j < nOrgUnitCount; ++j) {
                    IRow iRowAdd = kdTable.addRow(num + j);
                    FullOrgUnitInfo orgUnitInfoTemp = orgCollection.get(j);
                    String strRowKeyAdd = strRowKey + "_" + orgUnitInfoTemp.getNumber();
                    iRowAdd.setUserObject((Object)strRowKeyAdd);
                    String strNameTemp = orgUnitInfoTemp.getNumber() + " " + orgUnitInfoTemp.getName();
                    iRowAdd.getCell(strOrgColumn).setValue((Object)strNameTemp);
                    iRowAdd.getCell(strOrgColumn).setUserObject((Object)orgUnitInfoTemp);
                    for (int k = 0; k < nDimCount; ++k) {
                        iRowAdd.getCell(k).setValue(iRowTemp.getCell(k).getValue());
                        iRowAdd.getCell(k).setUserObject(iRowTemp.getCell(k).getUserObject());
                    }
                }
            }
        }
    }

    public static void goFirstChild(KDTree treeBgPeriod) {
        TreeModel model = treeBgPeriod.getModel();
        if (model == null) {
            return;
        }
        Object objNode = model.getRoot();
        while (treeBgPeriod.getModel().getChildCount(objNode) > 0) {
            objNode = treeBgPeriod.getModel().getChild(objNode, 0);
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)objNode;
        if (!node.equals(treeBgPeriod.getSelectionModel())) {
            treeBgPeriod.setSelectionNode(node);
        }
    }

    public void addTotalRow(KDTable kdTable, Vector vecSubRowCount, Vector vecCellIndex) {
        if (vecSubRowCount == null || vecSubRowCount.size() == 0) {
            return;
        }
        int nRowCount = kdTable.getRowCount();
        IRow iRowTotal = kdTable.addRow(nRowCount);
        iRowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        iRowTotal.getStyleAttributes().setLocked(true);
        Vector vecSubIndex = (Vector)vecSubRowCount.elementAt(0);
        for (int i = 0; i < vecCellIndex.size(); ++i) {
            int nCellIndex = (Integer)vecCellIndex.elementAt(i);
            StringBuffer strBuffFormula = new StringBuffer("=");
            for (int j = 0; j < vecSubIndex.size(); ++j) {
                int nRowIndex = (Integer)vecSubIndex.elementAt(j);
                strBuffFormula.append("cell(" + (nRowIndex + 1));
                strBuffFormula.append(" , " + (nCellIndex + 1) + ").getValue()");
                if (j == vecSubIndex.size() - 1) continue;
                strBuffFormula.append(" + ");
            }
            iRowTotal.getCell(nCellIndex).setExpressions(strBuffFormula.toString());
        }
        String strTotal = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"total");
        iRowTotal.getCell(0).setValue((Object)strTotal);
        iRowTotal.setUserObject(new Hashtable());
    }

    public void addSubtotalRow(KDTable kdTable, BgTemplateInfo bgTemplateInfo, Vector vecSubTotalIndex) {
        if (vecSubTotalIndex == null) {
            return;
        }
        Vector vecRowIndex = (Vector)vecSubTotalIndex.get(0);
        Vector vecTotalRowCount = (Vector)vecSubTotalIndex.get(1);
        Vector vecCellIndex = BgFormEditHelper.getSumableColumn(bgTemplateInfo, kdTable);
        int size = vecRowIndex.size();
        for (int i = 0; i < size; ++i) {
            int index = (Integer)vecRowIndex.elementAt(i);
            IRow iRowSubTotal = kdTable.addRow(index);
            if (index > 0) {
                IRow iRowTemp = kdTable.getRow(index - 1);
                String strSubAcctColumn = BgAssistantDimensionEnum.SUB_ACCOUNT.getName();
                int startIndex = kdTable.getColumnIndex(strSubAcctColumn);
                if (startIndex <= 0) {
                    String strOrgColumn = BgAssistantDimensionEnum.SUB_ORGUNIT.getName();
                    startIndex = kdTable.getColumnIndex(strOrgColumn);
                }
                for (int j = ++startIndex; j < kdTable.getColumnCount(); ++j) {
                    iRowSubTotal.getCell(j).setValue(iRowTemp.getCell(j).getValue());
                    iRowSubTotal.getCell(j).setUserObject(iRowTemp.getCell(j).getUserObject());
                }
            }
            for (int k = 0; k < vecCellIndex.size(); ++k) {
                int cellIndex = (Integer)vecCellIndex.elementAt(k);
                String strFormula = this.getFormulaByRowIndex(index, vecTotalRowCount, cellIndex);
                iRowSubTotal.getCell(cellIndex).setExpressions(strFormula);
            }
            iRowSubTotal.setUserObject((Object)vecSubTotalIndex);
            String strSubtotal = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"subtotal");
            iRowSubTotal.getCell(0).setValue((Object)strSubtotal);
            iRowSubTotal.getStyleAttributes().setBackground(new Color(16119270));
        }
    }

    private boolean checkKeyMatched(FullOrgUnitInfo orgInfo, IRow row, BgEntryInfo bgEntryInfo) {
        String bgEntryKey = bgEntryInfo.getBgItemsKey();
        String tmpKey = bgEntryKey + "_" + orgInfo.getNumber();
        String rowKey = row.getUserObject().toString();
        return tmpKey.equals(rowKey);
    }

    public void insertBgEntryInfosByPeriod(KDTable kdTable, FullOrgUnitInfo orgUnitInfo, BgEntryCollection bgEntryCollection, boolean isMultiCurrency) {
        if (bgEntryCollection == null) {
            return;
        }
        int nRowCount = kdTable.getRowCount();
        if (nRowCount == 0) {
            return;
        }
        int size = bgEntryCollection.size();
        for (int i = 0; i < size; ++i) {
            BgEntryInfo bgEntryInfo = bgEntryCollection.get(i);
            for (int j = 0; j < nRowCount; ++j) {
                IRow row = kdTable.getRow(j);
                boolean isMatched = this.checkKeyMatched(orgUnitInfo, row, bgEntryInfo);
                if (!isMatched) continue;
                BgFormEditHelper.fillBgEntry(isMultiCurrency, bgEntryInfo, row);
                row.getCell(0).setUserObject((Object)bgEntryInfo);
            }
        }
    }

    public Vector getSubTotalRowIndex(KDTable kdTable) {
        int nCount;
        Vector vec = new Vector();
        Vector<Integer> vecRowIndex = new Vector<Integer>();
        Vector vecTotalRowCount = new Vector();
        if (kdTable == null) {
            return null;
        }
        int nAddRow = 0;
        int nRowCount = kdTable.getRowCount();
        block0: for (int i = 0; i < nRowCount; i += nCount) {
            IRow iRowCurr = kdTable.getRow(i);
            String strRowKey = iRowCurr.getCell(0).getValue().toString();
            nCount = 0;
            for (int j = i; j < nRowCount; ++j) {
                Hashtable<Integer, Integer> has;
                IRow iRowTemp = kdTable.getRow(j);
                String strRowKeyTemp = iRowTemp.getCell(0).getValue().toString();
                if (strRowKey.equals(strRowKeyTemp)) {
                    ++nCount;
                    if (j != nRowCount - 1) continue;
                    vecRowIndex.add(new Integer(nRowCount + nAddRow));
                    has = new Hashtable();
                    has.put(new Integer(nRowCount + nAddRow), new Integer(nCount));
                    vecTotalRowCount.add(has);
                    continue;
                }
                vecRowIndex.add(new Integer(j + nAddRow));
                has = new Hashtable<Integer, Integer>();
                has.put(new Integer(j + nAddRow), new Integer(nCount));
                vecTotalRowCount.add(has);
                ++nAddRow;
                continue block0;
            }
        }
        if (vecRowIndex.size() == 0) {
            return null;
        }
        vec.add(0, vecRowIndex);
        vec.add(1, vecTotalRowCount);
        return vec;
    }

    public String getFormulaByRowIndex(int rowIndex, Vector vecTotalRowCount, int columnIndex) {
        StringBuffer strFormula = new StringBuffer("=");
        for (int i = 0; i < vecTotalRowCount.size(); ++i) {
            int nCount;
            Hashtable has = (Hashtable)vecTotalRowCount.get(i);
            Object obj = has.get(new Integer(rowIndex));
            if (obj == null) continue;
            for (int j = nCount = ((Integer)obj).intValue(); j > 0; --j) {
                int nIndex = rowIndex - j;
                strFormula.append("cell(" + (nIndex + 1) + ", " + (columnIndex + 1) + ").getValue()");
                if (j == 1) continue;
                strFormula.append(" + ");
            }
        }
        if (strFormula.toString().length() < 2) {
            return null;
        }
        return strFormula.toString();
    }

    public void fillBgEntrysByPeriod(String totalId, KDTable kdTable, FullOrgUnitCollection subOrgUnitCollection, BgFormCollection subBgFormCollection, BgPeriodNode bgPeriodNode) {
        if (subOrgUnitCollection == null || subBgFormCollection == null || bgPeriodNode == null) {
            return;
        }
        int size = subOrgUnitCollection.size();
        for (int i = 0; i < size; ++i) {
            FullOrgUnitInfo orgUnitInfo = subOrgUnitCollection.get(i);
            for (int j = 0; j < subBgFormCollection.size(); ++j) {
                boolean isMulityCurrency;
                BgFormInfo bgFormInfo = subBgFormCollection.get(j);
                String strId = bgFormInfo.getOrgUnit().getId().toString();
                boolean bl = isMulityCurrency = bgFormInfo.getBgTemplate().getRefCurrencies().size() > 1;
                if (!orgUnitInfo.getId().toString().equals(strId)) continue;
                BgEntryCollection bgEntryCollection = this.getBgEntryCollectionByPeriod(bgFormInfo, bgPeriodNode);
                this.insertBgEntryInfosByPeriod(kdTable, orgUnitInfo, bgEntryCollection, isMulityCurrency);
                if (!bgFormInfo.getId().toString().equals(totalId)) continue;
                int m = bgEntryCollection.size();
                for (int h = 0; h < m; ++h) {
                    BgEntryInfo entryInfo = bgEntryCollection.get(h);
                    int n = entryInfo.getBgData().size();
                    for (int k = 0; k < n; ++k) {
                        BgDataInfo tempDataInfo = entryInfo.getBgData().get(k);
                        BgDataInfo realDataInfo = bgFormInfo.getBgData(entryInfo.getBgItemsKey(), tempDataInfo.getElementKey(), bgPeriodNode);
                        if (realDataInfo == null) continue;
                        realDataInfo.setBgValue(tempDataInfo.getBgValue());
                    }
                }
            }
        }
    }

    private BgEntryCollection getBgEntryCollectionByPeriod(BgFormInfo bgFormInfo, BgPeriodNode bgPeriodNode) {
        int formCycle;
        BgEntryCollection currentBgEntries = new BgEntryCollection();
        int periodCycle = bgPeriodNode.getBgCycle().getValue();
        if (periodCycle >= (formCycle = bgFormInfo.getBgTemplate().getBgCycle().getValue())) {
            currentBgEntries.addCollection(bgFormInfo.getBgEntries(bgPeriodNode.getPeriod(), bgPeriodNode.getBgCycle()));
        } else {
            currentBgEntries.addCollection(bgFormInfo.getSummedBgEntries(bgPeriodNode.getPeriod(), bgPeriodNode.getBgCycle()));
        }
        return currentBgEntries;
    }

    public boolean checkIsSameAccountTable(CompanyOrgUnitInfo companyOrgUnitInfo, CompanyOrgUnitInfo subCompanyOrgUnitInfo) {
        String strSubAccountId;
        boolean isSame = true;
        if (companyOrgUnitInfo == null || subCompanyOrgUnitInfo == null) {
            isSame = true;
            return isSame;
        }
        if (companyOrgUnitInfo.getAccountTable() == null || subCompanyOrgUnitInfo.getAccountTable() == null) {
            isSame = true;
            return isSame;
        }
        String strAccountId = companyOrgUnitInfo.getAccountTable().getId().toString();
        if (!strAccountId.equals(strSubAccountId = subCompanyOrgUnitInfo.getAccountTable().getId().toString())) {
            isSame = false;
        }
        return isSame;
    }

    public void insertSubAccountColumn(KDTable kdTable, BgTemplateInfo bgTemplateInfo) {
        int nDimCount = bgTemplateInfo.getVisibleDims().size();
        IColumn iColumn = kdTable.addColumn(nDimCount + 1);
        iColumn.setKey(BgAssistantDimensionEnum.SUB_ACCOUNT.getName());
        String strHeadCellName = BgAssistantDimensionEnum.SUB_ORGUNIT.getAlias(SysContext.getSysContext().getLocale());
        kdTable.getHeadRow(0).getCell(nDimCount + 1).setValue((Object)strHeadCellName);
    }

    public int getRowIndexByBgItem(KDTable kdTable, AccountViewInfo accountViewInfo, FullOrgUnitInfo subOrgUnitInfo) {
        int nRowCount = kdTable.getRowCount();
        int nAccontCol = kdTable.getColumnIndex(BgDimensionEnum.ACCOUNT.getName());
        String strOrgKey = BgAssistantDimensionEnum.SUB_ORGUNIT.getName();
        int index = -1;
        for (int i = 0; i < nRowCount; ++i) {
            IRow iRow = kdTable.getRow(i);
            BgItemInfo bgItemInfo = (BgItemInfo)iRow.getCell(nAccontCol).getUserObject();
            boolean isSame = this.checkAccountIsSameByBgItem(bgItemInfo, accountViewInfo);
            if (!isSame) continue;
            FullOrgUnitInfo orgUnitInfoTemp = (FullOrgUnitInfo)iRow.getCell(strOrgKey).getUserObject();
            String strOrgId = orgUnitInfoTemp.getId().toString();
            if (!subOrgUnitInfo.getId().toString().equals(strOrgId)) continue;
            index = i;
        }
        return index;
    }

    public boolean checkAccountIsSameByBgItem(BgItemInfo bgItemInfo, AccountViewInfo accountViewInfo) {
        boolean isSame = false;
        BgItemHelper_ACCOUNT bgItemHelper_ACCOUNT = new BgItemHelper_ACCOUNT();
        AccountViewInfo accountInfoTemp = (AccountViewInfo)bgItemHelper_ACCOUNT.convertBizItem(bgItemInfo);
        String strId = accountInfoTemp.getId().toString();
        if (accountViewInfo.getId().toString().equals(strId)) {
            isSame = true;
        }
        return isSame;
    }

    public void insertSubAaccountRowByRowIndex(KDTable kdTable, AccountViewCollection accountViewCollection, int rowIndex) {
        String strAcctColKey = BgAssistantDimensionEnum.SUB_ACCOUNT.getName();
        String strOrgColKey = BgAssistantDimensionEnum.SUB_ORGUNIT.getName();
        IRow iRowTemp = kdTable.getRow(rowIndex);
        String strRowKey = (String)iRowTemp.getUserObject();
        int size = accountViewCollection.size();
        if (size == 1) {
            AccountViewInfo accountViewInfo = accountViewCollection.get(0);
            String strRowKeyTemp = strRowKey + "_" + accountViewInfo.getNumber();
            String strAcountName = accountViewInfo.getName();
            iRowTemp.getCell(strAcctColKey).setValue((Object)strAcountName);
            iRowTemp.getCell(strAcctColKey).setUserObject((Object)accountViewInfo);
            iRowTemp.setUserObject((Object)strRowKey);
        } else {
            AccountViewInfo accountViewInfo = accountViewCollection.get(0);
            String strRowKeyTemp = strRowKey + "_" + accountViewInfo.getNumber();
            String strAcountName = accountViewInfo.getNumber() + " " + accountViewInfo.getName();
            iRowTemp.getCell(strAcctColKey).setValue((Object)strAcountName);
            iRowTemp.getCell(strAcctColKey).setUserObject((Object)accountViewInfo);
            iRowTemp.setUserObject((Object)strRowKey);
            for (int j = 1; j < size; ++j) {
                IRow iRowAdd = kdTable.addRow(rowIndex + j);
                AccountViewInfo accountViewInfoTemp = accountViewCollection.get(j);
                String strRowKeyAdd = strRowKey + "_" + accountViewInfoTemp.getNumber();
                iRowAdd.setUserObject((Object)strRowKeyAdd);
                String strNameTemp = accountViewInfoTemp.getNumber() + " " + accountViewInfoTemp.getName();
                iRowAdd.getCell(strAcctColKey).setValue((Object)strNameTemp);
                iRowAdd.getCell(strAcctColKey).setUserObject((Object)accountViewInfoTemp);
                int nAccontIndex = kdTable.getColumnIndex(strAcctColKey);
                for (int k = 0; k < nAccontIndex; ++k) {
                    iRowAdd.getCell(k).setValue(iRowTemp.getCell(k).getValue());
                    iRowAdd.getCell(k).setUserObject(iRowTemp.getCell(k).getUserObject());
                }
            }
        }
    }

    public void fillSubTotalRowBgEntrysByPeriod(KDTable kdTable, Vector vecSubIndex, Vector vecColumnIndex, BgFormInfo bgFormInfo, BgPeriodNode bgPeriodNode) {
        BgEntryCollection bgEntryCollection = this.getBgEntryCollectionByPeriod(bgFormInfo, bgPeriodNode);
        boolean isMulityCurrency = bgFormInfo.getBgTemplate().getRefCurrencies().size() > 1;
        Vector vecIndex = (Vector)vecSubIndex.get(0);
        if (vecIndex.size() != bgEntryCollection.size()) {
            return;
        }
        for (int i = 0; i < vecIndex.size(); ++i) {
            int index = (Integer)vecIndex.get(i);
            BgEntryInfo bgEntryInfo = bgEntryCollection.get(i);
            IRow iRow = kdTable.getRow(index);
            iRow.getCell(0).setUserObject((Object)bgEntryInfo);
            this.fillTotalBgEntry(kdTable, isMulityCurrency, bgEntryInfo, iRow, vecColumnIndex);
        }
    }

    public void fillTotalBgEntry(KDTable kdTable, boolean isMultiCurrency, BgEntryInfo bgEntryInfo, IRow row, Vector vecColumIndex) {
        Iterator bgDataIter = bgEntryInfo.getBgData().iterator();
        while (bgDataIter.hasNext()) {
            BgDataInfo bgDataInfo = (BgDataInfo)bgDataIter.next();
            String cellKey = null;
            cellKey = isMultiCurrency ? BgHelper.getBgElementKey(bgDataInfo.getBgElement(), bgDataInfo.getCurrency()) : BgHelper.getBgElementKey(bgDataInfo.getBgElement(), null);
            ICell cell = row.getCell(cellKey);
            int index = kdTable.getColumnIndex(cellKey);
            boolean isSumColumn = this.isSubRowSumColumn(index, vecColumIndex);
            if (!isSumColumn) {
                if (bgDataInfo.getBgValue() == null) {
                    bgDataInfo.setBgValue(new BigDecimal("0.00"));
                    cell.setValue((Object)bgDataInfo);
                } else {
                    cell.setValue((Object)bgDataInfo.getBgValue());
                    cell.getStyleAttributes().setNumberFormat("00.00");
                }
            }
            cell.setUserObject((Object)bgDataInfo);
        }
    }

    public boolean isSubRowSumColumn(int index, Vector vecColumnIndex) {
        boolean isSumColumn = false;
        for (int i = 0; i < vecColumnIndex.size(); ++i) {
            int colIndex = (Integer)vecColumnIndex.get(i);
            if (colIndex != index) continue;
            isSumColumn = true;
            break;
        }
        return isSumColumn;
    }

    public void setKDTableLockByPeriodNode(KDTable kdTable, BgPeriodNode bgPeriodNode) {
        if (bgPeriodNode == null) {
            return;
        }
        if (bgPeriodNode.isLeaf()) {
            kdTable.getStyleAttributes().setLocked(false);
        } else {
            kdTable.getStyleAttributes().setLocked(true);
        }
    }

    public void setCurrentRowColorByOrg(KDTable kdTable, FullOrgUnitInfo orgUnitInfo) {
        int rowCount = kdTable.getRowCount();
        String strColumnKey = BgAssistantDimensionEnum.SUB_ORGUNIT.getName();
        int colCountBeforeOrg = kdTable.getColumnIndex(strColumnKey);
        for (int i = 0; i < rowCount; ++i) {
            IRow iRow = kdTable.getRow(i);
            FullOrgUnitInfo org = (FullOrgUnitInfo)iRow.getCell(strColumnKey).getUserObject();
            if (!org.getId().equals((Object)orgUnitInfo.getId())) continue;
            iRow.getStyleAttributes().setBackground(new Color(0xF6F6B6));
            iRow.getStyleAttributes().setLocked(true);
        }
        for (int j = 0; j < colCountBeforeOrg; ++j) {
            IColumn iColumn = kdTable.getColumn(j);
            iColumn.getStyleAttributes().setBackground(BgClientHelper.KDTABLE_DIMENSION_BG_COLOR);
        }
    }

    public void setCurrRowFormulaByOrg(KDTable kdTable, FullOrgUnitInfo orgUnitInfo, BgTemplateInfo bgTemplateInfo, int countRow, Vector vecCellIndex) {
        if (vecCellIndex == null || vecCellIndex.size() == 0) {
            return;
        }
        int rowCount = kdTable.getRowCount();
        String strColumnKey = BgAssistantDimensionEnum.SUB_ORGUNIT.getName();
        for (int i = 0; i < rowCount; ++i) {
            IRow iRow = kdTable.getRow(i);
            FullOrgUnitInfo org = (FullOrgUnitInfo)iRow.getCell(strColumnKey).getUserObject();
            if (!org.getId().equals((Object)orgUnitInfo.getId())) continue;
            for (int j = 0; j < vecCellIndex.size(); ++j) {
                int columnIndex = (Integer)vecCellIndex.elementAt(j);
                String strFormula = this.getFormulaByRowIndex(i, countRow, columnIndex);
                iRow.getCell(columnIndex).setExpressions(strFormula);
            }
        }
    }

    public String getFormulaByRowIndex(int rowIndex, int countRow, int columnIndex) {
        StringBuffer strFormula = new StringBuffer("=");
        for (int j = countRow; j > 0; --j) {
            int nIndex = rowIndex - j;
            strFormula.append("cell(" + (nIndex + 1) + ", " + (columnIndex + 1) + ").getValue()");
            if (j == 1) continue;
            strFormula.append(" + ");
        }
        if (strFormula.toString().length() < 2) {
            return null;
        }
        return strFormula.toString();
    }

    public void lockedRowByOrg(KDTable kdTable, FullOrgUnitInfo orgUnitInfo, BgTemplateInfo bgTemplateInfo, boolean isEnable) {
        int rowCount = kdTable.getRowCount();
        int columnCount = bgTemplateInfo.getVisibleDims().size();
        int cols = kdTable.getColumnCount();
        String strColumnKey = BgAssistantDimensionEnum.SUB_ORGUNIT.getName();
        for (int i = 0; i < rowCount; ++i) {
            IRow iRow = kdTable.getRow(i);
            FullOrgUnitInfo org = (FullOrgUnitInfo)iRow.getCell(strColumnKey).getUserObject();
            if (!org.getId().equals((Object)orgUnitInfo.getId())) continue;
            for (int j = columnCount; j < cols; ++j) {
                iRow.getCell(j).getStyleAttributes().setLocked(isEnable);
            }
        }
    }

    public void setColumnLocked(KDTable kdTable, int[] columnIndexAarray, boolean isLock) {
        for (int i = 0; i < columnIndexAarray.length; ++i) {
            int columnIndex = columnIndexAarray[i];
            IColumn iColumn = kdTable.getColumn(columnIndex);
            iColumn.getStyleAttributes().setLocked(isLock);
        }
    }

    public void setColumnLocked(KDTable kdTable, BgTemplateInfo bgTemplateInfo, boolean isLock) {
        int columnCount = bgTemplateInfo.getVisibleDims().size();
        for (int i = 0; i <= columnCount; ++i) {
            IColumn iColumn = kdTable.getColumn(i);
            iColumn.getStyleAttributes().setLocked(isLock);
        }
    }

    public boolean isCurrBgFormDataEqualsubBgFormTotal(BgFormInfo bgFormInfo, BgFormCollection subBgFormCollection) {
        boolean equal = false;
        Vector periodNodeVector = BgPeriodRange.getPeriodNodes(bgFormInfo.getBgEntries());
        int n = 0;
        for (int k = 0; k < periodNodeVector.size(); ++k) {
            BgPeriodNode bgPeriodNode = (BgPeriodNode)periodNodeVector.elementAt(k);
            if (bgPeriodNode.getBgCycle().getValue() == 1 || bgPeriodNode.getBgCycle().getValue() == 2) continue;
            ++n;
            Iterator iterator = bgFormInfo.getBgEntries(bgPeriodNode.getPeriod(), bgPeriodNode.getBgCycle()).iterator();
            while (iterator.hasNext()) {
                BgEntryInfo bgEntryInfo = (BgEntryInfo)iterator.next();
                Vector<BgEntryCollection> vec = new Vector<BgEntryCollection>();
                for (int i = 0; i < subBgFormCollection.size(); ++i) {
                    BgFormInfo bgFormInfoTemp = subBgFormCollection.get(i);
                    vec.add(bgFormInfoTemp.getBgEntries(bgPeriodNode.getPeriod(), bgPeriodNode.getBgCycle()));
                }
                equal = this.isCurrBgEntryDataEqualSubBgEntryTotal(bgEntryInfo, vec);
                if (!equal) continue;
                break;
            }
            if (equal) break;
        }
        return equal;
    }

    private void SystemHashMap(HashMap map) {
        Iterator itor = map.keySet().iterator();
        while (itor.hasNext()) {
            System.out.print(itor.next() + ";");
        }
    }

    private void compareMap(HashMap map1, HashMap map2) {
        Iterator itor = map1.keySet().iterator();
        int count = 0;
        while (itor.hasNext()) {
            Object key = itor.next();
            if (map2.containsKey(key)) continue;
            ++count;
        }
    }

    public boolean isBalance(BgFormInfo bgFormInfo, BgFormCollection subBgFormCollection) {
        Integer entryKey2 = null;
        Integer dataKey2 = null;
        boolean balance = true;
        ArrayList<HashMap> lst = new ArrayList<HashMap>(8);
        HashMap map = bgFormInfo.reassembleBgForm();
        System.out.print(map.size());
        for (int i = 0; i < subBgFormCollection.size(); ++i) {
            BgFormInfo bgFormInfoTemp = subBgFormCollection.get(i);
            HashMap subMap = bgFormInfoTemp.reassembleBgForm();
            lst.add(subMap);
        }
        for (Integer entryKey2 : map.keySet()) {
            HashMap mapData = (HashMap)map.get(entryKey2);
            for (Integer dataKey2 : mapData.keySet()) {
                BgDataInfo fatherInfo = (BgDataInfo)mapData.get(dataKey2);
                if (!fatherInfo.getBgElement().isApportionable() || (balance = this.isEqual(entryKey2, dataKey2, fatherInfo, lst))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isEqual(Integer entryKey, Integer dataKey, BgDataInfo dataInfo, List lstSon) {
        HashMap mapEntry = null;
        HashMap mapData = null;
        BigDecimal sum = new BigDecimal("0");
        int size = lstSon.size();
        for (int i = 0; i < size; ++i) {
            mapEntry = (HashMap)lstSon.get(i);
            if (!mapEntry.containsKey(entryKey)) {
                return false;
            }
            mapData = (HashMap)mapEntry.get(entryKey);
            BgDataInfo info = (BgDataInfo)mapData.get(dataKey);
            sum = sum.add(info.getBgValue());
        }
        return dataInfo.getBgValue().compareTo(sum) == 0;
    }

    public boolean isCurrBgEntryDataEqualSubBgEntryTotal(BgEntryInfo bgEntryInfo, Vector vecSubEntryConncections) {
        boolean equal = false;
        Vector vecSubEntrys = this.filterBgEntrysByBgItemKey(bgEntryInfo.getBgItemsKey(), vecSubEntryConncections);
        Iterator iterator = bgEntryInfo.getBgData().iterator();
        while (iterator.hasNext()) {
            BgDataInfo bgDataInfo = (BgDataInfo)iterator.next();
            if (!bgDataInfo.getBgElement().isApportionable()) continue;
            BigDecimal bigSum = this.sumSubBgDataBgBalueByBgElement(bgDataInfo, vecSubEntrys);
            BigDecimal bigValue = new BigDecimal("0.00");
            if (bgDataInfo.getBgValue() != null) {
                bigValue = bgDataInfo.getBgValue().setScale(2, 4);
            }
            if (bigValue.compareTo(bigSum.setScale(2, 4)) == 0) continue;
            equal = true;
        }
        return equal;
    }

    private BigDecimal sumSubBgDataBgBalueByBgElement(BgDataInfo superBgDataInfo, Vector vecSubEntrys) {
        BigDecimal bigSum = new BigDecimal("0.00");
        for (int i = 0; i < vecSubEntrys.size(); ++i) {
            BgEntryInfo bgEntryInfo = (BgEntryInfo)vecSubEntrys.elementAt(i);
            Iterator iterator = bgEntryInfo.getBgData().iterator();
            while (iterator.hasNext()) {
                BgDataInfo bgDataInfoTemp = (BgDataInfo)iterator.next();
                if (bgDataInfoTemp.getBgValue() == null || !bgDataInfoTemp.getElementKey().equals(superBgDataInfo.getElementKey())) continue;
                bigSum = bigSum.add(bgDataInfoTemp.getBgValue());
            }
        }
        return bigSum;
    }

    public Vector filterBgEntrysByBgItemKey(String strItemKey, Vector vecSubEntrys) {
        Vector<BgEntryInfo> vec = new Vector<BgEntryInfo>();
        for (int i = 0; i < vecSubEntrys.size(); ++i) {
            BgEntryCollection bgEntryCollection = (BgEntryCollection)((Object)vecSubEntrys.elementAt(i));
            Iterator iterator = bgEntryCollection.iterator();
            while (iterator.hasNext()) {
                BgEntryInfo bgEntryInfo = (BgEntryInfo)iterator.next();
                if (!strItemKey.equals(bgEntryInfo.getBgItemsKey())) continue;
                vec.add(bgEntryInfo);
            }
        }
        return vec;
    }

    public void reCalculateSumCol(KDTable kdTable, FullOrgUnitInfo orgUnitInfo, BgTemplateInfo bgTemplateInfo, Vector vecCellIndex) {
        if (vecCellIndex == null || vecCellIndex.size() == 0) {
            return;
        }
        int rowCount = kdTable.getRowCount();
        String strColumnKey = BgAssistantDimensionEnum.SUB_ORGUNIT.getName();
        for (int i = 0; i < rowCount; ++i) {
            IRow iRow = kdTable.getRow(i);
            FullOrgUnitInfo org = (FullOrgUnitInfo)iRow.getCell(strColumnKey).getUserObject();
            if (!org.getId().equals((Object)orgUnitInfo.getId())) continue;
            for (int j = 0; j < vecCellIndex.size(); ++j) {
                int columnIndex = (Integer)vecCellIndex.elementAt(j);
                kdTable.getEditManager().editCellAt(i, columnIndex);
            }
        }
    }

    public void goLeaf(KDTree kdTree) {
        if (kdTree.getRowCount() > 0) {
            DefaultKingdeeTreeNode defaultKingdeeTreeNode = (DefaultKingdeeTreeNode)kdTree.getModel().getRoot();
            kdTree.setSelectionNode((DefaultKingdeeTreeNode)defaultKingdeeTreeNode.getFirstLeaf());
        }
    }

    public void setListProjectLocked(KDTable kdTable, BgItemCollection bgItemCollection, boolean isLock) {
        int rowCount = kdTable.getRowCount();
        int size = bgItemCollection.size();
        for (int k = 0; k < size; ++k) {
            BgItemInfo bgItemInfoTemp = bgItemCollection.get(k);
            String strColKey = bgItemInfoTemp.getBgDimension().getName();
            int colIndex = kdTable.getColumnIndex(strColKey);
            for (int i = 0; i < rowCount; ++i) {
                IRow iRow = kdTable.getRow(i);
                BgItemInfo bgItemInfo = (BgItemInfo)iRow.getCell(colIndex).getValue();
                if (bgItemInfo.isIsLeaf()) continue;
                iRow.getStyleAttributes().setLocked(isLock);
            }
        }
    }

    public Hashtable getListAndNotListProject(BgTemplateInfo bgTemplateInfo) {
        Hashtable<BgItemInfo, BgItemCollection> hashtable = new Hashtable<BgItemInfo, BgItemCollection>();
        BgItemCollection bgItemCollectionNotList = this.getNotListProjectByBgTemplate(bgTemplateInfo);
        int sizeItem = bgItemCollectionNotList.size();
        for (int i = 0; i < sizeItem; ++i) {
            BgItemInfo bgItemInfo = bgItemCollectionNotList.get(i);
            BgItemCollection bgItemCollectionList = bgTemplateInfo.getRefDim(bgItemInfo.getBgDimension()).getBgItems();
            int sizeList = bgItemCollectionList.size();
            BgItemCollection listBgItemCollection = null;
            listBgItemCollection = hashtable.containsKey(bgItemInfo) ? (BgItemCollection)((Object)hashtable.get(bgItemInfo)) : new BgItemCollection();
            for (int j = 0; j < sizeList; ++j) {
                BgItemInfo bgItemTemp = bgItemCollectionList.get(j);
                if (!this.isSon(bgItemTemp.getItemNumber(), bgItemInfo.getItemNumber())) continue;
                listBgItemCollection.add(bgItemTemp);
            }
            if (hashtable.containsKey(bgItemInfo) || listBgItemCollection.size() <= 0) continue;
            hashtable.put(bgItemInfo, listBgItemCollection);
        }
        this.printHash(hashtable);
        return hashtable;
    }

    private void printHash(Hashtable hash) {
        for (BgItemInfo key : hash.keySet()) {
            BgItemCollection list = (BgItemCollection)((Object)hash.get(key));
            for (int i = 0; i < list.size(); ++i) {
            }
        }
    }

    private boolean isSon(String sonNumber, String number) {
        if (sonNumber.length() <= number.length()) {
            return false;
        }
        if (!sonNumber.startsWith(number)) {
            return false;
        }
        String suffix = sonNumber.substring(number.length());
        int index = suffix.lastIndexOf(46);
        return index <= 0;
    }

    private void setMappingKeyToRow(KDTable kdTable) {
        IRow iRow = null;
        int rowCount = kdTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            iRow = kdTable.getRow(i);
            String strKey = (String)iRow.getUserObject();
            this.hashOfKDTable.put(strKey, new Integer(i));
        }
    }

    public void setNotListProjectSumValue(KDTable kdTable, Hashtable hashtable, BgTemplateInfo bgTemplateInfo, FullOrgUnitInfo subOrgUnitInfo, int colIndex) {
        Hashtable hash = new Hashtable(16);
        this.setMappingKeyToRow(kdTable);
        int rowCount = kdTable.getRowCount();
        Vector vecItemColl = this.getBgItemCollByDimension(hashtable, bgTemplateInfo);
        int sizeVec = vecItemColl.size();
        for (int i = 0; i < sizeVec; ++i) {
            BgItemCollection bgItemCollection = (BgItemCollection)((Object)vecItemColl.get(i));
            int sizeItem = bgItemCollection.size();
            for (int j = 0; j < sizeItem; ++j) {
                BgItemInfo bgItemInfo = bgItemCollection.get(j);
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    BgItemInfo bgItemInfoNotList = (BgItemInfo)enumeration.nextElement();
                    String strNotListKey = bgItemInfoNotList.getItemNumber() + "_" + bgItemInfo.getItemNumber() + "_" + subOrgUnitInfo.getNumber();
                    String itemNumber = bgItemInfoNotList.getItemNumber();
                    if (hash.containsKey(strNotListKey)) continue;
                    List lstSon = this.findSon(hashtable, itemNumber);
                    BigDecimal bigSum = new BigDecimal("0.00");
                    if (lstSon.size() > 0) {
                        boolean flag = false;
                        for (int k = 0; k < lstSon.size(); ++k) {
                            BgItemInfo item = (BgItemInfo)lstSon.get(k);
                            String strSonKey = item.getItemNumber() + "_" + bgItemInfo.getItemNumber() + "_" + subOrgUnitInfo.getNumber();
                            if (hash.containsKey(strSonKey)) {
                                flag = true;
                                break;
                            }
                            BigDecimal bigSon = this.sumSon(hash, hashtable, bgItemInfo, item, kdTable, subOrgUnitInfo, colIndex);
                            bigSum.add(bigSon);
                        }
                        if (flag) {
                            bigSum = this.sumSelf(hash, hashtable, bgItemInfo, bgItemInfoNotList, kdTable, subOrgUnitInfo, colIndex);
                        }
                    } else {
                        bigSum = this.sumSelf(hash, hashtable, bgItemInfo, bgItemInfoNotList, kdTable, subOrgUnitInfo, colIndex);
                    }
                    this.setSumOfKDtable(kdTable, strNotListKey, colIndex, bigSum);
                }
            }
        }
        this.hashOfKDTable.clear();
    }

    private BigDecimal sumSon(Hashtable hashSum, Hashtable hash, BgItemInfo bgItemInfo, BgItemInfo itemFather, KDTable kdTable, FullOrgUnitInfo subOrgUnitInfo, int colIndex) {
        List lstSon = this.findSon(hash, itemFather.getItemNumber());
        BigDecimal bigSum = new BigDecimal("0.00");
        if (lstSon.size() > 0) {
            for (int i = 0; i < lstSon.size(); ++i) {
                BgItemInfo item = (BgItemInfo)lstSon.get(i);
                BigDecimal bigSon = this.sumSon(hashSum, hash, bgItemInfo, item, kdTable, subOrgUnitInfo, colIndex);
                bigSum.add(bigSon);
            }
        } else {
            bigSum = this.sumSelf(hashSum, hash, bgItemInfo, itemFather, kdTable, subOrgUnitInfo, colIndex);
        }
        return bigSum;
    }

    private BigDecimal sumSelf(Hashtable hashSum, Hashtable hash, BgItemInfo bgItemInfo, BgItemInfo itemFather, KDTable kdTable, FullOrgUnitInfo subOrgUnitInfo, int colIndex) {
        BgItemCollection bgItemCollectionList = (BgItemCollection)((Object)hash.get(itemFather));
        BigDecimal bigSum = this.getSumByListProject(kdTable, subOrgUnitInfo, bgItemCollectionList, bgItemInfo, colIndex);
        String strKey = itemFather.getItemNumber() + "_" + bgItemInfo.getItemNumber() + "_" + subOrgUnitInfo.getNumber();
        hashSum.put(strKey, bigSum);
        return bigSum;
    }

    private void setSumOfKDtable(KDTable kdTable, String key, int colIndex, BigDecimal value) {
        int index = (Integer)this.hashOfKDTable.get(key);
        IRow row = kdTable.getRow(index);
        row.getCell(colIndex).setValue((Object)value);
        BgDistributeEditHelper bgDistEditHelper = new BgDistributeEditHelper();
        bgDistEditHelper.updateCell(kdTable, index, colIndex);
        kdTable.getEditManager().editCellAt(index, colIndex);
    }

    private BigDecimal getSumByListProject(KDTable kdTable, FullOrgUnitInfo subOrgUnitInfo, BgItemCollection bgItemCollectionList, BgItemInfo bgItemInfo, int colIndex) {
        BigDecimal bigSum = new BigDecimal("0.00");
        int size = bgItemCollectionList.size();
        for (int i = 0; i < size; ++i) {
            BigDecimal bigValue;
            BgItemInfo bgItemInfoTemp = bgItemCollectionList.get(i);
            String strRowKey = bgItemInfoTemp.getItemNumber() + "_" + bgItemInfo.getItemNumber() + "_" + subOrgUnitInfo.getNumber();
            int index = (Integer)this.hashOfKDTable.get(strRowKey);
            IRow iRow = kdTable.getRow(index);
            if (iRow == null) continue;
            Object obj = iRow.getCell(colIndex).getValue();
            if (obj instanceof String) {
                obj = new BigDecimal(obj.toString());
            }
            if ((bigValue = (BigDecimal)obj) == null) continue;
            bigSum = bigSum.add(bigValue);
        }
        return bigSum;
    }

    public Vector getBgItemCollByDimension(Hashtable hashtable, BgTemplateInfo bgTemplateInfo) {
        Vector<BgItemCollection> vec = new Vector<BgItemCollection>();
        ReferencedDimensionCollection referencedDimensionCollection = bgTemplateInfo.getVisibleDims();
        int sizeDem = referencedDimensionCollection.size();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            BgItemInfo bgItemInfoNotList = (BgItemInfo)enumeration.nextElement();
            for (int i = 0; i < sizeDem; ++i) {
                ReferencedDimensionInfo referencedDimensionInfo = referencedDimensionCollection.get(i);
                if (bgItemInfoNotList.getBgDimension().equals((Object)referencedDimensionInfo.getBgDimension())) continue;
                BgItemCollection bgItemCollectionTemp = bgTemplateInfo.getRefDim(referencedDimensionInfo.getBgDimension()).getBgItems();
                vec.add(bgItemCollectionTemp);
            }
        }
        return vec;
    }

    public BgItemCollection getNotListProjectByBgTemplate(BgTemplateInfo bgTemplateInfo) {
        BgItemCollection bgItemCollectionExist = new BgItemCollection();
        ReferencedDimensionCollection refCol = bgTemplateInfo.getVisibleDims();
        int size = refCol.size();
        for (int i = 0; i < size; ++i) {
            ReferencedDimensionInfo refInfo = refCol.get(i);
            BgItemCollection bgItemCollection = bgTemplateInfo.getRefDim(refInfo.getBgDimension()).getBgItems();
            for (int j = 0; j < bgItemCollection.size(); ++j) {
                BgItemInfo bgItemInfo = bgItemCollection.get(j);
                if (bgItemInfo.isIsLeaf()) continue;
                if (this.colOfComplex == -1) {
                    this.colOfComplex = i;
                }
                bgItemCollectionExist.add(bgItemInfo);
            }
        }
        return bgItemCollectionExist;
    }

    public HashMap getPartRecordByBgDataInfo(IRow iRow, BgDataInfo bgDataInfo) {
        BgEntryInfo bgEntryInfo = (BgEntryInfo)iRow.getCell(0).getUserObject();
        BgFormInfo bgFormInfo = bgEntryInfo.getBgForm();
        if (bgFormInfo == null) {
            return null;
        }
        HashMap treeMap = bgFormInfo.getAllPastDataByBgData(bgDataInfo);
        return treeMap;
    }

    public void setHeadSumValue(KDTable kdTable, String orgNumber, Hashtable hashHead, int colIndex) {
        Hashtable hash = new Hashtable(16);
        this.setMappingKeyToRow(kdTable);
        Hashtable hashSumRow = this.findSumRow(hashHead, orgNumber);
        String fatherNumber2 = null;
        for (String fatherNumber2 : hashHead.keySet()) {
            if (hash.containsKey(fatherNumber2)) continue;
            this.sumSonOfHead(hashSumRow, hashHead, hash, fatherNumber2, kdTable, colIndex);
        }
        this.hashOfKDTable.clear();
    }

    private void sumSonOfHead(Hashtable hashSumRow, Hashtable hashHead, Hashtable hash, String fatherNumber, KDTable kdTable, int colIndex) {
        List lstSon = (List)hashHead.get(fatherNumber);
        for (int i = 0; i < lstSon.size(); ++i) {
            String sonNumber = (String)lstSon.get(i);
            if (!hashHead.containsKey(sonNumber) || hash.containsKey(sonNumber)) continue;
            this.sumSonOfHead(hashSumRow, hashHead, hash, sonNumber, kdTable, colIndex);
        }
        this.sumAllRowOfHead(hashSumRow, fatherNumber, kdTable, colIndex);
        hash.put(fatherNumber, fatherNumber);
    }

    private void sumAllRowOfHead(Hashtable hashSumRow, String fatherNumber, KDTable kdTable, int colIndex) {
        String fatherKey = null;
        BigDecimal bigSum = null;
        List lst = this.findSumRowByHead(hashSumRow, fatherNumber);
        for (int i = 0; i < lst.size(); ++i) {
            fatherKey = (String)lst.get(i);
            bigSum = this.sumHeadSelf(hashSumRow, fatherKey, kdTable, colIndex);
            this.setSumOfKDtable(kdTable, fatherKey, colIndex, bigSum);
        }
    }

    private BigDecimal sumHeadSelf(Hashtable hashSumRow, String fatherKey, KDTable kdTable, int col) {
        BigDecimal bigSum = new BigDecimal("0.00");
        List lstSon = (List)hashSumRow.get(fatherKey);
        for (int i = 0; i < lstSon.size(); ++i) {
            int row = (Integer)lstSon.get(i);
            BigDecimal bigValue = this.getValue(kdTable, row, col);
            bigSum = bigSum.add(bigValue);
        }
        return bigSum;
    }

    private BigDecimal getValue(KDTable kdTable, int row, int col) {
        BigDecimal value = new BigDecimal("0.00");
        IRow iRow = kdTable.getRow(row);
        if (iRow == null) {
            return value;
        }
        Object obj = iRow.getCell(col).getValue();
        if (obj instanceof String) {
            obj = new BigDecimal(obj.toString());
        }
        value = (BigDecimal)obj;
        return value;
    }

    private List findSumRowByHead(Hashtable hashSumRow, String fahterNumber) {
        ArrayList<String> lst = new ArrayList<String>(8);
        String substr = fahterNumber + "_";
        String key2 = null;
        for (String key2 : hashSumRow.keySet()) {
            if (key2.indexOf(substr) == -1) continue;
            lst.add(key2);
        }
        return lst;
    }

    private Hashtable findSumRow(Hashtable hash, String orgNumber) {
        Hashtable<String, List> hashSumRow = new Hashtable<String, List>(50);
        Enumeration enumeration = hash.keys();
        String headNumber = null;
        while (enumeration.hasMoreElements()) {
            headNumber = (String)enumeration.nextElement();
            List sonItem = (List)hash.get(headNumber);
            for (String key : this.hashOfKDTable.keySet()) {
                List lst = this.findSonRow(key, headNumber, sonItem, orgNumber);
                if (lst.size() == 0) continue;
                hashSumRow.put(key, lst);
            }
        }
        return hashSumRow;
    }

    private List findSonRow(String fatherKey, String fatherNumber, List sonItem, String orgNumber) {
        ArrayList lst = new ArrayList(6);
        for (int i = 0; i < sonItem.size(); ++i) {
            String sonKey;
            if (fatherKey.endsWith(orgNumber) || fatherKey.indexOf(fatherNumber + "_") == -1 || !this.hashOfKDTable.containsKey(sonKey = fatherKey.replaceFirst(fatherNumber, (String)sonItem.get(i)))) continue;
            lst.add(this.hashOfKDTable.get(sonKey));
        }
        return lst;
    }

    private List findSon(Hashtable hash, String father) {
        ArrayList<String> lst = new ArrayList<String>(16);
        for (String itemNumber : hash.keySet()) {
            if (!this.isSon(itemNumber, father)) continue;
            lst.add(itemNumber);
        }
        return lst;
    }

    public void setTableValue(KDTable kdt, int col, Hashtable hash) {
        BgDistributeEditHelper bgDistEditHelper = new BgDistributeEditHelper();
        int size = kdt.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow iRowTemp = kdt.getRow(i);
            String key = (String)iRowTemp.getUserObject();
            if (!hash.containsKey(key)) continue;
            iRowTemp.getCell(col).setValue((Object)((BigDecimal)hash.get(key)));
            bgDistEditHelper.updateCell(kdt, i, col);
            kdt.getEditManager().editCellAt(i, col);
        }
    }

    private String getComplexColNumber(String keyOfTable) {
        StringTokenizer token = new StringTokenizer(keyOfTable, "_");
        String number = null;
        int index = 0;
        while (token.hasMoreTokens()) {
            number = token.nextToken();
            if (index++ != this.colOfComplex) continue;
            break;
        }
        return number;
    }

    public Hashtable getHead(BgTemplateInfo bgTemplateInfo) {
        Hashtable<String, List<String>> hashtable = new Hashtable<String, List<String>>();
        BgItemCollection bgItemCollectionNotList = this.getNotListProjectByBgTemplate(bgTemplateInfo);
        int sizeItem = bgItemCollectionNotList.size();
        for (int i = 0; i < sizeItem; ++i) {
            BgItemInfo bgItemInfo = bgItemCollectionNotList.get(i);
            BgItemCollection bgItemCollectionList = bgTemplateInfo.getRefDim(bgItemInfo.getBgDimension()).getBgItems();
            int sizeList = bgItemCollectionList.size();
            List lstItem = null;
            String itemNumber = bgItemInfo.getItemNumber();
            lstItem = hashtable.containsKey(itemNumber) ? (List)hashtable.get(itemNumber) : new ArrayList();
            for (int j = 0; j < sizeList; ++j) {
                BgItemInfo bgItemTemp = bgItemCollectionList.get(j);
                if (!this.isSon(bgItemTemp.getItemNumber(), itemNumber)) continue;
                lstItem.add(bgItemTemp.getItemNumber());
            }
            if (hashtable.containsKey(itemNumber) || lstItem.size() <= 0) continue;
            hashtable.put(itemNumber, lstItem);
        }
        return hashtable;
    }

    public static boolean checkChildrenVlaid(BOSUuid parentTpId, BgFormCollection bfc) {
        boolean result = true;
        Iterator iter = bfc.iterator();
        while (iter.hasNext()) {
            BgFormInfo bfi = (BgFormInfo)iter.next();
            BgTemplateInfo bti = bfi.getBgTemplate();
            if (bti.getId().equals((Object)parentTpId)) continue;
            if (bti.getParent() == null) {
                result = false;
                break;
            }
            BOSUuid subTpId = bti.getParent().getId();
            if (subTpId.equals((Object)parentTpId)) continue;
            result = false;
            break;
        }
        return result;
    }

    public static boolean checkBgCycleSame(BgTemplateInfo bgTemplateInfoTotal, BgFormCollection bfc) {
        BgCycleTypeEnum bgCycle = bgTemplateInfoTotal.getBgCycle();
        Iterator iter = bfc.iterator();
        while (iter.hasNext()) {
            BgFormInfo bfi = (BgFormInfo)iter.next();
            BgTemplateInfo bti = bfi.getBgTemplate();
            if (bti.getBgCycle().equals((Object)bgCycle)) continue;
            return false;
        }
        return true;
    }
}

