/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.ma.bg.BgAssistantDimensionEnum;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgFormCollection;
import com.kingdee.eas.ma.bg.BgFormDAFactory;
import com.kingdee.eas.ma.bg.BgFormDataSourceEnum;
import com.kingdee.eas.ma.bg.BgFormFactory;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgFormStateEnum;
import com.kingdee.eas.ma.bg.BgFormStateHelper;
import com.kingdee.eas.ma.bg.BgItemCollection;
import com.kingdee.eas.ma.bg.BgKDSFactory;
import com.kingdee.eas.ma.bg.BgOperationEnum;
import com.kingdee.eas.ma.bg.BgOrgHelper;
import com.kingdee.eas.ma.bg.BgPastDataCollection;
import com.kingdee.eas.ma.bg.BgPastRecordInfo;
import com.kingdee.eas.ma.bg.BgPeriodNode;
import com.kingdee.eas.ma.bg.BgSchemeInfo;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.IBgForm;
import com.kingdee.eas.ma.bg.IBgFormDA;
import com.kingdee.eas.ma.bg.IBgKDS;
import com.kingdee.eas.ma.bg.client.AbstractBgDeclareEditUI;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.ma.bg.client.BgDeclareClientHelper;
import com.kingdee.eas.ma.bg.client.BgDistributeEditHelper;
import com.kingdee.eas.ma.bg.client.BgFormEditHelper;
import com.kingdee.eas.ma.bg.client.BgPastRecordEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.TreeSelectionEvent;

public class BgDeclareEditUI
extends AbstractBgDeclareEditUI {
    private BgTemplateInfo bgTemplateInfoTotal = null;
    private FullOrgUnitInfo orgUnitInfoTotal = null;
    private BgFormCollection bgFormCollectionAll = new BgFormCollection();
    private FullOrgUnitCollection orgUnitCollectionAll = new FullOrgUnitCollection();
    private BgFormInfo bgFormInfoTotal = null;
    private BgSchemeInfo bgSchemeInfo = null;
    private Vector vecCellIndex = null;
    private boolean isExist = false;

    protected IObjectValue createNewData() {
        return new BgFormInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    protected void initDataByIntroduction() throws EASBizException, BOSException, SQLException {
        this.initBgFormInfo();
        if (!BgDeclareClientHelper.checkChildrenVlaid(this.bgTemplateInfoTotal.getId(), this.bgFormCollectionAll)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgDistributeResource", (String)"templateNotMatch"));
            SysUtil.abort();
        }
        this.kDBizPromptBoxCurrency.setEnabledMultiSelection(true);
        BgFormEditHelper.bandCurrencyInfo(this.kDBizPromptBoxCurrency, this.bgTemplateInfoTotal);
        this.initKDTable(this.kdtBgFormData, this.bgTemplateInfoTotal);
    }

    protected IObjectPK getOrgPK() {
        FullOrgUnitInfo inOrgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("permi_org");
        if (inOrgUnitInfo.isIsCompanyOrgUnit()) {
            ObjectUuidPK orgPk = new ObjectUuidPK(inOrgUnitInfo.getId());
            return orgPk;
        }
        return super.getOrgPK();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId());
    }

    private void initBgFormInfo() throws EASBizException, BOSException, SQLException {
        String id = this.getUIContext().get("ID").toString();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        FullOrgUnitCollection inOrgs = (FullOrgUnitCollection)this.getUIContext().get("EditOrg");
        IBgFormDA iBgFormDa = BgFormDAFactory.getRemoteInstance();
        this.bgFormCollectionAll = iBgFormDa.getCollectionForDeclare((IObjectPK)pk, inOrgs, false);
        if (this.bgFormCollectionAll.size() != inOrgs.size() + 1) {
            int sizeBgForm = this.bgFormCollectionAll.size();
            int sizeOrg = inOrgs.size();
            for (int i = 0; i < sizeOrg; ++i) {
                FullOrgUnitInfo orgTemp = inOrgs.get(i);
                boolean isHas = false;
                for (int j = 0; j < sizeBgForm; ++j) {
                    BgFormInfo bgFormTemp = this.bgFormCollectionAll.get(j);
                    if (!orgTemp.getId().equals((Object)bgFormTemp.getOrgUnit().getId())) continue;
                    isHas = true;
                    break;
                }
                if (isHas) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseAddNewBgForm"));
                SysUtil.abort();
            }
        }
        Iterator iter = this.bgFormCollectionAll.iterator();
        while (iter.hasNext()) {
            BgFormInfo tmpBgFormInfo = (BgFormInfo)iter.next();
            if (tmpBgFormInfo.getId() == null) {
                this.orgUnitCollectionAll.add(tmpBgFormInfo.getOrgUnit());
                continue;
            }
            if (tmpBgFormInfo.getId().toString().equals(id)) {
                this.bgFormInfoTotal = tmpBgFormInfo;
                this.editData = tmpBgFormInfo;
                this.bgSchemeInfo = tmpBgFormInfo.getBgScheme();
                this.bgTemplateInfoTotal = tmpBgFormInfo.getBgTemplate();
                this.orgUnitInfoTotal = tmpBgFormInfo.getOrgUnit();
                continue;
            }
            this.orgUnitCollectionAll.add(tmpBgFormInfo.getOrgUnit());
            if (tmpBgFormInfo.getBgTemplate().getBgCycle().getValue() >= this.bgTemplateInfoTotal.getBgCycle().getValue()) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"bgCycleNotRight"));
            SysUtil.abort();
        }
        this.orgUnitCollectionAll.add(this.bgFormInfoTotal.getOrgUnit());
    }

    public void initKDTable(KDTable kdtable, BgTemplateInfo bgTemplateInfo) {
        BgDeclareClientHelper bgDeclareClientHelper = new BgDeclareClientHelper();
        BgClientHelper.initBgFormTable(bgTemplateInfo, kdtable);
        if (this.orgUnitCollectionAll == null || this.orgUnitCollectionAll.size() == 0) {
            return;
        }
        bgDeclareClientHelper.insertOrgDim(kdtable, this.orgUnitCollectionAll, bgTemplateInfo, true);
        bgDeclareClientHelper.setCurrentRowColorByOrg(kdtable, this.orgUnitInfoTotal);
        this.vecCellIndex = BgFormEditHelper.getSumableColumn(bgTemplateInfo, kdtable);
        System.out.println("id:" + bgTemplateInfo.getId());
        bgDeclareClientHelper.setCurrRowFormulaByOrg(kdtable, this.orgUnitInfoTotal, bgTemplateInfo, this.bgFormCollectionAll.size() - 1, this.vecCellIndex);
        kdtable.getMergeManager().setMergeMode(3);
    }

    public void onLoad() throws Exception {
        this.kdtBgFormData.checkParsed();
        this.kdtBgFormData.setFormulaMode(1);
        this.kdtBgFormData.getStyleAttributes().setNumberFormat("00.00");
        this.initDataByIntroduction();
        this.kDTextFieldBgType.setText(this.bgFormInfoTotal.getBgType().getName());
        this.kDTextFieldBgScheme.setText(this.bgSchemeInfo.getName());
        BgFormEditHelper.initPeriodTree(this.treeBgPeriod, this.bgFormInfoTotal);
        BgDeclareClientHelper bgDeclareClientHelper = new BgDeclareClientHelper();
        this.kDWorkButtonViewPastRecord.setVisible(false);
        this.setIcon();
        this.refreshTree();
        bgDeclareClientHelper.goLeaf(this.treeBgPeriod);
        bgDeclareClientHelper.lockedRowByOrg(this.kdtBgFormData, this.orgUnitInfoTotal, this.bgTemplateInfoTotal, true);
        bgDeclareClientHelper.setColumnLocked(this.kdtBgFormData, this.bgTemplateInfoTotal, true);
    }

    public IIDList getIDListForAll() {
        IIDList result = super.getIDListForAll();
        if (result == null) {
            result = new RealModeIDList();
        }
        return result;
    }

    public void setIcon() {
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    @Override
    public void storeFields() {
        this.storeBgDeclareInfo();
    }

    private void sumDistributeData() {
        if (!this.isExist) {
            return;
        }
        BgDeclareClientHelper bgDecClientHelper = new BgDeclareClientHelper();
        BgDistributeEditHelper bgDistEditHelper = new BgDistributeEditHelper();
        Hashtable hashHead = bgDecClientHelper.getHead(this.bgTemplateInfoTotal);
        int sizeSum = this.vecCellIndex.size();
        for (int j = 0; j < sizeSum; ++j) {
            int colIndex = (Integer)this.vecCellIndex.get(j);
            bgDecClientHelper.setHeadSumValue(this.kdtBgFormData, this.orgUnitInfoTotal.getNumber(), hashHead, colIndex);
        }
    }

    public Vector getSumCol(KDTable kDTable) {
        Vector<Integer> vec = new Vector<Integer>();
        int colCount = kDTable.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            String strKey = kDTable.getColumnKey(i);
            if (!strKey.equalsIgnoreCase("BudgetAmount")) continue;
            vec.add(new Integer(i));
        }
        return vec;
    }

    public void saveNewBgDeclareInfo() {
        try {
            IBgForm iBgForm = BgFormFactory.getRemoteInstance();
            IBgFormDA iBgFormDa = BgFormDAFactory.getRemoteInstance();
            int size = this.bgFormCollectionAll.size();
            BgFormCollection bgFormCollectionSub = new BgFormCollection();
            boolean isEqual = false;
            for (int i = 0; i < size; ++i) {
                BgFormInfo bgFormTemp = this.bgFormCollectionAll.get(i);
                if (bgFormTemp.getId() != null && bgFormTemp.getId().equals((Object)this.bgFormInfoTotal.getId())) continue;
                BgDistributeEditHelper bgDistEditHelper = new BgDistributeEditHelper();
                bgDistEditHelper.splitNotListProjectToList(bgFormTemp);
                BgFormInfo oriBgFormInfo = iBgFormDa.getFormForEdit((IObjectPK)new ObjectUuidPK(bgFormTemp.getId()));
                BgPastDataCollection bgPastDataCollection = BgPastRecordInfo.compareBgFormInfo(bgFormTemp, oriBgFormInfo);
                if (bgPastDataCollection.size() <= 0) continue;
                isEqual = true;
            }
            boolean n = true;
            Hashtable<String, BgOperationEnum> hash = new Hashtable<String, BgOperationEnum>();
            for (int i = 0; i < this.bgFormCollectionAll.size(); ++i) {
                BgFormInfo bgForm = this.bgFormCollectionAll.get(i);
                String strMsg = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"IsGather");
                if (bgForm.getId() != null && bgForm.getId().equals((Object)this.bgFormInfoTotal.getId())) {
                    this.checkState(bgForm, true, strMsg);
                    continue;
                }
                this.checkState(bgForm, false, strMsg);
            }
            BgFormCollection bgFormCollection = new BgFormCollection();
            this.bgFormInfoTotal.setDataSource(BgFormDataSourceEnum.SUBORDINATEDECLARE);
            this.bgFormInfoTotal.setState(BgFormStateEnum.Edited);
            bgFormCollection.add(this.bgFormInfoTotal);
            hash.put(this.bgFormInfoTotal.getOrgUnit().getId().toString(), BgOperationEnum.Gather);
            CtrlUnitInfo cuInfo = BgOrgHelper.getDefCU();
            for (int i = 0; i < bgFormCollectionSub.size(); ++i) {
                bgFormCollectionSub.get(i).setCU(cuInfo);
            }
            iBgForm.updateWithRecord_declare(bgFormCollection, hash);
            IBgKDS iBgKDS = BgKDSFactory.getRemoteInstance();
            iBgKDS.updateBgForm(this.bgFormInfoTotal.getId());
            iBgFormDa.updateBgFormStatus((IObjectPK)new ObjectUuidPK(this.bgFormInfoTotal.getId()), BgFormStateEnum.Edited);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
    }

    @Override
    protected void onTreeBgPeriod_valueChanged(TreeSelectionEvent e) throws Exception {
        if (!this.treeBgPeriod.isEnabled()) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
        if (node == null) {
            return;
        }
        if (node.getUserObject() == null) {
            return;
        }
        BgPeriodNode bgPeriodNode = (BgPeriodNode)node.getUserObject();
        this.refreshPeriod(bgPeriodNode);
    }

    private void refreshTree() {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeBgPeriod.getModel().getRoot();
        DefaultKingdeeTreeNode node = null;
        BgPeriodNode bgNode = null;
        Enumeration enums = root.breadthFirstEnumeration();
        while (enums.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)enums.nextElement();
            bgNode = (BgPeriodNode)node.getUserObject();
            if (bgNode == null) continue;
            this.refreshPeriod(bgNode);
        }
        this.treeBgPeriod.setSelectionRow(0);
        BgDeclareClientHelper.goFirstChild(this.treeBgPeriod);
    }

    private void refreshPeriod(BgPeriodNode bgPeriodNode) {
        this.storeBgDeclareInfo();
        BgDeclareClientHelper bgDeclareClientHelper = new BgDeclareClientHelper();
        bgDeclareClientHelper.fillBgEntrysByPeriod(this.bgFormInfoTotal.getId().toString(), this.kdtBgFormData, this.orgUnitCollectionAll, this.bgFormCollectionAll, bgPeriodNode);
        this.kdtBgFormData.getScriptManager().setAutoRun(true);
        this.kdtBgFormData.getScriptManager().runAll();
        bgDeclareClientHelper.setKDTableLockByPeriodNode(this.kdtBgFormData, bgPeriodNode);
        BgItemCollection bgItemColl = bgDeclareClientHelper.getNotListProjectByBgTemplate(this.bgTemplateInfoTotal);
        if (bgItemColl.size() > 0) {
            this.isExist = true;
            bgDeclareClientHelper.setListProjectLocked(this.kdtBgFormData, bgItemColl, true);
        }
        this.sumDistributeData();
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    public void storeBgDeclareInfo() {
        int nRowCount = this.kdtBgFormData.getRowCount();
        int nColumnCount = this.kdtBgFormData.getColumnCount();
        String strSubAcctColumn = BgAssistantDimensionEnum.SUB_ACCOUNT.getName();
        int index = this.kdtBgFormData.getColumnIndex(strSubAcctColumn);
        if (index <= 0) {
            String strOrgColumn = BgAssistantDimensionEnum.SUB_ORGUNIT.getName();
            index = this.kdtBgFormData.getColumnIndex(strOrgColumn);
        }
        ++index;
        for (int i = 0; i < nRowCount; ++i) {
            IRow iRow = this.kdtBgFormData.getRow(i);
            for (int j = index; j < nColumnCount; ++j) {
                String str;
                int indexStr;
                Object obj1;
                ICell iCell = iRow.getCell(j);
                Object obj = iCell.getUserObject();
                if (!(obj instanceof BgDataInfo) || (obj1 = iCell.getValue()) == null || (indexStr = (str = obj1.toString()).indexOf("cell")) > 0) continue;
                BigDecimal bigValue = new BigDecimal(obj1.toString());
                BgDataInfo bgDataInfo = (BgDataInfo)obj;
                bgDataInfo.setBgValue(bigValue);
            }
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) {
        this.doSave();
    }

    public void doSave() {
        SimpleTimer st = new SimpleTimer();
        this.storeFields();
        this.storeBgDeclareInfo();
        this.saveNewBgDeclareInfo();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        this.getUIWindow().close();
    }

    private void pastRecordShow() {
        BgDataInfo bgDataInfo;
        BgDeclareClientHelper bgDeclareClientHelper;
        HashMap treeMap;
        int nRowIndex = this.kdtBgFormData.getSelectManager().getActiveRowIndex();
        int nColumnIndex = this.kdtBgFormData.getSelectManager().getActiveColumnIndex();
        IRow iRow = this.kdtBgFormData.getRow(nRowIndex);
        ICell iCell = iRow.getCell(nColumnIndex);
        Object obj = iCell.getUserObject();
        if (obj instanceof BgDataInfo && (treeMap = (bgDeclareClientHelper = new BgDeclareClientHelper()).getPartRecordByBgDataInfo(iRow, bgDataInfo = (BgDataInfo)obj)) != null && treeMap.size() > 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", null);
            uiContext.put((Object)"bgPastRecord", (Object)treeMap);
            String strClassName = BgPastRecordEditUI.class.getName();
            try {
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(strClassName, (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
            }
            catch (UIException e) {
                this.handUIException(e);
            }
        }
    }

    @Override
    protected void onKDWorkButtonView_actionPerformed(ActionEvent e) throws Exception {
        this.pastRecordShow();
    }

    @Override
    protected void onKdtBgFormData_editStopped(KDTEditEvent e) throws Exception {
        int editedRowIndex = e.getRowIndex();
        int editedColIndex = e.getColIndex();
        Object obj = this.kdtBgFormData.getRow(editedRowIndex).getCell(editedColIndex).getValue();
        if (obj == null) {
            obj = "";
        }
        String value = null;
        if (obj instanceof BigDecimal) {
            value = ((BigDecimal)obj).toString();
        } else if (obj instanceof String) {
            value = obj.toString();
        }
        if (value == null || value.equals("")) {
            value = "0";
        }
        if (!BgClientHelper.verifyIsNumber(value)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"inputNumber"));
            this.kdtBgFormData.getEditManager().editCellAt(editedRowIndex, editedColIndex);
            return;
        }
        DecimalFormat format = BgClientHelper.getDecimalFormat();
        value = format.format(new BigDecimal(value));
        this.kdtBgFormData.getRow(editedRowIndex).getCell(editedColIndex).setValue((Object)value);
        this.sumDistributeData();
        BgDistributeEditHelper bgDistEditHelper = new BgDistributeEditHelper();
        bgDistEditHelper.updateCell(this.kdtBgFormData, editedRowIndex, editedColIndex);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.doSave();
    }

    protected void checkState(BgFormInfo bgForm, boolean isCurr, String strMsg) {
        BgFormStateHelper bsh = new BgFormStateHelper();
        int state = bgForm.getState().getValue();
        if (bgForm.getId() == null) {
            state = -1;
        }
        boolean isOk = false;
        boolean isProm = false;
        try {
            if (isCurr) {
                isOk = bsh.isGatherCurrForm(state);
                isProm = bsh.isGatherCurrProm(state);
            } else {
                isOk = bsh.isGatherSubForm(state);
                isProm = bsh.isGatherSubProm(state);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        if (!isOk) {
            String str = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"CurrBgForm");
            String strResState = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"State");
            String strSub = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"SubBgForm");
            String strState = bgForm.getNumber() + ":" + bgForm.getState().getAlias();
            if (isProm) {
                int confirm = -1;
                confirm = isCurr ? MsgBox.showConfirm2((Component)((Object)this), (String)(str + strState + strResState + strMsg)) : MsgBox.showConfirm2((Component)((Object)this), (String)(strSub + strState + strResState + strMsg));
                if (confirm == 2) {
                    SysUtil.abort();
                }
            } else {
                String str1 = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"NotGather");
                if (isCurr) {
                    MsgBox.showInfo((Component)((Object)this), (String)(str + strState + strResState + str1));
                } else {
                    MsgBox.showInfo((Component)((Object)this), (String)(strSub + strState + strResState + str1));
                }
                SysUtil.abort();
            }
        }
    }
}

