/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgType;
import com.kingdee.eas.ma.bg.ReferencedDimensionInfo;
import com.kingdee.eas.ma.bg.client.BgOrgUnitF7SelectorHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;

public class BgDimensionF7SelectorForRpt
extends KDDialog
implements KDPromptSelector {
    protected boolean isOK = false;
    KDButton btnOk = null;
    KDButton btnCancel = null;
    FormulaWizardUI formulaWizardUI = null;
    private KDTable kdtable = this.initKDtable();
    private final String NAME = "name";
    private final String ALIAS = "alias";

    public BgDimensionF7SelectorForRpt() throws HeadlessException {
        this.kdtable.getStyleAttributes().setLocked(true);
        this.kdtable.setBounds(10, 20, 380, 200);
        this.kdtable.setVisible(true);
        KDPanel jp = new KDPanel();
        jp.setLayout(null);
        jp.add((Component)this.kdtable);
        String strConfirm = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"confirm");
        this.btnOk = new KDButton("OK");
        this.btnOk.setText(strConfirm);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgDimensionF7SelectorForRpt.this.close(true);
            }
        });
        this.btnOk.setEnabled(true);
        this.btnOk.setBounds(100, 230, 80, 26);
        jp.add((Component)this.btnOk);
        String strCancel = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"cancel");
        this.btnCancel = new KDButton("CANCEL");
        this.btnCancel.setText(strCancel);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgDimensionF7SelectorForRpt.this.close(false);
            }
        });
        this.btnCancel.setBounds(200, 230, 80, 26);
        this.btnCancel.setEnabled(true);
        jp.add((Component)this.btnCancel);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)jp, "Center");
        this.setSize(400, 300);
    }

    public boolean isCanceled() {
        return !this.isOK;
    }

    public Object getData() {
        int currRow = this.kdtable.getSelectManager().getActiveRowIndex();
        if (currRow != -1) {
            IRow iRow = this.kdtable.getRow(currRow);
            int value = ((BgDimensionEnum)((Object)iRow.getUserObject())).getValue();
            return new Integer(value);
        }
        return null;
    }

    public static void main(String[] args) {
        BgDimensionF7SelectorForRpt bgElementF7Selector = new BgDimensionF7SelectorForRpt();
        bgElementF7Selector.show();
    }

    public void show() {
        this.setModal(true);
        if (this.getFormulaWizardUI() != null) {
            String strBgTypeNumber = this.getFormulaWizardUI().getParam("bgType");
            String strOrgNumber = this.getFormulaWizardUI().getParam("orgUnit");
            this.putDataToKDTable(strBgTypeNumber, strOrgNumber);
        }
        super.show();
    }

    private void close(boolean isOk) {
        this.isOK = isOk;
        this.setVisible(false);
    }

    public KDTable initKDtable() {
        if (this.kdtable == null) {
            this.kdtable = new KDTable();
        }
        this.kdtable.checkParsed();
        IColumn iColumn = this.kdtable.addColumn();
        iColumn.setKey("name");
        IColumn iColumn1 = this.kdtable.addColumn();
        iColumn1.setKey("alias");
        IRow iRow = this.kdtable.addHeadRow();
        String strNumber = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"number");
        String strName = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"name");
        iRow.getCell("name").setValue((Object)strNumber);
        iRow.getCell("alias").setValue((Object)strName);
        this.kdtable.getSelectManager().setSelectMode(2);
        return this.kdtable;
    }

    public void putDataToKDTable(String strBgTypeNumber, String strOrgNumber) {
        block6: {
            try {
                if (strBgTypeNumber == null || strBgTypeNumber.length() == 0) {
                    String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectBgType");
                    MsgBox.showWarning((Component)((Object)this), (String)strErr);
                    return;
                }
                IBgType iBgType = BgTypeFactory.getRemoteInstance();
                BgTypeInfo bgTypeInfo = iBgType.getValueByNumber(strBgTypeNumber);
                if (bgTypeInfo != null) {
                    BgTemplateInfo bgTemplateInfo = BgOrgUnitF7SelectorHelper.findBgTemplateInfoOfPath(bgTypeInfo, strOrgNumber);
                    if (bgTemplateInfo == null) {
                        return;
                    }
                    Iterator iterator = bgTemplateInfo.getRefDimensions().iterator();
                    this.kdtable.removeRows();
                    while (iterator.hasNext()) {
                        ReferencedDimensionInfo referencedDimensionInfo = (ReferencedDimensionInfo)iterator.next();
                        BgDimensionEnum bgDimensionEnum = referencedDimensionInfo.getBgDimension();
                        IRow iRow = this.kdtable.addRow();
                        iRow.setUserObject((Object)bgDimensionEnum);
                        iRow.getCell("name").setValue((Object)bgDimensionEnum.getName());
                        iRow.getCell("alias").setValue((Object)bgDimensionEnum.getAlias());
                    }
                    break block6;
                }
                String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectBgType");
                MsgBox.showWarning((Component)((Object)this), (String)strErr);
                return;
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    public FormulaWizardUI getFormulaWizardUI() {
        return this.formulaWizardUI;
    }

    public void setFormulaWizardUI(FormulaWizardUI wizardUI) {
        this.formulaWizardUI = wizardUI;
    }
}

