/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgAssistantDimensionEnum;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgDataCollection;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgDataTypeEnum;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgEntryCollection;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgFormCollection;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgPeriodNode;
import com.kingdee.eas.ma.bg.BgRptTemplateDAFactory;
import com.kingdee.eas.ma.bg.BgTemplateColumnInfo;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.IBgRptTemplateDA;
import com.kingdee.eas.ma.bg.ReferencedCurrencyInfo;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.ma.bg.client.BgDeclareClientHelper;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class BgDistributeEditHelper {
    public static final int SCALE = 6;
    private final String PERCENT = "Percent";

    public void insertPercentColumn(BgTemplateInfo bgTemplateInfo, KDTable kdTable) {
        boolean isMultiCurrency = bgTemplateInfo.getRefCurrencies().size() > 1;
        IRow mainHeadRow = kdTable.getHeadRow(0);
        IRow percentHeadRow = null;
        if (isMultiCurrency) {
            percentHeadRow = kdTable.getHeadRow(1);
        } else {
            percentHeadRow = kdTable.addHeadRow();
            this.copyValue(percentHeadRow, mainHeadRow, kdTable.getColumnCount());
        }
        Iterator iter = bgTemplateInfo.getApportionableBgTpCol().iterator();
        while (iter.hasNext()) {
            String eleKey;
            BgTemplateColumnInfo bgTpColInfo = (BgTemplateColumnInfo)iter.next();
            BgElementInfo bgEleInfo = bgTpColInfo.getBgElement();
            if (bgEleInfo.getDataType().equals((Object)BgDataTypeEnum.Amount)) {
                if (isMultiCurrency) {
                    Iterator refCyIter = bgTemplateInfo.getRefCurrencies().iterator();
                    while (refCyIter.hasNext()) {
                        CurrencyInfo cyInfo = ((ReferencedCurrencyInfo)refCyIter.next()).getCurrency();
                        String eleKey2 = BgHelper.getBgElementKey(bgEleInfo, cyInfo);
                        this.insertPercentColumnAt(kdTable, eleKey2, isMultiCurrency);
                    }
                    continue;
                }
                eleKey = BgHelper.getBgElementKey(bgEleInfo, null);
                this.insertPercentColumnAt(kdTable, eleKey, isMultiCurrency);
                continue;
            }
            eleKey = BgHelper.getBgElementKey(bgEleInfo, null);
            this.insertPercentColumnAt(kdTable, eleKey, false);
        }
    }

    private void copyValue(IRow percentHeadRow, IRow mainHeadRow, int columnCount) {
        for (int i = 0; i < columnCount; ++i) {
            ICell mainCell = mainHeadRow.getCell(i);
            ICell percentCell = percentHeadRow.getCell(i);
            if (mainCell == null || percentCell == null) continue;
            percentCell.setValue(mainCell.getValue());
        }
    }

    private void insertPercentColumnAt(KDTable kdTable, String eleKey, boolean isMultiCurrency) {
        int position = kdTable.getColumnIndex(eleKey) + 1;
        IColumn column = kdTable.addColumn(position);
        column.setKey(eleKey + "_" + this.PERCENT);
        String strColumnName = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"percent");
        strColumnName = strColumnName + "(%)";
        kdTable.getHeadRow(1).getCell(position).setValue((Object)strColumnName);
        kdTable.getHeadRow(0).getCell(position).setValue(kdTable.getHeadRow(0).getCell(position - 1).getValue());
        if (!isMultiCurrency) {
            strColumnName = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"splitValue");
            kdTable.getHeadRow(1).getCell(position - 1).setValue((Object)strColumnName);
        }
    }

    public void fillData(BgFormInfo editData, BgFormCollection subBgFormCollection, BgPeriodNode bgPeriodNode, KDTable kdtDistributeData) {
        if (bgPeriodNode == null) {
            return;
        }
        BgDeclareClientHelper bgDecClientHelper = new BgDeclareClientHelper();
        boolean isMultiCurrency = editData.getBgTemplate().getRefCurrencies().size() > 1;
        BgEntryCollection bgEntries = null;
        BgEntryCollection bgEntriesUpper = new BgEntryCollection();
        int size = subBgFormCollection.size();
        for (int i = 0; i < size; ++i) {
            BgFormInfo bgFormInfo = subBgFormCollection.get(i);
            if (bgPeriodNode.isLeaf()) {
                BgEntryInfo info;
                int j;
                bgEntries = bgFormInfo.getBgEntries(bgPeriodNode.getPeriod(), bgPeriodNode.getBgCycle());
                if (i == 0) {
                    for (j = 0; j < bgEntries.size(); ++j) {
                        info = bgEntries.get(j).deepClone_distr();
                        bgEntriesUpper.add(info);
                    }
                }
                if (bgEntries.size() == 0) {
                    for (j = 0; j < bgEntriesUpper.size(); ++j) {
                        info = bgEntriesUpper.get(j).deepClone_distr();
                        bgEntries.add(info);
                    }
                    if (bgPeriodNode.isLeaf()) {
                        BgEntryInfo info2;
                        if (bgPeriodNode.getBgCycle().getValue() == 3) {
                            if (!bgFormInfo.checkHasUpperBgEntries(bgPeriodNode.getPeriod(), BgCycleTypeEnum.Year)) {
                                BgEntryCollection bgEntries_year = new BgEntryCollection();
                                for (int j2 = 0; j2 < bgEntriesUpper.size(); ++j2) {
                                    info2 = bgEntriesUpper.get(j2).deepClone_distr();
                                    info2.setIsLeafPeriod(false);
                                    info2.setBgCycle(BgCycleTypeEnum.Year);
                                    bgEntries_year.add(info2);
                                }
                                subBgFormCollection.get(i).getBgEntries().addCollection(bgEntries_year);
                            } else if (!bgFormInfo.checkHasUpperBgEntries(bgPeriodNode.getPeriod(), BgCycleTypeEnum.Season)) {
                                BgEntryCollection bgEntries_season = new BgEntryCollection();
                                for (int j3 = 0; j3 < bgEntriesUpper.size(); ++j3) {
                                    info2 = bgEntriesUpper.get(j3).deepClone_distr();
                                    info2.setIsLeafPeriod(false);
                                    info2.setBgCycle(BgCycleTypeEnum.Season);
                                    bgEntries_season.add(info2);
                                }
                                subBgFormCollection.get(i).getBgEntries().addCollection(bgEntries_season);
                            }
                        } else if (bgPeriodNode.getBgCycle().getValue() == 2 && !bgFormInfo.checkHasUpperBgEntries(bgPeriodNode.getPeriod(), BgCycleTypeEnum.Year)) {
                            BgEntryCollection bgEntries_year = new BgEntryCollection();
                            for (int j4 = 0; j4 < bgEntriesUpper.size(); ++j4) {
                                info2 = bgEntriesUpper.get(j4).deepClone_distr();
                                info2.setIsLeafPeriod(false);
                                info2.setBgCycle(BgCycleTypeEnum.Year);
                                bgEntries_year.add(info2);
                            }
                            subBgFormCollection.get(i).getBgEntries().addCollection(bgEntries_year);
                        }
                    }
                    subBgFormCollection.get(i).getBgEntries().addCollection(bgEntries);
                }
            } else {
                bgEntries = bgFormInfo.getSummedBgEntries(bgPeriodNode.getPeriod(), bgPeriodNode.getBgCycle());
                int m = bgEntries.size();
                for (int h = 0; h < m; ++h) {
                    BgEntryInfo entryInfo = bgEntries.get(h);
                    int n = entryInfo.getBgData().size();
                    for (int k = 0; k < n; ++k) {
                        BgDataInfo tempDataInfo = entryInfo.getBgData().get(k);
                        BgDataInfo realDataInfo = bgFormInfo.getBgData(entryInfo.getBgItemsKey(), tempDataInfo.getElementKey(), bgPeriodNode);
                        if (realDataInfo == null) continue;
                        realDataInfo.setBgValue(tempDataInfo.getBgValue());
                    }
                }
            }
            bgDecClientHelper.insertBgEntryInfosByPeriod(kdtDistributeData, bgFormInfo.getOrgUnit(), bgEntries, isMultiCurrency);
        }
        if (!bgPeriodNode.isLeaf()) {
            return;
        }
        bgEntries = editData.getBgEntries(bgPeriodNode.getPeriod(), bgPeriodNode.getBgCycle());
        this.insertOrignalEntry(kdtDistributeData, bgEntries, isMultiCurrency);
    }

    private void insertOrignalEntry(KDTable kdtDistributeData, BgEntryCollection bgEntries, boolean isMultiCurrency) {
        if (bgEntries == null) {
            return;
        }
        int nRowCount = kdtDistributeData.getRowCount();
        if (nRowCount == 0) {
            return;
        }
        int size = bgEntries.size();
        for (int i = 0; i < size; ++i) {
            BgEntryInfo bgEntryInfo = bgEntries.get(i);
            for (int j = 0; j < nRowCount; ++j) {
                boolean isMatched;
                IRow row = kdtDistributeData.getRow(j);
                if (!(row.getUserObject() instanceof String) || !(isMatched = this.checkKeyMatched(row, bgEntryInfo))) continue;
                this.fillOrginalData(bgEntryInfo, row, isMultiCurrency);
            }
        }
    }

    private void fillOrginalData(BgEntryInfo bgEntryInfo, IRow row, boolean isMultiCurrency) {
        Iterator bgDataIter = bgEntryInfo.getBgData().iterator();
        while (bgDataIter.hasNext()) {
            BgDataInfo bgDataInfo = (BgDataInfo)bgDataIter.next();
            String cellKey = null;
            cellKey = bgDataInfo.getDataType().equals((Object)BgDataTypeEnum.Amount) && isMultiCurrency ? BgHelper.getBgElementKey(bgDataInfo.getBgElement(), bgDataInfo.getCurrency()) : BgHelper.getBgElementKey(bgDataInfo.getBgElement(), null);
            ICell cell = row.getCell(cellKey = cellKey + "_" + this.PERCENT);
            if (cell == null) continue;
            cell.setUserObject((Object)bgDataInfo);
        }
    }

    private boolean checkKeyMatched(IRow row, BgEntryInfo bgEntryInfo) {
        String bgEntryKey = bgEntryInfo.getBgItemsKey();
        String rowKey = row.getUserObject().toString();
        return rowKey.startsWith(bgEntryKey);
    }

    public void applySimpleScale(BgFormInfo editData, BgFormCollection subBgFormCollection, Hashtable scaleTable) {
        int entrySize = editData.getBgEntries().size();
        for (int i = 0; i < entrySize; ++i) {
            BgEntryInfo bgEntryInfo = editData.getBgEntries().get(i);
            int dataSize = bgEntryInfo.getBgData().size();
            for (int j = 0; j < dataSize; ++j) {
                BgDataInfo bgDataInfo = bgEntryInfo.getBgData().get(j);
                int formSize = subBgFormCollection.size();
                for (int k = 0; k < formSize; ++k) {
                    BgFormInfo subFormInfo = subBgFormCollection.get(k);
                    BgEntryCollection subBgEntryCollection = this.getBgEntryCollByLowerBgForm(bgEntryInfo, subFormInfo);
                    BigDecimal scale = (BigDecimal)scaleTable.get(subBgFormCollection.get(k).getOrgUnit().getId().toString());
                    this.setBgDataScaleLowerBgEntryColl(bgDataInfo, subBgEntryCollection, scale);
                }
            }
        }
    }

    private void setBgDataScaleLowerBgEntryColl(BgDataInfo bgDataInfo, BgEntryCollection subBgEntryCollection, BigDecimal bigScale) {
        int size = subBgEntryCollection.size();
        String elementKey = bgDataInfo.getElementKey();
        for (int i = 0; i < size; ++i) {
            BgEntryInfo bgEntryInfoTemp = subBgEntryCollection.get(i);
            BgDataCollection bgDataCollectionTemp = bgEntryInfoTemp.getBgData();
            int sizeTemp = bgDataCollectionTemp.size();
            for (int j = 0; j < sizeTemp; ++j) {
                BgDataInfo bgDataInfoTemp = bgDataCollectionTemp.get(j);
                if (!elementKey.equals(bgDataInfoTemp.getElementKey()) || !bgDataInfo.getElementNumber().equals(bgDataInfoTemp.getElementNumber())) continue;
                if (!bgDataInfo.getBgElement().isApportionable()) {
                    bgDataInfoTemp.setBgValue(bgDataInfo.getBgValue());
                    continue;
                }
                BigDecimal bigValue = bgDataInfo.getBgValue().multiply(bigScale).divide(new BigDecimal("100"), 6, 4);
                bgDataInfoTemp.setBgValue(bigValue);
            }
        }
    }

    private BgEntryCollection getBgEntryCollByLowerBgForm(BgEntryInfo bgEntryInfo, BgFormInfo subBgFormInfo) {
        BgEntryCollection bgEntryCollection = new BgEntryCollection();
        PeriodInfo periodInfo = bgEntryInfo.getPeriod();
        String strEntryKey = bgEntryInfo.getBgItemsKey();
        BgEntryCollection bgEntryCollectionTemp = subBgFormInfo.getBgEntries();
        int sizeTemp = bgEntryCollectionTemp.size();
        for (int j = 0; j < sizeTemp; ++j) {
            BgEntryInfo bgEntryInfoTemp = bgEntryCollectionTemp.get(j);
            if (!bgEntryInfoTemp.isIsLeafPeriod() || !periodInfo.getId().equals((Object)bgEntryInfoTemp.getPeriod().getId()) || !strEntryKey.equals(bgEntryInfoTemp.getBgItemsKey()) || !bgEntryInfo.getBgCycle().equals((Object)bgEntryInfoTemp.getBgCycle())) continue;
            bgEntryCollection.add(bgEntryInfoTemp);
        }
        return bgEntryCollection;
    }

    public void fillScaleData(KDTable kdtDistributeData) {
        DecimalFormat format = BgClientHelper.getDecimalFormat();
        int columnCount = kdtDistributeData.getColumnCount();
        for (int j = 0; j < columnCount; ++j) {
            IColumn column = kdtDistributeData.getColumn(j);
            if (!column.getKey().endsWith(this.PERCENT)) continue;
            IColumn dataColumn = kdtDistributeData.getColumn(j - 1);
            for (int i = 0; i < kdtDistributeData.getRowCount(); ++i) {
                ICell cell = kdtDistributeData.getRow(i).getCell(j);
                if (cell.getUserObject() == null) continue;
                BgDataInfo orginalDataInfo = (BgDataInfo)cell.getUserObject();
                ICell subDataCell = kdtDistributeData.getRow(i).getCell(j - 1);
                if (subDataCell.getUserObject() == null) continue;
                BgDataInfo subDataInfo = (BgDataInfo)subDataCell.getUserObject();
                BigDecimal bigDecimalSub = subDataCell.getValue() instanceof BigDecimal ? (BigDecimal)subDataCell.getValue() : new BigDecimal(subDataCell.getValue().toString());
                BigDecimal bigDecimalOrg = orginalDataInfo.getBgValue();
                BigDecimal bigDecimal = new BigDecimal("0");
                if (bigDecimalOrg.compareTo(new BigDecimal("0")) != 0) {
                    bigDecimal = bigDecimalSub.divide(bigDecimalOrg, 6, 4);
                }
                cell.setValue((Object)new BigDecimal(format.format(bigDecimal.multiply(new BigDecimal("100")))));
            }
        }
    }

    public void updateCell(KDTable kdtDistributeData, int rowIndex, int columnIndex) {
        ICell cell = kdtDistributeData.getRow(rowIndex).getCell(columnIndex);
        IColumn column = kdtDistributeData.getColumn(columnIndex);
        DecimalFormat format = BgClientHelper.getDecimalFormat();
        if (column.getKey().endsWith(this.PERCENT)) {
            ICell dataCell = kdtDistributeData.getRow(rowIndex).getCell(columnIndex - 1);
            if (dataCell.getUserObject() == null) {
                return;
            }
            BgDataInfo dataInfo = (BgDataInfo)dataCell.getUserObject();
            if (cell.getUserObject() == null) {
                return;
            }
            BigDecimal originalValue = ((BgDataInfo)cell.getUserObject()).getBgValue();
            BigDecimal scale = new BigDecimal(cell.getValue().toString());
            dataInfo.setBgValue(originalValue.multiply(scale).divide(new BigDecimal("100"), 6, 4));
            dataCell.setValue((Object)new BigDecimal(format.format(dataInfo.getBgValue()).toString()));
        } else {
            IColumn tmpColumn;
            BgDataInfo dataInfo = (BgDataInfo)cell.getUserObject();
            BigDecimal updatedValue = new BigDecimal("0.00");
            Object obj = cell.getValue();
            if (obj != null) {
                if (obj instanceof BigDecimal) {
                    updatedValue = new BigDecimal(cell.getValue().toString());
                } else if (obj instanceof String) {
                    updatedValue = new BigDecimal(obj.toString());
                }
            }
            if (dataInfo != null) {
                dataInfo.setBgValue(new BigDecimal(format.format(updatedValue).toString()));
            }
            if (columnIndex < kdtDistributeData.getColumnCount() - 1 && (tmpColumn = kdtDistributeData.getColumn(columnIndex + 1)).getKey().endsWith(this.PERCENT)) {
                ICell percentCell = kdtDistributeData.getRow(rowIndex).getCell(columnIndex + 1);
                if (percentCell.getUserObject() == null) {
                    return;
                }
                BigDecimal originalValue = ((BgDataInfo)percentCell.getUserObject()).getBgValue();
                BigDecimal bigData = new BigDecimal("0.00");
                if (originalValue.compareTo(new BigDecimal("0")) != 0) {
                    bigData = updatedValue.divide(originalValue, 6, 4);
                }
                percentCell.setValue((Object)new BigDecimal(format.format(bigData.multiply(new BigDecimal("100"))).toString()));
            }
        }
    }

    public Vector getScaleCol(KDTable kDTable) {
        Vector<Integer> vec = new Vector<Integer>();
        int colCount = kDTable.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            String strKey = kDTable.getColumnKey(i);
            if (!strKey.endsWith("Percent")) continue;
            vec.add(new Integer(i));
        }
        return vec;
    }

    public void reCalculatePerent(KDTable kDTable, OrgUnitInfo orgUnitInfo, int orgCount, Vector vecScale) {
        if (vecScale.size() == 0) {
            return;
        }
        DecimalFormat format = BgClientHelper.getDecimalFormat();
        BgDistributeEditHelper bgDistEditHelper = new BgDistributeEditHelper();
        int rowCount = kDTable.getRowCount();
        String strColumnKey = BgAssistantDimensionEnum.SUB_ORGUNIT.getName();
        BigDecimal bigCurrOrgValue = new BigDecimal("0");
        BigDecimal bigLowerOrgValue = new BigDecimal("0");
        for (int i = 0; i < rowCount; ++i) {
            IRow iRow = kDTable.getRow(i);
            OrgUnitInfo org = (OrgUnitInfo)iRow.getCell(strColumnKey).getUserObject();
            if (!org.getId().equals((Object)orgUnitInfo.getId())) continue;
            for (int j = 0; j < vecScale.size(); ++j) {
                int colIndex = (Integer)vecScale.get(j);
                for (int k = 1; k <= orgCount; ++k) {
                    IRow iRowLower = kDTable.getRow(i + k);
                    Object obj = iRow.getCell(colIndex - 1).getValue();
                    if (obj instanceof BigDecimal) {
                        bigCurrOrgValue = (BigDecimal)obj;
                    }
                    bigLowerOrgValue = iRowLower.getCell(colIndex - 1).getValue() instanceof BigDecimal ? (BigDecimal)iRowLower.getCell(colIndex - 1).getValue() : new BigDecimal((String)iRowLower.getCell(colIndex - 1).getValue());
                    BigDecimal bigScale = new BigDecimal("0");
                    if (bigLowerOrgValue != null && bigCurrOrgValue != null && bigCurrOrgValue.compareTo(new BigDecimal("0")) != 0) {
                        bigScale = bigLowerOrgValue.divide(bigCurrOrgValue, 6, 4);
                    }
                    bigScale = bigScale.multiply(new BigDecimal("100"));
                    iRowLower.getCell(colIndex).setValue((Object)format.format(bigScale));
                }
            }
        }
    }

    public void splitNotListProjectToList(BgFormInfo bgFormInfo) {
        BgEntryCollection bgEntryCollection = bgFormInfo.getBgEntries();
        int size = bgEntryCollection.size();
        for (int i = 0; i < size; ++i) {
            BgDataCollection bgDataCollection;
            BgEntryInfo bgEntryInfo = bgEntryCollection.get(i);
            if (!bgEntryInfo.isIsLeafPeriod() || bgEntryInfo.isIsLeafEntry()) continue;
            BgItemInfo[] bgItemArr = new BgItemInfo[]{bgEntryInfo.getBgItem1(), bgEntryInfo.getBgItem2(), bgEntryInfo.getBgItem3(), bgEntryInfo.getBgItem4(), bgEntryInfo.getBgItem5(), bgEntryInfo.getBgItem6()};
            StringBuffer strItemNum = new StringBuffer();
            boolean isHas = false;
            for (int j = 0; j < 6 && bgItemArr[j] != null; ++j) {
                if (bgItemArr[j].isIsLeaf()) continue;
                isHas = true;
                break;
            }
            if (isHas) {
                BgDataCollection bgDataColl = this.getAllBgDataCollByBgEntrys(bgItemArr, bgEntryCollection, bgEntryInfo.getPeriod());
                int n = bgDataColl.size();
                for (int j = 0; j < n; ++j) {
                    BgDataInfo info = bgDataColl.get(j);
                    if (info.getBgValue().equals(new BigDecimal("0"))) continue;
                    isHas = false;
                    break;
                }
            }
            if (!isHas || (bgDataCollection = this.getBgDataCollByBgEntrys(bgItemArr, bgEntryCollection, bgEntryInfo.getPeriod())).size() <= 0) continue;
            String strTempId = bgFormInfo.getBgTemplate().getId().toString();
            this.setBgValueByBgDataColl(bgEntryInfo.getBgData(), bgDataCollection, strTempId);
        }
    }

    private void setBgValueByBgDataColl(BgDataCollection notListBgDataColl, BgDataCollection listBgDataColl, String bgTemplateId) {
        int size = notListBgDataColl.size();
        int size1 = listBgDataColl.size();
        for (int i = 0; i < size; ++i) {
            BgDataInfo notListBgData = notListBgDataColl.get(i);
            for (int j = 0; j < size1; ++j) {
                BgDataInfo listBgData = listBgDataColl.get(j);
                if (!notListBgData.getElementKey().equals(listBgData.getElementKey())) continue;
                try {
                    IBgRptTemplateDA ibg = BgRptTemplateDAFactory.getRemoteInstance();
                    BgEntryInfo bgentry = listBgData.getBgEntry();
                    String strItemNums = bgentry.getBgItem1().getItemNumber();
                    boolean isExist = ibg.ParentTempisExistBgItem(bgTemplateId, strItemNums);
                    if (isExist) continue;
                    listBgData.setBgValue(notListBgData.getBgValue());
                    continue;
                }
                catch (EASBizException e1) {
                    e1.printStackTrace();
                    continue;
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private BgDataCollection getBgDataCollByBgEntrys(BgItemInfo[] bgItemInfoArray, BgEntryCollection bgEntryCollection, PeriodInfo period) {
        BgDataCollection bgDataCollection = new BgDataCollection();
        int size = bgEntryCollection.size();
        for (int i = 0; i < size; ++i) {
            BgEntryInfo bgEntryInfo = bgEntryCollection.get(i);
            if (!bgEntryInfo.isIsLeafPeriod() || !bgEntryInfo.isIsLeafEntry() || !bgEntryInfo.getPeriod().getId().equals((Object)period.getId())) continue;
            BgItemInfo[] bgItemArr = new BgItemInfo[]{bgEntryInfo.getBgItem1(), bgEntryInfo.getBgItem2(), bgEntryInfo.getBgItem3(), bgEntryInfo.getBgItem4(), bgEntryInfo.getBgItem5(), bgEntryInfo.getBgItem6()};
            boolean isExist = false;
            int indexEle = 0;
            for (int j = 0; j < 6; ++j) {
                int oriIndex;
                int index;
                if (bgItemArr[j] == null || !bgItemArr[j].isIsLeaf() || (index = bgItemArr[j].getItemNumber().lastIndexOf(".")) <= (oriIndex = bgItemInfoArray[j].getItemNumber().lastIndexOf(".")) || !bgItemArr[j].getItemNumber().startsWith(bgItemInfoArray[j].getItemNumber())) continue;
                isExist = true;
                indexEle = j;
                break;
            }
            if (!isExist) continue;
            int isNullIndex = 0;
            for (int k = 0; k < 6; ++k) {
                if (bgItemArr[k] != null) continue;
                isNullIndex = k;
                break;
            }
            boolean isEqual = true;
            for (int m = 0; m < isNullIndex; ++m) {
                if (m == indexEle || bgItemArr[m].getItemNumber().equals(bgItemInfoArray[m].getItemNumber())) continue;
                isEqual = false;
            }
            if (!isEqual) continue;
            Iterator iter = bgEntryInfo.getBgData().iterator();
            while (iter.hasNext()) {
                BgDataInfo bgdata = (BgDataInfo)iter.next();
                bgdata.setBgEntry(bgEntryInfo);
            }
            bgDataCollection.addCollection(bgEntryInfo.getBgData());
            break;
        }
        return bgDataCollection;
    }

    private BgDataCollection getAllBgDataCollByBgEntrys(BgItemInfo[] bgItemInfoArray, BgEntryCollection bgEntryCollection, PeriodInfo period) {
        BgDataCollection bgDataCollection = new BgDataCollection();
        int size = bgEntryCollection.size();
        for (int i = 0; i < size; ++i) {
            BgEntryInfo bgEntryInfo = bgEntryCollection.get(i);
            if (!bgEntryInfo.isIsLeafPeriod() || !bgEntryInfo.isIsLeafEntry() || !bgEntryInfo.getPeriod().getId().equals((Object)period.getId())) continue;
            BgItemInfo[] bgItemArr = new BgItemInfo[]{bgEntryInfo.getBgItem1(), bgEntryInfo.getBgItem2(), bgEntryInfo.getBgItem3(), bgEntryInfo.getBgItem4(), bgEntryInfo.getBgItem5(), bgEntryInfo.getBgItem6()};
            boolean isExist = false;
            int indexEle = 0;
            for (int j = 0; j < 6; ++j) {
                int oriIndex;
                int index;
                if (bgItemArr[j] == null || !bgItemArr[j].isIsLeaf() || (index = bgItemArr[j].getItemNumber().lastIndexOf(".")) <= (oriIndex = bgItemInfoArray[j].getItemNumber().lastIndexOf(".")) || !bgItemArr[j].getItemNumber().startsWith(bgItemInfoArray[j].getItemNumber())) continue;
                isExist = true;
                indexEle = j;
                break;
            }
            if (!isExist) continue;
            int isNullIndex = 0;
            for (int k = 0; k < 6; ++k) {
                if (bgItemArr[k] != null) continue;
                isNullIndex = k;
                break;
            }
            boolean isEqual = true;
            for (int m = 0; m < isNullIndex; ++m) {
                if (m == indexEle || bgItemArr[m].getItemNumber().equals(bgItemInfoArray[m].getItemNumber())) continue;
                isEqual = false;
            }
            if (!isEqual) continue;
            Iterator iter = bgEntryInfo.getBgData().iterator();
            while (iter.hasNext()) {
                BgDataInfo bgdata = (BgDataInfo)iter.next();
                bgdata.setBgEntry(bgEntryInfo);
            }
            bgDataCollection.addCollection(bgEntryInfo.getBgData());
        }
        return bgDataCollection;
    }

    public static boolean checkBgCycleBigger(BgFormInfo bgFormInfoTotal, BgFormCollection bgFormCollectionSub) {
        int bgCycle = bgFormInfoTotal.getBgTemplate().getBgCycle().getValue();
        Iterator iter = bgFormCollectionSub.iterator();
        while (iter.hasNext()) {
            BgFormInfo bfi = (BgFormInfo)iter.next();
            BgTemplateInfo bti = bfi.getBgTemplate();
            if (bti.getBgCycle().getValue() <= bgCycle) continue;
            return false;
        }
        return true;
    }
}

