/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgElementCollection;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgTemplateColumnInfo;
import com.kingdee.eas.ma.bg.BgTemplateHelper;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgType;
import com.kingdee.eas.ma.bg.client.AbstractBgElementF7UI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class BgElementF7UI
extends AbstractBgElementF7UI {
    private boolean isCancel = true;
    private BgElementInfo result = null;
    private final String NUMBER = "number";
    private final String NAME = "name";
    private final String BGTYPE = "bgType";
    private static final Logger logger = CoreUIObject.getLogger(BgElementF7UI.class);

    public BgElementF7UI() throws Exception {
        this.initKDtable();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        int currRow = this.kdtable.getSelectManager().getActiveRowIndex();
        if (currRow != -1) {
            IRow iRow = this.kdtable.getRow(currRow);
            this.result = (BgElementInfo)iRow.getUserObject();
        }
        this.isCancel = false;
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }

    public void initKDtable() {
        this.kdtable.removeHeadRows();
        this.kdtable.removeRows();
        this.kdtable.removeColumns();
        this.kdtable.checkParsed();
        this.kdtable.getStyleAttributes().setLocked(true);
        IColumn iColumn = this.kdtable.addColumn();
        iColumn.setKey("number");
        IColumn iColumn1 = this.kdtable.addColumn();
        iColumn1.setKey("name");
        IColumn iColumn2 = this.kdtable.addColumn();
        iColumn2.setKey("bgType");
        IRow iRow = this.kdtable.addHeadRow();
        String strNumber = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"number");
        String strName = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"name");
        String strBgtype = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"bgType");
        iRow.getCell("number").setValue((Object)strNumber);
        iRow.getCell("name").setValue((Object)strName);
        iRow.getCell("bgType").setValue((Object)strBgtype);
        this.kdtable.getSelectManager().setSelectMode(2);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String strOrgNumber = (String)this.getUIContext().get("orgNumber");
        String strBgTypeNumber = (String)this.getUIContext().get("bgTypeNumber");
        FullOrgUnitInfo org = (FullOrgUnitInfo)this.getUIContext().get("orgUnit");
        this.putDataToKDTable(strBgTypeNumber, strOrgNumber, org);
    }

    public void putDataToKDTable(String strBgTypeNumber, String strOrgNumber, FullOrgUnitInfo org) {
        block11: {
            try {
                if (strBgTypeNumber == null || strBgTypeNumber.length() == 0) {
                    String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectBgType");
                    MsgBox.showWarning((Component)((Object)this), (String)strErr);
                    return;
                }
                IBgType iBgType = BgTypeFactory.getRemoteInstance();
                BgTypeInfo temp = iBgType.getBgTypeInfo(" select isRptBgForm where number='" + strBgTypeNumber + "'");
                if (temp.isIsRptBgForm()) {
                    BgTypeInfo bgTypeInfo = iBgType.getBgTypeInfo(" select id,name,number,elements.* where number='" + strBgTypeNumber + "'");
                    if (bgTypeInfo != null) {
                        BgElementCollection bgElementCol = bgTypeInfo.getElements();
                        if (bgElementCol != null && bgElementCol.size() > 0) {
                            this.kdtable.removeRows();
                            for (int i = 0; i < bgElementCol.size(); ++i) {
                                BgElementInfo bgElementInfo = bgElementCol.get(i);
                                IRow iRow = this.kdtable.addRow();
                                iRow.setUserObject((Object)bgElementInfo);
                                ICell iCell1 = iRow.getCell("number");
                                iCell1.setValue((Object)bgElementInfo.getNumber());
                                ICell iCell2 = iRow.getCell("name");
                                iCell2.setValue((Object)bgElementInfo.getName());
                                ICell iCell3 = iRow.getCell("bgType");
                                iCell3.setValue((Object)bgTypeInfo.getName());
                            }
                        }
                        break block11;
                    }
                    String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectBgType");
                    MsgBox.showWarning((Component)((Object)this), (String)strErr);
                    return;
                }
                BgTypeInfo bgTypeInfo = iBgType.getValueByNumber(strBgTypeNumber);
                if (bgTypeInfo != null) {
                    BgTemplateInfo bgTemplateInfo = BgTemplateHelper.findTempByBgTypeAndOrgNum(bgTypeInfo, org);
                    if (bgTemplateInfo == null) {
                        return;
                    }
                    Iterator iterator = bgTemplateInfo.getBgTpColumns().iterator();
                    this.kdtable.removeRows();
                    while (iterator.hasNext()) {
                        BgTemplateColumnInfo bgTemplateColumnInfo = (BgTemplateColumnInfo)iterator.next();
                        BgElementInfo bgElementInfo = bgTemplateColumnInfo.getBgElement();
                        IRow iRow = this.kdtable.addRow();
                        iRow.setUserObject((Object)bgElementInfo);
                        ICell iCell1 = iRow.getCell("number");
                        iCell1.setValue((Object)bgElementInfo.getNumber());
                        ICell iCell2 = iRow.getCell("name");
                        iCell2.setValue((Object)bgElementInfo.getName());
                        ICell iCell3 = iRow.getCell("bgType");
                        iCell3.setValue((Object)bgTypeInfo.getName());
                    }
                    break block11;
                }
                String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectBgType");
                MsgBox.showWarning((Component)((Object)this), (String)strErr);
                return;
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void kdtable_tableClicked(KDTMouseEvent e) throws Exception {
        super.kdtable_tableClicked(e);
        if (e.getClickCount() == 2) {
            this.onBtnOK();
        }
    }

    private void onBtnOK() throws BOSException, EASBizException {
        KDTSelectBlock selectBlock = this.kdtable.getSelectManager().get();
        if (selectBlock == null) {
            return;
        }
        int currRow = this.kdtable.getSelectManager().getActiveRowIndex();
        IRow iRow = this.kdtable.getRow(currRow);
        this.result = (BgElementInfo)iRow.getUserObject();
        this.isCancel = false;
        this.getUIWindow().close();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public BgElementInfo getResult() {
        return this.result;
    }
}

