/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.bg.BgExchangeRateFactory;
import com.kingdee.eas.ma.bg.client.AbstractBgExchangeRateList;
import com.kingdee.eas.ma.bg.client.BgExchangeRateEdit;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class BgExchangeRateList
extends AbstractBgExchangeRateList {
    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return BgExchangeRateEdit.class.getName();
    }

    protected ICoreBase getBizInterface() throws BOSException {
        return BgExchangeRateFactory.getRemoteInstance();
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.ma.bg.BgExchangeRateResource", (String)"BgExchangeRate");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.kDSeparator2.setVisible(false);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        Object comobj = SysContext.getSysContext().getProperty((Object)"CurCompanyId");
        if (comobj.toString() == null || comobj.toString().equals("")) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgExchangeRateResource", (String)"noOrg"));
            SysUtil.abort();
        }
        ObjectUuidPK compk = new ObjectUuidPK(BOSUuid.read((String)comobj.toString()));
        ICompanyOrgUnit comorg = CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitInfo comInfo = comorg.getCompanyOrgUnitInfo((IObjectPK)compk);
        PeriodInfo pInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)comInfo);
        if (pInfo == null) {
            return;
        }
        int currentYear = pInfo.getPeriodYear();
        int currentNumber = pInfo.getPeriodNumber();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            ICell cell1 = row.getCell("validPeriodTo.periodYear");
            ICell cell2 = row.getCell("validPeriodTo.periodNumber");
            int year = (Integer)cell1.getValue();
            int number = (Integer)cell2.getValue();
            if (year > currentYear || year == currentYear && number > currentNumber) {
                if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgExchangeRateResource", (String)"confirmDelete")) == 0) {
                    this.remove(e);
                }
            } else if (this.confirmRemove()) {
                this.remove(e);
            }
        }
    }

    protected void remove(ActionEvent e) throws Exception {
        this.getBizInterface().delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())));
        this.refresh(e);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        FilterInfo filterInfo = new FilterInfo();
        SysContext sys = SysContext.getSysContext();
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)sys.getCurrentCompany();
        if (companyOrgUnitInfo != null) {
            String strCompanyId = companyOrgUnitInfo.getId().toString();
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)strCompanyId, CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
        }
        IQueryExecutor queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        return queryExecutor;
    }
}

