/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IExceptionHandler;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgEntryCollection;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgFormStateEnum;
import com.kingdee.eas.ma.bg.BgPeriodNode;
import com.kingdee.eas.ma.bg.ReferencedCurrencyCollection;
import com.kingdee.eas.ma.bg.ReferencedDimensionCollection;
import com.kingdee.eas.ma.bg.ReferencedDimensionInfo;
import com.kingdee.eas.ma.bg.client.AbstractBgFormActualEditUI;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.ma.bg.client.BgDataColumnSubject;
import com.kingdee.eas.ma.bg.client.BgFormEditHelper;
import com.kingdee.eas.ma.bg.client.BgSelectPeriodUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;

public class BgFormActualEditUI
extends AbstractBgFormActualEditUI {
    public static final String RESOURCE = "com.kingdee.eas.ma.bg.client.BgFormActualResource";
    public static final String EDITDATA = "editData";
    public static final String BGPERIODTREE = "treeBgPeriod";
    public static final String NAME = "name";
    public static final String BGFORMDATATABLE = "kdtBgFormData";
    public static final String PERIOD_NODE = "periodNode";
    public static final String INOROUT = "inOrOut";
    public static final String BGNAME1 = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgFormActualResource", (String)"uiTitle_value");
    public static final String BGNAME2 = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgFormActualResource", (String)"uiTitle_actual");
    private IOrgUnitCommon iOrgUnitCommon = null;
    public String kindName;

    public BgFormActualEditUI() throws Exception {
        KDTMenuManager tm = new KDTMenuManager(this.kdtBgFormData);
        String path = System.getProperty("user.dir");
        path = path + "/eastmp.xls";
        tm.setTempFile(path);
        tm.setExceptionHandler(new IExceptionHandler(){

            public void handle(Exception e) {
                BgFormActualEditUI.this.handUIException(e);
            }
        });
    }

    @Override
    public void loadFields() {
        BgFormEditHelper.loadFields(this);
        this.kdtBgFormData.getDataRequestManager().setDataRequestMode(0);
        this.kdtBgFormData.getMergeManager().setMergeMode(0);
        this.kdtBgFormData.getGroupManager().setGroup(true);
        if (!this.editData.getBgType().isIsRptBgForm()) {
            for (int i = 0; i < this.editData.getBgTemplate().getVisibleDims().size(); ++i) {
                this.kdtBgFormData.getColumn(i).setGroup(true);
                this.kdtBgFormData.getColumn(i).setMergeable(true);
            }
        }
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)EDITDATA, (Object)this.editData);
        uiContext.put((Object)BGPERIODTREE, (Object)this.treeBgPeriod);
        uiContext.put((Object)NAME, (Object)this.txtName.getText());
        uiContext.put((Object)BGFORMDATATABLE, (Object)this.kdtBgFormData);
        uiContext.put((Object)PERIOD_NODE, (Object)this.get2Period());
        uiContext.put((Object)INOROUT, (Object)"out");
        uiContext.put((Object)"kindName", (Object)this.kindName);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgSelectPeriodUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.goLeaf();
    }

    @Override
    protected BgPeriodNode[] get2Period() {
        BgPeriodNode[] period = new BgPeriodNode[2];
        boolean isFirst = false;
        Enumeration enumeration = ((DefaultKingdeeTreeNode)this.treeBgPeriod.getModel().getRoot()).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            BgPeriodNode bgPeriodNode;
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)enumeration.nextElement();
            if (node.getUserObject() == null || !(bgPeriodNode = (BgPeriodNode)node.getUserObject()).isLeaf()) continue;
            if (!isFirst) {
                period[0] = bgPeriodNode;
                isFirst = true;
            }
            period[1] = bgPeriodNode;
        }
        return period;
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getState().equals((Object)BgFormStateEnum.Edited)) {
            this.actionImport_actionPerformed_edit(e);
        } else if (this.editData.getState().equals((Object)BgFormStateEnum.Adjusted)) {
            this.actionImport_actionPerformed_adjust(e);
        } else if (this.editData.getState().equals((Object)BgFormStateEnum.Approved)) {
            this.actionImport_actionPerformed_approve(e);
        }
    }

    protected void actionImport_actionPerformed_edit(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)EDITDATA, (Object)this.editData);
        uiContext.put((Object)BGPERIODTREE, (Object)this.treeBgPeriod);
        uiContext.put((Object)NAME, (Object)this.txtName.getText());
        uiContext.put((Object)BGFORMDATATABLE, (Object)this.kdtBgFormData);
        uiContext.put((Object)PERIOD_NODE, (Object)this.get2Period());
        uiContext.put((Object)INOROUT, (Object)"in");
        uiContext.put((Object)"kindName", (Object)this.kindName);
        uiContext.put((Object)"Invoker", (Object)"ExAndIm");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgSelectPeriodUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.goLeaf();
    }

    protected void actionImport_actionPerformed_adjust(ActionEvent e) throws Exception {
        if (this.txtName.getText().trim().equals("")) {
            this.txtName.requestFocus();
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"noName"));
            SysUtil.abort();
        }
        this.editData.setName(this.txtName.getText().trim());
        BgPeriodNode bgPeriodNode1 = BgClientHelper.getEndBgPeriodNode(this.treeBgPeriod);
        if (bgPeriodNode1 == null) {
            return;
        }
        Date nowDate = new Date(System.currentTimeMillis());
        if (this.iOrgUnitCommon == null) {
            this.iOrgUnitCommon = OrgUnitCommonFactory.getRemoteInstance();
        }
        BOSUuid id = this.iOrgUnitCommon.getCompany(this.editData.getOrgUnit().getId()).getId();
        PeriodInfo period = PeriodUtils.getPeriodInfo((Date)nowDate, (IObjectPK)new ObjectUuidPK(id));
        int currentNumber = period.getPeriodNumber();
        int currentYear = period.getPeriodYear();
        int endNumber = bgPeriodNode1.getPeriod().getPeriodNumber();
        int endYear = bgPeriodNode1.getPeriod().getPeriodYear();
        if (endYear < currentYear || endYear == currentYear && endNumber < currentNumber) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgAdjustFormResource", (String)"notImport"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)EDITDATA, (Object)this.editData);
        uiContext.put((Object)BGPERIODTREE, (Object)this.treeBgPeriod);
        uiContext.put((Object)NAME, (Object)this.txtName.getText());
        uiContext.put((Object)BGFORMDATATABLE, (Object)this.kdtBgFormData);
        uiContext.put((Object)PERIOD_NODE, (Object)this.get2Period());
        uiContext.put((Object)INOROUT, (Object)"in");
        uiContext.put((Object)"kindName", (Object)this.kindName);
        uiContext.put((Object)"Invoker", (Object)"ExAndIm");
        BgCycleTypeEnum cycle = this.editData.getBgTemplate().getBgCycle();
        uiContext.put((Object)"adjustYear", (Object)new Integer(period.getPeriodYear()));
        if (cycle.equals((Object)BgCycleTypeEnum.Period)) {
            uiContext.put((Object)"adjustPeriod", (Object)new Integer(period.getPeriodNumber()));
        } else if (cycle.equals((Object)BgCycleTypeEnum.Season)) {
            uiContext.put((Object)"adjustPeriod", (Object)new Integer(period.getPeriodQuarter()));
        } else if (cycle.equals((Object)BgCycleTypeEnum.Year)) {
            uiContext.put((Object)"adjustPeriod", (Object)new Integer(period.getPeriodYear()));
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgSelectPeriodUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.goLeaf();
    }

    protected void actionImport_actionPerformed_approve(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)EDITDATA, (Object)this.editData);
        uiContext.put((Object)BGPERIODTREE, (Object)this.treeBgPeriod);
        uiContext.put((Object)NAME, (Object)this.txtName.getText());
        uiContext.put((Object)BGFORMDATATABLE, (Object)this.kdtBgFormData);
        uiContext.put((Object)PERIOD_NODE, (Object)this.get2Period());
        uiContext.put((Object)INOROUT, (Object)"in");
        uiContext.put((Object)"kindName", (Object)this.kindName);
        uiContext.put((Object)"Invoker", (Object)"ExAndIm");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgSelectPeriodUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.goLeaf();
    }

    @Override
    protected void fillDataByPeriod(BgEntryCollection currentBgEntries) {
        boolean isMultiCurrency = false;
        ReferencedCurrencyCollection refCy = this.editData.getBgTemplate().getRefCurrencies();
        if (refCy != null && refCy.size() > 1) {
            isMultiCurrency = true;
        }
        if (!this.editData.getBgType().isIsRptBgForm()) {
            this.kdtBgFormData.removeRows();
            ReferencedDimensionCollection dimColl = null;
            for (int i = 0; i < currentBgEntries.size(); ++i) {
                IRow row = this.kdtBgFormData.addRow();
                BgEntryInfo info = currentBgEntries.get(i);
                if (dimColl == null) {
                    dimColl = this.editData.getBgTemplate().getVisibleDims();
                }
                Iterator visibleRefDimsIter = dimColl.iterator();
                row.setUserObject((Object)info);
                int index = 1;
                while (visibleRefDimsIter.hasNext()) {
                    ReferencedDimensionInfo refDimInfo = (ReferencedDimensionInfo)visibleRefDimsIter.next();
                    BgDimensionEnum dimEnum = refDimInfo.getBgDimension();
                    String refName = dimEnum.getName();
                    ICell cell = row.getCell(refName);
                    cell.setValue(info.get("bgItem" + index));
                    ++index;
                }
            }
        }
        BgFormEditHelper.fillBgFormTable(currentBgEntries, this.kdtBgFormData, isMultiCurrency, this.kindName);
        this.kdtBgFormData.getGroupManager().group();
    }

    @Override
    public void onLoad() throws Exception {
        this.btnCopy.setVisible(false);
        this.txtNumber.setEditable(false);
        this.txtName.setEditable(false);
        this.btnSplit.setVisible(false);
        this.fieldName = this.kindName = (String)this.getUIContext().get("kindName");
        this.saveType = "noBgValue";
        super.onLoad();
        this.separator3.setVisible(false);
        this.actionSubmit.setBindWorkFlow(false);
        this.actionSave.setBindWorkFlow(false);
    }

    @Override
    public void setIcon() {
        this.btnImpActualExcel.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnExpActualExcel.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnBgPostil.setIcon(EASResource.getIcon((String)"imgTbtn_reportpostil"));
        this.btnAgree.setIcon(EASResource.getIcon((String)"imgTbtn_postil"));
        this.btnViewBgPostil.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnViewLog.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
    }

    @Override
    protected void treeBgPeriod_valueChanged(TreeSelectionEvent e) throws Exception {
        this.kindName = (String)this.getUIContext().get("kindName");
        if (!this.treeBgPeriod.isEnabled()) {
            return;
        }
        BgPeriodNode bgPeriodNode = BgClientHelper.getCurrentBgPeriodNode(this.treeBgPeriod);
        if (bgPeriodNode == null) {
            return;
        }
        BgEntryCollection currentBgEntries = new BgEntryCollection();
        if (bgPeriodNode.isLeaf()) {
            currentBgEntries.addCollection(this.editData.getBgEntries(bgPeriodNode.getPeriod(), bgPeriodNode.getBgCycle()));
        } else {
            currentBgEntries.addCollection(this.editData.getSummedBgEntries(bgPeriodNode.getPeriod(), bgPeriodNode.getBgCycle(), this.kindName));
        }
        this.fillDataByPeriod(currentBgEntries);
        try {
            this.kdtBgFormData.getScriptManager().runAll();
        }
        catch (Exception err) {
            err.getMessage();
        }
        BgFormEditHelper.colorRow(this.kdtBgFormData, this.editData);
        this.lockTable(bgPeriodNode);
        BgFormEditHelper.initRowRelation(this.editData.getBgTemplate(), this.kdtBgFormData);
        BgFormEditHelper.initColumnRelation(this.editData.getBgTemplate(), this.kdtBgFormData);
    }

    @Override
    protected void kdtBgFormData_editStopped(KDTEditEvent e) throws Exception {
        int editedRowIndex = e.getRowIndex();
        int editedColIndex = e.getColIndex();
        String value = null;
        Object valueObj = this.kdtBgFormData.getRow(editedRowIndex).getCell(editedColIndex).getValue();
        if (valueObj == null) {
            valueObj = "0";
        }
        if (!(valueObj instanceof String)) {
            return;
        }
        value = ((String)valueObj).trim();
        if (!BgClientHelper.verifyIsNumber(value)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"inputNumber"));
            this.kdtBgFormData.getEditManager().editCellAt(editedRowIndex, editedColIndex);
            return;
        }
        DecimalFormat format = BgClientHelper.getDecimalFormat();
        value = format.format(new BigDecimal(value));
        this.kdtBgFormData.getRow(editedRowIndex).getCell(editedColIndex).setValue((Object)value);
        this.updateCell(this.kdtBgFormData.getRow(editedRowIndex).getCell(editedColIndex));
        if (this.kdtBgFormData.getRow(editedRowIndex).getUserObject() instanceof BgEntryInfo) {
            BgEntryInfo updatedBgEntryInfo = (BgEntryInfo)this.kdtBgFormData.getRow(editedRowIndex).getUserObject();
            BgDataInfo updatedBgDataInfo = (BgDataInfo)this.kdtBgFormData.getRow(editedRowIndex).getCell(editedColIndex).getUserObject();
            String elementKey = this.kdtBgFormData.getColumnKey(editedColIndex);
            if (this.columnSubjectTable != null && this.columnSubjectTable.get(elementKey) != null) {
                BgDataColumnSubject columnSubject = (BgDataColumnSubject)this.columnSubjectTable.get(elementKey);
                columnSubject.setBgEntryInfo(updatedBgEntryInfo);
                columnSubject.setBgDataInfo(updatedBgDataInfo);
                columnSubject.setNrow(editedRowIndex);
                columnSubject.notifyChange();
            }
        }
    }

    public void updateCell(ICell cell) {
        if (cell.getUserObject() == null) {
            return;
        }
        BgDataInfo bgDataInfo = (BgDataInfo)cell.getUserObject();
        if (cell.getValue() == null) {
            bgDataInfo.setBigDecimal(this.kindName, new BigDecimal("0"));
        } else {
            String stringValue = cell.getValue().toString().trim();
            BigDecimal decimal = null;
            try {
                decimal = new BigDecimal(stringValue);
            }
            catch (NumberFormatException e) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"inputNumber"));
                this.kdtBgFormData.getEditManager().editCellAt(cell.getRowIndex(), cell.getColumnIndex());
                SysUtil.abort();
            }
            bgDataInfo.setBigDecimal(this.kindName, decimal);
        }
    }

    public String getUITitle() {
        if (this.kindName.equals("bgValue")) {
            return BGNAME1;
        }
        if (this.kindName.equals("bizActual")) {
            return BGNAME2;
        }
        return super.getUITitle();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.doSave(e);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        BgClientHelper.refreshBgFormList((CoreUI)this);
        this.getUIWindow().close();
    }
}

