/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTCellScriptEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTCellScriptListener;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgAssistantDimensionEnum;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgDataTypeEnum;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgEntryCollection;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgFormDAHelper;
import com.kingdee.eas.ma.bg.BgFormException;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgPastRecordInfo;
import com.kingdee.eas.ma.bg.BgPeriodRange;
import com.kingdee.eas.ma.bg.BgSchemeCollection;
import com.kingdee.eas.ma.bg.BgSchemeFactory;
import com.kingdee.eas.ma.bg.BgTemplateColumnCollection;
import com.kingdee.eas.ma.bg.BgTemplateColumnInfo;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTypeCollection;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgScheme;
import com.kingdee.eas.ma.bg.IBgType;
import com.kingdee.eas.ma.bg.ReferencedCurrencyCollection;
import com.kingdee.eas.ma.bg.ReferencedCurrencyFactory;
import com.kingdee.eas.ma.bg.ReferencedCurrencyInfo;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.ma.bg.client.BgDataColumnObserver;
import com.kingdee.eas.ma.bg.client.BgDataColumnSubject;
import com.kingdee.eas.ma.bg.client.BgFormEditUI;
import com.kingdee.eas.ma.bg.client.BizBgFormEditHandler;
import com.kingdee.eas.ma.bg.client.CashFlowBgFormEditHandler;
import com.kingdee.eas.ma.bg.client.IBgDataChangeSubject;
import com.kingdee.eas.ma.bg.client.IBgFormEditHandler;
import com.kingdee.eas.ma.bg.client.RptBgFormEditHandler;
import com.kingdee.eas.util.SysUtil;
import java.awt.Color;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class BgFormEditHelper {
    private static final String PLUS = "+";
    private static final String EQUAL_GETVALUE = ").getValue()";
    private static final String CELL_ = "cell(";
    private static final String EQUAL_MARK = "=";
    private static final String COMMA = ",";
    public static final String EDIT_ORG = "EditOrg";
    public static final String EDIT_CTRL_ORG = "EditCtrlOrg";
    public static final String EDIT_BGTYPE = "BgType";
    public static final String EDIT_ORGIDPATH = "OrgIDPath";

    public static void fillBgFormTable(BgEntryCollection bgEntries, KDTable kdTable, boolean isMultiCurrency) {
        BgFormEditHelper.fillBgFormTable(bgEntries, kdTable, isMultiCurrency, "BgValue");
    }

    public static void fillBgEntry(boolean isMultiCurrency, BgEntryInfo bgEntryInfo, IRow row) {
        BgFormEditHelper.fillBgEntry(isMultiCurrency, bgEntryInfo, row, "BgValue");
    }

    public static void fillBgFormTable(BgEntryCollection bgEntries, KDTable kdTable, boolean isMultiCurrency, String kindName) {
        kdTable.getScriptManager().setAutoRun(false);
        Iterator bgEntryIter = bgEntries.iterator();
        int cursorRow = 0;
        while (bgEntryIter.hasNext()) {
            BgEntryInfo bgEntryInfo = (BgEntryInfo)bgEntryIter.next();
            IRow row = kdTable.getRow(cursorRow);
            ++cursorRow;
            BgFormEditHelper.fillBgEntry(isMultiCurrency, bgEntryInfo, row, kindName);
        }
        kdTable.getScriptManager().setAutoRun(true);
    }

    public static void fillBgEntry(boolean isMultiCurrency, BgEntryInfo bgEntryInfo, IRow row, String kindName) {
        DecimalFormat format = BgClientHelper.getDecimalFormat();
        BigDecimal zero = new BigDecimal("0");
        row.getCell(0).setUserObject((Object)bgEntryInfo);
        Iterator bgDataIter = bgEntryInfo.getBgData().iterator();
        while (bgDataIter.hasNext()) {
            BgDataInfo bgDataInfo = (BgDataInfo)bgDataIter.next();
            String cellKey = null;
            cellKey = isMultiCurrency && bgDataInfo.getDataType().getValue() == 1 ? BgHelper.getBgElementKey(bgDataInfo.getBgElement(), bgDataInfo.getCurrency()) : BgHelper.getBgElementKey(bgDataInfo.getBgElement(), null);
            ICell cell = row.getCell(cellKey);
            if (cell == null) continue;
            if (bgDataInfo.getBigDecimal(kindName) == null) {
                bgDataInfo.setBigDecimal(kindName, zero);
            }
            cell.setValue((Object)bgDataInfo.getBigDecimal(kindName).divide(new BigDecimal(1), 2, 6));
            cell.setUserObject((Object)bgDataInfo);
        }
    }

    public static void updateCell(ICell cell) {
        if (cell.getUserObject() == null) {
            return;
        }
        BgDataInfo bgDataInfo = (BgDataInfo)cell.getUserObject();
        BigDecimal val = null;
        if (cell.getValue() == null) {
            val = new BigDecimal("0");
        } else {
            String stringValue = cell.getValue().toString().trim();
            val = new BigDecimal(stringValue);
        }
        bgDataInfo.setBgValue(val);
    }

    public static Hashtable generateColumnSubjectTable(BgFormInfo editData, KDTable kdTable, Vector periodNodeVector) {
        Hashtable<String, BgDataColumnSubject> subjectTalbe = new Hashtable<String, BgDataColumnSubject>();
        Hashtable formulaTable = editData.getBgTemplate().getFormulaTable();
        Iterator keyIter = formulaTable.keySet().iterator();
        while (keyIter.hasNext()) {
            String elementKey = keyIter.next().toString();
            String theFormula = formulaTable.get(elementKey).toString();
            BgDataColumnObserver bgDataColumnObserver = new BgDataColumnObserver(elementKey, theFormula, editData, periodNodeVector, kdTable);
            Iterator bgTpColIter = editData.getBgTemplate().getBgTpColumns().iterator();
            while (bgTpColIter.hasNext()) {
                String theNumber = ((BgTemplateColumnInfo)bgTpColIter.next()).getBgElement().getNumber();
                if (theFormula.indexOf(theNumber) == -1) continue;
                if (subjectTalbe.get(theNumber) == null) {
                    BgDataColumnSubject bgDataColumnSubject = new BgDataColumnSubject(theNumber);
                    subjectTalbe.put(theNumber, bgDataColumnSubject);
                }
                IBgDataChangeSubject theSubject = (IBgDataChangeSubject)subjectTalbe.get(theNumber);
                theSubject.attach(bgDataColumnObserver);
            }
        }
        return subjectTalbe;
    }

    public static void initRowRelation(BgTemplateInfo bgTemplateInfo, KDTable kdtBgFormData, int size) {
        Vector colVector = BgFormEditHelper.getSumableColumn(bgTemplateInfo, kdtBgFormData);
        int visibleDimsCount = bgTemplateInfo.getVisibleDims().size();
        if (colVector.size() == 0) {
            return;
        }
        block0: for (int nrow = 0; nrow < kdtBgFormData.getRowCount(); ++nrow) {
            IRow row = kdtBgFormData.getRow(nrow);
            for (int ncol = 0; ncol < visibleDimsCount; ++ncol) {
                BgItemInfo bgItemInfo = (BgItemInfo)row.getCell(ncol).getValue();
                if (bgItemInfo.isIsLeaf()) continue;
                Vector rowVector = null;
                rowVector = visibleDimsCount == 1 ? BgFormEditHelper.getLeafRows(kdtBgFormData, nrow, bgItemInfo) : BgFormEditHelper.getLeafRows(kdtBgFormData, nrow, visibleDimsCount);
                if (rowVector.size() == 0) continue;
                for (int i = 0; i < colVector.size(); ++i) {
                    int theCol = (Integer)colVector.get(i);
                    StringBuffer sb = new StringBuffer(64);
                    sb.append(EQUAL_MARK);
                    for (int j = 0; j < rowVector.size(); ++j) {
                        if (j % (size + 1) != 0) continue;
                        int theRow = (Integer)rowVector.get(j);
                        sb.append(CELL_);
                        sb.append(theRow + 1);
                        sb.append(COMMA);
                        sb.append(theCol + 1);
                        sb.append(EQUAL_GETVALUE);
                        if (j == (rowVector.size() / (size + 1) - 1) * (size + 1)) continue;
                        sb.append(PLUS);
                    }
                    row.getCell(theCol).setExpressions(sb.toString());
                }
                continue block0;
            }
        }
    }

    public static Vector getSumableColumn(BgTemplateInfo bgTemplateInfo, KDTable kdtBgFormData) {
        Vector<Integer> colVector = new Vector<Integer>();
        BgTemplateColumnCollection tpCols = bgTemplateInfo.getBgTpColumns();
        int size = tpCols.size();
        for (int j = 0; j < size; ++j) {
            BgTemplateColumnInfo bgTpColInfo = tpCols.get(j);
            BgElementInfo bgElementInfo = bgTpColInfo.getBgElement();
            if (!bgElementInfo.isSummable()) continue;
            if (bgElementInfo.getDataType().equals((Object)BgDataTypeEnum.Amount) && bgTemplateInfo.getRefCurrencies().size() > 1) {
                for (int i = 0; i < bgTemplateInfo.getRefCurrencies().size(); ++i) {
                    CurrencyInfo cyInfo = bgTemplateInfo.getRefCurrencies().get(i).getCurrency();
                    colVector.add(new Integer(kdtBgFormData.getColumnIndex(BgHelper.getBgElementKey(bgElementInfo, cyInfo))));
                }
                continue;
            }
            colVector.add(new Integer(kdtBgFormData.getColumnIndex(BgHelper.getBgElementKey(bgElementInfo, null))));
        }
        return colVector;
    }

    public static Vector getLeafRows(KDTable kdtBgFormData, int nrow, BgItemInfo totalBgItemInfo) {
        BgItemInfo bgItemInfo;
        Vector<Integer> v = new Vector<Integer>();
        for (int i = nrow + 1; i < kdtBgFormData.getRowCount() && (bgItemInfo = (BgItemInfo)kdtBgFormData.getRow(i).getCell(0).getValue()).getLongNumber() != null; ++i) {
            if (!bgItemInfo.getLongNumber().startsWith(totalBgItemInfo.getLongNumber()) || !bgItemInfo.isIsLeaf()) continue;
            v.add(new Integer(i));
        }
        return v;
    }

    private static String[] getItemsArray(IRow row, int visibleDimCount) {
        String[] basicItemKeyArray = new String[visibleDimCount];
        for (int i = 0; i < visibleDimCount; ++i) {
            basicItemKeyArray[i] = ((BgItemInfo)row.getCell(i).getValue()).getLongNumber();
        }
        return basicItemKeyArray;
    }

    private static BgItemInfo[] getItemInfoArray(IRow row, int visibleDimCount) {
        BgItemInfo[] basicItemKeyArray = new BgItemInfo[visibleDimCount];
        for (int i = 0; i < visibleDimCount; ++i) {
            basicItemKeyArray[i] = (BgItemInfo)row.getCell(i).getValue();
        }
        return basicItemKeyArray;
    }

    private static boolean checkLeafEntry(IRow row, int visibleDimCount) {
        for (int i = 0; i < visibleDimCount; ++i) {
            BgItemInfo bii = (BgItemInfo)row.getCell(i).getValue();
            if (bii == null) {
                return true;
            }
            if (bii.isIsLeaf()) continue;
            return false;
        }
        return true;
    }

    public static void lockColumn(BgTemplateInfo bgTpInfo, KDTable kdtBgFormData) {
        Iterator iter = bgTpInfo.getBgTpColumns().iterator();
        while (iter.hasNext()) {
            BgTemplateColumnInfo bgTpColInfo = (BgTemplateColumnInfo)iter.next();
            if (bgTpColInfo.getBgElement().isEnabled()) continue;
            if (bgTpInfo.getRefCurrencies().size() > 1) {
                for (int i = 0; i < bgTpInfo.getRefCurrencies().size(); ++i) {
                    String elementKey = BgHelper.getBgElementKey(bgTpColInfo.getBgElement(), bgTpInfo.getRefCurrencies().get(i).getCurrency());
                    kdtBgFormData.getColumn(elementKey).getStyleAttributes().setLocked(true);
                }
                continue;
            }
            String elementKey = BgHelper.getBgElementKey(bgTpColInfo.getBgElement(), null);
            kdtBgFormData.getColumn(elementKey).getStyleAttributes().setLocked(true);
        }
        int size = bgTpInfo.getVisibleDims().size();
        int columnCount = kdtBgFormData.getColumnCount();
        for (int i = 0; i < size && i < columnCount; ++i) {
            kdtBgFormData.getColumn(i).getStyleAttributes().setLocked(true);
        }
    }

    public static void lockRow(KDTable kdtBgFormData) {
        int size = kdtBgFormData.getRowCount();
        for (int i = 0; i < size; ++i) {
            ICell cell = kdtBgFormData.getRow(i).getCell(0);
            if (cell == null) {
                return;
            }
            BgEntryInfo bei = (BgEntryInfo)cell.getUserObject();
            if (bei == null || bei.isIsLeafEntry()) continue;
            kdtBgFormData.getRow(i).getStyleAttributes().setLocked(true);
        }
    }

    public static void colorRow(KDTable kdtBgFormData, BgFormInfo editData) {
        int columnCount = kdtBgFormData.getColumnCount();
        if (!editData.getBgType().isIsRptBgForm()) {
            int size = kdtBgFormData.getRowCount();
            for (int i = 0; i < size; ++i) {
                ICell cell = kdtBgFormData.getRow(i).getCell(0);
                if (cell == null) {
                    return;
                }
                BgEntryInfo bei = (BgEntryInfo)cell.getUserObject();
                if (bei == null || bei.isIsLeafEntry()) continue;
                for (int j = 0; j < columnCount; ++j) {
                    kdtBgFormData.getRow(i).getCell(j).getStyleAttributes().setBackground(new Color(0xF6F6B6));
                }
            }
        } else {
            int size = kdtBgFormData.getRowCount();
            for (int i = 0; i < size; ++i) {
                ICell cell = kdtBgFormData.getRow(i).getCell(1);
                if (cell == null) {
                    return;
                }
                if (cell.getExpressions() == null) continue;
                kdtBgFormData.getRow(cell.getRowIndex()).getStyleAttributes().setBackground(new Color(0xF6F6B6));
            }
        }
    }

    public static void initPeriodTree(KDTree treeBgPeriod, BgFormInfo editData) {
        BgFormEditHelper.initPeriodTree(treeBgPeriod, BgPeriodRange.getPeriodNodes(editData.getBgEntries()));
    }

    public static void initPeriodTree(KDTree treeBgPeriod, Vector periodNodeVector) {
        treeBgPeriod.setEnabled(false);
        treeBgPeriod.setRootVisible(false);
        DefaultKingdeeTreeNode root = BgClientHelper.getPeriodTreeRoot(periodNodeVector);
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)root);
        treeBgPeriod.setModel((TreeModel)treeModel);
        treeBgPeriod.setEnabled(true);
        treeBgPeriod.expandAllNodes(true, (TreeNode)root);
    }

    public static void initComboBoxBgScheme(BgFormInfo editData, KDComboBox comboBoxBgScheme) throws BOSException, EASBizException {
        IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
        BgSchemeCollection bgSchemes = iBgScheme.getCollectionByOrgUnit(editData.getOrgUnit());
        comboBoxBgScheme.setEnabled(false);
        comboBoxBgScheme.removeAllItems();
        comboBoxBgScheme.addItems(bgSchemes.toArray());
        comboBoxBgScheme.setSelectedIndex(-1);
        comboBoxBgScheme.setEnabled(true);
    }

    public static IBgFormEditHandler generateEditHandler(BgTypeInfo bgTypeInfo) {
        BizBgFormEditHandler ihandler = null;
        if ("CashFlowStatementBudget".equals(bgTypeInfo.getNumber())) {
            ihandler = new CashFlowBgFormEditHandler();
        } else if (bgTypeInfo.isIsRptBgForm()) {
            ihandler = new RptBgFormEditHandler();
        } else if (!bgTypeInfo.isIsRptBgForm()) {
            ihandler = new BizBgFormEditHandler();
        }
        return ihandler;
    }

    public static void colorPastRecord(BgFormInfo bfi, KDTable kdTable) {
        int nRowCount = kdTable.getRowCount();
        int maxRecordSeq = bfi.getMaxRecordSeq();
        String strSubAcctColumn = BgAssistantDimensionEnum.SUB_ACCOUNT.getName();
        int startIndex = kdTable.getColumnIndex(strSubAcctColumn);
        if (startIndex <= 0) {
            String strOrgColumn = BgAssistantDimensionEnum.SUB_ORGUNIT.getName();
            startIndex = kdTable.getColumnIndex(strOrgColumn);
        }
        ++startIndex;
        int nColumnCount = kdTable.getColumnCount();
        for (int i = 0; i < nRowCount; ++i) {
            IRow iRow = kdTable.getRow(i);
            for (int j = startIndex; j < nColumnCount; ++j) {
                ICell iCell = iRow.getCell(j);
                Object obj = iCell.getUserObject();
                if (!(obj instanceof BgDataInfo)) continue;
                BgDataInfo bgDataInfo = (BgDataInfo)obj;
                HashMap treeMap = bfi.getAllPastDataByBgData(bgDataInfo);
                if (treeMap.size() > 0) {
                    iCell.getStyleAttributes().setBackground(new Color(16771687));
                    continue;
                }
                iCell.getStyleAttributes().setBackground(Color.WHITE);
            }
        }
    }

    public static void bandCurrencyInfo(KDBizPromptBox kDBizPromptBox, BgTemplateInfo bgTemplateInfo) {
        if (kDBizPromptBox == null) {
            return;
        }
        CurrencyInfo[] cys = null;
        if (bgTemplateInfo == null) {
            kDBizPromptBox.setData(cys);
        } else {
            cys = new CurrencyInfo[bgTemplateInfo.getRefCurrencies().size()];
            for (int i = 0; i < bgTemplateInfo.getRefCurrencies().size(); ++i) {
                CurrencyInfo cyInfo;
                cys[i] = cyInfo = bgTemplateInfo.getRefCurrencies().get(i).getCurrency();
            }
            kDBizPromptBox.setData((Object)cys);
        }
    }

    public static void bandCurrencyInfoV2(KDBizPromptBox kDBizPromptBox, BgTemplateInfo bgTemplateInfo) {
        if (kDBizPromptBox == null) {
            return;
        }
        CurrencyInfo[] cys = null;
        if (bgTemplateInfo == null) {
            kDBizPromptBox.setData(cys);
        } else {
            ReferencedCurrencyCollection rcc = null;
            if (bgTemplateInfo.getRefCurrencies() != null && bgTemplateInfo.getRefCurrencies().size() > 0) {
                rcc = bgTemplateInfo.getRefCurrencies();
            } else {
                try {
                    rcc = ReferencedCurrencyFactory.getRemoteInstance().getReferencedCurrencyCollection("select currency.* where bgTemplate='" + bgTemplateInfo.getId().toString() + "'");
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            cys = new CurrencyInfo[rcc.size()];
            for (int i = 0; i < rcc.size(); ++i) {
                CurrencyInfo cyInfo;
                cys[i] = cyInfo = rcc.get(i).getCurrency();
            }
            kDBizPromptBox.setData((Object)cys);
        }
    }

    public static void commonLoadField(BgFormEditUI ui) {
        if (ui.editData == null) {
            return;
        }
        ui.txtNumber.setText(ui.editData.getNumber());
        ui.txtName.setText(ui.editData.getName());
        ui.bizPromptOrgUnit.setData((Object)ui.editData.getOrgUnit());
        ui.bizPromptBgTemplate.setData((Object)ui.editData.getBgTemplate());
        ui.bizPromptCreator.setData((Object)ui.editData.getLastUpdateUser());
        ui.kdtBizDate.setValue((Object)ui.editData.getLastUpdateTime());
    }

    public static void loadFields(BgFormEditUI ui) {
        if (ui.getOprtState().equals("VIEW")) {
            Object obj = ui.getUIContext().get("state");
            int state = 0;
            if (obj != null) {
                state = (Integer)obj;
            }
            ui.btnBgPostil.setVisible(true);
            ui.btnAgree.setVisible(true);
        } else {
            ui.btnBgPostil.setVisible(false);
            ui.btnAgree.setVisible(false);
        }
        ui.kDBizPromptBoxCurrency.setEnabledMultiSelection(true);
        BgFormDAHelper.addModelLisener(ui.editData, ui.bgFormAry, ui.bgEntryAry, ui.bgDataAry, ui.bgPastRecAry, ui.bgPstDataAry);
        ui.newBgItems = new Hashtable();
        BgFormEditHelper.commonLoadField(ui);
        try {
            BgFormEditHelper.afterLoadFields(ui);
        }
        catch (EASBizException e) {
            ui.handUIException(e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            ui.handUIException(e);
            SysUtil.abort();
        }
        Iterator iteratorTemp = ui.editData.getBgEntries().iterator();
        while (iteratorTemp.hasNext()) {
            BgEntryInfo bgEntryInfoTemp = (BgEntryInfo)iteratorTemp.next();
            bgEntryInfoTemp.setBgForm(ui.editData);
        }
        Iterator iteratorTemp1 = ui.editData.getPastRecords().iterator();
        while (iteratorTemp1.hasNext()) {
            BgPastRecordInfo bgPastRecordInfo = (BgPastRecordInfo)iteratorTemp1.next();
            bgPastRecordInfo.setBgForm(ui.editData);
        }
    }

    public static void afterLoadFields(BgFormEditUI ui) throws EASBizException, BOSException {
        ui.kdtBgFormData.checkParsed();
        ui.kdtBgFormData.setFormulaMode(1);
        StyleAttributes sa = ui.kdtBgFormData.getStyleAttributes();
        sa.setBorderPenStyle(Styles.Position.RIGHT, PenStyle.PS_SOLID);
        sa.setBorderColor(Styles.Position.RIGHT, ui.kdtBgFormData.getGridLineColor());
        sa.setBorderPenStyle(Styles.Position.BOTTOM, PenStyle.PS_SOLID);
        sa.setBorderColor(Styles.Position.RIGHT, ui.kdtBgFormData.getGridLineColor());
        final KDTable table = ui.kdtBgFormData;
        ui.kdtBgFormData.getScriptManager().addKDTCellScriptListener(new KDTCellScriptListener(){

            public void cellScriptBegin(KDTCellScriptEvent arg0) {
            }

            public void cellScriptEnd(KDTCellScriptEvent arg0) {
                ICell cell = table.getRow(arg0.getRowIndex()).getCell(arg0.getColIndex());
                Object theObj = cell.getValue();
                if (theObj instanceof String) {
                    String theValue = (String)theObj;
                    if (theValue == null) {
                        return;
                    }
                    if (BgClientHelper.verifyIsNumber(theValue)) {
                        BgFormEditHelper.updateCell(cell);
                    }
                } else if (theObj instanceof BigDecimal) {
                    BgFormEditHelper.updateCell(cell);
                }
            }
        });
        if (ui.getOprtState().equals("ADDNEW")) {
            BgFormEditHelper.afterLoadFields_AddNew(ui);
        } else {
            BgFormEditHelper.afterLoadFields_Edit(ui);
        }
        ui.goLeaf();
    }

    public static void afterLoadFields_AddNew(BgFormEditUI ui) throws EASBizException, BOSException {
        ui.separator3.setVisible(false);
        ui.treeBgPeriod.setModel(null);
        FullOrgUnitInfo inOrgUnitInfo = (FullOrgUnitInfo)ui.getUIContext().get(EDIT_ORG);
        if (inOrgUnitInfo == null) {
            throw new EASBizException(BgFormException.NOORG);
        }
        ui.bizPromptOrgUnit.setData((Object)inOrgUnitInfo);
        ui.editData.setOrgUnit(inOrgUnitInfo);
        IOrgUnitCommon iOrg = OrgUnitCommonFactory.getRemoteInstance();
        CompanyOrgUnitInfo companyInfo = iOrg.getCompany(ui.editData.getOrgUnit().getId());
        ui.editData.setCompany(companyInfo);
        BgClientHelper.initDefaultCreator(ui.bizPromptCreator);
        ui.kdtBizDate.setValue((Object)Calendar.getInstance().getTime());
        BgFormEditHelper.initComboBoxBgScheme(ui.editData, ui.comboBoxBgScheme);
        IBgType ibt = BgTypeFactory.getRemoteInstance();
        int orgView = (Integer)inOrgUnitInfo.get("treeType");
        BgTypeCollection btc = null;
        if (!OrgViewType.getEnum((int)orgView).equals((Object)OrgViewType.RESPONSECENTER)) {
            btc = ibt.getCollection(NewOrgViewHelper.convert((OrgViewType)OrgViewType.getEnum((int)orgView)).getValue());
        } else {
            BgTypeInfo info;
            int i;
            int n;
            Hashtable<BOSUuid, BgTypeInfo> hash;
            if (inOrgUnitInfo.isIsCompanyOrgUnit()) {
                btc = ibt.getCollection(1);
                hash = new Hashtable<BOSUuid, BgTypeInfo>();
                n = btc.size();
                for (i = 0; i < n; ++i) {
                    info = btc.get(i);
                    hash.put(info.getId(), info);
                }
            }
            if (!inOrgUnitInfo.isIsCompanyOrgUnit() && inOrgUnitInfo.isIsProfitOrgUnit()) {
                btc = ibt.getCollection(6);
                hash = new Hashtable();
                n = btc.size();
                for (i = 0; i < n; ++i) {
                    info = btc.get(i);
                    hash.put(info.getId(), info);
                }
            }
            if (!inOrgUnitInfo.isIsCompanyOrgUnit() && !inOrgUnitInfo.isIsProfitOrgUnit() && inOrgUnitInfo.isIsCostOrgUnit()) {
                btc = ibt.getCollection(5);
                hash = new Hashtable();
                n = btc.size();
                for (i = 0; i < n; ++i) {
                    info = btc.get(i);
                    hash.put(info.getId(), info);
                }
            }
        }
        if (btc == null) {
            throw new EASBizException(BgFormException.ERRORONINITBGTYPE);
        }
        ui.comboBoxBgType.setEnabled(false);
        ui.comboBoxBgType.addItems(btc.toArray());
        ui.comboBoxBgType.setSelectedIndex(-1);
        ui.comboBoxBgType.setEnabled(true);
        ui.setNumberByRule();
    }

    public static void afterLoadFields_Edit(BgFormEditUI ui) {
        if (ui.editHandler == null) {
            ui.editHandler = BgFormEditHelper.generateEditHandler(ui.editData.getBgType());
        }
        ui.initFormArea();
        ui.comboBoxBgScheme.removeAllItems();
        ui.comboBoxBgScheme.setEnabled(false);
        ui.comboBoxBgScheme.addItem((Object)ui.editData.getBgScheme());
        ui.comboBoxBgType.setEnabled(false);
        ui.comboBoxBgType.removeAllItems();
        ui.comboBoxBgType.addItem((Object)ui.editData.getBgType());
        ui.determineBindWf();
    }

    public static void initRowRelation(BgTemplateInfo bgTemplateInfo, KDTable kdtBgFormData) {
        Vector colVector = BgFormEditHelper.getSumableColumn(bgTemplateInfo, kdtBgFormData);
        int visibleDimsCount = bgTemplateInfo.getVisibleDims().size();
        if (colVector.size() == 0) {
            return;
        }
        for (int nrow = 0; nrow < kdtBgFormData.getRowCount(); ++nrow) {
            IRow row = kdtBgFormData.getRow(nrow);
            BgItemInfo[] vecBgItemInfo = new BgItemInfo[visibleDimsCount];
            boolean isAllLeafItem = true;
            int n = visibleDimsCount;
            for (int k = 0; k < n; ++k) {
                vecBgItemInfo[k] = (BgItemInfo)row.getCell(k).getValue();
                boolean bl = isAllLeafItem = isAllLeafItem && vecBgItemInfo[k].isIsLeaf();
                if (!isAllLeafItem) break;
            }
            if (isAllLeafItem) continue;
            Vector rowVector = null;
            rowVector = visibleDimsCount == 1 ? BgFormEditHelper.getLeafRows(kdtBgFormData, 0, vecBgItemInfo[0]) : BgFormEditHelper.getLeafRows(kdtBgFormData, nrow, visibleDimsCount);
            if (rowVector.size() == 0) continue;
            for (int i = 0; i < colVector.size(); ++i) {
                int theCol = (Integer)colVector.get(i);
                StringBuffer sb = new StringBuffer(64);
                sb.append(EQUAL_MARK);
                for (int j = 0; j < rowVector.size(); ++j) {
                    int theRow = (Integer)rowVector.get(j);
                    sb.append(CELL_);
                    sb.append(theRow + 1);
                    sb.append(COMMA);
                    sb.append(theCol + 1);
                    sb.append(EQUAL_GETVALUE);
                    if (j == rowVector.size() - 1) continue;
                    sb.append(PLUS);
                }
                row.getCell(theCol).setExpressions(sb.toString());
            }
        }
    }

    private static Vector getLeafRows(KDTable kdtBgFormData, int nrow, int visibleDimCount) {
        IRow row = kdtBgFormData.getRow(nrow);
        BgItemInfo[] basicItemArray = BgFormEditHelper.getItemInfoArray(row, visibleDimCount);
        Vector<Integer> vector = new Vector<Integer>();
        int size = kdtBgFormData.getRowCount();
        for (int i = nrow + 1; i < size; ++i) {
            row = kdtBgFormData.getRow(i);
            if (!BgFormEditHelper.checkLeafEntry(row, visibleDimCount)) continue;
            BgItemInfo[] itemArray = BgFormEditHelper.getItemInfoArray(row, visibleDimCount);
            boolean isSub = true;
            for (int j = 0; j < visibleDimCount && isSub; ++j) {
                BgItemInfo item = itemArray[j];
                BgItemInfo basicItem = basicItemArray[j];
                if (item.getLongNumber() != null) {
                    if (item.getLongNumber().startsWith(basicItem.getLongNumber())) continue;
                    isSub = false;
                    continue;
                }
                if (item.equals(basicItem)) continue;
                isSub = false;
            }
            if (!isSub) continue;
            vector.add(new Integer(i));
        }
        return vector;
    }

    public static void initColumnRelation(BgTemplateInfo template, KDTable table) {
        int i;
        Hashtable<String, String> name2Formula = new Hashtable<String, String>();
        BgTemplateColumnCollection tpColumnCol = template.getBgTpColumns();
        int n = tpColumnCol.size();
        for (int i2 = 0; i2 < n; ++i2) {
            BgTemplateColumnInfo tpColumn = tpColumnCol.get(i2);
            String formula = tpColumn.getFormula();
            if (formula == null || formula.trim().equals("")) continue;
            name2Formula.put(tpColumn.getBgElement().getName(), formula);
        }
        Hashtable<String, String> currName2Number = new Hashtable<String, String>();
        ReferencedCurrencyCollection tpCurrencyCol = template.getRefCurrencies();
        int n2 = tpCurrencyCol.size();
        for (i = 0; i < n2; ++i) {
            ReferencedCurrencyInfo tpCurrency = tpCurrencyCol.get(i);
            currName2Number.put(tpCurrency.getCurrency().getName(), tpCurrency.getCurrency().getNumber());
        }
        n2 = table.getColumnCount();
        for (i = 0; i < n2; ++i) {
            String element = (String)table.getHeadRow(0).getCell(i).getValue();
            String currency = null;
            if (table.getHeadRow(1) != null) {
                currency = (String)table.getHeadRow(1).getCell(i).getValue();
            }
            if (!name2Formula.containsKey(element)) continue;
            Hashtable<String, Integer> name2Index = new Hashtable<String, Integer>();
            int m = tpColumnCol.size();
            for (int j = 0; j < m; ++j) {
                String elementName = tpColumnCol.get(j).getBgElement().getName();
                String elementNumber = tpColumnCol.get(j).getBgElement().getNumber();
                if (elementName.equals(element)) continue;
                String key = null;
                if (currency == null) {
                    key = elementNumber;
                } else {
                    String currencyNumber = (String)currName2Number.get(currency);
                    key = elementNumber + "_" + currencyNumber;
                }
                int index = table.getColumnIndex(key);
                name2Index.put(elementName, new Integer(index));
            }
            String formula = (String)name2Formula.get(element);
            int m2 = table.getRowCount();
            for (int row = 0; row < m2; ++row) {
                String expression = "= " + (String)name2Formula.get(element);
                Enumeration keys = name2Index.keys();
                while (keys.hasMoreElements()) {
                    String elementName = (String)keys.nextElement();
                    Integer index = (Integer)name2Index.get(elementName);
                    String replace = " cell(" + (row + 1) + COMMA + (index + 1) + ").getValue() ";
                    expression = expression.replaceAll(elementName, replace);
                }
                expression = expression.replaceAll(" ", "");
                ICell iCell = table.getRow(row).getCell(i);
                iCell.setExpressions(expression);
                iCell.getStyleAttributes().setLocked(true);
                iCell.getStyleAttributes().setBackground(new Color(0xF6F6B6));
            }
        }
    }
}

