/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.ma.bg.AbstractReferencedDimensionInfo;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgFormQuerySchemaHelper;
import com.kingdee.eas.ma.bg.BgPeriodNode;
import com.kingdee.eas.ma.bg.BgPeriodRange;
import com.kingdee.eas.ma.bg.BgSchemeFactory;
import com.kingdee.eas.ma.bg.BgSchemeInfo;
import com.kingdee.eas.ma.bg.BgTemplateColumnCollection;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.IBgScheme;
import com.kingdee.eas.ma.bg.ReferencedCurrencyCollection;
import com.kingdee.eas.ma.bg.ReferencedDimensionCollection;
import com.kingdee.eas.ma.bg.ReferencedDimensionInfo;
import com.kingdee.eas.ma.bg.client.AbstractBgFormQSFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class BgFormQSFilterUI
extends AbstractBgFormQSFilterUI {
    public String bgTypeId = "";
    public PeriodInfo periodBegin;
    public PeriodInfo periodEnd;
    public int showTypeOrg;
    public int showTypePeriod;
    public boolean isOK = false;
    private BgSchemeInfo bgScheme;
    private PeriodCollection periodColl = new PeriodCollection();
    private KDCheckBox[] dimBox;
    private KDCheckBox[] eleBox;
    private KDCheckBox[] currencyBox;
    private static final int HEIGHT = 20;
    private static final int HOFFSET = 5;
    private static final int ROWCOUNT = 3;
    private static final int WIDTH = 100;
    private static final int INITX = 1;
    private static final int INITY = 16;
    private static String msgSelectDim = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"msgSelectDim");
    private static String msgSelectEle = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"msgSelectEle");
    private static String msgSelectCurr = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"msgSelectCurr");

    @Override
    protected void kDButtonOK_actionPerformed(ActionEvent e) throws Exception {
        Serializable info;
        int i;
        ArrayList[] list = new ArrayList[]{new ArrayList(10), new ArrayList(10), new ArrayList(10)};
        for (i = 0; i < this.dimBox.length; ++i) {
            if (!this.dimBox[i].isSelected()) continue;
            info = (ReferencedDimensionInfo)this.dimBox[i].getUserObject();
            list[0].add(info.getId().toString() + "=" + ((AbstractReferencedDimensionInfo)info).getBgDimension().getAlias());
        }
        if (list[0].size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)msgSelectDim);
            SysUtil.abort();
        }
        for (i = 0; i < this.eleBox.length; ++i) {
            if (!this.eleBox[i].isSelected()) continue;
            info = (BgElementInfo)this.eleBox[i].getUserObject();
            list[1].add(info.getId().toString() + "=" + info.getNumber());
        }
        if (list[1].size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)msgSelectEle);
            SysUtil.abort();
        }
        for (i = 0; i < this.currencyBox.length; ++i) {
            if (!this.currencyBox[i].isSelected()) continue;
            info = (CurrencyInfo)this.currencyBox[i].getUserObject();
            list[2].add(info.getId().toString() + "=" + info.getNumber());
        }
        if (list[2].size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)msgSelectCurr);
            SysUtil.abort();
        }
        HashMap<String, ArrayList[]> map = new HashMap<String, ArrayList[]>();
        String currTypeId = (String)this.getUIContext().get("currTypeId");
        map.put(currTypeId, list);
        this.bgTypeId = BgFormQuerySchemaHelper.createComplexStr(map);
        int tmpIndex = this.kDComboBoxBeginTime.getSelectedIndex();
        this.periodBegin = this.periodColl.get(tmpIndex);
        tmpIndex = this.kDComboBoxEndTime.getSelectedIndex();
        this.periodEnd = this.periodColl.get(tmpIndex);
        int numberBegin = this.periodBegin.getPeriodYear() * 100 + this.periodBegin.getPeriodNumber();
        int numberEnd = this.periodEnd.getPeriodYear() * 100 + this.periodEnd.getPeriodNumber();
        if (numberBegin > numberEnd) {
            PeriodInfo tmpPeriod = this.periodBegin;
            this.periodBegin = this.periodEnd;
            this.periodEnd = tmpPeriod;
        }
        this.showTypeOrg = this.kDRadioButtonOrgRow.isSelected() ? 1 : 2;
        this.showTypePeriod = this.kDRadioButtonPeriodRow.isSelected() ? 1 : 2;
        this.isOK = true;
        this.getUIWindow().close();
    }

    @Override
    protected void kDButtonCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    public void onLoad() throws Exception {
        int i;
        super.onLoad();
        Map context = this.getUIContext();
        this.kDTextFieldBgType.setText((String)context.get("currTypeName"));
        String schemeId = (String)context.get("bgSchemeId");
        IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
        this.bgScheme = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(schemeId));
        this.kDTextFieldBgScheme.setText(this.bgScheme.getName());
        this.periodBegin = this.bgScheme.getPeriodFrom();
        this.periodEnd = this.bgScheme.getPeriodTo();
        BgPeriodRange range = new BgPeriodRange(this.periodBegin, this.periodEnd);
        Vector vector = range.getPeriodNodesInRange(this.bgScheme.getCompany(), BgCycleTypeEnum.Period);
        int m = vector.size();
        for (i = 0; i < m; ++i) {
            BgPeriodNode tmpInfo = (BgPeriodNode)vector.get(i);
            if (tmpInfo.getBgCycle() != BgCycleTypeEnum.Period) continue;
            this.periodColl.add(tmpInfo.getPeriod());
        }
        m = this.periodColl.size();
        for (i = 0; i < m; ++i) {
            this.kDComboBoxBeginTime.addItem((Object)this.periodColl.get(i));
            this.kDComboBoxEndTime.addItem((Object)this.periodColl.get(i));
        }
        this.kDComboBoxBeginTime.setSelectedIndex(0);
        this.kDComboBoxEndTime.setSelectedIndex(this.kDComboBoxEndTime.getItemCount() - 1);
        String begin = (String)this.getUIContext().get("beginPeriod");
        String end = (String)this.getUIContext().get("endPeriod");
        int m2 = this.periodColl.size();
        for (int i2 = 0; i2 < m2; ++i2) {
            if (this.kDComboBoxBeginTime.getItemAt(i2).toString().equals(begin)) {
                this.kDComboBoxBeginTime.setSelectedIndex(i2);
            }
            if (!this.kDComboBoxEndTime.getItemAt(i2).toString().equals(end)) continue;
            this.kDComboBoxEndTime.setSelectedIndex(i2);
        }
        this.showTypeOrg = (Integer)context.get("orgShowType");
        this.showTypePeriod = (Integer)context.get("periodShowType");
        if (this.showTypeOrg == 1) {
            this.kDRadioButtonOrgRow.setSelected(true);
        } else {
            this.kDRadioButtonOrgCol.setSelected(true);
        }
        if (this.showTypePeriod == 1) {
            this.kDRadioButtonPeriodRow.setSelected(true);
        } else {
            this.kDRadioButtonPeriodCol.setSelected(true);
        }
        this.bgTypeId = (String)context.get("bgTypeId");
        BgTemplateInfo temInfo = (BgTemplateInfo)context.get("temInfo");
        List selectedDim = (List)context.get("selectedDim");
        List selectedEle = (List)context.get("selectedEle");
        List selectedCurrency = (List)context.get("selectedCurrency");
        this.displayDimension(temInfo.getRefDimensions(), selectedDim);
        this.displayElement(temInfo.getBgTpColumns(), selectedEle);
        this.displayCurrency(temInfo.getRefCurrencies(), selectedCurrency);
    }

    private void displayDimension(ReferencedDimensionCollection dimColl, List selected) {
        int size = dimColl.size();
        this.dimBox = new KDCheckBox[size];
        int offset = 0;
        int heigh = 19;
        int hoffset = 10;
        this.kDPanelDimension.removeAll();
        for (int i = 0; i < size; ++i) {
            this.dimBox[i] = new KDCheckBox();
            this.dimBox[i].setText(dimColl.get(i).getBgDimension().getAlias());
            this.dimBox[i].setToolTipText(dimColl.get(i).getBgDimension().getAlias());
            this.dimBox[i].setUserObject((Object)dimColl.get(i));
            this.setPosition(this.dimBox[i], i, offset);
            if (selected.contains(dimColl.get(i).getId().toString())) {
                this.dimBox[i].setSelected(true);
            } else {
                this.dimBox[i].setSelected(false);
            }
            this.kDPanelDimension.add((Component)this.dimBox[i], null);
            if ((i + 1) % 3 == 0) {
                offset = 0;
                continue;
            }
            offset += 95;
        }
        this.repaintPal(this.kDPanelDimension);
    }

    private void displayElement(BgTemplateColumnCollection eleColl, List selected) {
        int size = eleColl.size();
        this.eleBox = new KDCheckBox[size];
        int offset = 0;
        int heigh = 19;
        int hoffset = 10;
        this.kDPanelElement.removeAll();
        for (int i = 0; i < size; ++i) {
            this.eleBox[i] = new KDCheckBox();
            this.eleBox[i].setText(eleColl.get(i).getBgElement().getName());
            this.eleBox[i].setToolTipText(eleColl.get(i).getBgElement().getName());
            this.eleBox[i].setUserObject((Object)eleColl.get(i).getBgElement());
            this.setPosition(this.eleBox[i], i, offset);
            if (selected.contains(eleColl.get(i).getBgElement().getId().toString())) {
                this.eleBox[i].setSelected(true);
            } else {
                this.eleBox[i].setSelected(false);
            }
            this.kDPanelElement.add((Component)this.eleBox[i], null);
            if ((i + 1) % 3 == 0) {
                offset = 0;
                continue;
            }
            offset += 95;
        }
        this.repaintPal(this.kDPanelElement);
    }

    private void displayCurrency(ReferencedCurrencyCollection currColl, List selected) {
        int size = currColl.size();
        this.currencyBox = new KDCheckBox[size];
        int offset = 0;
        int heigh = 19;
        int hoffset = 10;
        this.kDPanelCurrency.removeAll();
        for (int i = 0; i < size; ++i) {
            this.currencyBox[i] = new KDCheckBox();
            this.currencyBox[i].setText(currColl.get(i).getCurrency().getName());
            this.currencyBox[i].setToolTipText(currColl.get(i).getCurrency().getName());
            this.currencyBox[i].setUserObject((Object)currColl.get(i).getCurrency());
            this.setPosition(this.currencyBox[i], i, offset);
            if (selected.contains(currColl.get(i).getCurrency().getId().toString())) {
                this.currencyBox[i].setSelected(true);
            } else {
                this.currencyBox[i].setSelected(false);
            }
            this.kDPanelCurrency.add((Component)this.currencyBox[i], null);
            if ((i + 1) % 3 == 0) {
                offset = 0;
                continue;
            }
            offset += 95;
        }
        this.repaintPal(this.kDPanelCurrency);
    }

    private void setPosition(KDCheckBox box, int index, int offset) {
        int x = 1;
        x = index % 3 == 0 ? 1 : 1 + offset;
        int y = 16;
        int row = index / 3;
        if (row > 0) {
            y = 41 * row;
        }
        box.setBounds(new Rectangle(x, y, 100, 20));
    }

    private void repaintPal(KDPanel pal) {
        pal.invalidate();
        if (pal.getParent() != null) {
            pal.getParent().validate();
        }
        pal.repaint();
    }
}

