/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.client.FormulaPickerUI;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.fi.rpt.client.IFormulaPickerListener;
import com.kingdee.eas.fi.rpt.client.IFormulaWizardListener;
import com.kingdee.eas.fi.rpt.client.RptFormulaComp;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.bg.BgDataTypeEnum;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgFormulaFactory;
import com.kingdee.eas.ma.bg.BgFormulaInfo;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgModelNodeInfo;
import com.kingdee.eas.ma.bg.BgSchemeHelper;
import com.kingdee.eas.ma.bg.BgTemplateColumnInfo;
import com.kingdee.eas.ma.bg.BgTemplateDAFactory;
import com.kingdee.eas.ma.bg.BgTemplateFactory;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTemplateRowInfo;
import com.kingdee.eas.ma.bg.IBgFormula;
import com.kingdee.eas.ma.bg.IBgTemplate;
import com.kingdee.eas.ma.bg.IBgTemplateDA;
import com.kingdee.eas.ma.bg.client.AbstractBgFormulaEditUI;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Map;

public class BgFormulaEditUI
extends AbstractBgFormulaEditUI {
    BgModelNodeInfo bgModelNodeInfo = null;
    BgTemplateInfo bgTemplateInfo = null;

    @Override
    public void actionCtrlC_actionPerformed(ActionEvent e) throws Exception {
        super.actionCtrlC_actionPerformed(e);
        this.kDTableFormula.getEditHelper().copy();
    }

    @Override
    public void actionCtrlV_actionPerformed(ActionEvent e) throws Exception {
        super.actionCtrlV_actionPerformed(e);
        this.kDTableFormula.getEditHelper().paste();
    }

    protected IObjectValue createNewData() {
        return new BgFormulaInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgFormulaFactory.getRemoteInstance();
    }

    protected void onKDButtonCancle_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    @Override
    protected void onKDButtonConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.saveFormula();
        this.getUIWindow().close();
    }

    protected void showFormula() throws EASBizException, BOSException {
        Map uIContext = this.getUIContext();
        this.bgModelNodeInfo = (BgModelNodeInfo)uIContext.get("ID");
        this.bgTemplateInfo = this.bgModelNodeInfo.getBgTemplate();
        if (this.bgTemplateInfo != null) {
            IBgTemplateDA iBgTemplateDA = BgTemplateDAFactory.getRemoteInstance();
            this.bgTemplateInfo = iBgTemplateDA.getBgTemplate(this.bgTemplateInfo.getId().toString());
        }
        BgClientHelper.initBgFormTable(this.bgTemplateInfo, this.kDTableFormula);
        if (this.bgModelNodeInfo != null) {
            Iterator iterator = this.bgModelNodeInfo.getBgFormulas().iterator();
            while (iterator.hasNext()) {
                int currCell;
                boolean isMultiCurrency;
                BgElementInfo bgElementInfo;
                BgFormulaInfo bgFormulaInfo = (BgFormulaInfo)iterator.next();
                if (bgFormulaInfo.getId() != null && bgFormulaInfo.getFormula() == null) {
                    IBgFormula iBgFormula = BgFormulaFactory.getRemoteInstance();
                    SelectorItemCollection selectorItemCollection = BgSchemeHelper.getFormulaDecSelector();
                    bgFormulaInfo = (BgFormulaInfo)iBgFormula.getValue((IObjectPK)new ObjectUuidPK(bgFormulaInfo.getId()), selectorItemCollection);
                }
                String strRowKey = this.getRowKey(bgFormulaInfo);
                int currRow = -1;
                int rowCount = this.kDTableFormula.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    IRow iRow = this.kDTableFormula.getRow(i);
                    if (iRow.getUserObject() == null || !iRow.getUserObject().equals(strRowKey)) continue;
                    currRow = i;
                    break;
                }
                if (currRow == -1 || (bgElementInfo = bgFormulaInfo.getBgElement()) == null) continue;
                String strNumber = bgElementInfo.getNumber();
                boolean bl = isMultiCurrency = this.bgTemplateInfo.getRefCurrencies().size() > 1;
                if (bgFormulaInfo.getCurrency() != null && isMultiCurrency) {
                    strNumber = strNumber + "_" + bgFormulaInfo.getCurrency().getNumber();
                }
                if ((currCell = this.kDTableFormula.getColumnIndex(strNumber)) == -1) continue;
                IRow currIRow = this.kDTableFormula.getRow(currRow);
                ICell iCell = currIRow.getCell(currCell);
                iCell.setValue((Object)bgFormulaInfo.getFormula());
                iCell.setUserObject((Object)bgFormulaInfo);
                String itemsKey = (String)currIRow.getUserObject();
                for (int i = 0; i < this.bgTemplateInfo.getBgTpRows().size(); ++i) {
                    BgTemplateRowInfo btri = this.bgTemplateInfo.getBgTpRows().get(i);
                    if (btri.getBgItemsKey() != itemsKey) continue;
                    bgFormulaInfo.setBgItem1(btri.getBgItem1());
                    bgFormulaInfo.setBgItem2(btri.getBgItem2());
                    bgFormulaInfo.setBgItem3(btri.getBgItem3());
                    bgFormulaInfo.setBgItem4(btri.getBgItem4());
                    bgFormulaInfo.setBgItem5(btri.getBgItem5());
                    bgFormulaInfo.setBgItem6(btri.getBgItem6());
                    break;
                }
                String elementKey = this.kDTableFormula.getColumn(currCell).getKey();
                for (int i = 0; i < this.bgTemplateInfo.getBgTpColumns().size(); ++i) {
                    BgTemplateColumnInfo bgTemplateColumnInfo = this.bgTemplateInfo.getBgTpColumns().get(i);
                    if (isMultiCurrency) {
                        String theElementNumber = bgTemplateColumnInfo.getBgElement().getNumber();
                        if (elementKey.indexOf(theElementNumber) == -1) continue;
                        bgFormulaInfo.setBgElement(bgTemplateColumnInfo.getBgElement());
                        break;
                    }
                    if (!bgTemplateColumnInfo.getBgElement().getNumber().equals(elementKey)) continue;
                    bgFormulaInfo.setBgElement(bgTemplateColumnInfo.getBgElement());
                    break;
                }
                if (bgFormulaInfo.getBgElement().getDataType() != null && bgFormulaInfo.getBgElement().getDataType().equals((Object)BgDataTypeEnum.Amount)) {
                    if (isMultiCurrency) {
                        String cyNumber = StringUtils.split((String)elementKey, (String)"_")[1];
                        for (int i = 0; i < this.bgTemplateInfo.getRefCurrencies().size(); ++i) {
                            CurrencyInfo cyInfo = this.bgTemplateInfo.getRefCurrencies().get(i).getCurrency();
                            if (!cyInfo.getNumber().equals(cyNumber)) continue;
                            bgFormulaInfo.setCurrency(cyInfo);
                        }
                    } else {
                        bgFormulaInfo.setCurrency(this.bgTemplateInfo.getRefCurrencies().get(0).getCurrency());
                    }
                }
                iCell.setUserObject((Object)bgFormulaInfo);
                PeriodInfo periodInfo = bgFormulaInfo.getPeriod();
            }
        }
        this.setBtnEnableByTemplate(this.bgTemplateInfo);
    }

    protected String getRowKey(BgFormulaInfo bgFormulaInfo) {
        BgItemInfo[] bgItemInfoArray = new BgItemInfo[6];
        if (bgFormulaInfo.getBgItem1() == null) {
            return null;
        }
        bgItemInfoArray[0] = bgFormulaInfo.getBgItem1();
        bgItemInfoArray[1] = bgFormulaInfo.getBgItem2();
        bgItemInfoArray[2] = bgFormulaInfo.getBgItem3();
        bgItemInfoArray[3] = bgFormulaInfo.getBgItem4();
        bgItemInfoArray[4] = bgFormulaInfo.getBgItem5();
        bgItemInfoArray[5] = bgFormulaInfo.getBgItem6();
        StringBuffer buff = new StringBuffer(192);
        String strRowKey = bgItemInfoArray[0].getItemNumber();
        buff.append(strRowKey);
        for (int i = 1; i < bgItemInfoArray.length && bgItemInfoArray[i] != null; ++i) {
            buff.append("_");
            buff.append(bgItemInfoArray[i].getItemNumber());
        }
        return buff.toString();
    }

    public void saveFormula() {
        if (this.bgModelNodeInfo != null) {
            this.bgModelNodeInfo.getBgFormulas().clear();
            int size = this.bgModelNodeInfo.getBgFormulas().size();
            int rowCount = this.kDTableFormula.getRowCount();
            int columnCount = this.kDTableFormula.getColumnCount();
            boolean formulaStartColumn = false;
            for (int i = 0; i < rowCount; ++i) {
                IRow iRow = this.kDTableFormula.getRow(i);
                for (int j = 0; j < columnCount; ++j) {
                    ICell iCell = iRow.getCell(j);
                    if (iCell.getUserObject() == null || !(iCell.getUserObject() instanceof BgFormulaInfo)) continue;
                    BgFormulaInfo bgFormulaInfo = this.createBgFormulaInfo(iRow, j);
                    iCell.setUserObject((Object)bgFormulaInfo);
                    bgFormulaInfo.setFormula((String)iCell.getValue());
                    bgFormulaInfo.setBgModelNode(this.bgModelNodeInfo);
                    this.bgModelNodeInfo.getBgFormulas().add(bgFormulaInfo);
                }
            }
        }
    }

    public void onLoad() throws Exception {
        this.kDButtonCopyToColumn.setIcon(EASResource.getIcon((String)"imgTbtn_copyformulatorow"));
        this.kDButtonPickerFormula.setIcon(EASResource.getIcon((String)"imgTbtn_importformulaguide"));
        this.kDButtonConfirm.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnCtrlC.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.btnCtrlV.setIcon(EASResource.getIcon((String)"imgTbtn_paste"));
        this.btnCtrlC.setEnabled(true);
        this.btnCtrlV.setEnabled(true);
        this.hideWorkBtn();
        this.kDTableFormula.checkParsed();
        this.showFormula();
        int m = this.kDTableFormula.getColumnCount();
        block0: for (int j = 0; j < m; ++j) {
            String element = (String)this.kDTableFormula.getHeadRow(0).getCell(j).getValue();
            int n = this.bgTemplateInfo.getBgTpColumns().size();
            for (int i = 0; i < n; ++i) {
                BgTemplateColumnInfo info = this.bgTemplateInfo.getBgTpColumns().get(i);
                if (!info.getBgElement().getName().equals(element)) continue;
                String formula = info.getFormula();
                if (formula == null || formula.trim().equals("")) continue block0;
                int l = this.kDTableFormula.getRowCount();
                for (int k = 0; k < l; ++k) {
                    this.kDTableFormula.getRow(k).getCell(j).getStyleAttributes().setLocked(true);
                    this.kDTableFormula.getRow(k).getCell(j).getStyleAttributes().setBackground(new Color(0xF6F6B6));
                }
                continue block0;
            }
        }
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.kDTableFormula.getStyleAttributes().setLocked(true);
        }
    }

    @Override
    protected void onkDWorkButtonPickerFormula(ActionEvent e) throws Exception {
        int dimSize = this.bgTemplateInfo.getVisibleDims().size();
        int index1 = this.kDTableFormula.getSelectManager().getActiveColumnIndex();
        if (index1 < dimSize) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"forbidEdit"));
            SysUtil.abort();
        }
        int index2 = this.kDTableFormula.getSelectManager().getActiveRowIndex();
        String element = (String)this.kDTableFormula.getHeadRow(0).getCell(index1).getValue();
        int n = this.bgTemplateInfo.getBgTpColumns().size();
        for (int i = 0; i < n; ++i) {
            String formula;
            BgTemplateColumnInfo info = this.bgTemplateInfo.getBgTpColumns().get(i);
            if (!info.getBgElement().getName().equals(element) || (formula = info.getFormula()) == null || formula.trim().equals("")) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"forbidFormula"));
            SysUtil.abort();
        }
        Object forumla = this.kDTableFormula.getRow(index2).getCell(index1).getValue();
        this.pickerFormula(forumla);
        String formula = (String)this.kDTableFormula.getRow(index2).getCell(index1).getValue();
        String orgNumber = this.bgTemplateInfo.getOrgUnit().getNumber();
        String bgTypeNumber = this.bgTemplateInfo.getBgType().getNumber();
        if (formula != null && formula.indexOf("BgFormula") >= 0 && formula.indexOf("\"" + orgNumber + "\"") >= 0 && formula.indexOf("\"" + bgTypeNumber + "\"") >= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"forbidSelect"));
            this.kDTableFormula.getRow(index2).getCell(index1).setValue((Object)"");
        }
    }

    protected void copyFormulaToColumn() {
        int rowCount;
        int currCell = this.kDTableFormula.getSelectManager().getActiveColumnIndex();
        int currRow = this.kDTableFormula.getSelectManager().getActiveRowIndex();
        if (currCell != 0 && (rowCount = this.kDTableFormula.getRowCount()) > 1) {
            IRow iRowValue = this.kDTableFormula.getRow(currRow);
            ICell iCellValue = iRowValue.getCell(currCell);
            String strFormula = (String)iCellValue.getValue();
            for (int i = 0; i < rowCount; ++i) {
                if (i == currRow) continue;
                IRow iRow = this.kDTableFormula.getRow(i);
                ICell iCell = iRow.getCell(currCell);
                if (iCell.getUserObject() == null) {
                    iCell.setUserObject((Object)this.createBgFormulaInfo(iRow, currCell));
                }
                iCell.setValue((Object)strFormula);
            }
        }
    }

    protected void pickerFormula(Object forumla) {
        String filter = "exclude:formulas{BgAcct,BgBalance}";
        PickerListener listener = new PickerListener();
        WizardListener wizardListener = new WizardListener();
        try {
            if (forumla != null) {
                FormulaHint hint = TableToolkit.parseFormula((String)forumla.toString());
                if (hint != null && RptFormulaComp.getInstance().getFormula(hint.getName()) != null) {
                    FormulaWizardUI wizard = FormulaWizardUI.creatFormulaWizard((Object)((Object)this));
                    wizard.addFormulaWizardListener((IFormulaWizardListener)wizardListener);
                    wizard.open(hint.getName(), hint);
                } else {
                    FormulaPickerUI picker = FormulaPickerUI.creatFormulaPicker((CoreUIObject)this);
                    picker.addFormulaPickerListener((IFormulaPickerListener)listener);
                    picker.open(filter, null);
                }
            } else {
                FormulaPickerUI picker = FormulaPickerUI.creatFormulaPicker((CoreUIObject)this);
                picker.addFormulaPickerListener((IFormulaPickerListener)listener);
                picker.open(filter, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void kDButtonCopyToColumn_actionPerformed(ActionEvent e) throws Exception {
        int dimSize = this.bgTemplateInfo.getVisibleDims().size();
        int index1 = this.kDTableFormula.getSelectManager().getActiveColumnIndex();
        if (index1 < dimSize) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"forbidCopy"));
            SysUtil.abort();
        }
        this.copyFormulaToColumn();
    }

    private void savePickerFourmula(String formulaLine) {
        int currRow = this.kDTableFormula.getSelectManager().getActiveRowIndex();
        int currCell = this.kDTableFormula.getSelectManager().getActiveColumnIndex();
        IRow iRow = this.kDTableFormula.getRow(currRow);
        ICell iCell = iRow.getCell(currCell);
        BgFormulaInfo bgFormulaInfo = (BgFormulaInfo)iCell.getUserObject();
        if (bgFormulaInfo == null) {
            bgFormulaInfo = this.createBgFormulaInfo(iRow, currCell);
            iCell.setUserObject((Object)bgFormulaInfo);
        }
        bgFormulaInfo.setFormula(formulaLine);
        iCell.setValue((Object)formulaLine);
    }

    private BgFormulaInfo createBgFormulaInfo(IRow iRow, int currCell) {
        BgFormulaInfo bgFormulaInfo = new BgFormulaInfo();
        String itemsKey = (String)iRow.getUserObject();
        for (int i = 0; i < this.bgTemplateInfo.getBgTpRows().size(); ++i) {
            BgTemplateRowInfo btri = this.bgTemplateInfo.getBgTpRows().get(i);
            if (!btri.getBgItemsKey().equals(itemsKey)) continue;
            bgFormulaInfo.setBgItem1(btri.getBgItem1());
            bgFormulaInfo.setBgItem2(btri.getBgItem2());
            bgFormulaInfo.setBgItem3(btri.getBgItem3());
            bgFormulaInfo.setBgItem4(btri.getBgItem4());
            bgFormulaInfo.setBgItem5(btri.getBgItem5());
            bgFormulaInfo.setBgItem6(btri.getBgItem6());
            break;
        }
        String elementKey = this.kDTableFormula.getColumn(currCell).getKey();
        boolean isMultiCurrency = this.bgTemplateInfo.getRefCurrencies().size() > 1;
        for (int i = 0; i < this.bgTemplateInfo.getBgTpColumns().size(); ++i) {
            BgTemplateColumnInfo bgTemplateColumnInfo = this.bgTemplateInfo.getBgTpColumns().get(i);
            if (isMultiCurrency) {
                String theElementNumber = bgTemplateColumnInfo.getBgElement().getNumber();
                if (elementKey.indexOf(theElementNumber) == -1) continue;
                bgFormulaInfo.setBgElement(bgTemplateColumnInfo.getBgElement());
                break;
            }
            if (!bgTemplateColumnInfo.getBgElement().getNumber().equals(elementKey)) continue;
            bgFormulaInfo.setBgElement(bgTemplateColumnInfo.getBgElement());
            break;
        }
        if (bgFormulaInfo != null && bgFormulaInfo.getBgElement() != null && bgFormulaInfo.getBgElement().getDataType().equals((Object)BgDataTypeEnum.Amount)) {
            if (isMultiCurrency) {
                String cyNumber = StringUtils.split((String)elementKey, (String)"_")[1];
                for (int i = 0; i < this.bgTemplateInfo.getRefCurrencies().size(); ++i) {
                    CurrencyInfo cyInfo = this.bgTemplateInfo.getRefCurrencies().get(i).getCurrency();
                    if (!cyInfo.getNumber().equals(cyNumber)) continue;
                    bgFormulaInfo.setCurrency(cyInfo);
                }
            } else {
                bgFormulaInfo.setCurrency(this.bgTemplateInfo.getRefCurrencies().get(0).getCurrency());
            }
        }
        return bgFormulaInfo;
    }

    public void hideWorkBtn() {
        this.btnSubmit.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnSave.setVisible(false);
        this.toolBar.setVisible(true);
    }

    private void setBtnEnableByTemplate(BgTemplateInfo bgTemplateInfo) {
        boolean isRef = false;
        try {
            IBgTemplate ibt = BgTemplateFactory.getRemoteInstance();
            isRef = ibt.checkRefByBgForm(bgTemplateInfo.getId());
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        if (isRef) {
            this.kDButtonCopyToColumn.setEnabled(false);
            this.kDButtonPickerFormula.setEnabled(false);
            this.kDButtonConfirm.setEnabled(false);
            this.kDTableFormula.getStyleAttributes().setLocked(true);
            this.btnCtrlC.setEnabled(false);
            this.btnCtrlV.setEnabled(false);
        }
    }

    @Override
    protected void kDTableFormula_editValueChanged(KDTEditEvent e) throws Exception {
        super.kDTableFormula_editValueChanged(e);
        int row = e.getRowIndex();
        int col = e.getColIndex();
        IRow iRow = this.kDTableFormula.getRow(row);
        ICell iCell = this.kDTableFormula.getRow(row).getCell(col);
        Object userObject = iCell.getUserObject();
        Object value = e.getValue();
        if (value == null) {
            if (userObject != null) {
                iCell.setUserObject(null);
            }
        } else {
            String fomula = (String)value;
            if (fomula.trim().equals("")) {
                if (userObject != null) {
                    iCell.setUserObject(null);
                }
            } else {
                BgFormulaInfo bgFormulaInfo = this.createBgFormulaInfo(iRow, col);
                iCell.setUserObject((Object)bgFormulaInfo);
            }
        }
    }

    class WizardListener
    implements IFormulaWizardListener {
        public void wizardSetout(FormulaWizardUI wizard) {
        }

        public void wizardReturnee(FormulaWizardUI wizard, String formulaLine, boolean isOk) {
            if (isOk) {
                BgFormulaEditUI.this.savePickerFourmula(formulaLine);
            }
        }
    }

    class PickerListener
    implements IFormulaPickerListener {
        public void pickerSetout(FormulaPickerUI picker) {
        }

        public void pickerReturnee(FormulaPickerUI picker, String formulaLine, boolean isOk) {
            if (isOk) {
                BgFormulaEditUI.this.savePickerFourmula(formulaLine);
            }
        }
    }
}

