/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.bg.BgDataFactory;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgDataTypeEnum;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgTemplateColumnCollection;
import com.kingdee.eas.ma.bg.BgTemplateColumnInfo;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.IBgData;
import com.kingdee.eas.ma.bg.ReferencedCurrencyInfo;
import com.kingdee.eas.ma.bg.ReferencedDimensionCollection;
import com.kingdee.eas.ma.bg.ReferencedDimensionInfo;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import java.util.Iterator;

public class BgIncClientHelper {
    public static BgFormInfo getBgForm(String bgDataId) throws EASBizException, BOSException {
        IBgData iBg = BgDataFactory.getRemoteInstance();
        String sql = "select bgEntry.bgForm.id, bgEntry.bgForm.number, bgEntry.bgForm.bgType, bgEntry.bgForm.company, bgEntry.bgForm.orgUnit, bgEntry.bgForm.bgTemplate  where id  ='" + bgDataId + "'";
        BgDataInfo result = iBg.getBgDataInfo(sql);
        return result.getBgEntry().getBgForm();
    }

    public static void initBgFormTable(BgTemplateInfo bgTpInfo, KDTable kdTable) {
        BgIncClientHelper.initBgFormTable_distribute(bgTpInfo, kdTable);
        kdTable.getHeadMergeManager().mergeBlock(0, 0, kdTable.getHeadRowCount() - 1, kdTable.getColumnCount() - 1, 3);
    }

    public static void initBgItemColumnAndRow(BgTemplateInfo bgTpInfo, KDTable kdTable) {
        ReferencedDimensionCollection visibleRefDims = bgTpInfo.getVisibleDims();
        Iterator visibleRefDimsIter = visibleRefDims.iterator();
        int columnCursor = 0;
        while (visibleRefDimsIter.hasNext()) {
            ReferencedDimensionInfo refDimInfo = (ReferencedDimensionInfo)visibleRefDimsIter.next();
            String refName = refDimInfo.getBgDimension().getName();
            IColumn ic = null;
            if (kdTable.getColumnIndex(refName) == -1) {
                ic = kdTable.addColumn(columnCursor);
                ic.setWidth(200);
                ic.setKey(refName);
            } else {
                ic = kdTable.getColumn(refName);
            }
            kdTable.getHeadRow(0).getCell(columnCursor).setValue((Object)refDimInfo.getBgDimension().getAlias(SysContext.getSysContext().getLocale()));
            ++columnCursor;
        }
        int itemColumnsNum = visibleRefDims.size();
        kdTable.getMergeManager().mergeBlock(0, 0, kdTable.getRowCount() - 1, itemColumnsNum - 1, 1);
    }

    public static void initBgFormTable_distribute(BgTemplateInfo bgTpInfo, KDTable kdTable) {
        int i;
        BgClientHelper.clearTable(kdTable);
        System.out.println("id:" + bgTpInfo.getId());
        IRow mainHeadRow = kdTable.addHeadRow();
        IRow multiCurrencyHeadRow = null;
        BgIncClientHelper.initBgItemColumnAndRow(bgTpInfo, kdTable);
        int columnCursor = kdTable.getColumnCount();
        BgTemplateColumnCollection tpCols = bgTpInfo.getBgTpColumns();
        boolean isMultiCurrency = bgTpInfo.getRefCurrencies().size() > 1;
        CurrencyInfo soloCurrency = null;
        if (!isMultiCurrency && bgTpInfo.getRefCurrencies().size() > 0) {
            soloCurrency = bgTpInfo.getRefCurrencies().get(0).getCurrency();
        }
        int size = tpCols.size();
        for (i = 0; i < size; ++i) {
            BgTemplateColumnInfo bgTpColInfo = tpCols.get(i);
            BgElementInfo bgElementInfo = bgTpColInfo.getBgElement();
            if (bgElementInfo.getDataType().equals((Object)BgDataTypeEnum.Amount) && isMultiCurrency) {
                if (multiCurrencyHeadRow == null) {
                    multiCurrencyHeadRow = kdTable.addHeadRow();
                }
                Iterator currencyIter = bgTpInfo.getRefCurrencies().iterator();
                while (currencyIter.hasNext()) {
                    ReferencedCurrencyInfo refCyInfo = (ReferencedCurrencyInfo)currencyIter.next();
                    CurrencyInfo cyInfo = refCyInfo.getCurrency();
                    IColumn ic = kdTable.addColumn(columnCursor);
                    ic.getStyleAttributes().setNumberFormat(BgClientHelper.getNumberFtm(cyInfo.getId()));
                    ic.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    ic.setMergeable(false);
                    ic.setKey(BgHelper.getBgElementKey(bgElementInfo, cyInfo));
                    mainHeadRow.getCell(columnCursor).setValue((Object)bgElementInfo);
                    multiCurrencyHeadRow.getCell(columnCursor).setValue((Object)cyInfo);
                    ++columnCursor;
                }
                continue;
            }
            IColumn ic = kdTable.addColumn(columnCursor);
            if (soloCurrency != null) {
                ic.getStyleAttributes().setNumberFormat(BgClientHelper.getNumberFtm(soloCurrency.getId()));
            } else {
                ic.getStyleAttributes().setNumberFormat(BgClientHelper.getNumberFtm());
            }
            ic.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            ic.setMergeable(false);
            ic.setKey(bgElementInfo.getNumber());
            mainHeadRow.getCell(columnCursor).setValue((Object)bgElementInfo);
            ++columnCursor;
        }
        if (multiCurrencyHeadRow != null) {
            for (i = 0; i < kdTable.getColumnCount(); ++i) {
                if (multiCurrencyHeadRow.getCell(i) == null || multiCurrencyHeadRow.getCell(i).getValue() != null) continue;
                multiCurrencyHeadRow.getCell(i).setValue(mainHeadRow.getCell(i).getValue());
            }
        }
    }
}

