/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.f7.OrgViewF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgIncGatherFilterParam;
import com.kingdee.eas.ma.bg.BgOrgHelper;
import com.kingdee.eas.ma.bg.BgTemplateColumnCollection;
import com.kingdee.eas.ma.bg.BgTemplateColumnInfo;
import com.kingdee.eas.ma.bg.BgTemplateDAFactory;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTypeCollection;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgType;
import com.kingdee.eas.ma.bg.ReferencedCurrencyCollection;
import com.kingdee.eas.ma.bg.ReferencedCurrencyInfo;
import com.kingdee.eas.ma.bg.ReferencedDimensionCollection;
import com.kingdee.eas.ma.bg.ReferencedDimensionInfo;
import com.kingdee.eas.ma.bg.ValidBgDimensionCollection;
import com.kingdee.eas.ma.bg.ValidBgDimensionInfo;
import com.kingdee.eas.ma.bg.client.AbstractBgIncGatherQueryPanel;
import com.kingdee.eas.ma.bg.client.BgItemDialog;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.ChangeEvent;

public class BgIncGatherQueryPanel
extends AbstractBgIncGatherQueryPanel {
    private OrgViewType[] orgView = null;
    private String orgUnitId = null;
    private String bgTypeId = null;
    private BgTemplateInfo bgTemInfo = null;
    private BgDimensionEnum bgDim = null;
    private BgTypeInfo bgType = null;
    private boolean isLoaded = false;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public Object getParam() {
        BgIncGatherFilterParam param = new BgIncGatherFilterParam();
        param.setBeginYear((Integer)this.beginYear.getValue());
        param.setBeginPeriod((Integer)this.beginPeriod.getValue());
        param.setEndYear((Integer)this.endYear.getValue());
        param.setEndPeriod((Integer)this.endPeriod.getValue());
        Object[] obj = (Object[])this.bizOrgUnit.getValue();
        if (obj[0] != null) {
            StringBuffer idBuf = new StringBuffer(192);
            for (int i = 0; i < obj.length; ++i) {
                FullOrgUnitInfo orgInfo = (FullOrgUnitInfo)obj[i];
                idBuf.append(orgInfo.getId().toString() + ",");
            }
            idBuf.deleteCharAt(idBuf.length() - 1);
            param.setOrgUnitId(idBuf.toString());
        }
        if (this.comboBgType.getSelectedItem() != null) {
            BgTypeInfo bgTypeInfo = (BgTypeInfo)this.comboBgType.getSelectedItem();
            param.setBgTypeId(bgTypeInfo.getId().toString());
        } else {
            param.setBgTypeId(null);
        }
        if (this.comboBgDim.getSelectedItem() != null) {
            param.setBgDim(((BgDimensionEnum)((Object)this.comboBgDim.getSelectedItem())).getValue());
        } else {
            param.setBgDim(-1);
        }
        if (this.bizItem.getValue() != null) {
            param.setBgItemIdId(this.bizItem.getValue().toString());
        } else {
            param.setBgItemIdId(null);
        }
        if (this.comboBgEle.getSelectedItem() != null) {
            param.setBgEleId(((BgElementInfo)this.comboBgEle.getSelectedItem()).getId().toString());
        } else {
            param.setBgEleId(null);
        }
        if (this.comboCurrency.getSelectedItem() != null) {
            param.setCurrencyId(((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString());
        } else {
            param.setCurrencyId(null);
        }
        if (this.raChecked.isSelected()) {
            param.setState(1);
        } else if (this.raNotChecked.isSelected()) {
            param.setState(2);
        } else if (this.raAll.isSelected()) {
            param.setState(3);
        }
        return param;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        filter.getFilterItems().add(new FilterItemInfo("beginYear", (Object)((Integer)this.beginYear.getValue())));
        filter.getFilterItems().add(new FilterItemInfo("beginPeriod", (Object)((Integer)this.beginPeriod.getValue())));
        filter.getFilterItems().add(new FilterItemInfo("endYear", (Object)((Integer)this.endYear.getValue())));
        filter.getFilterItems().add(new FilterItemInfo("endPeriod", (Object)((Integer)this.endPeriod.getValue())));
        if (this.bizOrgUnit.getData() != null) {
            Object[] obj = (Object[])this.bizOrgUnit.getData();
            String orgIds = "";
            for (int i = 0; i < obj.length; ++i) {
                orgIds = orgIds + ((OrgUnitInfo)obj[i]).getId().toString() + ",";
            }
            orgIds = orgIds.substring(0, orgIds.length() - 1);
            filter.getFilterItems().add(new FilterItemInfo("bizOrgUnit", (Object)orgIds));
        }
        if (this.comboBgType.getSelectedItem() != null) {
            filter.getFilterItems().add(new FilterItemInfo("bgType", (Object)((BgTypeInfo)this.comboBgType.getSelectedItem()).getId().toString()));
        }
        if (this.comboBgDim.getSelectedItem() != null) {
            filter.getFilterItems().add(new FilterItemInfo("bgdim", (Object)new Integer(((BgDimensionEnum)((Object)this.comboBgDim.getSelectedItem())).getValue())));
        }
        if (this.bizItem.getData() != null) {
            filter.getFilterItems().add(new FilterItemInfo("bgItem", (Object)((String)this.bizItem.getData())));
        }
        if (this.comboBgEle.getSelectedItem() != null) {
            filter.getFilterItems().add(new FilterItemInfo("bgEle", (Object)((BgElementInfo)this.comboBgEle.getSelectedItem()).getNumber()));
        }
        if (this.comboBgEle.getSelectedItem() != null) {
            filter.getFilterItems().add(new FilterItemInfo("bgEleDataType", (Object)new Integer(((BgElementInfo)this.comboBgEle.getSelectedItem()).getDataType().getValue())));
        }
        if (this.comboCurrency.getSelectedItem() != null) {
            filter.getFilterItems().add(new FilterItemInfo("currency", (Object)((CurrencyInfo)this.comboCurrency.getSelectedItem()).getNumber()));
        }
        if (this.raChecked.isSelected()) {
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1)));
        } else if (this.raNotChecked.isSelected()) {
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(2)));
        } else if (this.raAll.isSelected()) {
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(3)));
        }
        return filter;
    }

    public void setParam(Object param) {
        int state;
        String currencyId;
        int i;
        if (!(param instanceof BgIncGatherFilterParam)) {
            return;
        }
        BgIncGatherFilterParam fixedItemParam = (BgIncGatherFilterParam)param;
        this.beginYear.setValue((Object)new Integer(fixedItemParam.getBeginYear()));
        this.beginPeriod.setValue((Object)new Integer(fixedItemParam.getBeginPeriod()));
        this.endYear.setValue((Object)new Integer(fixedItemParam.getEndYear()));
        this.endPeriod.setValue((Object)new Integer(fixedItemParam.getEndPeriod()));
        String orgIds = fixedItemParam.getOrgUnitId();
        String[] ids = orgIds.split(",");
        FullOrgUnitInfo[] orgs = new FullOrgUnitInfo[ids.length];
        try {
            IFullOrgUnit iFull = FullOrgUnitFactory.getRemoteInstance();
            for (i = 0; i < ids.length; ++i) {
                orgs[i] = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(ids[i]));
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        this.bizOrgUnit.setValue((Object)orgs);
        if (fixedItemParam.getBgTypeId() != null) {
            for (i = 0; i < this.comboBgType.getItemCount(); ++i) {
                if (!fixedItemParam.getBgTypeId().equals(((BgTypeInfo)this.comboBgType.getItemAt(i)).getId().toString())) continue;
                this.comboBgType.setSelectedIndex(i);
                break;
            }
        }
        int bgDim = fixedItemParam.getBgDim();
        for (int i2 = 0; i2 < this.comboBgDim.getItemCount(); ++i2) {
            if (i2 == 0 || ((BgDimensionEnum)((Object)this.comboBgDim.getItemAt(i2))).getValue() != bgDim) continue;
            this.comboBgDim.setSelectedIndex(i2);
        }
        String bgItemId = fixedItemParam.getBgItemIdId();
        this.bizItem.setValue((Object)bgItemId);
        String bgEleId = fixedItemParam.getBgEleId();
        if (bgEleId != null) {
            for (int i3 = 0; i3 < this.comboBgEle.getItemCount(); ++i3) {
                if (i3 == 0 || !((BgElementInfo)this.comboBgEle.getItemAt(i3)).getId().toString().equals(bgEleId)) continue;
                this.comboBgEle.setSelectedIndex(i3);
            }
        }
        if ((currencyId = fixedItemParam.getCurrencyId()) != null) {
            for (int i4 = 0; i4 < this.comboCurrency.getItemCount(); ++i4) {
                if (i4 == 0 || !((CurrencyInfo)this.comboCurrency.getItemAt(i4)).getId().toString().equals(currencyId)) continue;
                this.comboCurrency.setSelectedIndex(i4);
            }
        }
        if ((state = fixedItemParam.getState()) == 1) {
            this.raChecked.setSelected(true);
        } else if (state == 2) {
            this.raNotChecked.setSelected(true);
        } else if (state == 3) {
            this.raAll.setSelected(true);
        }
    }

    public void onLoad() throws Exception {
        if (!this.isLoaded) {
            OrgUnitInfo org = SysContext.getSysContext().getCurrentOrgUnit();
            Vector vec = BgOrgHelper.getOrgViewTypes(org);
            this.orgView = new OrgViewType[vec.size()];
            for (int i = 0; i < vec.size(); ++i) {
                this.orgView[i] = (OrgViewType)vec.get(i);
            }
            this.initPeriod();
            this.initOrg();
            this.initBgType();
            this.initBgTem();
            this.initBgDim();
            this.initBgEle();
            this.initCurrency();
        }
        this.isLoaded = true;
        super.onLoad();
    }

    public void initPeriod() {
        Date date = new Date(System.currentTimeMillis());
        this.beginYear.setValue((Object)new Integer(date.getYear() + 1900));
        this.beginPeriod.setValue((Object)new Integer(date.getMonth() + 1));
        this.endYear.setValue((Object)new Integer(date.getYear() + 1900));
        this.endPeriod.setValue((Object)new Integer(date.getMonth() + 1));
    }

    public void initOrg() throws Exception {
        this.bizOrgUnit.setEnabled(false);
        OrgViewF7 orgF7 = new OrgViewF7((IUIObject)this);
        orgF7.setCuID(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        orgF7.setMultiSelect(true);
        orgF7.setOrgViewTypes(this.orgView);
        orgF7.setIsShowSub(true);
        orgF7.setTitle(EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"SelectOrgUnit"));
        this.bizOrgUnit.setSelector((KDPromptSelector)orgF7);
        Object obj = this.bizOrgUnit.getValue();
        if (obj == null || ((Object[])obj)[0] == null) {
            CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
            FullOrgUnitInfo info = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()));
            info.put("treeType", (Object)new Integer(1));
            if (info != null) {
                this.bizOrgUnit.setValue((Object)info);
            }
            this.orgUnitId = info.getId().toString();
        }
        this.bizOrgUnit.setEditFormat("$id$");
        this.bizOrgUnit.setDisplayFormat("$name$");
        this.bizOrgUnit.setEnabledMultiSelection(true);
        this.bizOrgUnit.setEnabled(true);
    }

    public void initBgType() throws Exception {
        Object[] obj = (Object[])this.bizOrgUnit.getValue();
        if (this.comboBgType.getItemCount() > 0) {
            this.comboBgType.removeAllItems();
        }
        IBgType ibtype = BgTypeFactory.getRemoteInstance();
        BgTypeCollection btc = ibtype.getCollection(BgOrgHelper.getOrgTypes((FullOrgUnitInfo)obj[0]));
        int size = btc.size();
        BgTypeInfo typeInfo = null;
        this.comboBgType.setEnabled(false);
        for (int i = 0; i < size; ++i) {
            typeInfo = btc.get(i);
            if (typeInfo.isIsRptBgForm()) continue;
            this.comboBgType.addItem((Object)typeInfo);
        }
        this.comboBgType.setEnabled(true);
        this.bgTypeId = btc.get(0).getId().toString();
    }

    @Override
    protected void bizOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.bizOrgUnit_dataChanged(e);
        if (!this.bizOrgUnit.isEnabled()) {
            return;
        }
        Object[] obj = (Object[])this.bizOrgUnit.getData();
        if (obj != null && obj[0] != null) {
            this.orgUnitId = ((FullOrgUnitInfo)obj[0]).getId().toString();
        }
        this.initBgType();
    }

    @Override
    protected void comboBgType_actionPerformed(ActionEvent e) throws Exception {
        super.comboBgType_actionPerformed(e);
        if (!this.comboBgType.isEnabled()) {
            return;
        }
        Object obj = this.comboBgType.getSelectedItem();
        if (obj != null) {
            this.bgTypeId = ((BgTypeInfo)obj).getId().toString();
            this.initBgTem();
            this.initBgDim();
            this.initBgEle();
            this.initCurrency();
        }
    }

    public String getBgTemId(String orgUnitId, String bgTypeId, int year, int period) throws BOSException, SQLException {
        String result = "";
        String periodStr = "(-1)";
        if (period >= 1 && period <= 3) {
            periodStr = "(1,2,3)";
        } else if (period >= 4 && period <= 6) {
            periodStr = "(4,5,6)";
        } else if (period >= 7 && period <= 9) {
            periodStr = "(7,8,9)";
        } else if (period >= 10 && period <= 12) {
            periodStr = "(10,11,12)";
        }
        StringBuffer sqlForm = new StringBuffer(40);
        sqlForm.append("select distinct a.fbgtemplateid temId from t_bg_bgform a ,t_bg_bgentry b ,t_bd_period c  where a.fid=b.fbgformid and b.fperiodid = c.fid and c.fperiodyear= " + year + " and c.fperiodnumber in " + periodStr + " and a.fstate=2 and a.fbgtypeid='" + bgTypeId + "' and a.forgunitid='" + orgUnitId + "'");
        ISQLExecutor iExecutor = SQLExecutorFactory.getRemoteInstance((String)sqlForm.toString());
        IRowSet irs = iExecutor.executeSQL();
        if (irs.next()) {
            result = irs.getString(1);
        }
        return result;
    }

    public void initBgTem() throws SQLException, EASBizException, BOSException {
        String bgTemId = this.getBgTemId(this.orgUnitId, this.bgTypeId, (Integer)this.beginYear.getValue(), (Integer)this.beginPeriod.getValue());
        if (bgTemId.equals("")) {
            this.bgTemInfo = null;
            return;
        }
        this.bgTemInfo = BgTemplateDAFactory.getRemoteInstance().getBgTemplate(bgTemId);
    }

    public void initBgDim() throws EASBizException, BOSException, SQLException {
        BgItemDialog dialog = new BgItemDialog((IUIObject)this);
        this.bgType = (BgTypeInfo)this.comboBgType.getSelectedItem();
        dialog.setBgTemInfo(this.bgTemInfo);
        dialog.setBgDim(this.bgDim);
        dialog.setBgType(this.bgType);
        this.bizItem.setSelector((KDPromptSelector)dialog);
        if (this.bgTemInfo == null) {
            if (this.bgType == null) {
                return;
            }
            if (this.bgType.isIsRptBgForm()) {
                this.comboBgDim.removeAllItems();
                this.comboBgDim.addItem(null);
                ValidBgDimensionCollection ValidDims = this.bgType.getValidBgDimensions();
                Iterator validDimsIter = ValidDims.iterator();
                while (validDimsIter.hasNext()) {
                    ValidBgDimensionInfo validDimInfo = (ValidBgDimensionInfo)validDimsIter.next();
                    this.comboBgDim.addItem((Object)validDimInfo.getBgDimension());
                }
                return;
            }
            return;
        }
        this.comboBgDim.removeAllItems();
        this.comboBgDim.addItem(null);
        ReferencedDimensionCollection visibleRefDims = this.bgTemInfo.getVisibleDims();
        Iterator visibleRefDimsIter = visibleRefDims.iterator();
        while (visibleRefDimsIter.hasNext()) {
            ReferencedDimensionInfo refDimInfo = (ReferencedDimensionInfo)visibleRefDimsIter.next();
            this.comboBgDim.addItem((Object)refDimInfo.getBgDimension());
        }
    }

    @Override
    protected void comboBgDim_actionPerformed(ActionEvent e) throws Exception {
        super.comboBgDim_actionPerformed(e);
        this.bizItem.setData(null);
        this.bgDim = this.comboBgDim.getSelectedItem() != null ? (BgDimensionEnum)((Object)this.comboBgDim.getSelectedItem()) : null;
        BgItemDialog dialog = new BgItemDialog((IUIObject)this);
        dialog.setBgTemInfo(this.bgTemInfo);
        dialog.setBgDim(this.bgDim);
        this.bizItem.setSelector((KDPromptSelector)dialog);
        this.bizItem.setData(null);
    }

    public void initBgEle() throws EASBizException, BOSException, SQLException {
        this.comboBgEle.removeAllItems();
        this.comboBgEle.addItem(null);
        if (this.bgTemInfo == null) {
            return;
        }
        BgTemplateColumnCollection tpColColl = this.bgTemInfo.getBgTpColumns();
        Iterator visibleTpColIter = tpColColl.iterator();
        while (visibleTpColIter.hasNext()) {
            BgTemplateColumnInfo tpColInfo = (BgTemplateColumnInfo)visibleTpColIter.next();
            this.comboBgEle.addItem((Object)tpColInfo.getBgElement());
        }
    }

    public void initCurrency() throws EASBizException, BOSException, SQLException {
        this.comboCurrency.removeAllItems();
        this.comboCurrency.addItem(null);
        if (this.bgTemInfo == null) {
            return;
        }
        ReferencedCurrencyCollection refCurrColl = this.bgTemInfo.getRefCurrencies();
        Iterator refCurrColIter = refCurrColl.iterator();
        while (refCurrColIter.hasNext()) {
            ReferencedCurrencyInfo refCurrInfo = (ReferencedCurrencyInfo)refCurrColIter.next();
            this.comboCurrency.addItem((Object)refCurrInfo.getCurrency());
        }
    }

    public BgTemplateInfo getBgTemInfo() {
        return this.bgTemInfo;
    }

    @Override
    protected void comboBgEle_actionPerformed(ActionEvent e) throws Exception {
        super.comboBgEle_actionPerformed(e);
        this.initCurrency();
    }

    @Override
    protected void comboCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.comboCurrency_actionPerformed(e);
    }

    @Override
    protected void beginPeriod_stateChanged(ChangeEvent e) throws Exception {
        super.beginPeriod_stateChanged(e);
        this.initBgTem();
        this.initBgDim();
        this.initBgEle();
        this.initCurrency();
    }

    @Override
    protected void beginYear_stateChanged(ChangeEvent e) throws Exception {
        super.beginYear_stateChanged(e);
        this.initBgTem();
        this.initBgDim();
        this.initBgEle();
        this.initCurrency();
    }
}

