/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootParser;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.bg.BgDataTypeEnum;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgIncreaseReqFormCollection;
import com.kingdee.eas.ma.bg.BgIncreaseReqFormEntryInfo;
import com.kingdee.eas.ma.bg.BgIncreaseReqFormFactory;
import com.kingdee.eas.ma.bg.BgIncreaseReqFormInfo;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgTemplateColumnCollection;
import com.kingdee.eas.ma.bg.BgTemplateColumnInfo;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.IBgIncreaseReqForm;
import com.kingdee.eas.ma.bg.ReferencedCurrencyInfo;
import com.kingdee.eas.ma.bg.client.AbstractBgIncGatherViewUI;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.ma.bg.client.BgIncGatherQueryPanel;
import com.kingdee.eas.ma.bg.client.BgIncreaseReqDataEditUI;
import com.kingdee.eas.ma.bg.client.BgIncreaseReqDataListUI;
import com.kingdee.eas.ma.bg.client.BgResource;
import com.kingdee.eas.ma.bg.client.ExcelFileFilter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.filechooser.FileFilter;

public class BgIncGatherViewUI
extends AbstractBgIncGatherViewUI {
    public final String RESOURCE = "com.kingdee.eas.ma.bg.client.BgIncreaseReqDataResource";

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void initTable() {
        IRow row = this.table.addHeadRow();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setIcon();
        this.table.checkParsed(true);
        this.table.getStyleAttributes().setLocked(true);
        this.table.getSelectManager().setSelectMode(2);
        this.table.getHeadMergeManager().setMergeMode(3);
        BgIncreaseReqFormCollection coll = (BgIncreaseReqFormCollection)((Object)this.getUIContext().get("BgInc"));
        BgTemplateInfo temInfo = (BgTemplateInfo)this.getUIContext().get("BgTemplate");
        Integer bgDim = (Integer)this.getUIContext().get("BgDim");
        String bgItem = (String)this.getUIContext().get("BgItem");
        String[] itemNumber = null;
        if (bgItem != null) {
            itemNumber = bgItem.split("&");
        }
        String bgEle = (String)this.getUIContext().get("BgEle");
        String currency = (String)this.getUIContext().get("Currency");
        int bgEleDataType = (Integer)this.getUIContext().get("BgEleDataType");
        this.initBgItemCol(temInfo, bgDim);
        this.initBgElementHeadRow(temInfo, this.table, bgEle, bgEleDataType, currency);
        this.initTableData(coll, temInfo, bgDim, itemNumber, bgEle, currency, bgEleDataType);
        this.initGather();
    }

    private void initTableData(BgIncreaseReqFormCollection coll, BgTemplateInfo temInfo, int bgDim, String[] itemNumber, String bgEle, String currency, int bgEleDataType) {
        if (temInfo == null) {
            return;
        }
        String eleNumber = "";
        String currencyNumber = "";
        int size = coll.size();
        block0: for (int i = 0; i < size; ++i) {
            BgIncreaseReqFormInfo bill = coll.get(i);
            int size1 = bill.getEntries().size();
            for (int j = 0; j < size1; ++j) {
                int k;
                boolean canAddRow;
                BgIncreaseReqFormEntryInfo entry = bill.getEntries().get(j);
                eleNumber = entry.getBgData().getElementNumber();
                currencyNumber = entry.getBgData().getCurrency().getNumber();
                if (itemNumber != null) {
                    canAddRow = true;
                    if (itemNumber.length == 1) {
                        int point = 0;
                        for (int k2 = 0; k2 < temInfo.getRefDimensions().size(); ++k2) {
                            if (temInfo.getRefDimensions().get(k2).getBgDimension().getValue() != bgDim) continue;
                            point = k2;
                            break;
                        }
                        if (!itemNumber[0].equals(((BgItemInfo)entry.getBgData().getBgEntry().get("bgItem" + (point + 1))).getItemNumber())) {
                            canAddRow = false;
                            continue block0;
                        }
                    } else {
                        for (k = 0; k < itemNumber.length; ++k) {
                            if (itemNumber[k].equals(((BgItemInfo)entry.getBgData().getBgEntry().get("bgItem" + (k + 1))).getItemNumber())) continue;
                            canAddRow = false;
                            break;
                        }
                    }
                    if (!canAddRow) continue;
                }
                if (bgEle != null) {
                    canAddRow = true;
                    if (bgEleDataType == 1) {
                        if (currency != null) {
                            if (!eleNumber.equals(bgEle) || !currencyNumber.equals(currency)) {
                                canAddRow = false;
                            }
                        } else if (!eleNumber.equals(bgEle)) {
                            canAddRow = false;
                        }
                    } else if (!eleNumber.equals(bgEle)) {
                        canAddRow = false;
                    }
                    if (!canAddRow) continue;
                }
                IRow row = this.table.addRow();
                row.getCell("id").setValue((Object)bill.getId().toString());
                row.getCell("number").setValue((Object)bill.getNumber());
                row.getCell("orgUnit").setValue((Object)bill.getBizOrgUnit().getName());
                row.getCell("bgType").setValue((Object)bill.getBgType().getName());
                if (row.getCell("BgElement_" + eleNumber) != null) {
                    row.getCell("BgElement_" + eleNumber).setValue((Object)entry.getReqValue());
                } else if (row.getCell("BgElement_" + eleNumber + "_" + currencyNumber) != null) {
                    row.getCell("BgElement_" + eleNumber + "_" + currencyNumber).setValue((Object)entry.getReqValue());
                }
                row.getCell("period").setValue((Object)bill.getPeriod());
                row.getCell("source").setValue((Object)bill.getSrcType());
                row.getCell("handler").setValue((Object)bill.getHandler().getName());
                row.getCell("auditor").setValue(bill.getAuditor() == null ? null : bill.getAuditor().getName());
                int size2 = temInfo.getRefDimensions().size();
                for (k = 0; k < size2; ++k) {
                    row.getCell("bgItem" + (k + 1)).setValue((Object)((BgItemInfo)entry.getBgData().getBgEntry().get("bgItem" + (k + 1))).getItemNumber());
                }
            }
        }
    }

    private void initBgItemCol(BgTemplateInfo temInfo, Integer bgDim) {
        IColumn col;
        int i;
        if (temInfo == null) {
            return;
        }
        int size = temInfo.getRefDimensions().size();
        for (i = 0; i < size; ++i) {
            col = this.table.addColumn(this.table.getColumnIndex("period"));
            col.setKey("bgItem" + (i + 1));
            this.table.getHeadRow(0).getCell(col.getColumnIndex()).setValue((Object)temInfo.getRefDimensions().get(i).getBgDimension());
            this.table.getHeadRow(1).getCell(col.getColumnIndex()).setValue((Object)temInfo.getRefDimensions().get(i).getBgDimension());
        }
        if (bgDim != -1) {
            size = this.table.getColumnCount();
            for (i = 0; i < size; ++i) {
                col = this.table.getColumn(i);
                if (!col.getKey().startsWith("bgItem") || ((BgDimensionEnum)((Object)this.table.getHeadRow(0).getCell(i).getValue())).getValue() == bgDim.intValue()) continue;
                col.getStyleAttributes().setHided(true);
            }
        }
    }

    private void initTotal() {
        this.table.getGroupManager().setGroup(true);
        this.table.getGroupManager().setOrientation(1);
        IColumn col = this.table.getColumn("orgUnit");
        col.setGroup(true);
        col.setMergeable(false);
        col.setStat(true);
        IRow row0 = this.table.getGroupManager().getStatRowTemplate(0);
        row0.getStyleAttributes().setBackground(BgClientHelper.KDTABLE_TOTAL_BG_COLOR);
        row0.getStyleAttributes().setLocked(true);
        row0.getCell("number").setValue((Object)BgResource.getString("Total"));
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            if (!this.table.getColumn(i).getKey().startsWith("BgElement_")) continue;
            row0.getCell(i).setExpressions("SUM");
        }
    }

    private void initGather() {
        IRow row0 = this.table.addRow();
        row0.getStyleAttributes().setHided(false);
        row0.getStyleAttributes().setBackground(BgClientHelper.KDTABLE_TOTAL_BG_COLOR);
        row0.getStyleAttributes().setLocked(false);
        row0.getCell("number").setValue((Object)BgResource.getString("Total"));
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            if (this.table.getColumn(i).getKey().startsWith("BgElement_")) {
                String expressions = "=";
                for (int j = 0; j < this.table.getRowCount() - 1; ++j) {
                    if (this.table.getRow(j).getCell(i).getValue() == null) continue;
                    expressions = expressions + "cell(" + (j + 1) + "," + (i + 1) + ").getValue()+";
                }
                expressions = expressions.substring(0, expressions.length() - 1);
                row0.getCell(i).setExpressions(expressions);
                continue;
            }
            if (this.table.getColumn(i).getKey().startsWith("number")) continue;
            row0.getCell(i).setValue((Object)"-");
        }
        this.table.getScriptManager().runAll();
    }

    public void initBgElementHeadRow(BgTemplateInfo bgTpInfo, KDTable kdTable, String bgEleNumber, int bgEleDataType, String currencyNumber) {
        block20: {
            String key;
            int i;
            if (bgTpInfo == null) {
                return;
            }
            IRow multiCurrencyHeadRow = null;
            int columnCursor = kdTable.getColumn("period").getColumnIndex();
            BgTemplateColumnCollection tpCols = bgTpInfo.getBgTpColumns();
            boolean isMultiCurrency = bgTpInfo.getRefCurrencies().size() > 1;
            CurrencyInfo soloCurrency = null;
            if (!isMultiCurrency && bgTpInfo.getRefCurrencies().size() > 0) {
                soloCurrency = bgTpInfo.getRefCurrencies().get(0).getCurrency();
            }
            int size = tpCols.size();
            for (i = 0; i < size; ++i) {
                BgTemplateColumnInfo bgTpColInfo = tpCols.get(i);
                BgElementInfo bgElementInfo = bgTpColInfo.getBgElement();
                if (bgElementInfo.getDataType().equals((Object)BgDataTypeEnum.Amount) && isMultiCurrency) {
                    if (multiCurrencyHeadRow == null) {
                        multiCurrencyHeadRow = kdTable.addHeadRow();
                    }
                    Iterator currencyIter = bgTpInfo.getRefCurrencies().iterator();
                    while (currencyIter.hasNext()) {
                        ReferencedCurrencyInfo refCyInfo = (ReferencedCurrencyInfo)currencyIter.next();
                        CurrencyInfo cyInfo = refCyInfo.getCurrency();
                        IColumn ic = kdTable.addColumn(columnCursor);
                        ic.getStyleAttributes().setNumberFormat(BgClientHelper.getNumberFtm(cyInfo.getId()));
                        ic.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                        ic.setMergeable(false);
                        ic.setKey("BgElement_" + BgHelper.getBgElementKey(bgElementInfo, cyInfo));
                        ic.setWidth(150);
                        this.table.getHeadRow(0).getCell(columnCursor).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgIncreaseReqDataResource", (String)"reqValue"));
                        this.table.getHeadRow(1).getCell(columnCursor).setValue((Object)bgElementInfo);
                        multiCurrencyHeadRow.getCell(columnCursor).setValue((Object)cyInfo);
                        ++columnCursor;
                    }
                    continue;
                }
                IColumn ic = kdTable.addColumn(columnCursor);
                if (soloCurrency != null) {
                    ic.getStyleAttributes().setNumberFormat(BgClientHelper.getNumberFtm(soloCurrency.getId()));
                } else {
                    ic.getStyleAttributes().setNumberFormat(BgClientHelper.getNumberFtm());
                }
                ic.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                ic.setMergeable(false);
                ic.setKey("BgElement_" + bgElementInfo.getNumber());
                ic.setWidth(150);
                this.table.getHeadRow(0).getCell(columnCursor).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgIncreaseReqDataResource", (String)"reqValue"));
                this.table.getHeadRow(1).getCell(columnCursor).setValue((Object)bgElementInfo);
            }
            if (multiCurrencyHeadRow != null) {
                for (i = 0; i < kdTable.getColumnCount(); ++i) {
                    if (multiCurrencyHeadRow.getCell(i) == null || multiCurrencyHeadRow.getCell(i).getValue() != null) continue;
                    multiCurrencyHeadRow.getCell(i).setValue(this.table.getHeadRow(1).getCell(i).getValue());
                }
            }
            if (bgEleNumber == null) break block20;
            if (currencyNumber != null) {
                if (isMultiCurrency) {
                    if (bgEleDataType == 1) {
                        size = this.table.getColumnCount();
                        for (i = 0; i < size; ++i) {
                            key = this.table.getColumnKey(i);
                            if (!key.startsWith("BgElement_") || key.equals("BgElement_" + bgEleNumber + "_" + currencyNumber)) continue;
                            this.table.getColumn(i).getStyleAttributes().setHided(true);
                        }
                    } else {
                        size = this.table.getColumnCount();
                        for (i = 0; i < size; ++i) {
                            key = this.table.getColumnKey(i);
                            if (!key.startsWith("BgElement_") || key.equals("BgElement_" + bgEleNumber)) continue;
                            this.table.getColumn(i).getStyleAttributes().setHided(true);
                        }
                    }
                } else {
                    size = this.table.getColumnCount();
                    for (i = 0; i < size; ++i) {
                        key = this.table.getColumnKey(i);
                        if (!key.startsWith("BgElement_") || key.equals("BgElement_" + bgEleNumber)) continue;
                        this.table.getColumn(i).getStyleAttributes().setHided(true);
                    }
                }
            } else {
                size = this.table.getColumnCount();
                for (i = 0; i < size; ++i) {
                    key = this.table.getColumnKey(i);
                    if (!key.startsWith("BgElement_") || key.startsWith("BgElement_" + bgEleNumber)) continue;
                    this.table.getColumn(i).getStyleAttributes().setHided(true);
                }
            }
        }
    }

    public void setIcon() {
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnGather.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.btnViewBill.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewbill"));
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSelectPeriodResource", (String)"out"));
        fileChooser.setFileFilter((FileFilter)new ExcelFileFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            if (!filePath.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                filePath = filePath + ".xls";
            }
        } else {
            this.getUIWindow().close();
            return;
        }
        if (filePath == null) {
            this.getUIWindow().close();
            return;
        }
        KDSBook kdsBook = new KDSBook(EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgIncreaseReqDataResource", (String)"incGatherResult"));
        KDSSheet kdsSheet = this.table.getIOManager().saveToKDSSheet(kdsBook, true, false, EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgIncreaseReqDataResource", (String)"incGatherResult"));
        kdsBook.addSheet(null, kdsSheet);
        ExportManager export = new ExportManager();
        try {
            export.exportToExcel(kdsBook, filePath);
        }
        catch (RuntimeException e1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSelectPeriodResource", (String)"fileIsOpen"));
        }
    }

    @Override
    public void actionGather_actionPerformed(ActionEvent e) throws Exception {
        super.actionGather_actionPerformed(e);
        CommonQueryDialog dialog = new CommonQueryDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        dialog.setParentUIClassName(BgIncGatherViewUI.class.getName());
        dialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.ma.bg", "BgIncreaseReqFormQuery"));
        dialog.setTitle(EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgIncreaseReqDataResource", (String)"gatherQuery_title"));
        dialog.setShowFilter(false);
        dialog.setShowSorter(false);
        dialog.setWidth(300);
        dialog.setHeight(315);
        dialog.addUserPanel((KDPanel)new BgIncGatherQueryPanel());
        if (dialog.show()) {
            String oql;
            this.table.removeRows();
            this.table.removeColumns();
            this.table.removeHeadRows();
            this.table.getGroupManager().removeGroup();
            this.table.setFormatXml(this.resHelper.getString("table.formatXml"));
            this.table.checkParsed(true);
            this.table.reLayoutAndPaint();
            EntityViewInfo mainQuery = dialog.getEntityViewInfoResult();
            FilterItemCollection filterItemColl = mainQuery.getFilter().getFilterItems();
            String orgIds = (String)BgHelper.getFilterValue(filterItemColl, "bizOrgUnit");
            String bgTypeId = (String)BgHelper.getFilterValue(filterItemColl, "bgType");
            int beginYear = (Integer)BgHelper.getFilterValue(filterItemColl, "beginYear");
            int beginPeriod = (Integer)BgHelper.getFilterValue(filterItemColl, "beginPeriod");
            int endYear = (Integer)BgHelper.getFilterValue(filterItemColl, "endYear");
            int endPeriod = (Integer)BgHelper.getFilterValue(filterItemColl, "endPeriod");
            Object obj = BgHelper.getFilterValue(filterItemColl, "bgdim");
            int bgDim = obj == null ? -1 : (Integer)obj;
            obj = BgHelper.getFilterValue(filterItemColl, "bgItem");
            String bgItem = obj == null ? null : (String)obj;
            obj = BgHelper.getFilterValue(filterItemColl, "bgEle");
            String bgEle = obj == null ? null : (String)obj;
            obj = BgHelper.getFilterValue(filterItemColl, "bgEleDataType");
            int bgEleDataType = obj == null ? -1 : (Integer)obj;
            obj = BgHelper.getFilterValue(filterItemColl, "currency");
            String currency = obj == null ? null : (String)obj;
            String[] itemNumber = null;
            if (bgItem != null) {
                itemNumber = bgItem.split("&");
            }
            String[] orgId = orgIds.split(",");
            String orgFilter = " ( ";
            for (int i = 0; i < orgId.length; ++i) {
                orgFilter = orgFilter + " bizOrgUnit.id ='" + orgId[i] + "' or";
            }
            orgFilter = orgFilter.substring(0, orgFilter.length() - 2);
            orgFilter = orgFilter + " )";
            obj = BgHelper.getFilterValue(filterItemColl, "state");
            int state = (Integer)obj;
            IBgIncreaseReqForm iBg = BgIncreaseReqFormFactory.getRemoteInstance();
            BgIncreaseReqFormCollection coll = iBg.getBgIncreaseReqFormCollection(oql = BgIncreaseReqDataListUI.getOql(bgTypeId, beginYear, beginPeriod, endYear, endPeriod, orgFilter, state));
            if (coll == null || coll.size() == 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgIncreaseReqDataResource", (String)"noInc"));
                return;
            }
            BgTemplateInfo temInfo = ((BgIncGatherQueryPanel)dialog.getUserPanel(0)).getBgTemInfo();
            this.initBgItemCol(temInfo, new Integer(bgDim));
            this.initBgElementHeadRow(temInfo, this.table, bgEle, bgEleDataType, currency);
            this.initTableData(coll, temInfo, bgDim, itemNumber, bgEle, currency, bgEleDataType);
            this.initGather();
            this.table.getSelectManager().setSelectMode(2);
            this.table.getHeadMergeManager().mergeBlock(0, 1, this.table.getHeadRowCount() - 1, this.table.getColumnCount() - 1, 3);
        } else {
            SysUtil.abort();
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.table.getPrintManager().print();
    }

    @Override
    public void actionPrintView_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintView_actionPerformed(e);
        this.setHead();
        this.table.getPrintManager().printPreview();
    }

    private void setHead() {
        HeadFootModel header = new HeadFootModel();
        String text2 = this.getUITitle();
        header.addRow(text2);
        Page hPage = HeadFootParser.parseModel2HeadFootPage((HeadFootModel)header);
        this.table.getPrintManager().setHeader(hPage);
    }

    @Override
    public void actionViewBill_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewBill_actionPerformed(e);
        if (this.table.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (this.getSelectedKeyValue() == null || this.getSelectedKeyValue().equals("") || this.getSelectedKeyValue().length() != 44) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgIncreaseReqDataResource", (String)"pleaseSelectBill"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(BgIncreaseReqDataEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String getSelectedKeyValue() {
        Object keyValue;
        IRow row = this.table.getRow(this.table.getSelectManager().getActiveRowIndex());
        ICell cell = row.getCell("id");
        if (cell == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
            SysUtil.abort();
        }
        if ((keyValue = cell.getValue()) != null) {
            return keyValue.toString();
        }
        return null;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }
}

