/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.f7.OrgViewF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgIncSourceTypeEnum;
import com.kingdee.eas.ma.bg.BgOrgHelper;
import com.kingdee.eas.ma.bg.BgTypeCollection;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgType;
import com.kingdee.eas.ma.bg.client.AbstractBgIncQueryPanel;
import com.kingdee.eas.ma.bg.client.BgIncreaseReqDataListUI;
import com.kingdee.eas.util.client.EASResource;
import java.util.Vector;

public class BgIncQueryPanel
extends AbstractBgIncQueryPanel {
    private OrgViewType[] orgView = null;
    private boolean hasLoaded = false;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        OrgUnitInfo org = SysContext.getSysContext().getCurrentOrgUnit();
        Vector vec = BgOrgHelper.getOrgViewTypes(org);
        this.orgView = new OrgViewType[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            this.orgView[i] = (OrgViewType)vec.get(i);
        }
        super.onLoad();
        this.initOrg();
        if (!this.hasLoaded) {
            this.initBgType();
        }
        if (this.comboSource.getItemAt(0) == null) {
            this.comboSource.removeItemAt(0);
        }
        this.comboBgType.setSelectedIndex(0);
        this.bizAuditor.setEditable(true);
        this.bizHandler.setEditable(true);
        this.bizOrgUnit.setEditable(true);
    }

    public void initOrg() throws Exception {
        Object[] obj = new Object[]{SysContext.getSysContext().getCurrentOrgUnit()};
        this.bizOrgUnit.setData((Object)obj);
        OrgViewF7 orgBox = new OrgViewF7((IUIObject)this);
        orgBox.setCuID(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        orgBox.setOrgViewTypes(this.orgView);
        orgBox.setIsShowSub(false);
        orgBox.setUIActionPK(new BgIncreaseReqDataListUI().getMetaDataPK(), (IMetaDataPK)new MetaDataPK("ActionOnLoad"));
        orgBox.setMultiSelect(true);
        orgBox.setTitle(EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"SelectOrgUnit"));
        this.bizOrgUnit.setSelector((KDPromptSelector)orgBox);
        this.bizOrgUnit.setEditFormat("$name$");
        this.bizOrgUnit.setDisplayFormat("$name$");
    }

    public void initBgType() throws EASBizException, BOSException {
        this.comboBgType.removeAllItems();
        Object obj = this.bizOrgUnit.getData();
        Object[] objs = (Object[])obj;
        ObjectUuidPK pk = new ObjectUuidPK(((OrgUnitInfo)objs[0]).getId());
        IBgType ibtype = BgTypeFactory.getRemoteInstance();
        FullOrgUnitInfo couInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)pk);
        BgTypeCollection coll = ibtype.getCollection(BgOrgHelper.getOrgTypes(couInfo));
        this.comboBgType.addItem(null);
        this.comboBgType.addItems(coll.toArray());
        this.hasLoaded = true;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        String filterMask = "";
        int index = 0;
        if (this.bizOrgUnit.getData() != null) {
            Object obj = this.bizOrgUnit.getData();
            Object[] objs = (Object[])obj;
            OrgUnitInfo org = null;
            for (int i = 0; i < objs.length; ++i) {
                org = (OrgUnitInfo)objs[i];
                filter.getFilterItems().add(new FilterItemInfo("bizOrgUnit.id", (Object)org.getId().toString()));
                index = i;
                filterMask = i == 0 ? "(#" + i + " or " : filterMask + "#" + i + " or ";
            }
            filterMask = filterMask.substring(0, filterMask.length() - 3) + ") ";
            ++index;
        }
        if (this.comboBgType.getSelectedItem() != null) {
            filter.getFilterItems().add(new FilterItemInfo("bgType.id", (Object)((BgTypeInfo)this.comboBgType.getSelectedItem()).getId().toString()));
            filterMask = filterMask.equals("") ? " #" + index : filterMask + " and #" + index;
            ++index;
        }
        if (this.comboSource.getSelectedItem() != null) {
            filter.getFilterItems().add(new FilterItemInfo("srcType", (Object)new Integer(((BgIncSourceTypeEnum)((Object)this.comboSource.getSelectedItem())).getValue())));
            filterMask = filterMask.equals("") ? " #" + index : filterMask + " and #" + index;
            ++index;
        }
        if (!this.txtNumber.getText().trim().equals("")) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + this.txtNumber.getText().trim() + "%"), CompareType.LIKE));
            filterMask = filterMask.equals("") ? " #" + index : filterMask + " and #" + index;
            ++index;
        }
        if (this.bizHandler.getData() != null) {
            filter.getFilterItems().add(new FilterItemInfo("handler.id", (Object)((UserInfo)this.bizHandler.getData()).getId().toString()));
            filterMask = filterMask.equals("") ? " #" + index : filterMask + " and #" + index;
            ++index;
        }
        if (this.bizAuditor.getData() != null) {
            filter.getFilterItems().add(new FilterItemInfo("auditor.id", (Object)((UserInfo)this.bizAuditor.getData()).getId().toString()));
            filterMask = filterMask.equals("") ? " #" + index : filterMask + " and #" + index;
            ++index;
        }
        filter.setMaskString(filterMask);
        return filter;
    }

    public void loadBgType(String id) {
        for (int i = 1; i < this.comboBgType.getItemCount(); ++i) {
            if (!((BgTypeInfo)this.comboBgType.getItemAt(i)).getId().toString().equals(id)) continue;
            this.comboBgType.setSelectedIndex(i);
            break;
        }
    }

    public void loadBgSource(Integer source) {
        if (source == null) {
            return;
        }
        for (int i = 1; i < this.comboSource.getItemCount(); ++i) {
            if (((BgIncSourceTypeEnum)((Object)this.comboSource.getItemAt(i))).getValue() != source.intValue()) continue;
            this.comboSource.setSelectedIndex(i);
            break;
        }
    }

    public void loadBgTypeq(String id) {
        for (int i = 1; i < this.comboBgType.getItemCount(); ++i) {
            if (!((BgTypeInfo)this.comboBgType.getItemAt(i)).getId().toString().equals(id)) continue;
            this.comboBgType.setSelectedIndex(i);
            break;
        }
    }

    public void loadNumber(String number) {
        if (number != null) {
            number = number.substring(1, number.length() - 1);
        }
        this.txtNumber.setText(number);
    }

    public void loadOrg(Vector vec) {
        if (vec != null && vec.size() != 0) {
            Object[] obj = new Object[vec.size()];
            try {
                IFullOrgUnit iou = FullOrgUnitFactory.getRemoteInstance();
                String id = "";
                for (int i = 0; i < vec.size(); ++i) {
                    id = (String)vec.get(i);
                    FullOrgUnitInfo orgInfo = iou.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
                    obj[i] = orgInfo;
                }
                this.bizOrgUnit.setData((Object)obj);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
        }
    }

    public void loadPerson(String id, KDBizPromptBox bizPerson) {
        if (id != null && !id.equals("")) {
            try {
                IUser iou = UserFactory.getRemoteInstance();
                UserInfo userInfo = iou.getUserInfo((IObjectPK)new ObjectUuidPK(id));
                bizPerson.setData((Object)userInfo);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
        }
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        if (entityViewInfo.getFilter() == null) {
            return;
        }
        FilterItemCollection filters = entityViewInfo.getFilter().getFilterItems();
        this.loadBgType((String)BgHelper.getFilterValue(filters, "bgType.id"));
        this.loadBgSource((Integer)BgHelper.getFilterValue(filters, "srcType"));
        this.loadNumber((String)BgHelper.getFilterValue(filters, "number"));
        this.loadOrg(BgHelper.getFilterValues(filters, "bizOrgUnit.id"));
        this.loadPerson((String)BgHelper.getFilterValue(filters, "handler.id"), this.bizHandler);
        this.loadPerson((String)BgHelper.getFilterValue(filters, "auditor.id"), this.bizAuditor);
    }
}

