/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgItemCollection;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.client.IBgItemHelper;
import java.util.Iterator;

public class BgItemHelper_BANKACCOUNT
implements IBgItemHelper {
    private FullOrgUnitInfo orgUnitInfo;
    private BgTypeInfo bgTypeInfo;

    @Override
    public BgItemCollection fetcheBgItems() throws BOSException, EASBizException {
        IAccountBank iab = AccountBankFactory.getRemoteInstance();
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo.setId(this.orgUnitInfo.getId());
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("company", (Object)companyInfo.getId().toString(), CompareType.EQUALS));
        evi.setFilter(fi);
        AccountBankCollection abc = iab.getAccountBankCollection(evi);
        BgItemCollection bic = new BgItemCollection();
        Iterator iter = abc.iterator();
        SelectorItemCollection sic = this.getSelectors();
        while (iter.hasNext()) {
            AccountBankInfo info = (AccountBankInfo)iter.next();
            info = iab.getAccountBankInfo((IObjectPK)new ObjectUuidPK(info.getId()), sic);
            bic.add(this.convertBgItem(info));
        }
        return bic;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("bankAccountNumber"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bank.name"));
        return sic;
    }

    @Override
    public void setBgType(BgTypeInfo bgTypeInfo) {
        this.bgTypeInfo = bgTypeInfo;
    }

    @Override
    public void setOrgUnit(FullOrgUnitInfo orgUnitInfo) {
        this.orgUnitInfo = orgUnitInfo;
    }

    @Override
    public BgDimensionEnum getCurrentBgDimEnum() {
        return BgDimensionEnum.BANKACCOUNT;
    }

    @Override
    public Object convertBizItem(BgItemInfo bgItemInfo) {
        return null;
    }

    @Override
    public BgItemInfo convertBgItem(Object objectInfo) {
        AccountBankInfo cfii = (AccountBankInfo)objectInfo;
        BgItemInfo bii = new BgItemInfo();
        bii.setId(BOSUuid.create((BOSObjectType)bii.getBOSType()));
        bii.setBgDimension(this.getCurrentBgDimEnum());
        bii.setItemID(cfii.getId());
        bii.setItemNumber(cfii.getNumber());
        bii.setItemName(cfii.getBank().getName() + "-" + cfii.getBankAccountNumber());
        bii.setIsLeaf(true);
        return bii;
    }

    @Override
    public KDBizPromptBox getBizPromptBox(IUIObject uiObj) {
        String queryPath = "com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery";
        KDBizPromptBox kdBizPromptBox = new KDBizPromptBox();
        kdBizPromptBox.setQueryInfo(queryPath);
        kdBizPromptBox.setDisplayFormat("$number$");
        kdBizPromptBox.setEditFormat("$number$");
        return kdBizPromptBox;
    }
}

