/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.client.MaterialPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgItemCollection;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.client.IBgItemHelper;
import java.util.Iterator;

public class BgItemHelper_MATERIAL
implements IBgItemHelper {
    protected FullOrgUnitInfo orgUnitInfo;
    protected BgTypeInfo bgTypeInfo;
    private CompanyOrgUnitInfo companyOrgUnitInfo;

    @Override
    public BgItemCollection fetcheBgItems() throws EASBizException, BOSException {
        IMaterial im = MaterialFactory.getRemoteInstance();
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.getCompanyOrgUnitInfo().getCU().getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.setMaskString("(#0 or #1 or #2) ");
        entity.setFilter(filter);
        CoreBaseCollection mc = im.getCollection(entity);
        BgItemCollection bic = new BgItemCollection();
        Iterator iter = mc.iterator();
        while (iter.hasNext()) {
            bic.add(this.convertBgItem((MaterialInfo)iter.next()));
        }
        return bic;
    }

    @Override
    public void setBgType(BgTypeInfo bgTypeInfo) {
        this.bgTypeInfo = bgTypeInfo;
    }

    @Override
    public void setOrgUnit(FullOrgUnitInfo orgUnitInfo) {
        this.orgUnitInfo = orgUnitInfo;
    }

    @Override
    public BgDimensionEnum getCurrentBgDimEnum() {
        return BgDimensionEnum.MATERIAL;
    }

    @Override
    public BgItemInfo convertBgItem(Object objectInfo) {
        MaterialInfo mi = (MaterialInfo)objectInfo;
        BgItemInfo bii = new BgItemInfo();
        bii.setId(BOSUuid.create((BOSObjectType)bii.getBOSType()));
        bii.setBgDimension(this.getCurrentBgDimEnum());
        bii.setItemID(mi.getId());
        bii.setItemNumber(mi.getNumber());
        bii.setItemName(mi.getName());
        bii.setMeasureUnit(mi.getBaseUnit());
        bii.setIsLeaf(true);
        return bii;
    }

    @Override
    public Object convertBizItem(BgItemInfo bgItemInfo) {
        MaterialInfo mi = new MaterialInfo();
        mi.setId(bgItemInfo.getItemID());
        mi.setNumber(bgItemInfo.getItemNumber());
        mi.setName(bgItemInfo.getItemName());
        mi.setBaseUnit(bgItemInfo.getMeasureUnit());
        return mi;
    }

    @Override
    public KDBizPromptBox getBizPromptBox(IUIObject uiObj) {
        KDBizPromptBox kdBizPromptBox = null;
        try {
            kdBizPromptBox = new KDBizPromptBox();
            kdBizPromptBox.setDisplayFormat("$number$");
            kdBizPromptBox.setEditFormat("$number$");
            EntityViewInfo entity = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            entity.setFilter(filter);
            kdBizPromptBox.setSelector((KDPromptSelector)new MaterialPromptBox(uiObj, this.getCompanyOrgUnitInfo(), null));
        }
        catch (Exception e) {
            kdBizPromptBox = null;
        }
        return kdBizPromptBox;
    }

    public CompanyOrgUnitInfo getCompanyOrgUnitInfo() throws EASBizException, BOSException {
        if (this.companyOrgUnitInfo == null) {
            this.companyOrgUnitInfo = BgHelper.getCompanyOrgByOrgUnit((OrgUnitInfo)this.orgUnitInfo);
        }
        return this.companyOrgUnitInfo;
    }
}

