/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IJob;
import com.kingdee.eas.basedata.org.JobFactory;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgItemCollection;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.client.IBgItemHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class BgItemHelper_POSITION_TYPE
implements IBgItemHelper {
    private FullOrgUnitInfo orgUnitInfo;
    private BgTypeInfo bgTypeInfo;

    @Override
    public BgItemCollection fetcheBgItems() throws EASBizException, BOSException {
        BgItemCollection bic = new BgItemCollection();
        if (this.orgUnitInfo.isIsAdminOrgUnit()) {
            IJob job = JobFactory.getRemoteInstance();
            IRowSet rs = job.getJobsByOrgUnit(this.orgUnitInfo.getId());
            try {
                while (rs.next()) {
                    BgItemInfo bii = new BgItemInfo();
                    bii.setId(BOSUuid.create((BOSObjectType)bii.getBOSType()));
                    bii.setBgDimension(this.getCurrentBgDimEnum());
                    bii.setItemID(BOSUuid.read((String)rs.getString("id")));
                    bii.setItemNumber(rs.getString("number"));
                    bii.setItemName(rs.getString("name"));
                    bii.setIsLeaf(true);
                    bic.add(bii);
                }
            }
            catch (SQLException e) {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"Job"});
            }
        }
        return bic;
    }

    @Override
    public void setBgType(BgTypeInfo bgTypeInfo) {
        this.bgTypeInfo = bgTypeInfo;
    }

    @Override
    public void setOrgUnit(FullOrgUnitInfo orgUnitInfo) {
        this.orgUnitInfo = orgUnitInfo;
    }

    @Override
    public BgDimensionEnum getCurrentBgDimEnum() {
        return BgDimensionEnum.POSITION_TYPE;
    }

    @Override
    public BgItemInfo convertBgItem(Object objectInfo) {
        JobInfo ji = (JobInfo)objectInfo;
        BgItemInfo bii = new BgItemInfo();
        bii.setId(BOSUuid.create((BOSObjectType)bii.getBOSType()));
        bii.setBgDimension(this.getCurrentBgDimEnum());
        bii.setItemID(ji.getId());
        bii.setItemNumber(ji.getNumber());
        bii.setItemName(ji.getName());
        bii.setIsLeaf(true);
        return bii;
    }

    @Override
    public Object convertBizItem(BgItemInfo bgItemInfo) {
        JobInfo ji = new JobInfo();
        ji.setId(bgItemInfo.getItemID());
        ji.setNumber(bgItemInfo.getItemNumber());
        ji.setName(bgItemInfo.getItemName());
        return ji;
    }

    @Override
    public KDBizPromptBox getBizPromptBox(IUIObject uiObj) {
        String queryPath = "com.kingdee.eas.basedata.org.app.JobsByAdminOrgUnit";
        AdminOrgUnitInfo adminInfo = null;
        try {
            adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.orgUnitInfo.getId()));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("CtrlUnit.id", (Object)adminInfo.getCU().getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("CtrlUnit.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("CtrlUnit.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)adminInfo.getLongNumber()));
        fi.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(adminInfo.getLongNumber() + "!" + "%"), CompareType.LIKE));
        fi.setMaskString("(#0 or #1 or #2) and (#3 or #4)");
        viewInfo.setFilter(fi);
        KDBizPromptBox kdBizPromptBox = new KDBizPromptBox();
        kdBizPromptBox.setQueryInfo(queryPath);
        kdBizPromptBox.setEntityViewInfo(viewInfo);
        kdBizPromptBox.setDisplayFormat("$number$");
        kdBizPromptBox.setEditFormat("$number$");
        return kdBizPromptBox;
    }
}

