/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IProject;
import com.kingdee.eas.basedata.assistant.ProjectCollection;
import com.kingdee.eas.basedata.assistant.ProjectFactory;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgItemCollection;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.client.IBgItemHelper;

public class BgItemHelper_PROJECT
implements IBgItemHelper {
    BgTypeInfo bgTypeInfo;
    FullOrgUnitInfo orgUnitInfo;

    @Override
    public BgItemCollection fetcheBgItems() throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("longnumber"));
        evi.getSorter().add(new SorterItemInfo("longnumber"));
        IProject iProject = ProjectFactory.getRemoteInstance();
        ProjectCollection projectCollection = iProject.getProjectCollection(evi);
        BgItemCollection bic = new BgItemCollection();
        for (ProjectInfo pi : projectCollection) {
            BgItemInfo bgItemInfo = this.convertBgItem(pi);
            bgItemInfo.setBgDimension(this.getCurrentBgDimEnum());
            bic.add(bgItemInfo);
        }
        return bic;
    }

    @Override
    public BgDimensionEnum getCurrentBgDimEnum() {
        return BgDimensionEnum.PROJECT;
    }

    @Override
    public KDBizPromptBox getBizPromptBox(IUIObject uiObj) {
        String queryInfoPath = "com.kingdee.eas.basedata.assistant.app.ProjectQuery";
        KDBizPromptBox kdBizPromptBox = new KDBizPromptBox();
        kdBizPromptBox.setDisplayFormat("$number$");
        kdBizPromptBox.setEditFormat("$number$");
        kdBizPromptBox.setQueryInfo(queryInfoPath);
        return kdBizPromptBox;
    }

    @Override
    public void setBgType(BgTypeInfo bgTypeInfo) {
        this.bgTypeInfo = bgTypeInfo;
    }

    @Override
    public void setOrgUnit(FullOrgUnitInfo orgUnitInfo) {
        this.orgUnitInfo = orgUnitInfo;
    }

    @Override
    public Object convertBizItem(BgItemInfo bgItemInfo) {
        ProjectInfo pi = new ProjectInfo();
        pi.setId(bgItemInfo.getItemID());
        pi.setNumber(bgItemInfo.getNumber());
        pi.setName(bgItemInfo.getItemName());
        pi.setLongNumber(bgItemInfo.getLongNumber());
        return pi;
    }

    @Override
    public BgItemInfo convertBgItem(Object objectInfo) {
        BgItemInfo bii = new BgItemInfo();
        ProjectInfo pi = (ProjectInfo)objectInfo;
        bii.setId(BOSUuid.create((BOSObjectType)bii.getBOSType()));
        bii.setItemID(pi.getId());
        bii.setItemNumber(pi.getNumber());
        bii.setItemName(pi.getName());
        bii.setLongNumber(pi.getLongNumber());
        bii.setBgDimension(BgDimensionEnum.PROJECT);
        return bii;
    }
}

