/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.tree.OrgUnitNodeInfo;
import com.kingdee.eas.ma.bg.BgTypeCollection;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeHelper;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgType;
import com.kingdee.eas.ma.bg.client.AbstractBgListUI;
import java.awt.event.ActionEvent;
import javax.swing.event.TreeSelectionEvent;

public abstract class BgListUI
extends AbstractBgListUI {
    @Override
    protected void kDTreeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        super.kDTreeOrgUnit_valueChanged(e);
        OrgUnitInfo orgUnitInfo = this.getOrgUnitInfo();
        if (orgUnitInfo == null) {
            return;
        }
        this.execQuery();
    }

    @Override
    protected void comboBoxBgType_actionPerformed(ActionEvent e) throws Exception {
        super.comboBoxBgType_actionPerformed(e);
        if (!this.comboBoxBgType.isEnabled()) {
            return;
        }
        this.refreshOrgUnitTree();
        this.kDTreeOrgUnit.setSelectionRow(1);
        this.execQuery();
    }

    private void refreshOrgUnitTree() throws BOSException {
        this.kDTreeOrgUnit.setModel(null);
        BgTypeInfo bgTypeInfo = this.getBgTypeInfo();
        if (bgTypeInfo == null) {
            return;
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDSplitPaneMain.setResizeWeight(0.2);
        IBgType iBgType = BgTypeFactory.getRemoteInstance();
        BgTypeCollection bgTypeCollection = iBgType.getBgTypeCollection(BgTypeHelper.getListEntityView());
        this.comboBoxBgType.setEnabled(false);
        this.comboBoxBgType.addItems(bgTypeCollection.toArray());
        this.comboBoxBgType.setEnabled(true);
        this.kDTreeOrgUnit.setModel(null);
        this.refreshOrgUnitTree();
        this.kDTreeOrgUnit.setSelectionRow(1);
    }

    protected OrgUnitInfo getOrgUnitInfo() {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.kDTreeOrgUnit.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        if (node.getUserObject() == null) {
            return null;
        }
        return ((OrgUnitNodeInfo)node.getUserObject()).getOrgUnitInfo();
    }

    protected String getOrgUnitId() {
        OrgUnitInfo oui = this.getOrgUnitInfo();
        if (oui == null) {
            return "";
        }
        return oui.getId().toString();
    }

    protected BgTypeInfo getBgTypeInfo() {
        if (this.comboBoxBgType.getSelectedIndex() == -1) {
            return null;
        }
        return (BgTypeInfo)this.comboBoxBgType.getSelectedItem();
    }

    protected String getBgTypeId() {
        BgTypeInfo bti = this.getBgTypeInfo();
        if (bti == null) {
            return "";
        }
        return bti.getId().toString();
    }
}

