/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.ma.bg.BgFormDataSourceEnum;
import com.kingdee.eas.ma.bg.BgOperationEnum;
import com.kingdee.eas.ma.bg.BgPastDataInfo;
import com.kingdee.eas.ma.bg.BgPastRecordInfo;
import com.kingdee.eas.ma.bg.client.AbstractBgPastRecordEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class BgPastRecordEditUI
extends AbstractBgPastRecordEditUI {
    private static final String ID = "id";
    private static final String SEQ = "seq";
    private static final String MODIFYTOTAL = "ModifyTatal";
    private static final String PASTDATA_PASTVALUE = "pastData.pastValue";
    private static final String PASTDATA_BALANCE = "pastData.balance";
    private static final String PASTDATA_DATASOURCE = "pastData.dataSource";
    private static final String MODIFY = "modify";
    private static final String MODIFYDATA = "modifyDate";
    private static final String OPERATION = "operation";

    @Override
    public void loadFields() {
        this.kDTable1.checkParsed();
        Map uIContext = this.getUIContext();
        String id = (String)uIContext.get("ID");
        String formatString = (String)uIContext.get("formatString");
        int formState = (Integer)uIContext.get("formState");
        if (id != null) {
            ResultSet rs = this.getResultSet(id);
            this.kDTable1.getColumn(PASTDATA_PASTVALUE).getStyleAttributes().setNumberFormat(formatString);
            this.kDTable1.getColumn(PASTDATA_BALANCE).getStyleAttributes().setNumberFormat(formatString);
            try {
                this.fillData(rs, formState);
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.handUIExceptionAndAbort(e);
            }
        }
        this.kDTable1.getStyleAttributes().setLocked(true);
    }

    protected ResultSet getResultSet(String id) {
        String str = "select a.fmodifydate, c.fname_l2,  b.fpastValue,b.fbalance,b.fdatasource  from t_bg_bgpastrecord a ,t_bg_bgpastdata b ,t_pm_user c  where b.fbgpastrecordid=a.fid and  a.fmodifierid=c.fid and  b.fbgdataid='" + id + "'";
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)str);
        IRowSet rs = null;
        try {
            rs = sqlExe.executeSQL();
        }
        catch (Exception ex) {
            this.handUIException(ex);
            ex.printStackTrace();
            SysUtil.abort();
        }
        return rs;
    }

    @Override
    protected void kDWorkButtonConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    protected void oNkDButtonCancle_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    protected void fillData(BgPastRecordInfo bgPastRecordInfo, BgPastDataInfo bgPastDataInfo) {
        IRow iRow = this.kDTable1.addRow();
        iRow.getCell(ID).setValue((Object)bgPastRecordInfo.getId().toString());
        iRow.getCell(SEQ).setValue((Object)new Integer(bgPastRecordInfo.getSeq()));
        iRow.getCell(PASTDATA_PASTVALUE).setValue((Object)bgPastDataInfo.getPastValue());
        iRow.getCell(PASTDATA_BALANCE).setValue((Object)bgPastDataInfo.getBalance());
        if (bgPastRecordInfo.getModifier() != null) {
            iRow.getCell(MODIFY).setValue((Object)bgPastRecordInfo.getModifier().getName());
        }
        iRow.getCell(MODIFYDATA).setValue((Object)bgPastRecordInfo.getModifyDate());
        if (bgPastRecordInfo.getBgForm() != null) {
            iRow.getCell(MODIFYTOTAL).setValue((Object)new Integer(bgPastRecordInfo.getBgForm().getPastRecords().size()));
            if (bgPastRecordInfo.getBgForm().getState() != null) {
                if (bgPastRecordInfo.getBgForm().getState().getValue() > 1) {
                    this.kDTable1.getColumn(PASTDATA_DATASOURCE).getStyleAttributes().setHided(true);
                } else {
                    iRow.getCell(PASTDATA_DATASOURCE).setValue((Object)bgPastDataInfo.getDataSource());
                }
            } else {
                iRow.getCell(PASTDATA_DATASOURCE).setValue((Object)bgPastDataInfo.getDataSource());
            }
        }
        String name = "";
        switch (bgPastDataInfo.getDataSource().getValue()) {
            case 1: {
                name = BgOperationEnum.Declare.getAlias();
                break;
            }
            case -1: {
                name = BgOperationEnum.Distribute.getAlias();
                break;
            }
            case 2: {
                name = BgOperationEnum.Adjust.getAlias();
                break;
            }
            case 3: {
                name = BgOperationEnum.Increase.getAlias();
            }
        }
        iRow.getCell(OPERATION).setValue((Object)name);
    }

    protected void fillData(ResultSet rs, int formState) throws SQLException {
        BigDecimal one = new BigDecimal(1);
        while (rs != null && rs.next()) {
            IRow iRow = this.kDTable1.addRow();
            iRow.getCell(PASTDATA_PASTVALUE).setValue((Object)rs.getBigDecimal("fpastValue").divide(one, 2, 6));
            iRow.getCell(PASTDATA_BALANCE).setValue((Object)rs.getBigDecimal("fbalance").divide(one, 2, 6));
            iRow.getCell(MODIFY).setValue((Object)rs.getString("fname_l2"));
            iRow.getCell(MODIFYDATA).setValue((Object)rs.getDate("fmodifydate"));
            if (formState > 1) {
                this.kDTable1.getColumn(PASTDATA_DATASOURCE).getStyleAttributes().setHided(true);
            } else {
                iRow.getCell(PASTDATA_DATASOURCE).setValue((Object)BgFormDataSourceEnum.getEnum(rs.getInt("fdatasource")));
            }
            String name = "";
            switch (rs.getInt("fdatasource")) {
                case 1: {
                    name = BgOperationEnum.Declare.getAlias();
                    break;
                }
                case -1: {
                    name = BgOperationEnum.Distribute.getAlias();
                    break;
                }
                case 2: {
                    name = BgOperationEnum.Adjust.getAlias();
                    break;
                }
                case 3: {
                    name = BgOperationEnum.Increase.getAlias();
                }
            }
            iRow.getCell(OPERATION).setValue((Object)name);
        }
    }

    public void onLoad() throws Exception {
        this.loadFields();
    }
}

