/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.client.FormulaPickerUI;
import com.kingdee.eas.fi.rpt.client.IFormulaPickerListener;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.bg.BgCtrlTypeEnum;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgFormException;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgMethodEnum;
import com.kingdee.eas.ma.bg.BgOrgHelper;
import com.kingdee.eas.ma.bg.BgRptRowDirectionEnum;
import com.kingdee.eas.ma.bg.BgRptRowPrefixTypeEnum;
import com.kingdee.eas.ma.bg.BgRptRowTypeEnum;
import com.kingdee.eas.ma.bg.BgRptTemplateDAFactory;
import com.kingdee.eas.ma.bg.BgRptTemplateFactory;
import com.kingdee.eas.ma.bg.BgRptTemplateInfo;
import com.kingdee.eas.ma.bg.BgRptTemplateRowInfo;
import com.kingdee.eas.ma.bg.BgRptTpHelper;
import com.kingdee.eas.ma.bg.BgTemplateException;
import com.kingdee.eas.ma.bg.BgTemplateFactory;
import com.kingdee.eas.ma.bg.BgTemplateHelper;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgRptTemplate;
import com.kingdee.eas.ma.bg.IBgRptTemplateDA;
import com.kingdee.eas.ma.bg.IBgTemplate;
import com.kingdee.eas.ma.bg.ReferencedDimensionCollection;
import com.kingdee.eas.ma.bg.ReferencedDimensionInfo;
import com.kingdee.eas.ma.bg.client.AbstractBgRptTemplateEditUI;
import com.kingdee.eas.ma.bg.client.AccountTotalFormulaEditUI;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.ma.bg.client.BgRptTemplateFormatUI;
import com.kingdee.eas.ma.bg.client.BgRptTpEditHelper;
import com.kingdee.eas.ma.bg.client.BgTemplateEditHelper;
import com.kingdee.eas.ma.bg.client.ExcelFileFilter;
import com.kingdee.eas.ma.bg.client.TableLineSelectorUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.filechooser.FileFilter;

public class BgRptTemplateEditUI
extends AbstractBgRptTemplateEditUI {
    protected IRow selectedRow;
    private boolean save = false;
    private final String EXPORTFILENAME = "ExportFileName";

    @Override
    public void loadFields() {
        this.beforeLoadFields();
        super.loadFields();
        try {
            this.afterLoadFields();
        }
        catch (EASBizException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
    }

    protected void beforeLoadFields() {
        this.kdtBgRptTpRows.checkParsed();
        this.comboRollingBgCycle.removeAllItems();
        this.comboRollingBgCycle.addItem((Object)BgCycleTypeEnum.Season);
        this.comboRollingBgCycle.addItem((Object)BgCycleTypeEnum.Period);
    }

    private void afterLoadFields() throws EASBizException, BOSException {
        CurrencyInfo cyInfo;
        IOrgUnitCommon iCompany;
        CompanyOrgUnitInfo companyInfo;
        if (this.getOprtState().equals("ADDNEW")) {
            this.afterLoadFields_AddNew();
        }
        if (this.getOprtState().equals("EDIT") || this.getOprtState().equals("VIEW")) {
            this.afterLoadFields_Edit();
        }
        if ((companyInfo = (iCompany = OrgUnitCommonFactory.getRemoteInstance()).getCompany(this.editData.getBgTemplate().getOrgUnit().getId(), BgTemplateHelper.getLocalCySelectors())) == null) {
            SysUtil.abort();
        }
        if ((cyInfo = companyInfo.getBaseCurrency()) == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgRptTpResource", (String)"MissingLocalCurrency"));
            SysUtil.abort();
        }
        this.bizPromptBoxCurrency.setData((Object)new Object[]{cyInfo});
    }

    protected void afterLoadFields_Edit() throws BOSException {
        IBgTemplate ibt;
        boolean refByForm;
        BgRptTpEditHelper.initKdtBgRptRow(this.editData, this.kdtBgRptTpRows);
        if (this.getOprtState().equals("VIEW")) {
            this.kdtBgRptTpRows.getStyleAttributes().setLocked(true);
        }
        if (refByForm = (ibt = BgTemplateFactory.getRemoteInstance()).checkRefByBgForm(this.editData.getBgTemplate().getId())) {
            this.comboBgMethod.setEnabled(false);
            this.comboBgCycle.setEnabled(false);
            this.comboRollingBgCycle.setEnabled(false);
            this.kdtBgRptTpRows.getStyleAttributes().setLocked(true);
            this.btnInsert.setEnabled(false);
            this.btnAppend.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.btnPickFormula.setEnabled(false);
        }
    }

    @Override
    protected void comboBgMethod_actionPerformed(ActionEvent e) throws Exception {
        super.comboBgMethod_actionPerformed(e);
        if (!this.comboBgMethod.isEnabled()) {
            return;
        }
        this.onBgMethodChanged();
    }

    private void onBgMethodChanged() {
        if (this.comboBgMethod.getSelectedItem() == null) {
            return;
        }
        BgMethodEnum bgMethodEnum = (BgMethodEnum)((Object)this.comboBgMethod.getSelectedItem());
        if (bgMethodEnum.getValue() == 1) {
            this.comboRollingBgCycle.setEnabled(false);
            int itemCount = this.comboBgCycle.getItemCount();
            boolean isExist = false;
            for (int i = 0; i < itemCount; ++i) {
                BgCycleTypeEnum bgCycleTypeEnumTemp = (BgCycleTypeEnum)((Object)this.comboBgCycle.getItemAt(i));
                if (bgCycleTypeEnumTemp.getValue() != 1) continue;
                isExist = true;
                break;
            }
            if (!isExist) {
                this.comboBgCycle.addItem((Object)BgCycleTypeEnum.Year);
            }
        } else {
            this.comboRollingBgCycle.setEnabled(true);
            this.comboBgCycle.removeItem((Object)BgCycleTypeEnum.Year);
            this.onBgCycleChange();
        }
    }

    protected void afterLoadFields_AddNew() throws EASBizException, BOSException {
        BgTypeInfo inBgTypeInfo = (BgTypeInfo)this.getUIContext().get("BgType");
        if (inBgTypeInfo == null) {
            SysUtil.abort();
        }
        this.editData.getBgTemplate().setBgType(inBgTypeInfo);
        this.bizPromptBgType.setData((Object)inBgTypeInfo);
        FullOrgUnitInfo inOrgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("EditOrg");
        if (inOrgUnitInfo == null) {
            SysUtil.abort();
        }
        this.editData.getBgTemplate().setOrgUnit(inOrgUnitInfo);
        this.bizPromptOrgUnit.setData((Object)inOrgUnitInfo);
        if (inOrgUnitInfo.isIsCompanyOrgUnit()) {
            CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
            companyInfo.setId(inOrgUnitInfo.getId());
            this.editData.getBgTemplate().setCompany(companyInfo);
        } else {
            IOrgUnitCommon iOrgUnitCommon = OrgUnitCommonFactory.getRemoteInstance();
            CompanyOrgUnitInfo companyInfo = iOrgUnitCommon.getCompany(inOrgUnitInfo.getId());
            this.editData.getBgTemplate().setCompany(companyInfo);
        }
        this.setDefaultData();
        BgTemplateEditHelper.addCodeRule(this.txtNumber, this.editData.getBgTemplate());
    }

    private void setDefaultData() throws EASBizException, BOSException {
        BgClientHelper.initDefaultCreator(this.bizPromptCreator);
        this.kDDatePickerEditDate.setValue((Object)Calendar.getInstance().getTime());
        this.comboBgMethod.setSelectedItem((Object)BgMethodEnum.TradBudget);
        this.comboBgCycle.setSelectedItem((Object)BgCycleTypeEnum.Period);
        this.comboRollingBgCycle.setSelectedItem((Object)BgCycleTypeEnum.Season);
        this.checkBoxEnabled.setSelected(true);
        this.editData.getBgTemplate().setBgCtrlType(BgCtrlTypeEnum.NoCtrl);
        if (this.editData.getBgTemplate().getBgType().getNumber().equals("BalanceSheetBudget")) {
            IRow row = this.kdtBgRptTpRows.addRow();
            BgRptTemplateRowInfo aRowInfo = new BgRptTemplateRowInfo();
            aRowInfo.setType(BgRptRowTypeEnum.Total);
            aRowInfo.setPrefixType(BgRptRowPrefixTypeEnum.None);
            aRowInfo.setNumber("TotalAssets");
            aRowInfo.setName(EASResource.getString((String)"com.kingdee.eas.ma.bg.BgRptTpResource", (String)"TotalAssets"));
            BgRptTpEditHelper.fillKdtBgRptRow(aRowInfo, row);
            row = this.kdtBgRptTpRows.addRow();
            aRowInfo.setNumber("TotalLiabilitiesAndEquity");
            aRowInfo.setName(EASResource.getString((String)"com.kingdee.eas.ma.bg.BgRptTpResource", (String)"TotalLiabilitiesAndEquity"));
            BgRptTpEditHelper.fillKdtBgRptRow(aRowInfo, row);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        try {
            if (!this.kdtBgRptTpRows.getStyleAttributes().isLocked()) {
                BgRptTpEditHelper.readBgRptRow(this.editData, this.kdtBgRptTpRows);
                this.editData.getBgTemplate().remove("refdimensions");
                this.editData.getBgTemplate().put("refDimensions", (Object)new ReferencedDimensionCollection());
                ReferencedDimensionInfo refDim = new ReferencedDimensionInfo();
                refDim.setIsPrimary(true);
                Iterator iter = this.editData.getBgRptTpRows().iterator();
                while (iter.hasNext()) {
                    BgRptTemplateRowInfo bgRptTpRowInfo = (BgRptTemplateRowInfo)iter.next();
                    BgItemInfo bgItemInfo = new BgItemInfo();
                    refDim.getBgItems().add(bgRptTpRowInfo.getRptBgItem());
                }
                this.editData.getBgTemplate().getRefDimensions().add(refDim);
            }
        }
        catch (BgTemplateException e) {
            this.handUIException((Throwable)((Object)e));
            SysUtil.abort();
        }
        if (this.getOprtState().equals("ADDNEW")) {
            this.editData.getBgTemplate().setIsMultidimensional(true);
        }
        CurrencyCollection currencyCollection = BgTemplateEditHelper.getCurrencyFromBox(this.bizPromptBoxCurrency);
        this.editData.getBgTemplate().initRefCurrency(currencyCollection);
    }

    protected IObjectValue createNewData() {
        return new BgRptTemplateInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgRptTemplateFactory.getRemoteInstance();
    }

    @Override
    protected void kdtBgRptTpRows_editStopped(KDTEditEvent e) throws Exception {
        super.kdtBgRptTpRows_editStopped(e);
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        IRow row = this.kdtBgRptTpRows.getRow(rowIndex);
        if (this.kdtBgRptTpRows.getColumnIndex("prefixType") == colIndex) {
            BgRptRowPrefixTypeEnum thePrefixType = (BgRptRowPrefixTypeEnum)((Object)e.getValue());
            BgRptTpEditHelper.onEditPrifixType(row, thePrefixType);
        } else if (this.kdtBgRptTpRows.getColumnIndex("formula") == colIndex) {
            this.onEditFormula(row, rowIndex);
        }
    }

    private void onEditFormula(IRow row, int curRowIndex) {
        BgRptRowTypeEnum type = this.getType(row);
        if (type == null) {
            return;
        }
        if (type.getValue() != 3) {
            return;
        }
        ICell cell = row.getCell("formula");
        if (cell.getValue() == null) {
            return;
        }
        Vector v = BgTemplateHelper.parseToDigital(cell.getValue().toString());
        if (v.size() == 2) {
            int beginRow = (Integer)v.get(0);
            int endRow = (Integer)v.get(1);
            if (beginRow > this.kdtBgRptTpRows.getRowCount() || endRow > this.kdtBgRptTpRows.getRowCount()) {
                this.resetTotalFormula(cell);
                return;
            }
            if (beginRow <= 0 || endRow <= 0) {
                this.resetTotalFormula(cell);
                return;
            }
            if (beginRow == curRowIndex + 1) {
                int n = beginRow = beginRow + 1 > this.kdtBgRptTpRows.getRowCount() ? 0 : beginRow + 1;
            }
            if (endRow == curRowIndex + 1) {
                --endRow;
            }
            cell.setValue((Object)BgRptTpHelper.number2TemplateDisplay(beginRow, endRow));
            cell.setUserObject((Object)BgRptTpHelper.number2TotalFormula(beginRow, endRow));
        } else {
            cell.setUserObject(cell.getValue());
        }
    }

    private void resetTotalFormula(ICell cell) {
        cell.setValue((Object)BgRptTpHelper.number2TemplateDisplay("0", "0"));
        cell.setUserObject(null);
    }

    @Override
    protected void btnAppend_actionPerformed(ActionEvent e) throws Exception {
        super.btnAppend_actionPerformed(e);
        IRow row = this.kdtBgRptTpRows.addRow();
        if (row != null) {
            this.initDefaultRow(row);
        }
    }

    @Override
    protected void btnInsert_actionPerformed(ActionEvent e) throws Exception {
        super.btnInsert_actionPerformed(e);
        IRow row = null;
        if (this.kdtBgRptTpRows.getRowCount() == 0) {
            row = this.kdtBgRptTpRows.addRow();
        } else {
            int curRowIndex = this.getSelectedRowIndex();
            if (curRowIndex == -1) {
                curRowIndex = 0;
            }
            row = this.kdtBgRptTpRows.addRow(curRowIndex);
        }
        if (row != null) {
            this.initDefaultRow(row);
        }
    }

    private void initDefaultRow(IRow row) {
        row.getCell("type").setValue((Object)BgRptRowTypeEnum.Common);
        BgRptTpEditHelper.onEditType(row, BgRptRowTypeEnum.Common);
        row.getCell("prefixType").setValue((Object)BgRptRowPrefixTypeEnum.None);
        BgRptTpEditHelper.onEditPrifixType(row, BgRptRowPrefixTypeEnum.None);
        row.getCell("direction").setValue((Object)BgRptRowDirectionEnum.Positive);
        row.getCell("formula").getStyleAttributes().setLocked(false);
    }

    @Override
    protected void btnRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        BgRptTemplateRowInfo info;
        ICell cell;
        String theNumber;
        int curRowIndex = this.getSelectedRowIndex();
        if (curRowIndex == -1 || curRowIndex >= this.kdtBgRptTpRows.getRowCount()) {
            SysUtil.abort();
        }
        if ("TotalAssets".equals(theNumber = (String)(cell = this.kdtBgRptTpRows.getRow(curRowIndex).getCell("number")).getValue()) || "TotalLiabilitiesAndEquity".equals(theNumber)) {
            SysUtil.abort();
        }
        if (this.kdtBgRptTpRows.getRow(curRowIndex).getUserObject() != null && (info = (BgRptTemplateRowInfo)this.kdtBgRptTpRows.getRow(curRowIndex).getUserObject()).isIsFromParent()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgRptTpResource", (String)"NotDelete"));
            SysUtil.abort();
        }
        this.kdtBgRptTpRows.removeRow(curRowIndex);
    }

    protected int getSelectedRowIndex() {
        KDTSelectBlock selectBlock = this.kdtBgRptTpRows.getSelectManager().get();
        if (selectBlock != null) {
            return selectBlock.getTop();
        }
        return -1;
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.doSave(e);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_TemporarilySave_OK"));
        this.getUIWindow().close();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.doSave(e);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        this.getUIWindow().close();
    }

    private void doSave(ActionEvent e) throws Exception {
        this.storeFields();
        this.verifyInput(e);
        CtrlUnitInfo cuInfo = BgOrgHelper.getDefCU();
        this.editData.getBgTemplate().setCU(cuInfo);
        for (int i = 0; i < this.editData.getBgTemplate().getRefDimensions().size(); ++i) {
            ReferencedDimensionInfo info = this.editData.getBgTemplate().getRefDimensions().get(i);
            for (int j = 0; j < info.getBgItems().size(); ++j) {
                info.getBgItems().get(j).setCU(cuInfo);
            }
        }
        IBgRptTemplate ibrt = BgRptTemplateFactory.getRemoteInstance();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            IObjectPK pk = ibrt.addNewCurrent(this.editData);
            this.editData.setId(BOSUuid.read((String)pk.toString()));
            this.setOprtState(OprtState.EDIT);
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            ibrt.updateCurrent((IObjectPK)new ObjectUuidPK(this.editData.getId()), this.editData);
        }
        this.save = true;
    }

    public boolean isSave() {
        return this.save;
    }

    @Override
    protected void bizPromptOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.bizPromptOrgUnit_dataChanged(e);
        this.renderKdtBgRptRow();
    }

    public void renderKdtBgRptRow() {
        KDComboBox kDComboBoxRowType = new KDComboBox();
        kDComboBoxRowType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    BgRptTemplateEditUI.this.onTypeChanged(e);
                }
                catch (Exception exc) {
                    BgRptTemplateEditUI.this.handUIException(exc);
                }
            }
        });
        kDComboBoxRowType.addItems(BgRptRowTypeEnum.getEnumList().toArray());
        this.kdtBgRptTpRows.getColumn("type").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)kDComboBoxRowType));
        KDComboBox kDComboBoxPrefixType = new KDComboBox();
        kDComboBoxPrefixType.addItems(BgRptRowPrefixTypeEnum.getEnumList().toArray());
        this.kdtBgRptTpRows.getColumn("prefixType").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)kDComboBoxPrefixType));
        KDComboBox kDComboBoxDirection = new KDComboBox();
        kDComboBoxDirection.addItems(BgRptRowDirectionEnum.getEnumList().toArray());
        this.kdtBgRptTpRows.getColumn("direction").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)kDComboBoxDirection));
    }

    private void onTypeChanged(ItemEvent e) {
        int rowIndex = this.kdtBgRptTpRows.getSelectManager().getActiveRowIndex();
        IRow iRow = this.kdtBgRptTpRows.getRow(rowIndex);
        if (iRow == null) {
            return;
        }
        BgRptRowTypeEnum bgRptRowType = (BgRptRowTypeEnum)((Object)e.getItem());
        if (bgRptRowType != null) {
            BgRptTpEditHelper.onEditType(iRow, bgRptRowType);
        }
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        IBgRptTemplateDA ibtda = BgRptTemplateDAFactory.getRemoteInstance();
        return ibtda.getBgRptTpByBgTp(pk.toString());
    }

    private void editAccountTotalFormula(IRow selectedRow) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"OrgUnitPath", this.getUIContext().get("OrgPath"));
        IUIWindow accountTotalSelector = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AccountTotalFormulaEditUI.class.getName(), (Map)uiContext, null, null);
        accountTotalSelector.show();
        String totalFormula = ((AccountTotalFormulaEditUI)accountTotalSelector.getUIObject()).getAccountTotalFormula();
        if (totalFormula == null) {
            return;
        }
        ICell cell = selectedRow.getCell("formula");
        cell.setUserObject((Object)totalFormula);
        cell.setValue((Object)totalFormula);
    }

    private void editTotalFormula(IRow selectedRow, int selectedRowIndex) throws UIException {
        int maxLine = this.kdtBgRptTpRows.getRowCount();
        if (maxLine <= 0) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)TableLineSelectorUI.MAXLINE, (Object)new Integer(maxLine));
        uiContext.put((Object)TableLineSelectorUI.CURLINE, (Object)new Integer(selectedRowIndex + 1));
        IUIWindow lineSelector = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TableLineSelectorUI.class.getName(), (Map)uiContext, null, null);
        lineSelector.show();
        String totalFormula = ((TableLineSelectorUI)lineSelector.getUIObject()).getTotalFormula();
        if (totalFormula == null) {
            return;
        }
        ICell cell = selectedRow.getCell("formula");
        cell.setUserObject((Object)totalFormula);
        cell.setValue((Object)BgRptTpHelper.totalFormula2TemplateDisplay(totalFormula));
    }

    private void editCommonFormula() throws Exception {
        FormulaPickerUI picker = FormulaPickerUI.creatFormulaPicker((CoreUIObject)this);
        String filter = "exclude:formulas{BgAcct,BgBalance}";
        picker.addFormulaPickerListener(new IFormulaPickerListener(){

            public void pickerSetout(FormulaPickerUI picker) {
            }

            public void pickerReturnee(FormulaPickerUI picker, String formulaLine, boolean isOk) {
                isOk = true;
                if (true) {
                    BgRptTemplateEditUI.this.savePickerFourmula(formulaLine);
                }
            }
        });
        picker.open(filter, null);
    }

    protected void savePickerFourmula(String formulaLine) {
        if (this.selectedRow == null) {
            return;
        }
        if (formulaLine != null && !formulaLine.equals("")) {
            this.selectedRow.getCell("formula").setValue((Object)formulaLine);
        }
    }

    private BgRptRowTypeEnum getType(IRow row) {
        ICell cell = row.getCell("type");
        if (cell == null) {
            return null;
        }
        return (BgRptRowTypeEnum)((Object)cell.getValue());
    }

    protected void initOldData(IObjectValue dataObject) {
    }

    public boolean checkBeforeWindowClosing() {
        return true;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.editData.getBgTemplate().getNumber() == null || this.editData.getBgTemplate().getNumber().equals("")) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"noNumber"));
            SysUtil.abort();
        }
        if (this.editData.getBgTemplate().getName() == null || this.editData.getBgTemplate().getName().equals("")) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"noName"));
            SysUtil.abort();
        }
        if (this.editData.getBgRptTpRows() == null || this.editData.getBgRptTpRows().size() == 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgRptTpResource", (String)"RowNotNull"));
            SysUtil.abort();
        }
    }

    @Override
    protected void onkDWorkButtonImport_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        BgTypeInfo bgType = this.editData.getBgTemplate().getBgType();
        uiContext.put((Object)"KdtableData", (Object)this.kdtBgRptTpRows);
        uiContext.put((Object)"BgType", (Object)this.editData.getBgTemplate().getBgType());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgRptTemplateFormatUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    protected void onkDWorkButtonExport_actionPerformed(ActionEvent e) throws Exception {
        super.onkDWorkButtonExport_actionPerformed(e);
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setFileFilter((FileFilter)new ExcelFileFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            if (!filePath.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                filePath = filePath + ".xls";
            }
        } else {
            fileChooser.cancelSelection();
            SysUtil.abort();
        }
        if (filePath == null) {
            fileChooser.cancelSelection();
        }
        KDSBook kdsBook = new KDSBook("Common");
        KDSSheet kdsSheet = this.kdtBgRptTpRows.getIOManager().saveToKDSSheet(kdsBook, true, false, "ExportFileName");
        kdsBook.addSheet(null, kdsSheet);
        ExportManager export = new ExportManager();
        try {
            export.exportToExcel(kdsBook, filePath);
        }
        catch (RuntimeException e1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSelectPeriodResource", (String)"fileIsOpen"));
        }
    }

    @Override
    protected void onkDWorkButtonOutImport_actionPerformed(ActionEvent e) throws Exception {
        KDSBook kdsBook;
        super.onkDWorkButtonOutImport_actionPerformed(e);
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setFileFilter((FileFilter)new ExcelFileFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog((Component)((Object)this)) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
        } else {
            fileChooser.cancelSelection();
            SysUtil.abort();
        }
        if (filePath == null) {
            fileChooser.cancelSelection();
        }
        if ((kdsBook = POIXlsReader.parse((String)filePath)) == null) {
            throw new EASBizException(BgFormException.READEXCEL);
        }
        KDSSheet sheet = kdsBook.getSheet((Object)"ExportFileName");
        if (sheet == null) {
            return;
        }
        BgRptTpEditHelper.readKDSSheetData(this.kdtBgRptTpRows, this.editData.getBgTemplate().getBgType(), sheet);
    }

    @Override
    protected void onkdtBgRptTpRows_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.onkdtBgRptTpRows_tableSelectChanged(e);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        int rowIndex = this.kdtBgRptTpRows.getSelectManager().getActiveRowIndex();
        IRow iRow = this.kdtBgRptTpRows.getRow(rowIndex);
        if (iRow == null) {
            return;
        }
        String strNumber = (String)iRow.getCell("number").getValue();
        if (strNumber != null) {
            if (strNumber.equals("TotalAssets") || strNumber.equals("TotalLiabilitiesAndEquity")) {
                iRow.getCell("name").getStyleAttributes().setLocked(true);
                this.btnPickFormula.setEnabled(false);
                this.btnRemove.setEnabled(false);
            } else {
                iRow.getCell("name").getStyleAttributes().setLocked(false);
                this.btnPickFormula.setEnabled(true);
                this.btnRemove.setEnabled(true);
            }
        } else {
            this.btnRemove.setEnabled(true);
        }
        BgRptRowTypeEnum bgRptRowTypeEnum = (BgRptRowTypeEnum)((Object)iRow.getCell("type").getValue());
        if (bgRptRowTypeEnum.equals((Object)BgRptRowTypeEnum.Total)) {
            this.btnPickFormula.setEnabled(false);
        } else {
            this.btnPickFormula.setEnabled(true);
        }
    }

    @Override
    protected void onComboBgCycle_itemStateChanged(ItemEvent e) throws Exception {
        super.onComboBgCycle_itemStateChanged(e);
        this.onBgCycleChange();
    }

    private void onBgCycleChange() {
        BgCycleTypeEnum bgCycleTypeEnum;
        BgMethodEnum bgMethodEnum = (BgMethodEnum)((Object)this.comboBgMethod.getSelectedItem());
        if (bgMethodEnum != null && bgMethodEnum.getValue() == 2 && (bgCycleTypeEnum = (BgCycleTypeEnum)((Object)this.comboBgCycle.getSelectedItem())) != null) {
            if (bgCycleTypeEnum.getValue() == 2) {
                this.comboRollingBgCycle.setSelectedItem((Object)bgCycleTypeEnum);
                this.comboRollingBgCycle.setEnabled(false);
            } else if (bgCycleTypeEnum.getValue() == 3) {
                this.comboRollingBgCycle.setEnabled(true);
            }
        }
    }

    @Override
    public void actionPicFormula_actionPerformed(ActionEvent e) throws Exception {
        super.actionPicFormula_actionPerformed(e);
        ArrayList blockArray = this.kdtBgRptTpRows.getSelectManager().getBlocks();
        if (blockArray == null || blockArray.size() == 0) {
            return;
        }
        int selectedRowIndex = ((KDTBlock)blockArray.get(0)).getTop();
        if (selectedRowIndex < 0 || selectedRowIndex >= this.kdtBgRptTpRows.getRowCount()) {
            return;
        }
        this.selectedRow = this.kdtBgRptTpRows.getRow(selectedRowIndex);
        BgRptRowTypeEnum type = this.getType(this.selectedRow);
        if (type == null) {
            return;
        }
        if (type.getValue() == 2) {
            String bgTypeNumber = this.editData.getBgTemplate().getBgType().getNumber();
            if (bgTypeNumber.equals("BalanceSheetBudget")) {
                this.editAccountTotalFormula(this.selectedRow);
            } else {
                this.editCommonFormula();
            }
        }
    }
}

