/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgFormException;
import com.kingdee.eas.ma.bg.BgRptRowDirectionEnum;
import com.kingdee.eas.ma.bg.BgRptRowPrefixTypeEnum;
import com.kingdee.eas.ma.bg.BgRptRowTypeEnum;
import com.kingdee.eas.ma.bg.BgRptTemplateFormatEnum;
import com.kingdee.eas.ma.bg.BgRptTemplateRowInfo;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.client.AbstractBgRptTemplateFormatUI;
import com.kingdee.eas.ma.bg.client.BgRptTpEditHelper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Map;

public class BgRptTemplateFormatUI
extends AbstractBgRptTemplateFormatUI {
    public static final String KDTABLEDATA = "KdtableData";
    public static final String BGTYPE = "BgType";
    private BgTypeInfo bgTypeInfo = null;
    private KDTable kdtBgRptTpRows = null;
    private String strIncomeBudget = "IncomeStatementBudget.xls";
    private String strBalanceSheetBudget = "BalanceSheetBudget.xls";

    @Override
    public void loadFields() {
        super.loadFields();
        Map uiContext = this.getUIContext();
        this.kdtBgRptTpRows = (KDTable)uiContext.get(KDTABLEDATA);
        this.bgTypeInfo = (BgTypeInfo)uiContext.get(BGTYPE);
        Iterator iterator = BgRptTemplateFormatEnum.iterator();
        while (iterator.hasNext()) {
            BgRptTemplateFormatEnum bgFormatEnum = (BgRptTemplateFormatEnum)((Object)iterator.next());
            if (bgFormatEnum.getValue() != 1 && bgFormatEnum.getValue() != 2) continue;
            IRow iRow = this.kDTableFormat.addRow();
            iRow.setUserObject((Object)bgFormatEnum);
            iRow.getCell("seq").setValue((Object)new Integer(bgFormatEnum.getValue()));
            iRow.getCell("name").setValue((Object)bgFormatEnum.getAlias());
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void onkDTableFormat_tableClicked(KDTMouseEvent e) throws Exception {
        super.onkDTableFormat_tableClicked(e);
        if (e.getClickCount() >= 2) {
            this.importFormat();
            this.getUIWindow().close();
        }
    }

    @Override
    protected void onkDButtonConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.onkDButtonConfirm_actionPerformed(e);
        this.importFormat();
        this.getUIWindow().close();
    }

    @Override
    protected void onkDButtonCancel_actionPerformed(ActionEvent e) throws Exception {
        super.onkDButtonCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    public void importFormat() throws EASBizException {
        KDSBook kdsBook = null;
        String strPath = System.getProperty("easclient.root");
        strPath = strPath == null ? "W:\\eas\\deploy\\client\\" : strPath + "\\";
        kdsBook = this.bgTypeInfo.getNumber().equals("IncomeStatementBudget") ? POIXlsReader.parse((String)(strPath + this.strIncomeBudget)) : POIXlsReader.parse((String)(strPath + this.strBalanceSheetBudget));
        if (kdsBook == null) {
            throw new EASBizException(BgFormException.READEXCEL);
        }
        int rowIndex = this.kDTableFormat.getSelectManager().getActiveRowIndex();
        IRow iRow = this.kDTableFormat.getRow(rowIndex);
        if (iRow == null) {
            return;
        }
        BgRptTemplateFormatEnum bgFormatEnum = (BgRptTemplateFormatEnum)((Object)iRow.getUserObject());
        String sheetName = bgFormatEnum.getAlias();
        KDSSheet sheet = kdsBook.getSheet((Object)sheetName);
        if (sheet == null) {
            return;
        }
        this.readKDSSheetData(sheet);
    }

    public void onLoad() throws Exception {
        this.kDTableFormat.checkParsed();
        super.onLoad();
        this.loadFields();
    }

    public void readKDSSheetData(KDSSheet sheet) {
        int columnCount = 7;
        this.kdtBgRptTpRows.removeRows();
        String strName = null;
        Object strSpaceNumber = null;
        String strType = null;
        String strPrefixType = null;
        String strDirection = null;
        String strPre = null;
        String strFounula = null;
        String strNameSum = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgRptTpResource", (String)"TotalAssets");
        String strNameTotal = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgRptTpResource", (String)"TotalLiabilitiesAndEquity");
        for (int rowIndex = 1; rowIndex != -1 && !(strName = sheet.getCell(rowIndex, 0, false).getText()).equals(""); ++rowIndex) {
            String strNameTrim = strName.trim();
            IRow iRowTemp = this.kdtBgRptTpRows.addRow();
            BgRptTemplateRowInfo bgRptTpRowInfo = new BgRptTemplateRowInfo();
            if (this.bgTypeInfo.getNumber().equals("BalanceSheetBudget")) {
                if (strNameTrim.equals(strNameSum)) {
                    bgRptTpRowInfo.setNumber("TotalAssets");
                } else if (strNameTrim.equals(strNameTotal)) {
                    bgRptTpRowInfo.setNumber("TotalLiabilitiesAndEquity");
                }
            }
            bgRptTpRowInfo.setName(strName);
            strType = sheet.getCell(rowIndex, 1, false).getText().trim();
            if (!strType.equals("")) {
                for (BgRptRowTypeEnum bgRptRowTypeEnum : BgRptRowTypeEnum.getEnumList()) {
                    if (!strType.equals(bgRptRowTypeEnum.getAlias())) continue;
                    bgRptTpRowInfo.setType(bgRptRowTypeEnum);
                    break;
                }
            }
            if (!(strPrefixType = sheet.getCell(rowIndex, 2, false).getText().trim()).equals("")) {
                for (BgRptRowPrefixTypeEnum bgRptRowPrefixTypeEnum : BgRptRowPrefixTypeEnum.getEnumList()) {
                    if (!strPrefixType.equals(bgRptRowPrefixTypeEnum.getAlias())) continue;
                    bgRptTpRowInfo.setPrefixType(bgRptRowPrefixTypeEnum);
                    break;
                }
            }
            if (!(strPre = sheet.getCell(rowIndex, 3, false).getText().trim()).equals("")) {
                bgRptTpRowInfo.setPrefix(strPre);
            }
            if (!(strDirection = sheet.getCell(rowIndex, 4, false).getText().trim()).equals("")) {
                for (BgRptRowDirectionEnum bgRptRowDirectionEnum : BgRptRowDirectionEnum.getEnumList()) {
                    if (!strDirection.equals(bgRptRowDirectionEnum.getAlias())) continue;
                    bgRptTpRowInfo.setDirection(bgRptRowDirectionEnum);
                    break;
                }
            }
            if (!(strFounula = sheet.getCell(rowIndex, 5, false).getText().trim()).equals("")) {
                bgRptTpRowInfo.setFormula(strFounula);
            }
            BgRptTpEditHelper.fillKdtBgRptRow(bgRptTpRowInfo, iRowTemp);
        }
    }
}

