/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgOrgHelper;
import com.kingdee.eas.ma.bg.BgSchemeFactory;
import com.kingdee.eas.ma.bg.BgSchemeHelper;
import com.kingdee.eas.ma.bg.BgSchemeInfo;
import com.kingdee.eas.ma.bg.BgTemplateDAFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.EASLoginModel;
import com.kingdee.eas.ma.bg.IBgScheme;
import com.kingdee.eas.ma.bg.IBgTemplateDA;
import com.kingdee.eas.ma.bg.client.AbstractBgSchemeTreeListUI;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.ma.bg.client.BgSchemeEditUI;
import com.kingdee.eas.ma.bg.client.BgSubOrgUnitSelectorUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Map;

public class BgSchemeTreeListUI
extends AbstractBgSchemeTreeListUI {
    public BgTypeInfo selectedBgTypeInfo;
    boolean isGroupStart = BgHelper.isStartGroupUsing();

    @Override
    protected void enableBtns(boolean flag) {
        super.enableBtns(flag);
        if (this.kDWorkButtonSendDown != null) {
            this.kDWorkButtonSendDown.setEnabled(flag);
        }
    }

    @Override
    protected void initComboxOrgType() {
        this.isBgScheme = true;
        super.initComboxOrgType();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getOrgUnitId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        IQueryExecutor queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        return queryExecutor;
    }

    protected String getEditUIName() {
        return BgSchemeEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgSchemeFactory.getRemoteInstance();
    }

    @Override
    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId());
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        CtrlUnitInfo orgCtrl = SysContext.getSysContext().getCurrentCtrlUnit();
        IFullOrgUnit iFull = FullOrgUnitFactory.getRemoteInstance();
        BgClientHelper.checkIsOnCU((CoreUI)this, this.getBGOrgUnitInfo(), orgCtrl);
        FullOrgUnitInfo orgInfo = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgCtrl.getId()));
        uiContext.put((Object)"EditOrg", (Object)orgInfo);
        uiContext.put((Object)"EditCtrlOrg", (Object)orgCtrl);
        IBgTemplateDA ibtda = BgTemplateDAFactory.getRemoteInstance();
        boolean isGroup = ibtda.getIsGrouping(orgInfo.getId().toString());
        if (isGroup && !this.isGroupStart) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"GroupNotUsing"));
            return;
        }
        uiContext.put((Object)"identity", (Object)String.valueOf(System.currentTimeMillis()));
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refresh(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        CtrlUnitInfo orgCtrl = SysContext.getSysContext().getCurrentCtrlUnit();
        IFullOrgUnit iFull = FullOrgUnitFactory.getRemoteInstance();
        BgClientHelper.checkIsOnCU((CoreUI)this, this.getBGOrgUnitInfo(), orgCtrl);
        this.checkSelected();
        BOSUuid id = BOSUuid.read((String)this.getSelectedKeyValue());
        if (id == null) {
            return;
        }
        IBgScheme ibt = BgSchemeFactory.getRemoteInstance();
        if (ibt.isUsedBgScheme(id)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"hadUserdnotDelete"));
            return;
        }
        if (ibt.checkIsEsixstLowerScheme(id)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"RefByLowerScheme"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    public static void main(String[] args) {
        EASLoginModel.newInstance().loginMain(BgSchemeTreeListUI.class.getName());
    }

    @Override
    public void actionAssign_actionPerformed(ActionEvent e) throws Exception {
        CtrlUnitInfo orgCtrl = SysContext.getSysContext().getCurrentCtrlUnit();
        IFullOrgUnit iFull = FullOrgUnitFactory.getRemoteInstance();
        BgClientHelper.checkIsOnCU((CoreUI)this, this.getBGOrgUnitInfo(), orgCtrl);
        this.checkSelected();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        FullOrgUnitInfo org = this.getBGOrgUnitInfo();
        INewOrgViewFacade iNew = NewOrgViewFacadeFactory.getRemoteInstance();
        int orgView = (Integer)org.get("treeType");
        OrgUnitCollection orgUnitCollectionSub = iNew.getChildren(org.getId().toString(), OrgViewType.getEnum((int)orgView));
        if (orgUnitCollectionSub == null || orgUnitCollectionSub.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"noSubOrgNotSendDown"));
            return;
        }
        UIContext uiContextOrg = new UIContext((Object)this);
        uiContextOrg.put((Object)"EditOrg", (Object)orgUnitCollectionSub);
        IUIWindow orgSelectorUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgSubOrgUnitSelectorUI.class.getName(), (Map)uiContextOrg, null, null);
        orgSelectorUI.show();
        OrgUnitCollection subOrgs = ((BgSubOrgUnitSelectorUI)orgSelectorUI.getUIObject()).getOrgUnitCollectionSub();
        if (subOrgs == null || subOrgs.size() == 0) {
            return;
        }
        ICompanyOrgUnit iCom = CompanyOrgUnitFactory.getRemoteInstance();
        for (int i = 0; i < subOrgs.size(); ++i) {
            if (iCom.exists((IObjectPK)new ObjectUuidPK(subOrgs.get(i).getId()))) continue;
            MsgBox.showWarning((Component)((Object)this), (String)"\u4e0b\u7ea7CU\u4e0d\u662f\u516c\u53f8\uff0c\u8bf7\u4fee\u6539CU\u7684\u7ec4\u7ec7\u5c5e\u6027\uff01");
            SysUtil.abort();
        }
        int currRow = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow iRow = this.tblMain.getRow(currRow);
        String strId = iRow.getCell("id").getValue().toString();
        IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
        BgSchemeInfo bgSchemeInfo = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(strId), BgSchemeHelper.getAssignSelectors());
        if (bgSchemeInfo == null) {
            String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectedScheme");
            MsgBox.showWarning((Component)((Object)this), (String)strErr);
            return;
        }
        OrgUnitInfo orgUnitInfo = null;
        for (int i = 0; i < subOrgs.size(); ++i) {
            orgUnitInfo = subOrgs.get(i);
            boolean isAssign = iBgScheme.checkIsAssignByOrgUnit(bgSchemeInfo.getId(), orgUnitInfo.getId());
            if (isAssign) {
                String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"ExistedAssignScheme");
                int yes = MsgBox.showConfirm2((Component)((Object)this), (String)(orgUnitInfo.getName() + strErr));
                if (yes != 0) {
                    return;
                }
            }
            BgSchemeInfo bgSchemeInfoNew = new BgSchemeInfo();
            bgSchemeInfoNew.setId(BOSUuid.create((BOSObjectType)bgSchemeInfoNew.getBOSType()));
            bgSchemeInfoNew.setNumber(bgSchemeInfo.getNumber() + "_" + orgUnitInfo.getNumber());
            bgSchemeInfoNew.setName(bgSchemeInfo.getName() + "_" + orgUnitInfo.getName());
            bgSchemeInfoNew.setIsFormal(false);
            bgSchemeInfoNew.setIsSysDefined(bgSchemeInfo.isIsSysDefined());
            this.getDecPeriodInfo(bgSchemeInfo);
            CompanyOrgUnitInfo companyOrgUnitInfo = this.getDecOrgUnitInfo(orgUnitInfo);
            PeriodInfo periodInfoFrom = PeriodUtils.getPeriod((PeriodInfo)bgSchemeInfo.getPeriodFrom(), (CompanyOrgUnitInfo)companyOrgUnitInfo);
            PeriodInfo periodInfoTo = PeriodUtils.getPeriod((PeriodInfo)bgSchemeInfo.getPeriodTo(), (CompanyOrgUnitInfo)companyOrgUnitInfo);
            if (periodInfoFrom == null || periodInfoTo == null) {
                String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"notExistPeriodConversion");
                MsgBox.showWarning((Component)((Object)this), (String)strErr);
                return;
            }
            bgSchemeInfoNew.setPeriodFrom(periodInfoFrom);
            bgSchemeInfoNew.setPeriodTo(periodInfoTo);
            bgSchemeInfoNew.setCreator(bgSchemeInfo.getCreator());
            bgSchemeInfoNew.setCreateTime(new Timestamp(System.currentTimeMillis()));
            bgSchemeInfoNew.setParentScheme(bgSchemeInfo);
            bgSchemeInfoNew.setOrgUnit(orgUnitInfo);
            if (bgSchemeInfo.getCompany() != null && orgUnitInfo.getId().equals((Object)bgSchemeInfo.getCompany().getId())) {
                String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"sendDownOrgUintNotEqualsCurrOrgUnit");
                MsgBox.showWarning((Component)((Object)this), (String)strErr);
                return;
            }
            bgSchemeInfoNew.setCompany(companyOrgUnitInfo);
            bgSchemeInfoNew.setNumber(bgSchemeInfoNew.getNumber() + "_" + BgHelper.getTimeString());
            bgSchemeInfoNew.setCU(BgOrgHelper.getDefCU());
            iBgScheme.submit((CoreBaseInfo)bgSchemeInfoNew);
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"sendDownSucc"));
        this.refresh(e);
    }

    public void getDecPeriodInfo(BgSchemeInfo bgSchemeInfo) {
        try {
            String strErr;
            IPeriod iperiod = PeriodFactory.getRemoteInstance();
            PeriodInfo periodFromTemp = bgSchemeInfo.getPeriodFrom();
            PeriodInfo periodFromToTemp = bgSchemeInfo.getPeriodTo();
            if (periodFromTemp.getPeriodType() == null || periodFromTemp.getPeriodType().getId() == null) {
                periodFromToTemp = (PeriodInfo)iperiod.getValue((IObjectPK)new ObjectUuidPK(bgSchemeInfo.getPeriodFrom().getId()));
                if (periodFromTemp.getPeriodType() == null || periodFromTemp.getPeriodType().getId() == null) {
                    strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSetPeriodRelation");
                    MsgBox.showWarning((Component)((Object)this), (String)strErr);
                    SysUtil.abort();
                } else {
                    bgSchemeInfo.setPeriodFrom(periodFromTemp);
                }
            }
            if (periodFromToTemp.getPeriodType() == null || periodFromToTemp.getPeriodType().getId() == null) {
                if ((periodFromToTemp = (PeriodInfo)iperiod.getValue((IObjectPK)new ObjectUuidPK(periodFromToTemp.getId()))).getPeriodType() == null || periodFromToTemp.getPeriodType().getId() == null) {
                    strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSetPeriodRelation");
                    MsgBox.showWarning((Component)((Object)this), (String)strErr);
                    SysUtil.abort();
                } else {
                    bgSchemeInfo.setPeriodTo(periodFromToTemp);
                }
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
    }

    public CompanyOrgUnitInfo getDecOrgUnitInfo(OrgUnitInfo orgUnitInfo) {
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        try {
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            companyOrgUnitInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()));
            if (companyOrgUnitInfo.getAccountPeriodType() == null || companyOrgUnitInfo.getAccountPeriodType().getId() == null) {
                String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSetPeriodType");
                MsgBox.showWarning((Component)((Object)this), (String)strErr);
                SysUtil.abort();
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        return companyOrgUnitInfo;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.setIcon();
        this.separator2.setVisible(false);
        this.kDSeparator2.setVisible(false);
        int itemCount = this.comboxOrgType.getItemCount();
        if (itemCount > 0) {
            this.comboxOrgType.setSelectedItem((Object)OrgViewType.CTRLUNIT);
            this.comboxOrgType.setEnabled(false);
        }
        this.treeViewOrgUnit.setTitle(OrgViewType.CTRLUNIT.getAlias());
        this.btnAddNew.setEnabled(true);
        this.actionAddNew.setEnabled(true);
    }

    public void setIcon() {
        this.kDWorkButtonSendDown.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
    }
}

