/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgPeriodNode;
import com.kingdee.eas.ma.bg.client.AbstractBgSplitPeriodUI;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class BgSplitPeriodUI
extends AbstractBgSplitPeriodUI {
    private BigDecimal[] scale;

    @Override
    public void loadFields() {
        super.loadFields();
        this.initTable();
    }

    public void initTable() {
        this.tblMain.removeHeadRows();
        this.tblMain.removeRows();
        this.tblMain.removeColumns();
        IColumn col1 = this.tblMain.addColumn();
        col1.setKey("period");
        col1.getStyleAttributes().setLocked(true);
        IColumn col2 = this.tblMain.addColumn();
        col2.setKey("scale");
        IRow mainHeadRow1 = this.tblMain.addHeadRow();
        mainHeadRow1.getCell("period").setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSplitResource", (String)"Period"));
        mainHeadRow1.getCell("scale").setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSplitResource", (String)"Scale"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadFields();
        PeriodCollection pc = (PeriodCollection)this.getUIContext().get("splitPeriods");
        BgCycleTypeEnum cycle = (BgCycleTypeEnum)((Object)this.getUIContext().get("bgCycle"));
        this.scale = new BigDecimal[pc.size()];
        for (int i = 0; i < pc.size(); ++i) {
            IRow row = this.tblMain.addRow();
            BgPeriodNode node = new BgPeriodNode();
            node.setBgCycle(cycle);
            node.setPeriod(pc.get(i));
            row.getCell("period").setValue((Object)node);
        }
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        this.verifyInput();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            this.scale[i] = new BigDecimal(row.getCell("scale").getValue().toString());
        }
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel1_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel1_actionPerformed(e);
        this.getUIWindow().close();
    }

    public void verifyInput() {
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            String value1 = (String)this.tblMain.getRow(i).getCell(1).getValue();
            if (value1 == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSplitResource", (String)"inputScale"));
                this.tblMain.getEditManager().editCellAt(i, 1);
                SysUtil.abort();
            }
            if (!BgClientHelper.verifyIsNumber(value1)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"inputNumber"));
                this.tblMain.getEditManager().editCellAt(i, 1);
                SysUtil.abort();
            }
            if (!BgClientHelper.verifyIsPlus(value1)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"inputPlus"));
                this.tblMain.getEditManager().editCellAt(i, 1);
                SysUtil.abort();
            }
            DecimalFormat format = BgClientHelper.getDecimalFormat();
            value1 = format.format(new BigDecimal(value1));
            this.tblMain.getRow(i).getCell(1).setValue((Object)value1);
        }
        if (!this.checkScale()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSplitResource", (String)"errorScale"));
            SysUtil.abort();
        }
    }

    private boolean checkScale() {
        int rowCount = this.tblMain.getRowCount();
        float value = 0.0f;
        for (int i = 0; i < rowCount; ++i) {
            value += Float.parseFloat((String)this.tblMain.getRow(i).getCell(1).getValue());
        }
        return !(value - 100.0f > 0.0f) && !(value - 100.0f < 0.0f);
    }

    public BigDecimal[] getScale() {
        return this.scale;
    }
}

