/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgOrgHelper;
import com.kingdee.eas.ma.bg.BgTypeCollection;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgType;
import com.kingdee.eas.ma.bg.client.AbstractBgTypeF7UI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgTypeF7UI
extends AbstractBgTypeF7UI {
    private boolean isCancel = true;
    private BgTypeInfo result = null;
    private final String NAME = "name";
    private final String NUMBER = "number";
    private static final Logger logger = CoreUIObject.getLogger(BgTypeF7UI.class);

    public void initKDtable() {
        this.kdtable.removeHeadRows();
        this.kdtable.removeRows();
        this.kdtable.removeColumns();
        this.kdtable.checkParsed();
        this.kdtable.getStyleAttributes().setLocked(true);
        IColumn iColumn = this.kdtable.addColumn();
        iColumn.setKey("number");
        iColumn.setWidth(170);
        IColumn iColumn1 = this.kdtable.addColumn();
        iColumn1.setKey("name");
        iColumn1.setWidth(170);
        IRow iRow = this.kdtable.addHeadRow();
        String strNumber = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"number");
        String strName = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"name");
        iRow.getCell("number").setValue((Object)strNumber);
        iRow.getCell("name").setValue((Object)strName);
        this.kdtable.getSelectManager().setSelectMode(2);
    }

    public BgTypeF7UI() throws Exception {
        this.initKDtable();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        int currRow = this.kdtable.getSelectManager().getActiveRowIndex();
        if (currRow != -1) {
            IRow iRow = this.kdtable.getRow(currRow);
            this.result = (BgTypeInfo)iRow.getUserObject();
        } else {
            this.result = null;
        }
        this.isCancel = false;
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }

    @Override
    protected void kdtable_tableClicked(KDTMouseEvent e) throws Exception {
        super.kdtable_tableClicked(e);
        if (e.getClickCount() == 2) {
            this.onBtnOK();
        }
    }

    private void onBtnOK() throws BOSException, EASBizException {
        KDTSelectBlock selectBlock = this.kdtable.getSelectManager().get();
        if (selectBlock == null) {
            return;
        }
        int currRow = this.kdtable.getSelectManager().getActiveRowIndex();
        IRow iRow = this.kdtable.getRow(currRow);
        this.result = (BgTypeInfo)iRow.getUserObject();
        this.isCancel = false;
        this.getUIWindow().close();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String strOrgNumber = (String)this.getUIContext().get("orgNumber");
        this.putDataToKDTable(strOrgNumber);
    }

    public void putDataToKDTable(String strOrgNumber) {
        block7: {
            try {
                if (strOrgNumber == null || strOrgNumber.length() == 0) {
                    String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectBgType");
                    MsgBox.showWarning((Component)((Object)this), (String)strErr);
                    return;
                }
                IFullOrgUnit iOrgUnit = FullOrgUnitFactory.getRemoteInstance();
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)strOrgNumber, CompareType.EQUALS));
                entityViewInfo.setFilter(filterInfo);
                OrgUnitCollection orgUnitCollection = iOrgUnit.getOrgUnitCollection(entityViewInfo);
                if (orgUnitCollection.size() == 0) {
                    this.kdtable.removeRows();
                    return;
                }
                FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)orgUnitCollection.get(0);
                Vector vec = BgOrgHelper.getOrgTypes(orgUnitInfo);
                IBgType iBgType = BgTypeFactory.getRemoteInstance();
                BgTypeCollection bgTypeCollection = iBgType.getCollection(vec);
                if (bgTypeCollection != null) {
                    Iterator iterator = bgTypeCollection.iterator();
                    this.kdtable.removeRows();
                    while (iterator.hasNext()) {
                        BgTypeInfo bgTypeInfo = (BgTypeInfo)iterator.next();
                        IRow iRow = this.kdtable.addRow();
                        iRow.setUserObject((Object)bgTypeInfo);
                        iRow.getCell("number").setValue((Object)bgTypeInfo.getNumber());
                        iRow.getCell("name").setValue((Object)bgTypeInfo.getName());
                    }
                    break block7;
                }
                this.kdtable.removeRows();
                String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectBgType");
                MsgBox.showWarning((Component)((Object)this), (String)strErr);
                return;
            }
            catch (BOSException e) {
                throw new IllegalComponentStateException(e.toString());
            }
            catch (EASBizException e) {
                throw new IllegalComponentStateException(e.toString());
            }
        }
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public BgTypeInfo getResult() {
        return this.result;
    }
}

