/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgAdjustHelper;
import com.kingdee.eas.ma.bg.BgCtrlTypeEnum;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgDataCollection;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgEntryTypeEnum;
import com.kingdee.eas.ma.bg.BgFormProcessFactory;
import com.kingdee.eas.ma.bg.BgItemCollection;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.BgV2ManagerFactory;
import com.kingdee.eas.ma.bg.IBgV2Manager;
import com.kingdee.eas.ma.bg.ReferencedDimensionCollection;
import com.kingdee.eas.ma.bg.ReferencedDimensionInfo;
import com.kingdee.eas.ma.bg.client.AbstractBgV2FormAdjustEditUI;
import com.kingdee.eas.ma.bg.client.BgAdjustFormEditUIHelper;
import com.kingdee.eas.ma.bg.client.BgItemHelperFactory;
import com.kingdee.eas.ma.bg.client.BgV2FormEditUIHelper;
import com.kingdee.eas.ma.bg.client.IBgItemHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgV2FormAdjustEditUI
extends AbstractBgV2FormAdjustEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BgV2FormAdjustEditUI.class);
    private boolean thisFormHasChanged = false;
    private final String RESOURCE = "com.kingdee.eas.ma.bg.client.BgAdjustFormResource";
    Component thisComp = this;
    private IOrgUnitCommon iOrgUnitCommon = null;
    private FullOrgUnitInfo orgUnitInfo;
    private BgTypeInfo bgTypeInfo;
    private HashMap hmAdjust = new HashMap();
    private HashMap hmEntries = new HashMap();

    @Override
    public void setIcon() {
        super.setIcon();
        this.btnAddItem.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelItem.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnRename.setVisible(false);
    }

    public BgV2FormAdjustEditUI() throws Exception {
        this.kdt.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
                BgV2FormAdjustEditUI.this.thisFormHasChanged = true;
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
            }

            public void editCanceled(KDTEditEvent arg0) {
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
        BgV2FormEditUIHelper.loadFields(this);
        this.initButton();
        this.initHmAdjust();
    }

    @Override
    public void actionAddItem_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddItem_actionPerformed(e);
        if (!this.canModify()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgAdjustFormResource", (String)"notModify"));
            SysUtil.abort();
        }
        int currentIndex = this.kdt.getRowCount() - 1;
        ReferencedDimensionCollection dimColl = this.bgTemInfo.getVisibleDims();
        IRow row = this.kdt.addRow(currentIndex + 1);
        row.setUserObject((Object)BgAdjustHelper.ADJUST_ADDITEM);
        Iterator visibleRefDimsIter = dimColl.iterator();
        int columnCursor = 0;
        while (visibleRefDimsIter.hasNext()) {
            ReferencedDimensionInfo refDimInfo = (ReferencedDimensionInfo)visibleRefDimsIter.next();
            BgDimensionEnum dimEnum = refDimInfo.getBgDimension();
            String refName = dimEnum.getName();
            KDTDefaultCellEditor editor = BgAdjustFormEditUIHelper.getEditor(this.editData, this.bgTemInfo.getBgType(), this.bgTemInfo.getOrgUnit(), dimEnum, (IUIObject)this);
            ICell cell = row.getCell(columnCursor);
            cell.setEditor((ICellEditor)editor);
            cell.getStyleAttributes().setLocked(false);
            ++columnCursor;
        }
        for (int i = columnCursor; i < this.kdt.getColumnCount(); ++i) {
            row.getCell(i).setValue((Object)"0.00");
            BgDataInfo bgData = new BgDataInfo();
            bgData.setBgValue(new BigDecimal("0.00"));
            bgData.setElementNumber(((BgElementInfo)this.kdt.getHeadRow(1).getCell(i).getValue()).getNumber());
            bgData.setBgCtrlType(BgCtrlTypeEnum.PeriodCtrl);
            bgData.setFlexibleBgCtrlParam(new BigDecimal("0.00"));
            bgData.setId(BOSUuid.create((BOSObjectType)bgData.getBOSType()));
            bgData.setCurrency((CurrencyInfo)this.comboCurrency.getSelectedItem());
            BgElementInfo element = (BgElementInfo)this.kdt.getHeadRow(1).getCell(i).getValue();
            bgData.setDataType(element.getDataType());
            row.getCell(i).setUserObject((Object)bgData);
        }
        row.getStyleAttributes().setLocked(false);
        this.kdt.getEditManager().editCellAt(currentIndex + 1, 0);
    }

    @Override
    public void actionDelItem_actionPerformed(ActionEvent e) throws Exception {
        int currentIndex;
        super.actionDelItem_actionPerformed(e);
        if (!this.canModify()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgAdjustFormResource", (String)"notModify"));
            SysUtil.abort();
        }
        if ((currentIndex = this.kdt.getSelectManager().getActiveRowIndex()) < 0) {
            return;
        }
        ICell cel = this.kdt.getCell(currentIndex, this.bgTemInfo.getVisibleDims().size());
        BgDataInfo data = (BgDataInfo)cel.getUserObject();
        IRow irow = this.kdt.getRow(this.kdt.getSelectManager().getActiveRowIndex());
        if (!(irow.getUserObject() != null && ((String)irow.getUserObject()).equals(BgAdjustHelper.ADJUST_ADDITEM) || BgV2ManagerFactory.getRemoteInstance().checkIsAdjustItem(data.getId().toString()))) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgAdjustFormResource", (String)"canNotDelItemInTemp"));
            SysUtil.abort();
        }
        HashMap hmDelItem = (HashMap)this.hmAdjust.get(BgAdjustHelper.ADJUST_DELITEM);
        BgItemCollection bgItemCol = (BgItemCollection)((Object)hmDelItem.get(BgAdjustHelper.ADJUST_BGITEM));
        BgDataCollection bgDataCol = (BgDataCollection)((Object)hmDelItem.get(BgAdjustHelper.ADJUST_BGDATA));
        ReferencedDimensionCollection dimColl = this.bgTemInfo.getVisibleDims();
        Iterator visibleRefDimsIter = dimColl.iterator();
        int columnCursor = 0;
        IRow row = this.kdt.getRow(currentIndex);
        Object rowObject = row.getUserObject();
        if (rowObject == null || !((String)rowObject).equals(BgAdjustHelper.ADJUST_ADDITEM)) {
            ICell cell;
            int i;
            for (i = 0; i < dimColl.size(); ++i) {
                cell = row.getCell(columnCursor);
                bgItemCol.add((BgItemInfo)cell.getValue());
                ++columnCursor;
            }
            for (i = columnCursor; i < this.kdt.getColumnCount(); ++i) {
                cell = row.getCell(columnCursor);
                bgDataCol.add((BgDataInfo)cell.getUserObject());
            }
        }
        this.kdt.removeRow(currentIndex);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public boolean checkBeforeWindowClosing() {
        return super.checkBeforeWindowClosing();
    }

    private void deleteCurrentAdjustingForm() {
        String strAdjustingFormId = this.bgFormId;
        try {
            BgFormProcessFactory.getRemoteInstance().deleteBgForm(strAdjustingFormId);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void initButton() {
        this.btnCheckRpt.setVisible(false);
        this.btnSplit.setVisible(false);
        this.btnPostil.setVisible(false);
        this.btnAgree.setVisible(false);
        this.btnViewPastRecord.setVisible(false);
        this.btnViewPostil.setVisible(false);
        this.btnViewLog.setVisible(false);
        this.btnAddItem.setVisible(false);
        this.btnDelItem.setVisible(false);
    }

    public boolean canModify() throws Exception {
        return true;
    }

    @Override
    protected void kdt_editStopped(KDTEditEvent e) throws Exception {
        int x = e.getRowIndex();
        int y = e.getColIndex();
        if (this.kdt.getColumnKey(y).startsWith("dim")) {
            ICell cell = this.kdt.getCell(x, y);
            Object thisCell = cell.getValue();
            if (thisCell == null) {
                return;
            }
            ReferencedDimensionCollection refCol = this.bgTemInfo.getRefDimensions();
            IBgItemHelper bgItemHelper = this.getBgItemHelper(refCol.get(y).getBgDimension());
            BgItemInfo bgItemInfo = bgItemHelper.convertBgItem(thisCell);
            bgItemInfo.setIsFromParent(false);
            cell.setUserObject((Object)bgItemInfo);
            cell.setValue((Object)bgItemInfo);
        } else {
            super.kdt_editStopped(e);
        }
    }

    public IBgItemHelper getBgItemHelper(BgDimensionEnum dimEnum) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (this.bgTypeInfo == null) {
            this.bgTypeInfo = this.bgTemInfo.getBgType();
        }
        if (this.orgUnitInfo == null) {
            this.orgUnitInfo = this.bgTemInfo.getOrgUnit();
        }
        IBgItemHelper iBgItemHelper = new BgItemHelperFactory().getBgItemHelper(this.bgTypeInfo, dimEnum, this.orgUnitInfo);
        return iBgItemHelper;
    }

    private void initHmAdjust() {
        BgItemCollection addBgItemCol = new BgItemCollection();
        BgItemCollection delBgItemCol = new BgItemCollection();
        Vector vecAddBgItemColForCheck = new Vector();
        BgDataCollection addBgDataCol = new BgDataCollection();
        BgDataCollection delBgDataCol = new BgDataCollection();
        HashMap<String, Object> hmAdd = new HashMap<String, Object>();
        hmAdd.put(BgAdjustHelper.ADJUST_BGITEM, (Object)addBgItemCol);
        hmAdd.put(BgAdjustHelper.ADJUST_BGDATA, (Object)addBgDataCol);
        hmAdd.put(BgAdjustHelper.ADJUST_ADDITEMFORCHECK, vecAddBgItemColForCheck);
        HashMap<String, AbstractObjectCollection> hmDel = new HashMap<String, AbstractObjectCollection>();
        hmDel.put(BgAdjustHelper.ADJUST_BGITEM, delBgItemCol);
        hmDel.put(BgAdjustHelper.ADJUST_BGDATA, delBgDataCol);
        this.hmAdjust.clear();
        this.hmAdjust.put(BgAdjustHelper.ADJUST_ADDITEM, hmAdd);
        this.hmAdjust.put(BgAdjustHelper.ADJUST_DELITEM, hmDel);
        this.hmAdjust.put(BgAdjustHelper.ADJUST_BGFORMID, this.bgFormId);
    }

    private void checkAndPrepare() {
        HashMap hmAddItem = (HashMap)this.hmAdjust.get(BgAdjustHelper.ADJUST_ADDITEM);
        BgItemCollection bgItemCol = (BgItemCollection)((Object)hmAddItem.get(BgAdjustHelper.ADJUST_BGITEM));
        BgDataCollection bgDataCol = (BgDataCollection)((Object)hmAddItem.get(BgAdjustHelper.ADJUST_BGDATA));
        Vector vecBgItemColForCheck = (Vector)hmAddItem.get(BgAdjustHelper.ADJUST_ADDITEMFORCHECK);
        int bgCycle = this.bgTemInfo.getBgCycle().getValue();
        String strCurrencyNumber = ((CurrencyInfo)this.comboCurrency.getSelectedItem()).getNumber();
        for (int i = 0; i < this.kdt.getRowCount(); ++i) {
            ICell cell;
            int j;
            IRow row = this.kdt.getRow(i);
            Object rowObject = row.getUserObject();
            if (rowObject == null || !((String)rowObject).equals(BgAdjustHelper.ADJUST_ADDITEM)) continue;
            String strDimsNumber = new String("");
            int columnCursor = 0;
            ReferencedDimensionCollection dimColl = this.bgTemInfo.getVisibleDims();
            Iterator visibleRefDimsIter = dimColl.iterator();
            Vector<BgItemInfo> vecBgItem = new Vector<BgItemInfo>();
            StringBuffer bgItemKey = new StringBuffer("");
            BgItemCollection bgItemColForCheck = new BgItemCollection();
            for (j = 0; j < dimColl.size(); ++j) {
                cell = row.getCell(columnCursor);
                if (cell.getUserObject() == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgAdjustFormResource", (String)"mustInputBgItemAtFirst"));
                    SysUtil.abort();
                } else {
                    BgItemInfo thisbgItem = (BgItemInfo)cell.getUserObject();
                    strDimsNumber = strDimsNumber + thisbgItem.getItemNumber() + "_";
                    if (!bgItemCol.contains(thisbgItem)) {
                        boolean isContain = false;
                        for (int k = 0; k < this.bgItem[columnCursor].size(); ++k) {
                            if (!this.bgItem[columnCursor].get(k).getItemID().equals((Object)thisbgItem.getItemID())) continue;
                            isContain = true;
                            thisbgItem = this.bgItem[columnCursor].get(k);
                            break;
                        }
                        if (!isContain) {
                            bgItemCol.add(thisbgItem);
                        }
                        vecBgItem.add(thisbgItem);
                    }
                    bgItemKey.append(thisbgItem.getItemNumber() + "_");
                    bgItemColForCheck.add(thisbgItem);
                }
                ++columnCursor;
            }
            this.hmEntries.clear();
            for (j = columnCursor; j < this.kdt.getColumnCount(); ++j) {
                BgEntryInfo bgEntry;
                cell = row.getCell(j);
                BgDataInfo bgData = (BgDataInfo)cell.getUserObject();
                bgData.setBgValue(new BigDecimal((String)cell.getValue()));
                row.getCell(j).setValue((Object)"0.00");
                bgData.setCurrency((CurrencyInfo)this.comboCurrency.getSelectedItem());
                IColumn column = this.kdt.getColumn(j);
                String strColKey = column.getKey();
                String[] arrayColKey = strColKey.split("_");
                strColKey = arrayColKey[0] + "_" + arrayColKey[1];
                if (!this.hmEntries.containsKey(strColKey)) {
                    bgEntry = new BgEntryInfo();
                    bgEntry.setId(BOSUuid.create((BOSObjectType)bgEntry.getBOSType()));
                    PeriodInfo period = new PeriodInfo();
                    period.setId(BOSUuid.read((String)arrayColKey[0]));
                    bgEntry.setPeriod(period);
                    for (int k = 0; k < vecBgItem.size(); ++k) {
                        int bgItemIndex = k + 1;
                        bgEntry.put("bgItem" + bgItemIndex, vecBgItem.get(k));
                    }
                    Integer inte = new Integer(arrayColKey[1]);
                    BgCycleTypeEnum bgCycleType = BgCycleTypeEnum.getEnum(inte);
                    bgEntry.setBgCycle(bgCycleType);
                    if (bgCycle == bgCycleType.getValue()) {
                        bgEntry.setIsLeafPeriod(true);
                    } else {
                        bgEntry.setIsLeafPeriod(false);
                    }
                    bgEntry.setIsLeafEntry(true);
                    String strBgItemKey = bgItemKey.toString();
                    strBgItemKey = strBgItemKey.substring(0, strBgItemKey.length() - 2);
                    bgEntry.setBgItemsKey(strBgItemKey);
                    bgEntry.setEntryType(BgEntryTypeEnum.Adjust);
                    bgEntry.setSplitRate(new BigDecimal("0.00"));
                    bgData.setBgEntry(bgEntry);
                    this.hmEntries.put(strColKey, bgEntry);
                } else {
                    bgEntry = (BgEntryInfo)this.hmEntries.get(strColKey);
                    bgData.setBgEntry(bgEntry);
                }
                IRow headrow = this.kdt.getHeadRow(1);
                ICell headCell = headrow.getCell(columnCursor);
                bgData.setBgElement((BgElementInfo)headCell.getValue());
                String strPeriod = BgV2FormEditUIHelper.getPeriodStr(column.getKey(), this.kdt);
                String strIdentity = strPeriod + "_" + strDimsNumber + ((BgElementInfo)this.kdt.getHeadRow(1).getCell(j).getValue()).getNumber() + "_" + strCurrencyNumber;
                bgData.setIdentity(strIdentity);
                bgDataCol.add(bgData);
            }
            vecBgItemColForCheck.add(bgItemColForCheck);
        }
    }

    @Override
    protected void submitCurrentBgData() throws BOSException, EASBizException {
        this.checkAndPrepare();
        super.submitCurrentBgData();
        this.submitAdjustedBgData(this.hmAdjust);
        this.initHmAdjust();
    }

    private void submitAdjustedBgData(HashMap hm) {
        try {
            IBgV2Manager bgV2 = BgV2ManagerFactory.getRemoteInstance();
            bgV2.submitAdjustedBgData(hm);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
    }
}

