/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateType;
import com.kingdee.eas.ma.bgcsl.BgCslWorkTableFacadeFactory;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateInfo;
import com.kingdee.eas.ma.bgcsl.IBgCslWorkTableFacade;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgCslAllTemplateF7UI;
import com.kingdee.eas.ma.bgcsl.client.BgCslExamineResultQueryUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslWorkTableListUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCslAllTemplateF7UI
extends AbstractBgCslAllTemplateF7UI {
    private static final long serialVersionUID = -5722200149653607764L;
    private static final Logger logger = CoreUIObject.getLogger(BgCslAllTemplateF7UI.class);
    private CoreBaseCollection colls = null;
    private final String SELECT = "select";
    private String csltemplate = BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslWorkTableResource", (String)"csltemplate");
    private String nworktemplate = BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslWorkTableResource", (String)"worktemplate");
    private String adjtemplate = BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslWorkTableResource", (String)"csladjtemplate");
    private String orgTreeId = null;
    private String bgsShemeid = null;
    private String orgUnitId = null;
    public static final String SELECTED_ID_SET = "SELECTED_ID_SET";
    private Set<String> selectedIds = null;
    private BgCslWorkTableListUI ui = null;
    private BgCslExamineResultQueryUI examineResultQueryUI = null;
    private boolean isCanceled = false;

    public void onLoad() throws Exception {
        this.selectedIds = (Set)this.getUIContext().get(SELECTED_ID_SET);
        super.onLoad();
        Object _obj = this.getUIContext().get("Owner");
        if (_obj != null && _obj instanceof BgCslWorkTableListUI) {
            this.ui = (BgCslWorkTableListUI)_obj;
        }
        if (_obj != null && _obj instanceof BgCslExamineResultQueryUI) {
            this.examineResultQueryUI = (BgCslExamineResultQueryUI)((Object)_obj);
        }
    }

    public void onShow() throws Exception {
        String templateSql;
        super.onShow();
        Object _obj = this.getUIContext().get("Owner");
        if (_obj != null && _obj instanceof BgCslWorkTableListUI) {
            this.ui = (BgCslWorkTableListUI)_obj;
        }
        if ((templateSql = this.initSql()).length() > 0) {
            List templateInfo = this.getFacadeInterface().getBgCslFormTemplate(templateSql);
            if (templateInfo != null && !templateInfo.isEmpty()) {
                this.tblMain.removeRows();
                IRow row = null;
                String columnKey = null;
                int columnCount = this.tblMain.getColumnCount();
                BgCslTemplateInfo cslInfo = null;
                BgNWorkTemplateInfo nworkInfo = null;
                BgCslAdjTemplateInfo adjInfo = null;
                for (Map template : templateInfo) {
                    row = this.tblMain.addRow();
                    for (int i = 0; i < columnCount; ++i) {
                        columnKey = this.tblMain.getColumnKey(i).toLowerCase();
                        row.getCell(i).setValue(template.get(columnKey));
                    }
                    if (template.get("templatetype").equals(this.csltemplate)) {
                        cslInfo = new BgCslTemplateInfo();
                        cslInfo.setId(BOSUuid.read((String)template.get("id").toString()));
                        cslInfo.setName((String)row.getCell("name").getValue());
                        cslInfo.setNumber((String)row.getCell("number").getValue());
                        row.setUserObject((Object)cslInfo);
                    }
                    if (template.get("templatetype").equals(this.nworktemplate)) {
                        nworkInfo = new BgNWorkTemplateInfo();
                        nworkInfo.setId(BOSUuid.read((String)template.get("id").toString()));
                        nworkInfo.setName((String)row.getCell("name").getValue());
                        nworkInfo.setNumber((String)row.getCell("number").getValue());
                        row.setUserObject((Object)nworkInfo);
                    }
                    if (template.get("templatetype").equals(this.adjtemplate)) {
                        adjInfo = new BgCslAdjTemplateInfo();
                        adjInfo.setId(BOSUuid.read((String)template.get("id").toString()));
                        adjInfo.setName((String)row.getCell("name").getValue());
                        adjInfo.setNumber((String)row.getCell("number").getValue());
                        row.setUserObject((Object)adjInfo);
                    }
                    if (this.selectedIds == null || !this.selectedIds.contains(template.get("id").toString())) continue;
                    row.getCell("select").setValue((Object)Boolean.TRUE);
                }
            }
            this.tblMain.checkParsed();
            templateInfo.clear();
        }
        this.setTblMainEditable(false);
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        this.setCanceled(false);
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancle_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancle_actionPerformed(e);
        this.setCanceled(true);
        this.getUIWindow().close();
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnSearch_actionPerformed(e);
        this.search();
    }

    protected void search() {
        int count = this.tblMain.getRowCount();
        String text = this.searchText.getText();
        if (!StringUtils.isEmpty((String)text)) {
            String name = null;
            String number = null;
            for (int i = 0; i < count; ++i) {
                boolean notExist;
                name = this.tblMain.getRow(i).getCell(2).getValue().toString();
                number = this.tblMain.getRow(i).getCell(3).getValue().toString();
                boolean bl = notExist = name.indexOf(text) == -1 && number.indexOf(text) == -1;
                if (notExist) {
                    this.tblMain.getRow(i).getStyleAttributes().setHided(true);
                    continue;
                }
                this.tblMain.getRow(i).getStyleAttributes().setHided(false);
            }
        }
    }

    @Override
    protected void searchText_focusLost(FocusEvent e) throws Exception {
        super.searchText_focusLost(e);
        int count = this.tblMain.getRowCount();
        String text = this.searchText.getText();
        if (StringUtils.isEmpty((String)text)) {
            Object name = null;
            Object number = null;
            for (int i = 0; i < count; ++i) {
                this.tblMain.getRow(i).getStyleAttributes().setHided(false);
            }
        } else {
            this.search();
        }
    }

    @Override
    protected void btnClear_actionPerformed(ActionEvent e) throws Exception {
        super.btnClear_actionPerformed(e);
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            if (this.tblMain.getRow(i).getStyleAttributes().isHided()) continue;
            this.tblMain.getRow(i).getCell("select").setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    protected void btnAllSelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnAllSelect_actionPerformed(e);
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            if (this.tblMain.getRow(i).getStyleAttributes().isHided()) continue;
            this.tblMain.getRow(i).getCell("select").setValue((Object)Boolean.TRUE);
        }
    }

    public Object getData() {
        Boolean _re = null;
        IRow row = null;
        Object _type = null;
        String _templateType = null;
        ArrayList _list = new ArrayList();
        HashMap map = new HashMap();
        this.colls = new CoreBaseCollection();
        int in = this.tblMain.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell(0).getValue() == null || !(row.getCell(0).getValue() instanceof Boolean)) continue;
            _re = (Boolean)row.getCell(0).getValue();
            _templateType = (String)row.getCell("templatetype").getValue();
            if (!_re.booleanValue()) continue;
            this.colls.add((CoreBaseInfo)row.getUserObject());
        }
        return this.getCoreBaseToArray(this.colls);
    }

    private Object[] getCoreBaseToArray(CoreBaseCollection c) {
        Object[] arr = new CoreBaseInfo[this.colls.size()];
        for (int index = 0; index < arr.length; ++index) {
            arr[index] = this.colls.get(index);
        }
        return arr;
    }

    protected boolean isCanceled() {
        return this.isCanceled;
    }

    protected void setCanceled(Boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    protected String initSql() {
        HashSet typeSet;
        StringBuffer sql = new StringBuffer();
        Object obj = null;
        if (this.ui != null && this.ui instanceof BgCslWorkTableListUI) {
            obj = this.ui.getTemplateTypeData();
            this.orgTreeId = this.ui.getOrgTreeInfo().getId().toString();
            this.orgUnitId = this.ui.getOrgUnitInfo().getId().toString();
            if (this.ui.getBgSchemeInfo() == null) {
                return "";
            }
            this.bgsShemeid = this.ui.getBgSchemeInfo().getId().toString();
        }
        if (this.examineResultQueryUI != null && this.examineResultQueryUI instanceof BgCslExamineResultQueryUI) {
            obj = this.examineResultQueryUI.getTemplateTypeData();
            this.orgTreeId = this.examineResultQueryUI.getOrgTreeInfo().getId().toString();
            this.orgUnitId = this.examineResultQueryUI.getOrgUnitInfo().getId().toString();
            if (this.examineResultQueryUI.getBgSchemeInfo() == null) {
                return "";
            }
            this.bgsShemeid = this.examineResultQueryUI.getBgSchemeInfo().getId().toString();
        }
        Object[] string = null;
        if (obj instanceof Object[]) {
            Object[] _obj = (Object[])obj;
            string = new String[_obj.length];
            for (int i = 0; i < _obj.length; ++i) {
                try {
                    if (_obj[i].toString() == null) continue;
                    string[i] = _obj[i].toString();
                    continue;
                }
                catch (NullPointerException e) {
                    string[i] = null;
                }
            }
        } else {
            string = new String[1];
            if (obj != null) {
                string[0] = obj.toString();
            }
        }
        if ((typeSet = new HashSet(Arrays.asList((Object[])string))).contains(this.adjtemplate)) {
            sql.append(this.getBgCslAdjSql());
        }
        if (typeSet.contains(this.nworktemplate)) {
            if (sql.length() > 0) {
                sql.append(" union all ");
            }
            sql.append(this.getNWorkSql());
        }
        if (typeSet.contains(this.csltemplate)) {
            if (sql.length() > 0) {
                sql.append(" union all ");
            }
            sql.append(this.getBgCslSql());
        }
        if (sql.length() > 0) {
            sql.insert(0, "select * from (").append(") templateNameTable order by templateNameTable.templatetype,templateNameTable.number asc ");
        }
        return sql.toString();
    }

    private String getBgCslSql() {
        StringBuffer bgcslTemplateSql = new StringBuffer();
        bgcslTemplateSql.append(" SELECT BGCSLTEMPLATE.FID AS ID, BGCSLTEMPLATE.FNumber AS NUMBER, BGCSLTEMPLATE.FName AS NAME, ");
        bgcslTemplateSql.append(" BGCSLTEMPLATE.FDescription AS DESCRIPTION, LASTUPDATEUSER.FName_l2 AS LASTUPDATEUSERNAME, ");
        bgcslTemplateSql.append(" BGCSLTEMPLATE.FLastUpdateTime AS LASTUPDATETIME, '" + BgCslTemplateType.CSLTEMPLATE.getAlias() + "' AS TEMPLATETYPE, ");
        bgcslTemplateSql.append(" DEFAULTMEASUREUNIT.FName_l2 AS DEFAULTMEASUREUNITNAME, N'' AS ORGUNITNAME ");
        bgcslTemplateSql.append(" FROM T_MBG_BgCslTemplate AS BGCSLTEMPLATE");
        bgcslTemplateSql.append(" LEFT OUTER JOIN T_PM_User AS LASTUPDATEUSER ON BGCSLTEMPLATE.FLastUpdateUserID = LASTUPDATEUSER.FID ");
        bgcslTemplateSql.append(" LEFT JOIN T_BD_MeasureUnit AS DEFAULTMEASUREUNIT ON BGCSLTEMPLATE.FDefaultMeasureUnitID = DEFAULTMEASUREUNIT.FID ");
        bgcslTemplateSql.append(" where  BGCSLTEMPLATE.FOrgTreeID='").append(this.orgTreeId).append("'");
        bgcslTemplateSql.append(" and  BGCSLTEMPLATe.FBgSchemeID='").append(this.bgsShemeid).append("'");
        if (this.examineResultQueryUI != null && this.examineResultQueryUI instanceof BgCslExamineResultQueryUI) {
            bgcslTemplateSql.append(" and BGCSLTEMPLATE.FTemplateStatus= 0");
        }
        return bgcslTemplateSql.toString();
    }

    private String getNWorkSql() {
        StringBuffer nworkTemplateSql = new StringBuffer();
        nworkTemplateSql.append(" SELECT BGNWORKTEMPLATE.FID AS ID, BGNWORKTEMPLATE.FNumber AS NUMBER, BGNWORKTEMPLATE.FName AS NAME, ");
        nworkTemplateSql.append(" BGNWORKTEMPLATE.FDescription AS DESCRIPTION, LASTUPDATEUSER.FName_l2 AS LASTUPDATEUSERNAME, ");
        nworkTemplateSql.append(" BGNWORKTEMPLATE.FLastUpdateTime AS LASTUPDATETIME, '" + BgCslTemplateType.WORKTEMPLATE.getAlias() + "' AS TEMPLATETYPE, ");
        nworkTemplateSql.append(" N'' AS DEFAULTMEASUREUNITNAME, N'' AS ORGUNITNAME");
        nworkTemplateSql.append(" FROM T_MBG_BgNWorkTemplate AS BGNWORKTEMPLATE");
        nworkTemplateSql.append(" LEFT OUTER JOIN T_PM_User AS LASTUPDATEUSER ON BGNWORKTEMPLATE.FLastUpdateUserID = LASTUPDATEUSER.FID");
        nworkTemplateSql.append(" where BGNWORKTEMPLATE.FOrgTreeID='").append(this.orgTreeId).append("'");
        nworkTemplateSql.append(" and  BGNWORKTEMPLATE.FBgSchemeID='").append(this.bgsShemeid).append("'");
        if (this.examineResultQueryUI != null && this.examineResultQueryUI instanceof BgCslExamineResultQueryUI) {
            nworkTemplateSql.append("  and BGNWORKTEMPLATE.FTemplateStatus= 0 ");
        }
        return nworkTemplateSql.toString();
    }

    private String getBgCslAdjSql() {
        StringBuffer adjTemplateSql = new StringBuffer();
        adjTemplateSql.append(" SELECT BGCSLADJTEMPLATE.FID AS ID, BGCSLADJTEMPLATE.FNumber AS NUMBER, BGCSLADJTEMPLATE.FName AS NAME, ");
        adjTemplateSql.append(" BGCSLADJTEMPLATE.FDescription AS DESCRIPTION,LASTUPDATEUSER.FName_l2 AS LASTUPDATEUSERNAME, ");
        adjTemplateSql.append(" BGCSLADJTEMPLATE.FLastUpdateTime AS LASTUPDATETIME, '" + BgCslTemplateType.CSLADJTEMPLATE.getAlias() + "' AS TEMPLATETYPE, ");
        adjTemplateSql.append(" DEFAULTMEASUREUNIT.FName_l2 AS DEFAULTMEASUREUNITNAME, ORGUNIT.FName_l2 AS ORGUNITNAME");
        adjTemplateSql.append(" FROM T_MBG_BgCslAdjTemplate AS BGCSLADJTEMPLATE");
        adjTemplateSql.append(" LEFT OUTER JOIN T_PM_User AS LASTUPDATEUSER ON BGCSLADJTEMPLATE.FLastUpdateUserID = LASTUPDATEUSER.FID");
        adjTemplateSql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS DEFAULTMEASUREUNIT ON BGCSLADJTEMPLATE.FDefaultMeasureUnitID = DEFAULTMEASUREUNIT.FID");
        adjTemplateSql.append(" INNER JOIN T_ORG_BaseUnit AS ORGUNIT ON BGCSLADJTEMPLATE.FOrgUnitID = ORGUNIT.FID ");
        adjTemplateSql.append(" where BGCSLADJTEMPLATE.FOrgTreeID='").append(this.orgTreeId).append("'");
        adjTemplateSql.append(" and BGCSLADJTEMPLATE.FBgSchemeID='").append(this.bgsShemeid).append("'");
        adjTemplateSql.append(" and BGCSLADJTEMPLATE.FOrgUnitID='").append(this.orgUnitId).append("'");
        if (this.examineResultQueryUI != null && this.examineResultQueryUI instanceof BgCslExamineResultQueryUI) {
            adjTemplateSql.append(" and BGCSLADJTEMPLATE.FTemplateStatus= 0");
        } else {
            adjTemplateSql.append(" and BGCSLADJTEMPLATE.FOrgUnitID='").append(this.orgUnitId).append("'");
        }
        return adjTemplateSql.toString();
    }

    protected IBgCslWorkTableFacade getFacadeInterface() throws Exception {
        return BgCslWorkTableFacadeFactory.getRemoteInstance();
    }

    public void setTblMainEditable(boolean flag) {
        for (int i = 1; i < this.tblMain.getColumnCount(); ++i) {
            this.tblMain.getColumn(i).getStyleAttributes().setLocked(true);
        }
    }
}

