/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgElimContextHelper;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BizRefCslTemplateFactory;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgCslBizCalcMainUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslBizCalcFunctionSelectF7UI;
import com.kingdee.eas.ma.bgcsl.client.BgCslBizCalcListUI;
import com.kingdee.eas.ma.bgcsl.client.utils.BgCslOrgSelectDialog;
import com.kingdee.eas.ma.bgcsl.utils.BgCslSchemeDimensionHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgNWorkTemplateHelper;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizRelyFactory;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.function.dataType.MbgFunction;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCslBizCalcMainUI
extends AbstractBgCslBizCalcMainUI {
    private static final long serialVersionUID = 5412814805688138508L;
    private static final Logger logger = CoreUIObject.getLogger(BgCslBizCalcMainUI.class);
    private OrgTreeInfo orgTreeInfo = null;

    @Override
    public void storeFields() {
        super.storeFields();
        this.afterStoreFields();
    }

    public void onLoad() throws Exception {
        this.orgTreeInfo = (OrgTreeInfo)this.getUIContext().get("ORGTREE_INFO");
        super.onLoad();
    }

    public void onShow() throws Exception {
        super.onShow();
        if (MbgFunction.getCurrentLocale() == "en_US") {
            String scopeConstraints = "Applicable Scope";
            this.kDTabbedPane1.add((Component)this.scope, (Object)scopeConstraints);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnExecute.setVisible(false);
    }

    protected void setMainUITitle() {
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.biz.client.BizResource", (String)"bgCslMainUITitle") + this.bizCalcInfo.getName());
    }

    public BgSchemeDimensionHelper getSchemeHelper() {
        if (this.helper == null) {
            try {
                this.helper = new BgCslSchemeDimensionHelper(this.getBgSchemeInfo().getId().toString(), this.orgTreeInfo);
            }
            catch (Exception ex) {
                logger.error((Object)"getSchemeHelper error:", (Throwable)ex);
                this.handUIExceptionAndAbort(ex);
            }
        }
        return this.helper;
    }

    protected void initOrgDialog() {
        IRow row = this.scopeTable.getRow(0);
        ICell cell = row.getCell("dimType");
        cell.setValue((Object)BgCommCHelper.getMessageStr((String)BgNWorkTemplateHelper.RES, (String)"bizOrgUnit"));
        cell.setUserObject((Object)BizConstants.BIZ_ORGUNIT_TYPE);
        cell.getStyleAttributes().setLocked(true);
        BgCslOrgSelectDialog dialog = new BgCslOrgSelectDialog();
        dialog.setOrgTreeID(this.orgTreeInfo != null ? this.orgTreeInfo.getId().toString() : null);
        dialog.setDimension(this.getSchemeHelper().getDimension(DimensionBaseConstants.DEF_ORGUNIT_NUMBER));
        dialog.setOrgId(this.getOrgUnitInfo().getId().toString());
        dialog.setBgSchemeId(this.getBgSchemeInfo().getId().toString());
        KDBizPromptBox prmtBgOrgUnit = this.getBizPromptBox();
        prmtBgOrgUnit.setSelector((KDPromptSelector)dialog);
        prmtBgOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                KDPromptSelector selector = ((KDBizPromptBox)eventObj.getSource()).getSelector();
                if (selector instanceof DataChangeListener) {
                    ((DataChangeListener)selector).dataChanged(eventObj);
                }
            }
        });
        row.getCell("dimValue").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtBgOrgUnit));
    }

    protected void initBizCalc() {
        this.bizCalcInfo = (BizCalcInfo)this.getUIContext().get("BizCalcInfo");
        BgNWorkTemplateCollection workColls = null;
        BgCslTemplateCollection cslColls = null;
        BgCslAdjTemplateCollection cslAdjColls = null;
        Map tempMap = null;
        if (!this.getOprtState().equals(OprtState.ADDNEW) && !this.getOprtState().equals(OprtState.COPYADDNEW)) {
            List preBizCalc = null;
            try {
                preBizCalc = BizRelyFactory.getRemoteInstance().getPreCalc(this.bizCalcInfo.getId().toString());
                tempMap = BizRefCslTemplateFactory.getRemoteInstance().getRefTemplateCollection(this.bizCalcInfo.getId().toString());
                if (tempMap != null) {
                    if (tempMap.containsKey("WORKTEMPLATE_COLLECTION")) {
                        workColls = (BgNWorkTemplateCollection)((Object)tempMap.get("WORKTEMPLATE_COLLECTION"));
                    }
                    if (tempMap.containsKey("bgtemplate")) {
                        cslColls = (BgCslTemplateCollection)((Object)tempMap.get("bgtemplate"));
                    }
                    if (tempMap.containsKey("bgcsladjtemplate")) {
                        cslAdjColls = (BgCslAdjTemplateCollection)((Object)tempMap.get("bgcsladjtemplate"));
                    }
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.bizCalcInfo.put("prebizcalc", (Object)preBizCalc);
            if (workColls != null && !workColls.isEmpty()) {
                this.bizCalcInfo.put("WORKTEMPLATE_COLLECTION", workColls);
            }
            if (cslColls != null && !cslColls.isEmpty()) {
                this.bizCalcInfo.put("bgtemplate", cslColls);
            }
            if (cslAdjColls != null && !cslAdjColls.isEmpty()) {
                this.bizCalcInfo.put("bgcsladjtemplate", cslAdjColls);
            }
        }
    }

    protected void refreshList() throws Exception {
        Object listUI = this.getUIContext().get("Owner");
        if (listUI instanceof BgCslBizCalcListUI) {
            ((BgCslBizCalcListUI)listUI).refreshList();
        }
    }

    protected IObjectPK doCopyAddNew(BizCalcInfo info) throws EASBizException, BOSException {
        return BizRefCslTemplateFactory.getRemoteInstance().copyAddNew(info);
    }

    protected IObjectPK doSubmit(BizCalcInfo info) throws EASBizException, BOSException {
        return BizRefCslTemplateFactory.getRemoteInstance().saveCslBizCalc(info);
    }

    protected Map doCancelCancel(Set<String> bizCalcIds, String bgSchemeId) throws Exception {
        return BizRefCslTemplateFactory.getRemoteInstance().cancelCancelColls(bizCalcIds, bgSchemeId, this.orgTreeInfo != null ? this.orgTreeInfo.getId().toString() : null);
    }

    protected String getBizFunctionPickerUI() {
        return BgCslBizCalcFunctionSelectF7UI.class.getName();
    }

    protected void processVariablesUIContext(UIContext ctx) {
        super.processVariablesUIContext(ctx);
        HashMap filterValueMap = new HashMap();
        filterValueMap.put(DimensionConstants.DEF_ORGUNIT_SRCNUMBER, new HashSet());
        filterValueMap.put(DimensionConstants.DEF_CSL_SRCNUMBER, new HashSet());
        ctx.put((Object)"filterValueMap", filterValueMap);
        ctx.put((Object)"isAddNumericVariate", (Object)false);
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        try {
            OrgUnitInfo orgUnitInfo = BgElimContextHelper.getBgElimContext().getCurOrgGroup();
            if (orgUnitInfo != null) {
                return new ObjectUuidPK(orgUnitInfo.getId());
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        return super.getOrgPK(action);
    }

    protected BOSUuid getUnionId() {
        if (this.orgTreeInfo != null) {
            return this.orgTreeInfo.getId();
        }
        return null;
    }

    protected boolean isNeedProcessType() {
        return false;
    }

    protected void afterCtx(UIContext ctx) {
        if (ctx != null) {
            ctx.put((Object)"isHiddenPartCsldim", (Object)true);
        }
    }

    protected void isBgSchemeIsFiling() {
        if (this.getBgSchemeInfo() != null && this.getBgSchemeInfo().isIsFiling()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgFormDimensionRelationResource", (String)"cslScheme_isFlling"));
            SysUtil.abort();
        }
    }
}

