/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTempNodeCollection;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTempNodeInfo;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgCslQueryPanelCondition;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialItemsCollection;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialItemsInfo;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialRelationGroupCollection;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateType;
import com.kingdee.eas.ma.bgcsl.BgElimContext;
import com.kingdee.eas.ma.bgcsl.BgEliminationHelper;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateInfo;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgCslFormQueryPanelUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslSpecialPanelDialog;
import com.kingdee.eas.ma.bgcsl.common.IBgCslSpecialInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.DimensionRelationshipFactory;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.client.BgNFormListUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BgCslFormQueryPanelUI
extends AbstractBgCslFormQueryPanelUI {
    private static final Logger logger = CoreUIObject.getLogger(BgCslFormQueryPanelUI.class);
    private final BgCslQueryPanelCondition condition;
    private DefaultTreeModel tmplTreeModel;
    private Map<String, List<BgCslAdjTemplateInfo>> adjTemplates;
    private static final String RES = "com.kingdee.eas.ma.bgcsl.BgCslWorkTableResource";
    protected BgElimContext bgElimContext = BgElimContext.getInstance();
    private BgSchemeDimensionHelper schemeHelper = null;

    public BgCslFormQueryPanelUI(BgCslQueryPanelCondition condition) throws Exception {
        this.condition = condition;
        this.initLayout();
        this.initListener();
        this.loadQueryPanelUI();
    }

    private void loadQueryPanelUI() throws Exception {
        this.initComponent();
        this.fillDefaultMember();
    }

    public void initLayout() {
        super.initLayout();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.tmplTreeView.getTree().setShowPopMenuDefaultItem(true);
        this.tmplTreeView.getTree().addTreePopupMenu(new TreePopupMenuListener(){

            public boolean popMenu(TreePopupMenuEvent event) {
                event.getMenu().show((Component)event.getSource(), 0, 0);
                return true;
            }
        });
        this.orgTreeView.getTree().setShowPopMenuDefaultItem(true);
        this.orgTreeView.getTree().addTreePopupMenu(new TreePopupMenuListener(){

            public boolean popMenu(TreePopupMenuEvent event) {
                event.getMenu().show((Component)event.getSource(), 0, 0);
                return true;
            }
        });
        JMenuItem popMenuItemCreateForm = new JMenuItem(EASResource.getString((String)RES, (String)"popMenuItemCreateForm"), EASResource.getIcon((String)"imgTbtn_new"));
        popMenuItemCreateForm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgCslFormQueryPanelUI.this.verify();
                BgCslFormQueryPanelUI.this.condition.getOwner().openForm();
            }
        });
        this.orgTreeView.getTree().getPopupMenu().add((Component)popMenuItemCreateForm, 0);
    }

    private void initComponent() throws Exception {
        this.initBgPeriod();
        this.initCurrency();
        this.initBgVersion();
        this.initOrgTree();
        this.initSpecialDim();
        this.initTemplateTree();
        this.treeTabbedPane.setSelectedIndex(1);
    }

    private void initSpecialDim() {
        BgCslSpecialPanelDialog dialog = new BgCslSpecialPanelDialog((IUIObject)this);
        dialog.setSchemeInfo(this.condition.getSchemeInfo());
        dialog.setUnionGroupId(this.getSelectOrgUnitInfo().getId().toString());
        this.prmtSpecialDim.setSelector((KDPromptSelector)dialog);
        this.prmtSpecialDim.addDataChangeListener((DataChangeListener)dialog);
        this.prmtSpecialDim.setDisplayFormatter((IFormatter)new SpecialDimFormatter());
        this.prmtSpecialDim.setEditFormatter((IFormatter)new SpecialDimFormatter());
        this.prmtSpecialDim.setEditable(false);
    }

    private void initCurrency() throws EASBizException, BOSException {
        if (this.getSchemeHelper() != null) {
            DimensionMemberSelectHelper.addIdFilter((KDBizPromptBox)this.prmtBgVersion, (String)DimensionConstants.DEF_VERSION_NUMBER, (BgSchemeDimensionHelper)this.getSchemeHelper());
            BgNFCHelper.setCurrency((KDComboBox)this.cbxCurrency, (BOSUuid)SysContext.getSysContext().getCurrentOrgUnit().getId(), (boolean)false, (Set)this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_CURRENCY_NUMBER, false));
        }
    }

    private void initBgVersion() {
        BgNFormListUI.addRollVersionFilter((KDBizPromptBox)this.prmtBgVersion);
        this.prmtBgVersion.setEnabledMultiSelection(false);
        this.prmtBgVersion.setEditable(false);
    }

    public final BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null && this.condition.getSchemeInfo() != null) {
            this.schemeHelper = new BgSchemeDimensionHelper(null, this.condition.getSchemeInfo().getId().toString());
        }
        return this.schemeHelper;
    }

    private boolean checkSchemeHelperNull() throws EASBizException, BOSException {
        return this.getSchemeHelper() != null && !this.getSchemeHelper().getAllDim().isEmpty();
    }

    private void initBgPeriod() throws Exception {
        BgPeriodDialog bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this, false);
        bgPeriodDialog.setBgPeriodTypeNumbers(this.checkSchemeHelperNull() ? this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true) : null);
        this.prmtBgPeriod.setSelector((KDPromptSelector)bgPeriodDialog);
        this.prmtBgPeriod.setEditable(false);
        this.prmtBgPeriod.setEnabledMultiSelection(false);
        this.prmtBgPeriod.setHistoryRecordEnabled(false);
        if (this.condition.getSchemeInfo() != null) {
            bgPeriodDialog.setBgPeriodBeginDate(this.condition.getSchemeInfo().getDateFrom());
            bgPeriodDialog.setBgPeriodEndDate(this.condition.getSchemeInfo().getDateTo());
        }
    }

    private void fillDefaultMember() {
        this.cbxCslOrgTree.addItem((Object)this.condition.getOrgTreeInfo());
        this.prmtScheme.setData((Object)this.condition.getSchemeInfo());
        this.prmtBgVersion.setData((Object)this.condition.getBgVersionInfo());
        this.prmtBgPeriod.setData((Object)this.condition.getBgPeriodInfo());
        BgNFCHelper.setSelectObject((KDComboBox)this.cbxCurrency, (Object)this.condition.getCurrencyInfo());
    }

    private void initOrgTree() throws Exception {
        try {
            TreeModel treeModel = this.loadOrgTreeModel();
            this.orgTree.setModel(treeModel);
            this.orgTree.expandOnLevel(1);
            this.orgTree.setRootVisible(true);
            this.orgTree.updateUI();
            this.locateCurrentOrg(this.condition.getOrgUnitInfo().getId().toString());
        }
        catch (Exception var) {
            logger.error((Object)"", (Throwable)var);
            throw new Exception(var);
        }
    }

    public void locateCurrentOrg(String orgUnitId) throws BOSException, EASBizException {
        if (this.orgTree.getRowCount() == 0) {
            return;
        }
        if (StringUtils.isEmpty((String)orgUnitId)) {
            if (this.orgTree.getRowCount() > 0) {
                this.orgTree.setSelectionRow(0);
            }
        } else {
            this.locateCurrentOrg(orgUnitId, (DefaultKingdeeTreeNode)this.orgTree.getModel().getRoot());
            if (this.orgTree.getSelectionPath() == null && this.orgTree.getRowCount() > 0) {
                this.orgTree.setSelectionRow(0);
            }
        }
        this.orgTree.expandOnLevel(2);
    }

    private void locateCurrentOrg(String orgUnitId, DefaultKingdeeTreeNode node) {
        FullOrgUnitInfo orgUnitInfo = this.getOrgUnitInfo(node);
        if (null != orgUnitInfo && orgUnitInfo.getId().toString().equals(orgUnitId)) {
            this.orgTree.setSelectionPath(new TreePath(node.getPath()));
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.locateCurrentOrg(orgUnitId, (DefaultKingdeeTreeNode)node.getChildAt(i));
        }
    }

    protected FullOrgUnitInfo getOrgUnitInfo(DefaultKingdeeTreeNode node) {
        FullOrgUnitInfo orgInfo = null;
        if (node != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
            if (node.getUserObject() instanceof OrgStructureInfo) {
                OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
                if (oui != null && oui.getUnit() != null) {
                    orgInfo = oui.getUnit();
                    orgInfo.setLongNumber(oui.getLongNumber());
                }
                return orgInfo;
            }
            if (node.getUserObject() instanceof OrgUnitInfo) {
                return ((OrgUnitInfo)node.getUserObject()).castToFullOrgUnitInfo();
            }
            if (node.getUserObject() instanceof BgOrgUnitInfo) {
                return ((BgOrgUnitInfo)node.getUserObject()).castToFullOrgUnitInfo();
            }
        }
        return orgInfo;
    }

    protected TreeModel loadOrgTreeModel() throws Exception {
        OrgTreeInfo treeInfo = this.condition.getOrgTreeInfo();
        if (treeInfo == null) {
            treeInfo = this.bgElimContext.getCurOrgBound();
        }
        OrgUnitInfo currCompany = this.bgElimContext.getCurOrgGroup();
        DefaultKingdeeTreeNode rootNode = BgEliminationHelper.getUnionDebtTree(currCompany, treeInfo, false, true);
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)rootNode);
        return treeModel;
    }

    private void initTemplateTree() throws Exception {
        this.tmplTreeModel = (DefaultTreeModel)this.tmplTree.getModel();
        DefaultKingdeeTreeNode tmplTreeNodeRoot = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)RES, (String)"formTemplate"));
        tmplTreeNodeRoot.removeAllChildren();
        this.tmplTreeModel.setRoot((TreeNode)tmplTreeNodeRoot);
        DefaultKingdeeTreeNode adjTmplNode = new DefaultKingdeeTreeNode((Object)BgCslTemplateType.CSLADJTEMPLATE);
        adjTmplNode.setTextColor(new Color(60, 186, 254));
        tmplTreeNodeRoot.add((MutableTreeNode)adjTmplNode);
        adjTmplNode.setAllowsChildren(true);
        this.acquireAdjTmpl();
        if (null != this.adjTemplates && this.adjTemplates.containsKey(this.getSelectOrgUnitInfo().getId().toString())) {
            this.appendList2Node(adjTmplNode, this.sortByNumber(this.adjTemplates.get(this.getSelectOrgUnitInfo().getId().toString())));
        }
        DefaultKingdeeTreeNode workTmplNode = new DefaultKingdeeTreeNode((Object)BgCslTemplateType.WORKTEMPLATE);
        workTmplNode.setAllowsChildren(true);
        workTmplNode.setTextColor(new Color(39, 159, 91));
        tmplTreeNodeRoot.add((MutableTreeNode)workTmplNode);
        this.appendList2Node(workTmplNode, this.acquireWorkPaperTmpl());
        DefaultKingdeeTreeNode cslTmplNode = new DefaultKingdeeTreeNode((Object)BgCslTemplateType.CSLTEMPLATE);
        cslTmplNode.setAllowsChildren(true);
        cslTmplNode.setTextColor(new Color(248, 69, 69));
        tmplTreeNodeRoot.add((MutableTreeNode)cslTmplNode);
        this.appendList2Node(cslTmplNode, this.acquireCslTmpl());
        this.tmplTree.expandOnLevel(2);
    }

    private List<? extends VirtualSheetParamInfo> sortByNumber(List<? extends VirtualSheetParamInfo> list) {
        Collections.sort(list, new Comparator<VirtualSheetParamInfo>(){

            @Override
            public int compare(VirtualSheetParamInfo o1, VirtualSheetParamInfo o2) {
                return o1 == null || o2 == null ? 0 : o1.getNumber().compareTo(o2.getNumber());
            }
        });
        return list;
    }

    private void acquireAdjTmpl() throws BOSException {
        BgCslAdjTemplateCollection bgCslAdjTemplates = BgCslAdjTemplateFactory.getRemoteInstance().getBgCslAdjTemplateCollection(this.getEntityViewInfo());
        this.adjTemplates = new HashMap<String, List<BgCslAdjTemplateInfo>>();
        Iterator iterator = bgCslAdjTemplates.iterator();
        while (iterator.hasNext()) {
            BgCslAdjTemplateInfo tmplInfo = (BgCslAdjTemplateInfo)iterator.next();
            BgCslAdjTempNodeCollection nodes = tmplInfo.getNodes();
            Iterator nodeIter = nodes.iterator();
            while (nodeIter.hasNext()) {
                BgCslAdjTempNodeInfo nodeInfo = (BgCslAdjTempNodeInfo)nodeIter.next();
                String orgUnitId = nodeInfo.getOrgUnit().getId().toString();
                if (!this.adjTemplates.containsKey(orgUnitId)) {
                    ArrayList childAdjTmpls = new ArrayList();
                    this.adjTemplates.put(orgUnitId, childAdjTmpls);
                }
                this.adjTemplates.get(orgUnitId).add(tmplInfo);
            }
        }
    }

    private EntityViewInfo getEntityViewInfo() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("orgUnit.id");
        selector.add("formType");
        selector.add("bgSpecialItems.dimRelaGroupRef.*");
        selector.add("bgSpecialItems.*");
        selector.add("data");
        selector.add("defaultMeasureUnit.id");
        selector.add("defaultMeasureUnit.number");
        selector.add("defaultMeasureUnit.name");
        selector.add("bgMeasureUnit.*");
        selector.add("dimensionData");
        selector.add("nodes.bgTemplate");
        selector.add("nodes.orgUnit");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)this.condition.getSchemeInfo().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("templateStatus", (Object)0, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private void appendList2Node(DefaultKingdeeTreeNode parentNode, List<? extends VirtualSheetParamInfo> values) {
        if (null != values && !values.isEmpty()) {
            for (int i = values.size() - 1; i >= 0; --i) {
                VirtualSheetParamInfo info = values.get(i);
                DefaultKingdeeTreeNode newChild = new DefaultKingdeeTreeNode((Object)new TemplateNodeInfo(info));
                this.tmplTreeModel.insertNodeInto((MutableTreeNode)newChild, (MutableTreeNode)parentNode, 0);
            }
            this.tmplTreeModel.reload((TreeNode)parentNode);
        }
    }

    private List<? extends VirtualSheetParamInfo> acquireWorkPaperTmpl() throws BOSException {
        BgNWorkTemplateCollection workPaperTmplCol = BgNWorkTemplateFactory.getRemoteInstance().getBgNWorkTemplateCollection("select * where bgScheme.id = '" + this.condition.getSchemeInfo().getId().toString() + "' and orgTree.id = '" + this.condition.getOrgTreeInfo().getId().toString() + "' and templateStatus = " + 0 + " order by number");
        LinkedList<BgNWorkTemplateInfo> values = new LinkedList<BgNWorkTemplateInfo>();
        Iterator iterator = workPaperTmplCol.iterator();
        while (iterator.hasNext()) {
            values.add((BgNWorkTemplateInfo)iterator.next());
        }
        return values;
    }

    private List<? extends VirtualSheetParamInfo> acquireCslTmpl() throws BOSException {
        BgCslTemplateCollection cslTmplCol = BgCslTemplateFactory.getRemoteInstance().getBgCslTemplateCollection("select id,number,name,formType,bgSpecialItems.dimRelaGroupRef.*,bgSpecialItems.*,data,defaultMeasureUnit.id,defaultMeasureUnit.number,defaultMeasureUnit.name,bgMeasureUnit.*,dimensionData where bgScheme.id = '" + this.condition.getSchemeInfo().getId().toString() + "' and orgTree.id = '" + this.condition.getOrgTreeInfo().getId().toString() + "' and templateStatus = " + 0 + "  order by number");
        LinkedList<BgCslTemplateInfo> values = new LinkedList<BgCslTemplateInfo>();
        Iterator iterator = cslTmplCol.iterator();
        while (iterator.hasNext()) {
            values.add((BgCslTemplateInfo)iterator.next());
        }
        return values;
    }

    private DefaultKingdeeTreeNode getSelectedOrgNode() {
        return (DefaultKingdeeTreeNode)this.orgTree.getLastSelectedPathComponent();
    }

    protected void initListener() {
        this.orgTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (null == BgCslFormQueryPanelUI.this.tmplTreeModel) {
                    return;
                }
                BgCslFormQueryPanelUI.this.refreshAdjTemplateBySelectOrg();
                DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)BgCslFormQueryPanelUI.this.tmplTree.getLastSelectedPathComponent();
                if (null == treeNode) {
                    BgCslFormQueryPanelUI.this.prmtSpecialDim.setData(null);
                }
            }
        });
        this.orgTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && BgCslFormQueryPanelUI.this.getSelectedOrgNode().isLeaf()) {
                    BgCslFormQueryPanelUI.this.treeTabbedPane.setSelectedIndex(1);
                }
            }
        });
        this.tmplTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                BgCslFormQueryPanelUI.this.refreshSpecialDimF7ByTmpl();
            }
        });
        this.tmplTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DefaultKingdeeTreeNode lastNode = (DefaultKingdeeTreeNode)BgCslFormQueryPanelUI.this.tmplTree.getLastSelectedPathComponent();
                    if (lastNode.getUserObject() instanceof TemplateNodeInfo) {
                        BgCslFormQueryPanelUI.this.verify();
                        BgCslFormQueryPanelUI.this.condition.getOwner().openForm();
                    } else {
                        if (!lastNode.isLeaf()) {
                            return;
                        }
                        MsgBox.showWarning((String)EASResource.getString((String)BgCslFormQueryPanelUI.RES, (String)"pleaseClickTemplateNode"));
                        SysUtil.abort();
                    }
                }
            }
        });
    }

    private void verify() {
        BgCslTemplateInfo cslTemplateInfo;
        VirtualSheetParamInfo info;
        TemplateNodeInfo selectedTemplateNode;
        OrgUnitInfo selectOrgUnitInfo = this.getSelectOrgUnitInfo();
        if (null == selectOrgUnitInfo) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"pleaseSelectOrgNode"));
            SysUtil.abort();
        }
        if (null == (selectedTemplateNode = this.getSelectedTemplateNode())) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"pleaseSelectTmplNode"));
            SysUtil.abort();
        }
        if ((info = selectedTemplateNode.getInfo()) instanceof BgCslAdjTemplateInfo) {
            BgCslAdjTemplateInfo adjTemplateInfo = (BgCslAdjTemplateInfo)info;
            if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)adjTemplateInfo.getFormType())) {
                this.checkSpecialDimMember();
            }
        } else if (info instanceof BgCslTemplateInfo && BgTemFormTypeEnum.SPECIALFORM.equals((Object)(cslTemplateInfo = (BgCslTemplateInfo)info).getFormType())) {
            this.checkSpecialDimMember();
        }
    }

    private void checkSpecialDimMember() {
        IBgCslSpecialInfo specialInfo = (IBgCslSpecialInfo)this.prmtSpecialDim.getData();
        if (specialInfo == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"pleaseSelectSpecialDim"));
            this.prmtSpecialDim.requestFocus();
            SysUtil.abort();
        }
        BgCslSpecialItemsCollection bgSpecialItems = specialInfo.getBgSpecialItems();
        int in = bgSpecialItems.size();
        for (int i = 0; i < in; ++i) {
            BgCslSpecialItemsInfo bgCslSpecialItemsInfo = bgSpecialItems.get(i);
            String dimensionNumber = bgCslSpecialItemsInfo.getDimensionNumber();
            if (null != dimensionNumber && !dimensionNumber.contains("#")) continue;
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"pleaseSelectSpecialDim"));
            this.prmtSpecialDim.requestFocus();
            SysUtil.abort();
        }
    }

    private void refreshSpecialDimF7ByTmpl() {
        TemplateNodeInfo templateNode = this.getSelectedTemplateNode();
        BgCslSpecialPanelDialog dialog = (BgCslSpecialPanelDialog)this.prmtSpecialDim.getSelector();
        dialog.setUnionGroupId(this.getSelectOrgUnitInfo().getId().toString());
        if (null != templateNode) {
            VirtualSheetParamInfo info = templateNode.getInfo();
            if (info instanceof BgCslAdjTemplateInfo) {
                BgCslAdjTemplateInfo adjTemplateInfo = (BgCslAdjTemplateInfo)info;
                dialog.setBgTemplateInfo((IBgCslSpecialInfo)info.clone());
                dialog.resetUI();
                if (!BgTemFormTypeEnum.SPECIALFORM.equals((Object)adjTemplateInfo.getFormType())) {
                    this.prmtSpecialDim.setData(null);
                } else {
                    BgCslAdjTemplateInfo clone = (BgCslAdjTemplateInfo)adjTemplateInfo.clone();
                    int in = clone.getBgSpecialItems().size();
                    for (int i = 0; i < in; ++i) {
                        this.buildMemberIfOnly(clone.getBgSpecialItems().get(i));
                    }
                    this.prmtSpecialDim.setData((Object)clone);
                }
            } else if (info instanceof BgCslTemplateInfo) {
                BgCslTemplateInfo bgCslTemplateInfo = (BgCslTemplateInfo)info;
                dialog.setBgTemplateInfo((IBgCslSpecialInfo)info.clone());
                dialog.resetUI();
                if (!BgTemFormTypeEnum.SPECIALFORM.equals((Object)bgCslTemplateInfo.getFormType())) {
                    this.prmtSpecialDim.setData(null);
                } else {
                    BgCslTemplateInfo clone = (BgCslTemplateInfo)bgCslTemplateInfo.clone();
                    int in = clone.getBgSpecialItems().size();
                    for (int i = 0; i < in; ++i) {
                        this.buildMemberIfOnly(clone.getBgSpecialItems().get(i));
                    }
                    this.prmtSpecialDim.setData(bgCslTemplateInfo.clone());
                }
            } else {
                dialog.setBgTemplateInfo(null);
                this.prmtSpecialDim.setData(null);
            }
        } else {
            dialog.resetUI();
        }
    }

    private OrgUnitInfo getSelectOrgUnitInfo() {
        return OrgF7InnerUtils.getUserObject((DefaultKingdeeTreeNode)this.getSelectedOrgNode());
    }

    private TemplateNodeInfo getSelectedTemplateNode() {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tmplTree.getLastSelectedPathComponent();
        if (null != treeNode && treeNode.getUserObject() instanceof TemplateNodeInfo) {
            return (TemplateNodeInfo)treeNode.getUserObject();
        }
        return null;
    }

    private void refreshAdjTemplateBySelectOrg() {
        DefaultKingdeeTreeNode tmplTreeNodeRoot = (DefaultKingdeeTreeNode)this.tmplTreeModel.getRoot();
        DefaultKingdeeTreeNode adjTmplNode = (DefaultKingdeeTreeNode)tmplTreeNodeRoot.getChildAt(0);
        adjTmplNode.removeAllChildren();
        if (null != this.adjTemplates && this.adjTemplates.containsKey(this.getSelectOrgUnitInfo().getId().toString())) {
            this.appendList2Node(adjTmplNode, this.sortByNumber(this.adjTemplates.get(this.getSelectOrgUnitInfo().getId().toString())));
        }
        this.tmplTreeModel.reload((TreeNode)adjTmplNode);
    }

    public BgCslQueryPanelCondition getCurrentCondition() {
        BgCslQueryPanelCondition currentCondition = new BgCslQueryPanelCondition();
        currentCondition.setCurrencyInfo((CurrencyInfo)this.cbxCurrency.getSelectedItem());
        currentCondition.setBgVersionInfo((BgVersionInfo)this.prmtBgVersion.getData());
        currentCondition.setBgPeriodInfo((BgPeriodInfo)this.prmtBgPeriod.getData());
        currentCondition.setOrgTreeInfo(this.condition.getOrgTreeInfo());
        currentCondition.setSchemeInfo(this.condition.getSchemeInfo());
        currentCondition.setOrgUnitInfo(this.getSelectOrgUnitInfo());
        currentCondition.setTemplateInfo(this.getSelectedTemplateNode().getInfo());
        IBgCslSpecialInfo bgCslSpecialInfo = (IBgCslSpecialInfo)this.prmtSpecialDim.getData();
        if (null != bgCslSpecialInfo) {
            currentCondition.setBgSpecialItems(bgCslSpecialInfo.getBgSpecialItems());
        }
        return currentCondition;
    }

    @Override
    protected void prmtBgVersion_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgVersion_dataChanged(e);
        Object oldValue = e.getOldValue();
        Object newValue = e.getNewValue();
        if (newValue == null) {
            this.prmtBgVersion.setDataNoNotify(oldValue);
        }
    }

    @Override
    protected void prmtBgPeriod_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgPeriod_dataChanged(e);
        Object oldValue = e.getOldValue();
        Object newValue = e.getNewValue();
        if (newValue == null) {
            this.prmtBgPeriod.setDataNoNotify(oldValue);
        }
    }

    private void buildMemberIfOnly(BgCslSpecialItemsInfo bgCslSpecialItemsInfo) {
        try {
            Map relaMap = DimensionRelationshipFactory.getRemoteInstance().getOnlyRelationshipByGourps(this.getGroupIds(bgCslSpecialItemsInfo), this.getSelectOrgUnitInfo().getId().toString(), null);
            for (String gourpId : relaMap.keySet()) {
                DimensionRelationshipInfo rela = (DimensionRelationshipInfo)relaMap.get(gourpId);
                this.parseRelationshipMember(rela, bgCslSpecialItemsInfo);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private Set<String> getGroupIds(BgCslSpecialItemsInfo itemsInfo) {
        HashSet<String> groupIds = new HashSet<String>();
        BgCslSpecialRelationGroupCollection coll = itemsInfo.getDimRelaGroupRef();
        for (int i = 0; i < coll.size(); ++i) {
            groupIds.add(coll.get(i).getDimRelaGroup().getId().toString());
        }
        return groupIds;
    }

    private void parseRelationshipMember(DimensionRelationshipInfo dimRela, BgCslSpecialItemsInfo bgCslSpecialItemsInfo) {
        String[] names = dimRela.getDimensionName().split(DimensionConstants.TICK_SEPARATOR);
        String[] memberDisplayNames = bgCslSpecialItemsInfo.getMemberDisplayName().split(DimensionConstants.COMMA_SEPARATOR);
        bgCslSpecialItemsInfo.setMemberDisplayName(this.replaceNoFindStr(names, memberDisplayNames).toString());
        String[] srcNumbers = dimRela.getDimensionNumber().split(DimensionConstants.COMMA_SEPARATOR);
        String[] numbers = new String[srcNumbers.length];
        int in = srcNumbers.length;
        for (int i = 0; i < in; ++i) {
            numbers[i] = srcNumbers[i].split(":")[1];
        }
        String[] dimNumbers = bgCslSpecialItemsInfo.getDimensionNumber().split(DimensionConstants.COMMA_SEPARATOR);
        bgCslSpecialItemsInfo.setDimensionNumber(this.replaceNoFindStr(numbers, dimNumbers).toString());
        bgCslSpecialItemsInfo.setMemberName(dimRela.getDimensionNumber());
    }

    private StringBuilder replaceNoFindStr(String[] sources, String[] targets) {
        StringBuilder showName = new StringBuilder();
        int in = targets.length;
        for (int i = 0; i < in; ++i) {
            String memberDisplayName = targets[i];
            showName.append(memberDisplayName.replaceAll("#", sources[i])).append(DimensionConstants.COMMA_SEPARATOR);
        }
        showName.deleteCharAt(showName.length() - 1);
        return showName;
    }

    private StringBuilder replaceNumberNoFindStr(String source, String target) {
        StringBuilder showNumber = new StringBuilder();
        String[] numbers = source.split(DimensionConstants.COMMA_SEPARATOR);
        String[] memberDisplayNames = target.split(DimensionConstants.COMMA_SEPARATOR);
        int in = memberDisplayNames.length;
        for (int i = 0; i < in; ++i) {
            String memberDisplayName = memberDisplayNames[i];
            showNumber.append(memberDisplayName.replaceAll("#", numbers[i].split(":")[1])).append(DimensionConstants.COMMA_SEPARATOR);
        }
        showNumber.deleteCharAt(showNumber.length() - 1);
        return showNumber;
    }

    private class SpecialDimFormatter
    implements IFormatter {
        private SpecialDimFormatter() {
        }

        public String valueToString(Object o) {
            if (null == o || !(o instanceof IBgCslSpecialInfo)) {
                return null;
            }
            StringBuilder formatString = new StringBuilder();
            IBgCslSpecialInfo specialInfo = (IBgCslSpecialInfo)o;
            BgCslSpecialItemsCollection bgSpecialItems = specialInfo.getBgSpecialItems();
            if (null == bgSpecialItems || bgSpecialItems.isEmpty()) {
                return null;
            }
            int in = bgSpecialItems.size();
            for (int i = 0; i < in; ++i) {
                BgCslSpecialItemsInfo bgCslSpecialItemsInfo = bgSpecialItems.get(i);
                String dimensionNumber = bgCslSpecialItemsInfo.getDimensionNumber();
                if (null == dimensionNumber || dimensionNumber.contains("#")) {
                    return null;
                }
                formatString.append(bgCslSpecialItemsInfo.getMemberDisplayName()).append(",");
            }
            formatString.deleteCharAt(formatString.length() - 1);
            return formatString.toString();
        }

        public void applyPattern(String s) {
        }
    }

    class TemplateNodeInfo {
        private VirtualSheetParamInfo info;

        public TemplateNodeInfo(VirtualSheetParamInfo info) {
            this.info = info;
        }

        public String toString() {
            return "[" + this.info.getNumber() + "] " + this.info.getName();
        }

        public VirtualSheetParamInfo getInfo() {
            return this.info;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemplateNodeInfo that = (TemplateNodeInfo)o;
            return this.info.equals((Object)that);
        }

        public int hashCode() {
            return this.info.hashCode();
        }
    }
}

