/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgEliminationHelper;
import com.kingdee.eas.ma.bgcsl.IBgCslOffsetEntryTemplate;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgCslOffTemplateDispatchUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslOffTemplateDispatchReportUI;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.SearchKeyEnum;
import com.kingdee.eas.ma.mbg.utils.BgOrgTreeHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDispatchConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDispatchUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BgCslOffTemplateDispatchUI
extends AbstractBgCslOffTemplateDispatchUI {
    private static final long serialVersionUID = 1986251833800613252L;
    private static final Logger logger = CoreUIObject.getLogger(BgCslOffTemplateDispatchUI.class);
    protected static final String COL_SELECT = "select";
    protected static final Color NO_DISPATCHED = Color.BLACK;
    protected static final Color DISPATCHED_BY_CURRSCHEME = Color.RED;
    protected Set<String> selectIds = null;
    protected Map<String, Set<String>> dispatchMap = null;
    private TreeModel oldTree = null;
    private TreeWillExpandListener listener = null;
    private BgCslOffsetEntryTemplateCollection temColls = new BgCslOffsetEntryTemplateCollection();
    private LongTimeDialog dialog = null;

    public Set<String> getSelectIds() {
        return this.selectIds;
    }

    public void setSelectIds(Set<String> selectIds) {
        this.selectIds = selectIds;
    }

    public Map<String, Set<String>> getDispatchMap() throws Exception {
        if (this.dispatchMap == null) {
            this.initDispatchData();
        }
        return this.dispatchMap;
    }

    public void setOldTree(TreeModel oldTree) {
        this.oldTree = oldTree;
    }

    public TreeModel getOldTree() {
        return this.oldTree;
    }

    public void setListener(TreeWillExpandListener listener) {
        this.listener = listener;
    }

    public TreeWillExpandListener getListener() {
        return this.listener;
    }

    private BgCslOffsetEntryTemplateCollection getElimTemColls() {
        return this.temColls;
    }

    protected String getBgSchemeId() {
        return (String)this.getUIContext().get(BgBaseConstants.BGSCHEME_ID);
    }

    protected BgSchemeInfo getBgScheme() {
        return (BgSchemeInfo)this.getUIContext().get(BgBaseConstants.BGSCHEME_INFO);
    }

    protected String getOrgUnitId() {
        return (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("selectTemplates") != null) {
            this.setSelectIds((Set)this.getUIContext().get("selectTemplates"));
        } else {
            this.setSelectIds(new HashSet<String>());
        }
        this.init();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    protected void initListener() {
    }

    protected void init() throws Exception {
        this.initData();
        this.initBgOrgView();
        this.initBgOrgUnit();
        this.initBgTemplate();
    }

    protected void initBgTemplate() throws Exception {
        this.temTable.checkParsed();
        this.temTable.getSelectManager().setSelectMode(10);
        this.temTable.getColumn("lastupdatetime").getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateFormatString());
        this.getElimTemColls().clear();
        BgCslOffsetEntryTemplateCollection colls = this.getElimTemplateColls(this.getBgSchemeId(), this.getOrgUnitId());
        if (colls != null) {
            int i;
            BgCslOffsetEntryTemplateInfo template = null;
            int in = colls.size();
            for (i = 0; i < in; ++i) {
                template = colls.get(i);
                if (!this.selectIds.contains(template.getId().toString())) continue;
                this.getElimTemColls().add(template);
                this.addRowByTemplate(this.temTable, template, true);
            }
            in = colls.size();
            for (i = 0; i < in; ++i) {
                template = colls.get(i);
                if (this.selectIds.contains(template.getId().toString())) continue;
                this.getElimTemColls().add(template);
                this.addRowByTemplate(this.temTable, template, false);
            }
        }
        this.selectIds.clear();
        this.fillDispatchInfo();
    }

    protected void addRowByTemplate(KDTable table, BgCslOffsetEntryTemplateInfo template, boolean isChoose) {
        if (table == null || template == null) {
            return;
        }
        IRow row = this.temTable.addRow();
        row.setUserObject((Object)template);
        row.getCell("id").setValue((Object)template.getId());
        row.getCell(COL_SELECT).setValue((Object)isChoose);
        row.getCell("number").setValue((Object)template.getNumber());
        row.getCell("name").setValue((Object)template.getName());
        row.getCell("lastupdateUser").setValue((Object)template.getCreator().getName());
        row.getCell("lastupdatetime").setValue((Object)template.getCreateTime());
    }

    protected BgCslOffsetEntryTemplateCollection getElimTemplateColls(String bgSchemeId, String orgUnitId) throws Exception {
        return BgCslOffTemplateDispatchUI.getElimTemplateColls(null, bgSchemeId, orgUnitId);
    }

    public static BgCslOffsetEntryTemplateCollection getElimTemplateColls(Context ctx, String bgSchemeId, String orgUnitId) throws BOSException {
        BgCslOffsetEntryTemplateCollection colls = new BgCslOffsetEntryTemplateCollection();
        if (StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)orgUnitId)) {
            return colls;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("templateStatus", (Object)0, CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)BgSchemeDispatchUtils.getSelectBgTemplate());
        view.getSorter().add(new SorterItemInfo("number"));
        IBgCslOffsetEntryTemplate iElimTemp = null;
        iElimTemp = ctx == null ? BgCslOffsetEntryTemplateFactory.getRemoteInstance() : BgCslOffsetEntryTemplateFactory.getLocalInstance(ctx);
        return iElimTemp.getBgCslOffsetEntryTemplateCollection(view);
    }

    protected void initBgOrgView() throws Exception {
        this.comBgOrgView.addItem(this.getUIContext().get("orgTreeInfo"));
    }

    protected void initBgOrgUnit() throws Exception {
        this.treeOrgUnit.setRootVisible(true);
        this.treeOrgUnit.setShowCheckBox(true);
        TreeModel model = this.loadModel();
        this.treeOrgUnit.setModel(model);
        this.setOldTree(model);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getOldTree().getRoot();
        if (root != null) {
            root.setCheckBoxEnabled(false);
            root.setCheckBoxVisible(false);
            root.setChecked(false);
        }
        this.setNoPermissionNode4Org(root);
    }

    protected void setNoPermissionNode4Org(DefaultKingdeeTreeNode root) throws EASBizException, BOSException {
    }

    protected TreeModel loadModel() throws EASBizException, BOSException {
        DefaultKingdeeTreeNode rootNode = BgEliminationHelper.getUnionDebtTree(this.getOrgUnit(), this.getOrgTree(), false, true);
        return new DefaultTreeModel((TreeNode)rootNode);
    }

    protected OrgUnitInfo getOrgUnit() {
        return (OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
    }

    protected OrgTreeInfo getOrgTree() {
        return (OrgTreeInfo)this.getUIContext().get("orgTreeInfo");
    }

    protected void initData() throws Exception {
        this.initDispatchData();
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        BgOrgUnitUtils.selectOrgUnit((TreeModel)this.treeOrgUnit.getModel(), (boolean)true);
        this.treeOrgUnit.expandOnLevel(7);
        this.treeOrgUnit.repaint();
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        if (node == null) {
            node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        }
        BgOrgUnitUtils.selectOrgUnit((DefaultKingdeeTreeNode)node, (boolean)false);
        this.treeOrgUnit.repaint();
    }

    @Override
    protected void temTable_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.fillDispatchInfo();
    }

    @Override
    protected void temTable_editValueChanged(KDTEditEvent e) throws Exception {
        this.temTable.getEditManager().stopEditing();
        this.fillDispatchInfo();
    }

    @Override
    protected void temTable_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getColIndex() >= 0 && e.getRowIndex() > 0 && !COL_SELECT.equals(this.temTable.getColumnKey(e.getColIndex()))) {
            ICell cell;
            cell.setValue((Object)(!Boolean.TRUE.equals((cell = this.temTable.getCell(e.getRowIndex(), COL_SELECT)).getValue()) ? 1 : 0));
            this.fillDispatchInfo();
        }
    }

    @Override
    protected void btnSelectAllTem_actionPerformed(ActionEvent e) throws Exception {
        int in = this.temTable.getRowCount();
        for (int i = 0; i < in; ++i) {
            this.temTable.getRow(i).getCell(COL_SELECT).setValue((Object)Boolean.TRUE);
        }
        this.fillDispatchInfo();
    }

    @Override
    protected void btnClearAllTem_actionPerformed(ActionEvent e) throws Exception {
        int in = this.temTable.getRowCount();
        for (int i = 0; i < in; ++i) {
            this.temTable.getRow(i).getCell(COL_SELECT).setValue((Object)Boolean.FALSE);
        }
        this.fillDispatchInfo();
    }

    @Override
    protected void txtKey_focusLost(FocusEvent e) throws Exception {
        this.doSearch();
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        this.doSearch();
    }

    protected void doSearch() throws Exception {
        String value = this.txtKey.getText();
        SearchKeyEnum keyEnum = (SearchKeyEnum)this.comSearchKey.getSelectedItem();
        if (StringUtils.isEmpty((String)value)) {
            this.restartTemplateColls();
            this.treeOrgUnit.setModel(this.getOldTree());
            BgOrgUnitUtils.selectOrgUnit((TreeModel)this.treeOrgUnit.getModel(), (boolean)false);
            this.selectIds.clear();
            this.fillDispatchInfo();
            return;
        }
        Set<BOSUuid> orgUnitIds = null;
        if (keyEnum.getValue() == 0 || keyEnum.getValue() == 10) {
            TreeModel model = BgCslOffTemplateDispatchUI.clipAndCloneTreeModel(this.getOldTree(), keyEnum, value, orgUnitIds);
            this.treeOrgUnit.setModel(model);
            BgOrgUnitUtils.selectOrgUnit((TreeModel)this.treeOrgUnit.getModel(), (boolean)false);
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
            if (root != null) {
                root.setCheckBoxEnabled(false);
                root.setCheckBoxVisible(false);
                root.setChecked(false);
            }
            this.selectIds.clear();
            this.fillDispatchInfo();
        } else {
            this.reFillTemplate(value, keyEnum);
            this.fillDispatchInfo();
        }
        this.treeOrgUnit.expandOnLevel(7);
    }

    protected void reFillTemplate(String value, SearchKeyEnum keyEnum) {
        if (keyEnum.getValue() == 30) {
            this.filterTemplateColls(this.getElimTemColls(), "number", value, true);
        } else if (keyEnum.getValue() == 20) {
            this.filterTemplateColls(this.getElimTemColls(), "name", value, true);
        }
    }

    public static TreeModel clipAndCloneTreeModel(TreeModel model, SearchKeyEnum key, String value, Set<BOSUuid> orgSets) {
        DefaultTreeModel treeModel = (DefaultTreeModel)BgOrgUnitUtils.deepCloneTreeModel((TreeModel)model);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        if (root.getUserObject() != null) {
            BgCslOffTemplateDispatchUI.disableTreeNodeByFilterCondition(root, key, value, orgSets);
            OrgF7InnerUtils.clipTreeNodeByColor((DefaultKingdeeTreeNode)root);
        }
        return treeModel;
    }

    private static void disableTreeNodeByFilterCondition(DefaultKingdeeTreeNode root, SearchKeyEnum key, String value, Set<BOSUuid> orgUnitIds) {
        if (root == null || StringUtils.isEmpty((String)value)) {
            return;
        }
        OrgStructureInfo structureInfo = null;
        FullOrgUnitInfo unitInfo = null;
        DefaultKingdeeTreeNode node = null;
        Enumeration nodeEnum = root.breadthFirstEnumeration();
        String searchvalue = null;
        while (nodeEnum.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
            structureInfo = (OrgStructureInfo)node.getUserObject();
            if (structureInfo == null) continue;
            unitInfo = structureInfo.getUnit();
            if (SearchKeyEnum.orgName.equals((Object)key)) {
                searchvalue = unitInfo.getName();
            } else if (SearchKeyEnum.orgNumber.equals((Object)key)) {
                searchvalue = unitInfo.getNumber();
            }
            if (searchvalue != null && searchvalue.indexOf(value) >= 0) {
                node.setChecked(orgUnitIds != null && orgUnitIds.contains(unitInfo.getId()));
                continue;
            }
            OrgF7InnerUtils.disableTreeNode((DefaultKingdeeTreeNode)node);
        }
    }

    protected BgCslOffsetEntryTemplateInfo getSelectedTemplate() {
        int rowIndex = this.temTable.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return null;
        }
        IRow row = this.temTable.getRow(rowIndex);
        BgCslOffsetEntryTemplateInfo template = (BgCslOffsetEntryTemplateInfo)row.getUserObject();
        return template;
    }

    protected void restartTemplateColls() {
        List<String> selectIds = this.getSelectedTemplateIds();
        BgCslOffsetEntryTemplateCollection colls = this.getElimTemColls();
        this.temTable.removeRows();
        if (colls == null) {
            return;
        }
        BgCslOffsetEntryTemplateInfo template = null;
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            template = colls.get(i);
            this.addRowByTemplate(this.temTable, template, selectIds != null && selectIds.contains(template.getId().toString()));
        }
        this.temTable.repaint();
    }

    protected List<String> getSelectedTemplateIds() {
        ArrayList<String> selBgTemplateIds = new ArrayList<String>();
        Object obj = null;
        IRow row = null;
        BgCslOffsetEntryTemplateInfo template = null;
        int in = this.temTable.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.temTable.getRow(i);
            template = (BgCslOffsetEntryTemplateInfo)row.getUserObject();
            obj = row.getCell(COL_SELECT).getValue();
            if (!(obj instanceof Boolean) || !((Boolean)obj).booleanValue()) continue;
            selBgTemplateIds.add(template.getId().toString());
        }
        return selBgTemplateIds;
    }

    protected List<String> getSelectedOrgUnitIds() {
        return BgOrgUnitUtils.getSelectOrgUnitIds((KDTree)this.treeOrgUnit);
    }

    protected void filterTemplateColls(BgCslOffsetEntryTemplateCollection colls, String fields, String value, boolean isBlured) {
        this.temTable.removeRows();
        if (colls == null || fields == null || value == null) {
            return;
        }
        BgCslOffsetEntryTemplateInfo template = null;
        Object obj = null;
        String tmpValue = null;
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            template = colls.get(i);
            obj = template.get(fields);
            if (obj == null) continue;
            tmpValue = obj.toString();
            if (isBlured) {
                if (tmpValue.indexOf(value) < 0) continue;
                this.addRowByTemplate(this.temTable, template, false);
                continue;
            }
            if (!tmpValue.equals(value)) continue;
            this.addRowByTemplate(this.temTable, template, false);
        }
        this.temTable.repaint();
    }

    @Override
    protected void btnConferm_actionPerformed(ActionEvent e) throws Exception {
        this.verifyData();
        this.assign();
    }

    public void verifyData() throws Exception {
        List<String> bgOrgUnitIds;
        super.verifyData();
        List<String> bgTemplateIds = this.getSelectedTemplateIds();
        if (bgTemplateIds == null || bgTemplateIds.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)("selectBgTemplate" + this.getMessageFlag())));
            SysUtil.abort();
        }
        if ((bgOrgUnitIds = this.getSelectedOrgUnitIds()) == null || bgOrgUnitIds.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)("selectBgOrgUnit" + this.getMessageFlag())));
            SysUtil.abort();
        }
    }

    protected String getMessageFlag() {
        return ".assign";
    }

    protected void assign() throws Exception {
        if (this.dialog == null) {
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                this.dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                this.dialog = new LongTimeDialog((Dialog)win);
            }
            if (this.dialog == null) {
                return;
            }
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                return BgCslOffTemplateDispatchUI.this.executeAssign();
            }

            public void afterExec(Object result) throws Exception {
                List _result = (List)result;
                if (_result != null) {
                    BgOrgTreeHelper.selectAllSubNode((DefaultKingdeeTreeNode)((DefaultKingdeeTreeNode)BgCslOffTemplateDispatchUI.this.treeOrgUnit.getModel().getRoot()), (boolean)false);
                    BgCslOffTemplateDispatchUI.this.treeOrgUnit.repaint();
                    UIContext uiContext = new UIContext((Object)this);
                    uiContext.put((Object)BgSchemeDispatchConstants.SCHEME_DISPATCH, (Object)BgCslOffTemplateDispatchUI.this.isDispath());
                    uiContext.put((Object)BgSchemeDispatchConstants.SCHEME_ISOFFSET, (Object)BgCslOffTemplateDispatchUI.this.isOffset());
                    uiContext.put((Object)BgSchemeDispatchConstants.SCHEME_DISPATCH_RESULT, (Object)_result);
                    uiContext.put((Object)BgBaseConstants.BGSCHEME_INFO, (Object)BgCslOffTemplateDispatchUI.this.getBgScheme());
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCslOffTemplateDispatchUI.this.getDispatchReportUIName(), (Map)uiContext, null, OprtState.VIEW);
                    uiWindow.show();
                }
            }
        });
        this.dialog.show();
        this.initDispatchData();
        this.fillDispatchInfo();
    }

    protected boolean isOffset() {
        return true;
    }

    protected boolean isDispath() {
        return true;
    }

    protected void initDispatchData() throws Exception {
        this.dispatchMap = BgCslOffsetEntryTemplateFactory.getRemoteInstance().getDispatchInfo(this.getBgSchemeId(), this.getOrgTree().getId().toString(), this.getOrgUnitId());
    }

    private void fillDispatchInfo() throws Exception {
        HashSet<String> selectTemplateIds = new HashSet<String>(this.getSelectedTemplateIds());
        if (!this.selectIds.equals(selectTemplateIds)) {
            this.selectIds = selectTemplateIds;
            if (this.treeOrgUnit.getModel() == null) {
                return;
            }
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
            this.fillDispatchInfo(root, selectTemplateIds);
            this.treeOrgUnit.repaint();
        }
    }

    protected void fillDispatchInfo(DefaultKingdeeTreeNode root, Set<String> selectTemplateIds) throws Exception {
        if (root == null || selectTemplateIds == null) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo oui = null;
        OrgUnitInfo tmpUnit = null;
        String orgUnitId = null;
        Object dispatchIds = null;
        HashSet cloneDispatchIds = new HashSet();
        int in = root.getChildCount();
        for (int i = 0; i < in; ++i) {
            cloneDispatchIds.clear();
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node.getUserObject() instanceof OrgStructureInfo) {
                oui = (OrgStructureInfo)node.getUserObject();
                if (oui.getUnit() != null) {
                    orgUnitId = oui.getUnit().getId().toString();
                }
            } else {
                if (!(node.getUserObject() instanceof OrgUnitInfo)) continue;
                tmpUnit = (OrgUnitInfo)node.getUserObject();
                orgUnitId = tmpUnit.getId().toString();
            }
            if (this.getDispatchMap().get(orgUnitId) != null) {
                cloneDispatchIds.addAll(this.getDispatchMap().get(orgUnitId));
            }
            cloneDispatchIds.retainAll(selectTemplateIds);
            if (!cloneDispatchIds.isEmpty()) {
                node.setTextColor(DISPATCHED_BY_CURRSCHEME);
            } else {
                node.setTextColor(NO_DISPATCHED);
            }
            if (node.isLeaf()) continue;
            this.fillDispatchInfo(node, selectTemplateIds);
        }
    }

    protected String getDispatchReportUIName() {
        return BgCslOffTemplateDispatchReportUI.class.getName();
    }

    protected Object executeAssign() throws EASBizException, BOSException {
        List<String> bgTemplateIds = this.getSelectedTemplateIds();
        List<String> bgOrgUnitIds = this.getSelectedOrgUnitIds();
        return BgCslOffsetEntryTemplateFactory.getRemoteInstance().assign(this.getBgSchemeId(), bgOrgUnitIds, bgTemplateIds);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }
}

