/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.bgcsl.BgCslSchemeFacadeFactory;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgMergeSchemeTreeListUI;
import com.kingdee.eas.ma.bgcsl.client.BgSchemeMergeScopeEditUI;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import org.apache.log4j.Logger;

public class BgMergeSchemeTreeListUI
extends AbstractBgMergeSchemeTreeListUI {
    private static final Logger logger = CoreUIObject.getLogger(BgMergeSchemeTreeListUI.class);
    private static final String RS = "com.kingdee.eas.ma.bgcsl.client.BgCslSchemeResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnMergeScope.setEnabled(true);
        this.btnCopy.setVisible(false);
        this.menuItemCopy.setVisible(false);
    }

    public void initWorkButton() {
        super.initWorkButton();
        this.btnViewDim.setVisible(false);
        this.menuItemMergeScope.setEnabled(true);
        this.menuItemMergeScope.setIcon(EASResource.getIcon((String)"imgTbtn_pagesetting"));
        this.btnMergeScope.setIcon(EASResource.getIcon((String)"imgTbtn_pagesetting"));
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        FilterInfo filter = (viewInfo = (EntityViewInfo)viewInfo.clone()).getFilter();
        if (filter == null) {
            filter = new FilterInfo();
            viewInfo.setFilter(filter);
        }
        FilterInfo cslFilter = new FilterInfo();
        cslFilter.getFilterItems().add(new FilterItemInfo("bgDimSettings.dimNumber", (Object)DimensionConstants.DEF_CSL_NUMBER, CompareType.EQUALS));
        try {
            filter.mergeFilter(cslFilter, "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    @Override
    public void actionMergeScope_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.removeConfirm();
        List notDelNumList = BgCslSchemeFacadeFactory.getRemoteInstance().removeBgCslScheme(this.getSelectedIdValues());
        if (notDelNumList.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RS, (String)"delSuccess"));
        } else {
            StringBuffer numbers = new StringBuffer();
            for (String number : notDelNumList) {
                numbers.append(number).append(",");
            }
            numbers.delete(numbers.length() - 1, numbers.length());
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)RS, (String)"partialDelFail"), (String)EASResource.getString((String)RS, (String)"delDetail", (Object[])new Object[]{numbers.toString()}), (int)2);
        }
        this.refreshList();
    }

    protected void removeConfirm() {
        if (MsgBox.showConfirm2((String)EASResource.getString((String)RS, (String)"delConfirm")) != 0) {
            SysUtil.abort();
        }
    }

    protected String getEditUIName() {
        return BgSchemeMergeScopeEditUI.class.getName();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, this.prmtOrgUnit.getData());
        super.prepareUIContext(uiContext, e);
    }
}

