/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperCollection;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperInfo;
import com.kingdee.eas.ma.bgcsl.client.workPaper.MbgWorkPaperProvider;
import com.kingdee.eas.ma.bgcsl.provider.BgCslViewListFormExportProvider;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellInfo;
import com.kingdee.eas.ma.mbg.client.utils.MBGViewListFormClientHelper;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.ViewListBookParseHelper;
import com.kingdee.eas.ma.mbg.common.ViewListExportBookParseHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgWorkPaperExportProvider
extends MbgWorkPaperProvider {
    private static final Logger logger = CoreUIObject.getLogger(BgCslViewListFormExportProvider.class);
    private boolean isRunning = true;
    private MbgWorkPaperCollection workPaperList = null;
    private CoreUI ownerUI = null;
    private Map<String, Book> bookMap = new HashMap<String, Book>();
    private MbgWorkPaperInfo currentWorkPaperInfo = null;

    public MbgWorkPaperInfo getBgFormInfo() {
        return this.currentWorkPaperInfo;
    }

    public void setBgFormInfo(MbgWorkPaperInfo info) {
        this.currentWorkPaperInfo = info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Book getBook(String formId) {
        while (this.isRunning) {
            logger.error((Object)"************************************************************");
            Map<String, Book> map = this.bookMap;
            synchronized (map) {
                if (this.bookMap.containsKey(formId)) {
                    logger.error((Object)("GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG findBook:" + formId));
                    break;
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Book book = this.bookMap.get(formId);
        this.bookMap.remove(formId);
        return book;
    }

    public MbgWorkPaperExportProvider(MbgWorkPaperCollection bgFormList, CoreUI ownerUI) {
        this.workPaperList = bgFormList;
        this.ownerUI = ownerUI;
        Thread thread = new Thread(){

            @Override
            public void run() {
                MbgWorkPaperExportProvider.this.init();
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init() {
        try {
            Iterator ite = this.workPaperList.iterator();
            while (ite.hasNext()) {
                MbgWorkPaperInfo bgFormInfo = (MbgWorkPaperInfo)ite.next();
                String formId = bgFormInfo.getId().toString();
                this.setBgFormInfo(bgFormInfo);
                this.setEditValue((IObjectValue)bgFormInfo);
                this.setOrgUnitInfo(bgFormInfo.getOrgUnit());
                this.setOwner((CoreUIObject)this.ownerUI);
                long ct = System.currentTimeMillis();
                logger.info((Object)("start initViewListBook : " + ct));
                Book book = this.initViewListBook();
                logger.info((Object)("end initViewListBook : " + (System.currentTimeMillis() - ct) + "ms"));
                Map<String, Book> map = this.bookMap;
                synchronized (map) {
                    logger.error((Object)("OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO endLoadBook:" + formId));
                    this.bookMap.put(formId, book);
                }
            }
            return;
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.ownerUI.handUIException((Throwable)e);
            return;
        }
        finally {
            this.isRunning = false;
        }
    }

    private Book initViewListBook() throws Exception {
        Book _book = (Book)this.load();
        this.fillData(_book);
        this.calcBook(_book, this.getReportAdapter());
        this.processMeasureUnit(_book);
        return _book;
    }

    @Override
    protected void fillBgDataValue(Sheet sheet, Map<String, Map<String, BgNViewDataInfo>> dataMap, Map<String, Map<String, BgNViewDataInfo>> tmpDataMap, Map<String, Map<String, Map<String, MbgViewListDesCellInfo>>> descMap, String editNote) throws Exception {
        if (sheet == null) {
            return;
        }
        Cell cell = null;
        ItemFormula formula = null;
        String cellOrgId = null;
        BgNViewDataInfo dataValue = null;
        BgNFSHelper.disableUndo((Book)sheet.getBook());
        BgNFSHelper.disableCal((Book)sheet.getBook());
        DimensionCacheHelper cachehelper = this.getCheckFactory().getCacheHelper();
        for (int rowIndex = 0; rowIndex <= sheet.getMaxRowIndex(); ++rowIndex) {
            for (int colIndex = 0; colIndex <= sheet.getMaxColIndex(); ++colIndex) {
                cell = sheet.getCell(rowIndex, colIndex, false);
                formula = BgNFSHelper.getItemFormula((Cell)cell);
                if (formula != null) {
                    String version = formula.getExt("Version");
                    cellOrgId = formula.getExt("ORGUNITID");
                    dataValue = MBGViewListFormClientHelper.getData(tmpDataMap, (String)cellOrgId, (String)formula.getFormula(), (String)version, (boolean)false);
                    if (dataValue == null) {
                        dataValue = MBGViewListFormClientHelper.getData(dataMap, (String)cellOrgId, (String)formula.getFormula(), (String)version, (boolean)false);
                    }
                    if (dataValue != null) {
                        MBGViewListFormClientHelper.setDataValueToCell((Cell)cell, (BgNViewDataInfo)dataValue, (DimensionCacheHelper)cachehelper, (int)this.getDataType());
                    } else {
                        MBGViewListFormClientHelper.setDataValueToCell((Cell)cell, null, (DimensionCacheHelper)cachehelper, (int)this.getDataType());
                    }
                }
                this.fillDescriptions(cell, descMap);
                this.fillEditNote(cell, editNote);
            }
        }
        this.dealCalculateColFormula(sheet);
        BgNFSHelper.enableUndo((Book)sheet.getBook());
    }

    @Override
    protected void loadMbgViewManager() throws Exception {
        super.loadMbgViewManager();
        BgViewHelper.movePageDimensionsToRow((MbgViewListManager)((MbgViewListManager)this.curMbgViewManager), (boolean)false);
    }

    @Override
    public ViewListBookParseHelper getBookParseHelper() {
        if (this.bookParseHelper == null) {
            this.bookParseHelper = new ViewListExportBookParseHelper(this.getBookDimensionParse(), this.getBgFormInfo().getOrgUnit(), this.getBgViewManagerForMulOrg(), this.orgUnitMap, this.isCheckFull(), this.getMemberFilter(), this.getCheckFactory().getCacheHelper());
        }
        this.bookParseHelper.setTemplateStyle(this.getTemplateStyle());
        this.bookParseHelper.setVersionNumber(this.getVersionNumber());
        this.bookParseHelper.setOrgViewId(this.getOrgViewId());
        this.bookParseHelper.setEditScenType(this.getEditScenType());
        this.bookParseHelper.setSheetTitle(this.getSheetTitle());
        this.bookParseHelper.setEditOrgUnit(this.editOrgUnit);
        this.bookParseHelper.setEditPeriod(this.editPeriod);
        this.bookParseHelper.setViewF7Enable(true);
        this.bookParseHelper.setPageF7Enable(true);
        this.bookParseHelper.setOrgF7Enable(true);
        this.bookParseHelper.setParseForm(true);
        this.bookParseHelper.setAccountMap(this.getAccountDataTypeMap());
        this.bookParseHelper.setReadonly(false);
        this.bookParseHelper.setShowDefaultMember(true);
        this.bookParseHelper.setPropMaps(this.getPropMaps());
        this.bookParseHelper.setAdapter(this.getReportAdapter());
        return this.bookParseHelper;
    }

    @Override
    protected void loadMultiOrg() throws Exception {
        HashSet<String> orgNums = new HashSet<String>();
        this.getOrgNumsForCurViewManager((MbgViewListManager)this.curMbgViewManager, orgNums);
        if (orgNums != null && orgNums.size() > 1) {
            this.addBgViewManagerForMultiOrg(orgNums);
        }
    }
}

