/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.ma.base.client.utils.NumberExpandHelper;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperInfo;
import com.kingdee.eas.ma.bgcsl.client.AbstractSingleOrgUnitBackF7UI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SingleOrgUnitBackF7UI
extends AbstractSingleOrgUnitBackF7UI {
    private static final long serialVersionUID = -1982008359663410475L;
    private static final Logger logger = CoreUIObject.getLogger(SingleOrgUnitBackF7UI.class);
    private FullOrgUnitCollection orgCollection = new FullOrgUnitCollection();
    private FullOrgUnitCollection allOrgCollection = null;
    private MbgWorkPaperInfo paperInfo = null;
    private Map<String, String> orgMap = null;
    private Set<String> bgPeriodNums = null;
    private Set<String> versionNums = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("orgCol") != null) {
            this.allOrgCollection = (FullOrgUnitCollection)this.getUIContext().get("orgCol");
            if (this.allOrgCollection != null) {
                this.orgCollection.addCollection(this.allOrgCollection);
            }
        }
        if (this.getUIContext().get("workPaperInfo") != null) {
            this.paperInfo = (MbgWorkPaperInfo)this.getUIContext().get("workPaperInfo");
        }
        if (this.getUIContext().get("StartBgPeriod") != null) {
            this.bgPeriodNums = (Set)this.getUIContext().get("StartBgPeriod");
        }
        if (this.getUIContext().get("VERSION_NUMBER") != null) {
            this.versionNums = (Set)this.getUIContext().get("VERSION_NUMBER");
        }
        this.refreshOrgTable();
    }

    private void refreshOrgTable() {
        if (this.orgCollection != null) {
            this.tblLeft.checkParsed();
            this.tblLeft.removeRows();
            this.tblLeft.setEditable(false);
            FullOrgUnitInfo orgInfo = null;
            IRow row = null;
            this.orgMap = new HashMap<String, String>();
            int in = this.orgCollection.size();
            for (int i = 0; i < in; ++i) {
                orgInfo = this.orgCollection.get(i);
                row = this.tblLeft.addRow();
                this.tblLeft.setRowCount(this.tblLeft.getRowCount() + 1);
                row.getCell("number").setValue((Object)orgInfo.getNumber());
                row.getCell("name").setValue((Object)orgInfo.getName());
                this.orgMap.put(orgInfo.getNumber(), orgInfo.getId().toString());
            }
        }
    }

    @Override
    protected void tblLeft_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblLeft_tableClicked(e);
        if (e.getClickCount() == 2) {
            this.addRows();
        }
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.btnAdd_actionPerformed(e);
        this.checkSelected(this.tblLeft);
        this.addRows();
    }

    @Override
    protected void btnAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddAll_actionPerformed(e);
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (int i = 0; i < this.tblLeft.getRowCount(); ++i) {
            rows.add(new Integer(i));
        }
        this.add(rows);
    }

    @Override
    protected void btnRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemoveAll_actionPerformed(e);
        if (this.tblRight.getRowCount() <= 0) {
            return;
        }
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (int i = 0; i < this.tblRight.getRowCount(); ++i) {
            rows.add(new Integer(i));
        }
        this.remove(rows);
    }

    private void checkSelected(KDTable table) {
        if (table.getRowCount() == 0 || table.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    @Override
    protected void btnRemove_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemove_actionPerformed(e);
        this.checkSelected(this.tblRight);
        List rows = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblRight);
        this.remove(rows);
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        if (this.paperInfo == null || this.paperInfo.getBgScheme() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.MbgWorkPaperResource", (String)"2_SingleOrgUnitBackF7UI"));
            return;
        }
        HashSet<String> orgSets = new HashSet<String>();
        String number = null;
        IRow row = null;
        if (this.tblRight.getRowCount() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.MbgWorkPaperResource", (String)"singleOrgNull"));
            SysUtil.abort();
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.MbgWorkPaperResource", (String)"getSingleValueAgain"));
        for (int i = 0; i < this.tblRight.getRowCount(); ++i) {
            row = this.tblRight.getRow(i);
            number = NumberExpandHelper.getNumber((IRow)row);
            if (this.orgMap == null || !this.orgMap.containsKey(number)) continue;
            orgSets.add(this.orgMap.get(number));
        }
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void quickQueryButton_actionPerformed(ActionEvent e) throws Exception {
        this.doSerch();
    }

    @Override
    protected void txtQuickQueryInput_focusLost(FocusEvent e) throws Exception {
        this.doSerch();
    }

    protected void doSerch() {
        String searchTxt = this.txtQuickQueryInput.getText();
        if (!StringUtils.isEmpty((String)searchTxt)) {
            this.orgCollection.clear();
            FullOrgUnitInfo orgUnit = null;
            for (int i = 0; i < this.allOrgCollection.size(); ++i) {
                orgUnit = this.allOrgCollection.get(i);
                if (!orgUnit.getNumber().contains(searchTxt) && !orgUnit.getName().contains(searchTxt)) continue;
                this.orgCollection.add(orgUnit);
            }
        } else {
            this.orgCollection.clear();
            this.orgCollection.addCollection(this.allOrgCollection);
        }
        this.refreshOrgTable();
    }

    protected void addRows() throws Exception {
        List rows = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblLeft);
        this.add(rows);
    }

    protected void add(List rows) {
        int i;
        if (rows == null || rows.isEmpty()) {
            return;
        }
        String number = null;
        boolean tag = false;
        HashSet<String> selectedNumbers = new HashSet<String>();
        for (i = 0; i < this.tblRight.getRowCount(); ++i) {
            number = NumberExpandHelper.getNumber((IRow)this.tblRight.getRow(i));
            selectedNumbers.add(number);
        }
        for (i = 0; i < rows.size(); ++i) {
            int rowIndex = (Integer)rows.get(i);
            IRow row = this.tblLeft.getRow(rowIndex);
            number = NumberExpandHelper.getNumber((IRow)row);
            if (selectedNumbers.contains(number)) continue;
            if (!BgNumberHelper.checkNumber((String)number)) {
                tag = true;
                continue;
            }
            this.addOneRow(rowIndex);
        }
    }

    protected void addOneRow(int rowIndex) {
        IRow row = this.tblLeft.getRow(rowIndex);
        if (row == null) {
            return;
        }
        if (!row.getStyleAttributes().isHided()) {
            IRow newRow = this.tblRight.addRow();
            newRow.getCell("number").setValue(row.getCell("number").getValue());
            newRow.getCell("name").setValue(row.getCell("name").getValue());
        }
    }

    protected void remove(List<Integer> rows) {
        if (rows == null || rows.isEmpty()) {
            return;
        }
        Collections.sort(rows);
        HashSet removeCompareValue = new HashSet();
        for (int i = rows.size() - 1; i >= 0; --i) {
            int rowIndex = rows.get(i);
            IRow row = this.tblRight.getRow(rowIndex);
            this.tblRight.removeRow(rowIndex);
        }
    }
}

